/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestApplicationSubmissionContextPBImpl {
    @Parameterized.Parameter
    public ApplicationSubmissionContextPBImpl impl;

    @Test
    public void testAppTagsLowerCaseConversionDefault() {
        this.impl.setApplicationTags((Set)Sets.newHashSet((Object[])new String[]{"ABcd", "efgH"}));
        this.impl.getApplicationTags().forEach(s -> Assert.assertEquals((Object)s, (Object)s.toLowerCase()));
    }

    @Test
    public void testAppTagsLowerCaseConversionDisabled() {
        ApplicationSubmissionContextPBImpl.setForceLowerCaseTags((boolean)false);
        this.impl.setApplicationTags((Set)Sets.newHashSet((Object[])new String[]{"ABcd", "efgH"}));
        this.impl.getApplicationTags().forEach(s -> Assert.assertNotEquals((Object)s, (Object)s.toLowerCase()));
    }

    @Test
    public void testAppTagsLowerCaseConversionEnabled() {
        ApplicationSubmissionContextPBImpl.setForceLowerCaseTags((boolean)true);
        this.impl.setApplicationTags((Set)Sets.newHashSet((Object[])new String[]{"ABcd", "efgH"}));
        this.impl.getApplicationTags().forEach(s -> Assert.assertEquals((Object)s, (Object)s.toLowerCase()));
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        list.add(new Object[]{new ApplicationSubmissionContextPBImpl()});
        list.add(new Object[]{new ApplicationSubmissionContextPBImpl(YarnProtos.ApplicationSubmissionContextProto.newBuilder().build())});
        return list;
    }
}

