/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.logaggregation.ContainerLogFileInfo;
import org.apache.hadoop.yarn.logaggregation.ExtendedLogMetaRequest;
import org.apache.hadoop.yarn.logaggregation.LogAggregationMetaCollector;
import org.apache.hadoop.yarn.logaggregation.filecontroller.FakeLogAggregationFileController;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLogAggregationMetaCollector {
    private static final String TEST_NODE = "TEST_NODE_1";
    private static final String TEST_NODE_2 = "TEST_NODE_2";
    private static final String BIG_FILE_NAME = "TEST_BIG";
    private static final String SMALL_FILE_NAME = "TEST_SMALL";
    private static ApplicationId app = ApplicationId.newInstance((long)Clock.systemDefaultZone().millis(), (int)1);
    private static ApplicationId app2 = ApplicationId.newInstance((long)Clock.systemDefaultZone().millis(), (int)2);
    private static ApplicationAttemptId appAttempt = ApplicationAttemptId.newInstance((ApplicationId)app, (int)1);
    private static ApplicationAttemptId app2Attempt = ApplicationAttemptId.newInstance((ApplicationId)app2, (int)1);
    private static ContainerId attemptContainer = ContainerId.newContainerId((ApplicationAttemptId)appAttempt, (long)1L);
    private static ContainerId attemptContainer2 = ContainerId.newContainerId((ApplicationAttemptId)appAttempt, (long)2L);
    private static ContainerId attempt2Container = ContainerId.newContainerId((ApplicationAttemptId)app2Attempt, (long)1L);
    private static ContainerId attempt2Container2 = ContainerId.newContainerId((ApplicationAttemptId)app2Attempt, (long)2L);
    private FakeNodeFileController fileController;

    @Before
    public void setUp() throws Exception {
        this.fileController = this.createFileController();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testAllNull() throws IOException {
        ExtendedLogMetaRequest.ExtendedLogMetaRequestBuilder request = new ExtendedLogMetaRequest.ExtendedLogMetaRequestBuilder();
        request.setAppId(null);
        request.setContainerId(null);
        request.setFileName(null);
        request.setFileSize(null);
        request.setModificationTime(null);
        request.setNodeId(null);
        request.setUser(null);
        LogAggregationMetaCollector collector = new LogAggregationMetaCollector(request.build(), (Configuration)new YarnConfiguration());
        List res = collector.collect((LogAggregationFileController)this.fileController);
        List allFile = res.stream().flatMap(m -> m.getContainerLogMeta().stream()).collect(Collectors.toList());
        Assert.assertEquals((long)8L, (long)allFile.size());
    }

    @Test
    public void testAllSet() throws IOException {
        ExtendedLogMetaRequest.ExtendedLogMetaRequestBuilder request = new ExtendedLogMetaRequest.ExtendedLogMetaRequestBuilder();
        HashSet<String> fileSizeExpressions = new HashSet<String>();
        fileSizeExpressions.add("<51");
        HashSet<String> modificationTimeExpressions = new HashSet<String>();
        modificationTimeExpressions.add("<1000");
        request.setAppId(app.toString());
        request.setContainerId(attemptContainer.toString());
        request.setFileName(String.format("%s.*", SMALL_FILE_NAME));
        request.setFileSize(fileSizeExpressions);
        request.setModificationTime(modificationTimeExpressions);
        request.setNodeId(TEST_NODE);
        request.setUser("TEST");
        LogAggregationMetaCollector collector = new LogAggregationMetaCollector(request.build(), (Configuration)new YarnConfiguration());
        List res = collector.collect((LogAggregationFileController)this.fileController);
        List allFile = res.stream().flatMap(m -> m.getContainerLogMeta().stream()).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)allFile.size());
    }

    @Test
    public void testSingleNodeRequest() throws IOException {
        ExtendedLogMetaRequest.ExtendedLogMetaRequestBuilder request = new ExtendedLogMetaRequest.ExtendedLogMetaRequestBuilder();
        request.setAppId(null);
        request.setContainerId(null);
        request.setFileName(null);
        request.setFileSize(null);
        request.setModificationTime(null);
        request.setNodeId(TEST_NODE);
        request.setUser(null);
        LogAggregationMetaCollector collector = new LogAggregationMetaCollector(request.build(), (Configuration)new YarnConfiguration());
        List res = collector.collect((LogAggregationFileController)this.fileController);
        List allFile = res.stream().flatMap(m -> m.getContainerLogMeta().stream()).collect(Collectors.toList());
        Assert.assertEquals((long)4L, (long)allFile.stream().filter(f -> f.getFileName().contains(TEST_NODE)).count());
    }

    @Test
    public void testMultipleNodeRegexRequest() throws IOException {
        ExtendedLogMetaRequest.ExtendedLogMetaRequestBuilder request = new ExtendedLogMetaRequest.ExtendedLogMetaRequestBuilder();
        request.setAppId(null);
        request.setContainerId(null);
        request.setFileName(null);
        request.setFileSize(null);
        request.setModificationTime(null);
        request.setNodeId("TEST_NODE_.*");
        request.setUser(null);
        LogAggregationMetaCollector collector = new LogAggregationMetaCollector(request.build(), (Configuration)new YarnConfiguration());
        List res = collector.collect((LogAggregationFileController)this.fileController);
        List allFile = res.stream().flatMap(m -> m.getContainerLogMeta().stream()).collect(Collectors.toList());
        Assert.assertEquals((long)8L, (long)allFile.size());
    }

    @Test
    public void testMultipleFileRegex() throws IOException {
        ExtendedLogMetaRequest.ExtendedLogMetaRequestBuilder request = new ExtendedLogMetaRequest.ExtendedLogMetaRequestBuilder();
        request.setAppId(null);
        request.setContainerId(null);
        request.setFileName(String.format("%s.*", BIG_FILE_NAME));
        request.setFileSize(null);
        request.setModificationTime(null);
        request.setNodeId(null);
        request.setUser(null);
        LogAggregationMetaCollector collector = new LogAggregationMetaCollector(request.build(), (Configuration)new YarnConfiguration());
        List res = collector.collect((LogAggregationFileController)this.fileController);
        List allFile = res.stream().flatMap(m -> m.getContainerLogMeta().stream()).collect(Collectors.toList());
        Assert.assertEquals((long)4L, (long)allFile.size());
        Assert.assertTrue((boolean)allFile.stream().allMatch(f -> f.getFileName().contains(BIG_FILE_NAME)));
    }

    @Test
    public void testContainerIdExactMatch() throws IOException {
        ExtendedLogMetaRequest.ExtendedLogMetaRequestBuilder request = new ExtendedLogMetaRequest.ExtendedLogMetaRequestBuilder();
        request.setAppId(null);
        request.setContainerId(attemptContainer.toString());
        request.setFileName(null);
        request.setFileSize(null);
        request.setModificationTime(null);
        request.setNodeId(null);
        request.setUser(null);
        LogAggregationMetaCollector collector = new LogAggregationMetaCollector(request.build(), (Configuration)new YarnConfiguration());
        List res = collector.collect((LogAggregationFileController)this.fileController);
        List allFile = res.stream().flatMap(m -> m.getContainerLogMeta().stream()).collect(Collectors.toList());
        Assert.assertEquals((long)2L, (long)allFile.size());
        Assert.assertTrue((boolean)allFile.stream().allMatch(f -> f.getFileName().contains(attemptContainer.toString())));
    }

    @Test
    public void testMultipleFileBetweenSize() throws IOException {
        ExtendedLogMetaRequest.ExtendedLogMetaRequestBuilder request = new ExtendedLogMetaRequest.ExtendedLogMetaRequestBuilder();
        HashSet<String> fileSizeExpressions = new HashSet<String>();
        fileSizeExpressions.add(">50");
        fileSizeExpressions.add("<101");
        request.setAppId(null);
        request.setContainerId(null);
        request.setFileName(null);
        request.setFileSize(fileSizeExpressions);
        request.setModificationTime(null);
        request.setNodeId(null);
        request.setUser(null);
        LogAggregationMetaCollector collector = new LogAggregationMetaCollector(request.build(), (Configuration)new YarnConfiguration());
        List res = collector.collect((LogAggregationFileController)this.fileController);
        List allFile = res.stream().flatMap(m -> m.getContainerLogMeta().stream()).collect(Collectors.toList());
        Assert.assertEquals((long)4L, (long)allFile.size());
        Assert.assertTrue((boolean)allFile.stream().allMatch(f -> f.getFileSize().equals("100")));
    }

    @Test
    public void testInvalidQueryStrings() throws IOException {
        ExtendedLogMetaRequest.ExtendedLogMetaRequestBuilder request = new ExtendedLogMetaRequest.ExtendedLogMetaRequestBuilder();
        HashSet<String> fileSizeExpressions = new HashSet<String>();
        fileSizeExpressions.add("50");
        fileSizeExpressions.add("101");
        try {
            request.setFileName("*");
            Assert.fail((String)"An error should be thrown due to an invalid regex");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            request.setFileSize(fileSizeExpressions);
            Assert.fail((String)"An error should be thrown due to multiple exact match expression");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private FakeNodeFileController createFileController() {
        FileStatus appDir = new FileStatus();
        appDir.setPath(new Path(String.format("test/%s", app.toString())));
        FileStatus appDir2 = new FileStatus();
        appDir2.setPath(new Path(String.format("test/%s", app2.toString())));
        ArrayList<FileStatus> appDirs = new ArrayList<FileStatus>();
        appDirs.add(appDir);
        appDirs.add(appDir2);
        FileStatus nodeFile = new FileStatus();
        nodeFile.setPath(new Path(String.format("test/%s", TEST_NODE)));
        FileStatus nodeFile2 = new FileStatus();
        nodeFile2.setPath(new Path(String.format("test/%s", TEST_NODE_2)));
        ArrayList<FileStatus> nodeFiles = new ArrayList<FileStatus>();
        nodeFiles.add(nodeFile);
        nodeFiles.add(nodeFile2);
        HashMap<ImmutablePair<String, String>, Map<String, List<ContainerLogFileInfo>>> internal = new HashMap<ImmutablePair<String, String>, Map<String, List<ContainerLogFileInfo>>>();
        internal.put(new ImmutablePair((Object)app.toString(), (Object)TEST_NODE), this.createLogFiles(TEST_NODE, attemptContainer));
        internal.put(new ImmutablePair((Object)app.toString(), (Object)TEST_NODE_2), this.createLogFiles(TEST_NODE_2, attemptContainer2));
        internal.put(new ImmutablePair((Object)app2.toString(), (Object)TEST_NODE), this.createLogFiles(TEST_NODE, attempt2Container));
        internal.put(new ImmutablePair((Object)app2.toString(), (Object)TEST_NODE_2), this.createLogFiles(TEST_NODE_2, attempt2Container2));
        return new FakeNodeFileController(internal, appDirs, nodeFiles);
    }

    private Map<String, List<ContainerLogFileInfo>> createLogFiles(String nodeId, ContainerId ... containerId) {
        HashMap<String, List<ContainerLogFileInfo>> logFiles = new HashMap<String, List<ContainerLogFileInfo>>();
        for (ContainerId c : containerId) {
            ArrayList<ContainerLogFileInfo> files = new ArrayList<ContainerLogFileInfo>();
            ContainerLogFileInfo bigFile = new ContainerLogFileInfo();
            bigFile.setFileName(this.generateFileName(BIG_FILE_NAME, nodeId, c.toString()));
            bigFile.setFileSize("100");
            bigFile.setLastModifiedTime("1000");
            ContainerLogFileInfo smallFile = new ContainerLogFileInfo();
            smallFile.setFileName(this.generateFileName(SMALL_FILE_NAME, nodeId, c.toString()));
            smallFile.setFileSize("50");
            smallFile.setLastModifiedTime("100");
            files.add(bigFile);
            files.add(smallFile);
            logFiles.put(c.toString(), files);
        }
        return logFiles;
    }

    private String generateFileName(String name, String nodeId, String containerId) {
        return String.format("%s_%s_%s", name, nodeId, containerId);
    }

    private static class FakeNodeFileController
    extends FakeLogAggregationFileController {
        private Map<ImmutablePair<String, String>, Map<String, List<ContainerLogFileInfo>>> logFiles;
        private List<FileStatus> appDirs;
        private List<FileStatus> nodeFiles;

        FakeNodeFileController(Map<ImmutablePair<String, String>, Map<String, List<ContainerLogFileInfo>>> logFiles, List<FileStatus> appDirs, List<FileStatus> nodeFiles) {
            this.logFiles = logFiles;
            this.appDirs = appDirs;
            this.nodeFiles = nodeFiles;
        }

        public RemoteIterator<FileStatus> getApplicationDirectoriesOfUser(String user) throws IOException {
            return new RemoteIterator<FileStatus>(){
                private Iterator<FileStatus> iter;
                {
                    this.iter = appDirs.iterator();
                }

                public boolean hasNext() throws IOException {
                    return this.iter.hasNext();
                }

                public FileStatus next() throws IOException {
                    return this.iter.next();
                }
            };
        }

        public RemoteIterator<FileStatus> getNodeFilesOfApplicationDirectory(FileStatus appDir) throws IOException {
            return new RemoteIterator<FileStatus>(){
                private Iterator<FileStatus> iter;
                {
                    this.iter = nodeFiles.iterator();
                }

                public boolean hasNext() throws IOException {
                    return this.iter.hasNext();
                }

                public FileStatus next() throws IOException {
                    return this.iter.next();
                }
            };
        }

        public Map<String, List<ContainerLogFileInfo>> getLogMetaFilesOfNode(ExtendedLogMetaRequest logRequest, FileStatus currentNodeFile, ApplicationId appId) throws IOException {
            return this.logFiles.get(new ImmutablePair((Object)appId.toString(), (Object)currentNodeFile.getPath().getName()));
        }
    }
}

