/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.testutils;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogDeletionService;
import org.apache.hadoop.yarn.logaggregation.testutils.AggregatedLogDeletionServiceForTest;
import org.apache.hadoop.yarn.logaggregation.testutils.FileStatusUtils;
import org.apache.hadoop.yarn.logaggregation.testutils.LogAggregationTestcaseBuilder;
import org.apache.hadoop.yarn.logaggregation.testutils.MockRMClientUtils;
import org.apache.hadoop.yarn.logaggregation.testutils.PathWithFileStatus;
import org.junit.Assert;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogAggregationTestcase {
    private static final Logger LOG = LoggerFactory.getLogger(LogAggregationTestcase.class);
    private final Configuration conf;
    private final long now;
    private PathWithFileStatus bucketDir;
    private final long bucketDirModTime;
    private PathWithFileStatus userDir;
    private final String userDirName;
    private final long userDirModTime;
    private PathWithFileStatus suffixDir;
    private final String suffix;
    private final String suffixDirName;
    private final long suffixDirModTime;
    private final String bucketId;
    private final Path remoteRootLogPath;
    private final Map<Integer, Exception> injectedAppDirDeletionExceptions;
    private final List<String> fileControllers;
    private final List<Pair<String, Long>> additionalAppDirs;
    private final List<ApplicationId> applicationIds = new ArrayList<ApplicationId>();
    private final int[] runningAppIds;
    private final int[] finishedAppIds;
    private final List<List<PathWithFileStatus>> appFiles = new ArrayList<List<PathWithFileStatus>>();
    private final FileSystem mockFs;
    private List<PathWithFileStatus> appDirs;
    private final List<LogAggregationTestcaseBuilder.AppDescriptor> appDescriptors;
    private AggregatedLogDeletionServiceForTest deletionService;
    private ApplicationClientProtocol rmClient;

    public LogAggregationTestcase(LogAggregationTestcaseBuilder builder) throws IOException {
        this.conf = builder.conf;
        this.now = builder.now;
        this.bucketDir = builder.bucketDir;
        this.bucketDirModTime = builder.bucketDirModTime;
        this.userDir = builder.userDir;
        this.userDirName = builder.userDirName;
        this.userDirModTime = builder.userDirModTime;
        this.suffix = builder.suffix;
        this.suffixDir = builder.suffixDir;
        this.suffixDirName = builder.suffixDirName;
        this.suffixDirModTime = builder.suffixDirModTime;
        this.bucketId = builder.bucketId;
        this.appDescriptors = builder.apps;
        this.runningAppIds = builder.runningAppIds;
        this.finishedAppIds = builder.finishedAppIds;
        this.remoteRootLogPath = builder.remoteRootLogPath;
        this.injectedAppDirDeletionExceptions = builder.injectedAppDirDeletionExceptions;
        this.fileControllers = builder.fileControllers;
        this.additionalAppDirs = builder.additionalAppDirs;
        this.mockFs = ((FilterFileSystem)builder.rootFs).getRawFileSystem();
        this.validateAppControllers();
        this.setupMocks();
        this.setupDeletionService();
    }

    private void validateAppControllers() {
        HashSet<String> availableControllers;
        Set controllers = this.appDescriptors.stream().map(a -> a.fileController).filter(Objects::nonNull).collect(Collectors.toSet());
        Set difference = Sets.difference(controllers, (Set)(availableControllers = this.fileControllers != null ? new HashSet<String>(this.fileControllers) : Sets.newHashSet()));
        if (!difference.isEmpty()) {
            throw new IllegalStateException(String.format("Invalid controller defined! Available: %s, Actual: %s", availableControllers, controllers));
        }
    }

    private void setupMocks() throws IOException {
        this.createApplicationsByDescriptors();
        List<Path> rootPaths = this.determineRootPaths();
        for (Path rootPath : rootPaths) {
            String controllerName = rootPath.getName();
            ApplicationId arbitraryAppIdForBucketDir = this.applicationIds.get(0);
            this.userDir = FileStatusUtils.createDirLogPathWithFileStatus(rootPath, this.userDirName, this.userDirModTime);
            this.suffixDir = FileStatusUtils.createDirLogPathWithFileStatus(this.userDir.path, this.suffixDirName, this.suffixDirModTime);
            this.bucketDir = this.bucketId != null ? FileStatusUtils.createDirLogPathWithFileStatus(this.suffixDir.path, this.bucketId, this.bucketDirModTime) : FileStatusUtils.createDirBucketDirLogPathWithFileStatus(rootPath, this.userDirName, this.suffix, arbitraryAppIdForBucketDir, this.bucketDirModTime);
            this.setupListStatusForPath(rootPath, this.userDir);
            this.initFileSystemListings(controllerName);
        }
    }

    private List<Path> determineRootPaths() {
        ArrayList<Path> rootPaths = new ArrayList<Path>();
        if (this.fileControllers != null && !this.fileControllers.isEmpty()) {
            for (String fileController : this.fileControllers) {
                rootPaths.add(new Path(this.remoteRootLogPath, fileController));
            }
        } else {
            rootPaths.add(this.remoteRootLogPath);
        }
        return rootPaths;
    }

    private void initFileSystemListings(String controllerName) throws IOException {
        this.setupListStatusForPath(this.userDir, this.suffixDir);
        this.setupListStatusForPath(this.suffixDir, this.bucketDir);
        this.setupListStatusForPath(this.bucketDir, (FileStatus[])this.appDirs.stream().filter(app -> app.path.toString().contains(controllerName)).map(app -> app.fileStatus).toArray(FileStatus[]::new));
        for (Pair<String, Long> appDirPair : this.additionalAppDirs) {
            PathWithFileStatus appDir = FileStatusUtils.createDirLogPathWithFileStatus(this.bucketDir.path, (String)appDirPair.getLeft(), (Long)appDirPair.getRight());
            this.setupListStatusForPath(appDir, new FileStatus[0]);
        }
    }

    private void createApplicationsByDescriptors() throws IOException {
        int len = this.appDescriptors.size();
        this.appDirs = new ArrayList<PathWithFileStatus>(len);
        for (int i = 0; i < len; ++i) {
            LogAggregationTestcaseBuilder.AppDescriptor appDesc = this.appDescriptors.get(i);
            ApplicationId applicationId = appDesc.createApplicationId(this.now, i + 1);
            this.applicationIds.add(applicationId);
            Path basePath = this.remoteRootLogPath;
            if (appDesc.fileController != null) {
                basePath = new Path(basePath, appDesc.fileController);
            }
            PathWithFileStatus appDir = FileStatusUtils.createPathWithFileStatusForAppId(basePath, applicationId, this.userDirName, this.suffix, appDesc.modTimeOfAppDir);
            LOG.debug("Created application with ID '{}' to path '{}'", (Object)applicationId, (Object)appDir.path);
            this.appDirs.add(appDir);
            this.addAppChildrenFiles(appDesc, appDir);
        }
        this.setupFsMocksForAppsAndChildrenFiles();
        for (Map.Entry<Integer, Exception> e : this.injectedAppDirDeletionExceptions.entrySet()) {
            Mockito.when((Object)this.mockFs.delete(this.appDirs.get((int)e.getKey().intValue()).path, true)).thenThrow(new Throwable[]{e.getValue()});
        }
    }

    private void setupFsMocksForAppsAndChildrenFiles() throws IOException {
        for (int i = 0; i < this.appDirs.size(); ++i) {
            List<PathWithFileStatus> appChildren = this.appFiles.get(i);
            Path appPath = this.appDirs.get((int)i).path;
            this.setupListStatusForPath(appPath, (FileStatus[])appChildren.stream().map(child -> child.fileStatus).toArray(FileStatus[]::new));
        }
    }

    private void setupListStatusForPath(Path dir, PathWithFileStatus pathWithFileStatus) throws IOException {
        this.setupListStatusForPath(dir, new FileStatus[]{pathWithFileStatus.fileStatus});
    }

    private void setupListStatusForPath(PathWithFileStatus dir, PathWithFileStatus pathWithFileStatus) throws IOException {
        this.setupListStatusForPath(dir, new FileStatus[]{pathWithFileStatus.fileStatus});
    }

    private void setupListStatusForPath(Path dir, FileStatus[] fileStatuses) throws IOException {
        LOG.debug("Setting up listStatus. Parent: {}, files: {}", (Object)dir, (Object)fileStatuses);
        Mockito.when((Object)this.mockFs.listStatus(dir)).thenReturn((Object)fileStatuses);
    }

    private void setupListStatusForPath(PathWithFileStatus dir, FileStatus[] fileStatuses) throws IOException {
        LOG.debug("Setting up listStatus. Parent: {}, files: {}", (Object)dir.path, (Object)fileStatuses);
        Mockito.when((Object)this.mockFs.listStatus(dir.path)).thenReturn((Object)fileStatuses);
    }

    private void setupDeletionService() {
        List<ApplicationId> finishedApps = this.createFinishedAppsList();
        List<ApplicationId> runningApps = this.createRunningAppsList();
        this.deletionService = new AggregatedLogDeletionServiceForTest(runningApps, finishedApps, this.conf);
    }

    public LogAggregationTestcase startDeletionService() {
        this.deletionService.init(this.conf);
        this.deletionService.start();
        return this;
    }

    private List<ApplicationId> createRunningAppsList() {
        ArrayList<ApplicationId> runningApps = new ArrayList<ApplicationId>();
        for (int i : this.runningAppIds) {
            ApplicationId appId = this.applicationIds.get(i - 1);
            runningApps.add(appId);
        }
        return runningApps;
    }

    private List<ApplicationId> createFinishedAppsList() {
        ArrayList<ApplicationId> finishedApps = new ArrayList<ApplicationId>();
        for (int i : this.finishedAppIds) {
            ApplicationId appId = this.applicationIds.get(i - 1);
            finishedApps.add(appId);
        }
        return finishedApps;
    }

    public LogAggregationTestcase runDeletionTask(long retentionSeconds) throws Exception {
        List<ApplicationId> finishedApps = this.createFinishedAppsList();
        List<ApplicationId> runningApps = this.createRunningAppsList();
        this.rmClient = MockRMClientUtils.createMockRMClient(finishedApps, runningApps);
        List tasks = this.deletionService.createLogDeletionTasks(this.conf, retentionSeconds, this.rmClient);
        for (AggregatedLogDeletionService.LogDeletionTask deletionTask : tasks) {
            deletionTask.run();
        }
        return this;
    }

    private void addAppChildrenFiles(LogAggregationTestcaseBuilder.AppDescriptor appDesc, PathWithFileStatus appDir) {
        ArrayList<PathWithFileStatus> appChildren = new ArrayList<PathWithFileStatus>();
        for (Pair<String, Long> fileWithModDate : appDesc.filesWithModDate) {
            PathWithFileStatus appChildFile = FileStatusUtils.createFileLogPathWithFileStatus(appDir.path, (String)fileWithModDate.getLeft(), (Long)fileWithModDate.getRight());
            appChildren.add(appChildFile);
        }
        this.appFiles.add(appChildren);
    }

    public LogAggregationTestcase verifyAppDirsDeleted(long timeout, int ... ids) throws IOException {
        for (int id : ids) {
            this.verifyAppDirDeleted(id, timeout);
        }
        return this;
    }

    public LogAggregationTestcase verifyAppDirsNotDeleted(long timeout, int ... ids) throws IOException {
        for (int id : ids) {
            this.verifyAppDirNotDeleted(id, timeout);
        }
        return this;
    }

    public LogAggregationTestcase verifyAppDirDeleted(int id, long timeout) throws IOException {
        this.verifyAppDirDeletion(id, 1, timeout);
        return this;
    }

    public LogAggregationTestcase verifyAppDirNotDeleted(int id, long timeout) throws IOException {
        this.verifyAppDirDeletion(id, 0, timeout);
        return this;
    }

    public LogAggregationTestcase verifyAppFilesDeleted(long timeout, List<Pair<Integer, Integer>> pairs) throws IOException {
        for (Pair<Integer, Integer> pair : pairs) {
            this.verifyAppFileDeleted((Integer)pair.getLeft(), (Integer)pair.getRight(), timeout);
        }
        return this;
    }

    public LogAggregationTestcase verifyAppFilesNotDeleted(long timeout, List<Pair<Integer, Integer>> pairs) throws IOException {
        for (Pair<Integer, Integer> pair : pairs) {
            this.verifyAppFileNotDeleted((Integer)pair.getLeft(), (Integer)pair.getRight(), timeout);
        }
        return this;
    }

    public LogAggregationTestcase verifyAppFileDeleted(int id, int fileNo, long timeout) throws IOException {
        this.verifyAppFileDeletion(id, fileNo, 1, timeout);
        return this;
    }

    public LogAggregationTestcase verifyAppFileNotDeleted(int id, int fileNo, long timeout) throws IOException {
        this.verifyAppFileDeletion(id, fileNo, 0, timeout);
        return this;
    }

    private void verifyAppDirDeletion(int id, int times, long timeout) throws IOException {
        if (timeout == -1L) {
            ((FileSystem)Mockito.verify((Object)this.mockFs, (VerificationMode)Mockito.times((int)times))).delete(this.appDirs.get((int)(id - 1)).path, true);
        } else {
            ((FileSystem)Mockito.verify((Object)this.mockFs, (VerificationMode)Mockito.timeout((long)timeout).times(times))).delete(this.appDirs.get((int)(id - 1)).path, true);
        }
    }

    private void verifyAppFileDeletion(int appId, int fileNo, int times, long timeout) throws IOException {
        List<PathWithFileStatus> childrenFiles = this.appFiles.get(appId - 1);
        PathWithFileStatus file = childrenFiles.get(fileNo - 1);
        ((FileSystem)Mockito.verify((Object)this.mockFs, (VerificationMode)Mockito.timeout((long)timeout).times(times))).delete(file.path, true);
    }

    private void verifyMockRmClientWasClosedNTimes(int expectedRmClientCloses) throws IOException {
        ApplicationClientProtocol mockRMClient = this.deletionService != null ? this.deletionService.getMockRMClient() : this.rmClient;
        ((Closeable)Mockito.verify((Object)((Closeable)mockRMClient), (VerificationMode)Mockito.times((int)expectedRmClientCloses))).close();
    }

    public void teardown(int expectedRmClientCloses) throws IOException {
        this.deletionService.stop();
        this.verifyMockRmClientWasClosedNTimes(expectedRmClientCloses);
    }

    public LogAggregationTestcase refreshLogRetentionSettings() throws IOException {
        this.deletionService.refreshLogRetentionSettings();
        return this;
    }

    public AggregatedLogDeletionService getDeletionService() {
        return this.deletionService;
    }

    public LogAggregationTestcase verifyCheckIntervalMilliSecondsEqualTo(int checkIntervalMilliSeconds) {
        Assert.assertEquals((long)checkIntervalMilliSeconds, (long)this.deletionService.getCheckIntervalMsecs());
        return this;
    }

    public LogAggregationTestcase verifyCheckIntervalMilliSecondsNotEqualTo(int checkIntervalMilliSeconds) {
        Assert.assertTrue(((long)checkIntervalMilliSeconds != this.deletionService.getCheckIntervalMsecs() ? 1 : 0) != 0);
        return this;
    }

    public LogAggregationTestcase verifyAnyPathListedAtLeast(int atLeast, long timeout) throws IOException {
        ((FileSystem)Mockito.verify((Object)this.mockFs, (VerificationMode)Mockito.timeout((long)timeout).atLeast(atLeast))).listStatus((Path)ArgumentMatchers.any(Path.class));
        return this;
    }

    public LogAggregationTestcase changeModTimeOfApp(int appId, long modTime) {
        PathWithFileStatus appDir = this.appDirs.get(appId - 1);
        appDir.changeModificationTime(modTime);
        return this;
    }

    public LogAggregationTestcase changeModTimeOfAppLogDir(int appId, int fileNo, long modTime) {
        List<PathWithFileStatus> childrenFiles = this.appFiles.get(appId - 1);
        PathWithFileStatus file = childrenFiles.get(fileNo - 1);
        file.changeModificationTime(modTime);
        return this;
    }

    public LogAggregationTestcase changeModTimeOfBucketDir(long modTime) {
        this.bucketDir.changeModificationTime(modTime);
        return this;
    }

    public LogAggregationTestcase reinitAllPaths() throws IOException {
        List<Path> rootPaths = this.determineRootPaths();
        for (Path rootPath : rootPaths) {
            String controllerName = rootPath.getName();
            this.initFileSystemListings(controllerName);
        }
        this.setupFsMocksForAppsAndChildrenFiles();
        return this;
    }
}

