/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.yarn.util.TimelineServiceHelper;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestTimelineServiceHelper {
    @Test
    public void testMapCastToHashMap() {
        Map nullMap = null;
        Assert.assertNull((Object)TimelineServiceHelper.mapCastToHashMap(nullMap));
        HashMap emptyHashMap = new HashMap();
        Assert.assertEquals((long)TimelineServiceHelper.mapCastToHashMap(emptyHashMap).size(), (long)0L);
        TreeMap emptyTreeMap = new TreeMap();
        Assert.assertEquals((long)TimelineServiceHelper.mapCastToHashMap(emptyTreeMap).size(), (long)0L);
        HashMap<String, String> firstHashMap = new HashMap<String, String>();
        String key = "KEY";
        String value = "VALUE";
        firstHashMap.put(key, value);
        Assert.assertEquals((Object)TimelineServiceHelper.mapCastToHashMap(firstHashMap), firstHashMap);
        TreeMap<String, String> firstTreeMap = new TreeMap<String, String>();
        firstTreeMap.put(key, value);
        HashMap alternateHashMap = TimelineServiceHelper.mapCastToHashMap(firstTreeMap);
        Assert.assertEquals((long)firstTreeMap.size(), (long)alternateHashMap.size());
        Assertions.assertThat((String)((String)alternateHashMap.get(key))).isEqualTo((Object)value);
        HashMap complicatedHashMap = new HashMap();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(value);
        complicatedHashMap.put(key, hashSet);
        Assert.assertEquals((Object)TimelineServiceHelper.mapCastToHashMap(complicatedHashMap), complicatedHashMap);
        TreeMap<String, HashSet<String>> complicatedTreeMap = new TreeMap<String, HashSet<String>>();
        complicatedTreeMap.put(key, hashSet);
        Assert.assertEquals(TimelineServiceHelper.mapCastToHashMap(complicatedTreeMap).get(key), hashSet);
    }
}

