/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.CollectorInfo;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.client.api.impl.TimelineV2ClientImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTimelineClientV2Impl {
    private static final Logger LOG = LoggerFactory.getLogger(TestTimelineClientV2Impl.class);
    private TestV2TimelineClient client;
    private static final long TIME_TO_SLEEP = 150L;
    private static final String EXCEPTION_MSG = "Exception in the content";
    private YarnConfiguration conf;

    @BeforeEach
    public void setup(TestInfo testInfo) {
        this.conf = new YarnConfiguration();
        this.conf.setBoolean("yarn.timeline-service.enabled", true);
        this.conf.setFloat("yarn.timeline-service.version", 2.0f);
        this.conf.setInt("yarn.timeline-service.timeline-client.number-of-async-entities-to-merge", 3);
        if (!testInfo.getDisplayName().contains("testRetryOnConnectionFailure")) {
            this.client = this.createTimelineClient(this.conf);
        }
    }

    @Test
    void getTestInfo(TestInfo testInfo) {
        System.out.println(testInfo.getDisplayName());
        System.out.println(testInfo.getTestMethod());
        System.out.println(testInfo.getTestClass());
        System.out.println(testInfo.getTags());
    }

    private TestV2TimelineClient createTimelineClient(YarnConfiguration config) {
        ApplicationId id = ApplicationId.newInstance((long)0L, (int)0);
        TestV2TimelineClient tc = new TestV2TimelineClient(id);
        tc.init((Configuration)config);
        tc.start();
        return tc;
    }

    @Test
    void testExceptionMultipleRetry() {
        Throwable cause;
        TestV2TimelineClientForExceptionHandling c = new TestV2TimelineClientForExceptionHandling(ApplicationId.newInstance((long)0L, (int)0));
        int maxRetries = 2;
        this.conf.setInt("yarn.timeline-service.client.max-retries", maxRetries);
        c.init((Configuration)this.conf);
        c.start();
        c.setTimelineCollectorInfo(CollectorInfo.newInstance((String)"localhost:12345"));
        try {
            c.putEntities(new TimelineEntity[]{new TimelineEntity()});
        }
        catch (IOException e) {
            Assertions.fail((String)"YARN exception is expected");
        }
        catch (YarnException e) {
            cause = e.getCause();
            Assertions.assertTrue((boolean)(cause instanceof IOException), (String)"IOException is expected");
            Assertions.assertTrue((boolean)cause.getMessage().contains("TimelineClient has reached to max retry times : " + maxRetries), (String)"YARN exception is expected");
        }
        c.setThrowYarnException(true);
        try {
            c.putEntities(new TimelineEntity[]{new TimelineEntity()});
        }
        catch (IOException e) {
            Assertions.fail((String)"YARN exception is expected");
        }
        catch (YarnException e) {
            cause = e.getCause();
            Assertions.assertTrue((boolean)(cause instanceof YarnException), (String)"YARN exception is expected");
            Assertions.assertTrue((boolean)cause.getMessage().contains(EXCEPTION_MSG), (String)"YARN exception is expected");
        }
        c.stop();
    }

    @Test
    void testPostEntities() throws Exception {
        try {
            this.client.putEntities(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("1")});
        }
        catch (YarnException e) {
            Assertions.fail((String)"Exception is not expected");
        }
    }

    @Test
    void testASyncCallMerge() throws Exception {
        this.client.setSleepBeforeReturn(true);
        try {
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("1")});
            Thread.sleep(75L);
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("2")});
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("3")});
        }
        catch (YarnException e) {
            Assertions.fail((String)"Exception is not expected");
        }
        for (int i = 0; i < 4 && this.client.getNumOfTimelineEntitiesPublished() != 2; ++i) {
            Thread.sleep(150L);
        }
        Assertions.assertEquals((int)2, (int)this.client.getNumOfTimelineEntitiesPublished(), (String)"two merged TimelineEntities needs to be published");
        TimelineEntities secondPublishedEntities = this.client.getPublishedEntities(1);
        Assertions.assertEquals((int)2, (int)secondPublishedEntities.getEntities().size(), (String)"Merged TimelineEntities Object needs to 2 TimelineEntity Object");
        Assertions.assertEquals((Object)"2", (Object)((TimelineEntity)secondPublishedEntities.getEntities().get(0)).getId(), (String)"Order of Async Events Needs to be FIFO");
        Assertions.assertEquals((Object)"3", (Object)((TimelineEntity)secondPublishedEntities.getEntities().get(1)).getId(), (String)"Order of Async Events Needs to be FIFO");
    }

    @Test
    void testSyncCall() throws Exception {
        try {
            this.client.putEntities(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("1")});
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("2")});
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("3")});
            this.client.putEntities(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("4")});
        }
        catch (YarnException e) {
            Assertions.fail((String)"Exception is not expected");
        }
        for (int i = 0; i < 4 && this.client.getNumOfTimelineEntitiesPublished() != 3; ++i) {
            Thread.sleep(150L);
        }
        this.printReceivedEntities();
        boolean asyncPushesMerged = this.client.getNumOfTimelineEntitiesPublished() == 3;
        int lastPublishIndex = asyncPushesMerged ? 2 : 3;
        TimelineEntities firstPublishedEntities = this.client.getPublishedEntities(0);
        Assertions.assertEquals((int)1, (int)firstPublishedEntities.getEntities().size(), (String)"sync entities should not be merged with async");
        if (asyncPushesMerged) {
            TimelineEntities secondPublishedEntities = this.client.getPublishedEntities(1);
            Assertions.assertEquals((int)2, (int)secondPublishedEntities.getEntities().size(), (String)"async entities should be merged before publishing sync");
            Assertions.assertEquals((Object)"2", (Object)((TimelineEntity)secondPublishedEntities.getEntities().get(0)).getId(), (String)"Order of Async Events Needs to be FIFO");
            Assertions.assertEquals((Object)"3", (Object)((TimelineEntity)secondPublishedEntities.getEntities().get(1)).getId(), (String)"Order of Async Events Needs to be FIFO");
        } else {
            TimelineEntities secondAsyncPublish = this.client.getPublishedEntities(1);
            Assertions.assertEquals((Object)"2", (Object)((TimelineEntity)secondAsyncPublish.getEntities().get(0)).getId(), (String)"Order of Async Events Needs to be FIFO");
            TimelineEntities thirdAsyncPublish = this.client.getPublishedEntities(2);
            Assertions.assertEquals((Object)"3", (Object)((TimelineEntity)thirdAsyncPublish.getEntities().get(0)).getId(), (String)"Order of Async Events Needs to be FIFO");
        }
        TimelineEntities thirdPublishedEntities = this.client.getPublishedEntities(lastPublishIndex);
        Assertions.assertEquals((int)1, (int)thirdPublishedEntities.getEntities().size(), (String)"sync entities had to be published at the last");
        Assertions.assertEquals((Object)"4", (Object)((TimelineEntity)thirdPublishedEntities.getEntities().get(0)).getId(), (String)"Expected last sync Event is not proper");
    }

    @Test
    void testExceptionCalls() throws Exception {
        this.client.setThrowYarnException(true);
        try {
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("1")});
        }
        catch (YarnException e) {
            Assertions.fail((String)"Async calls are not expected to throw exception");
        }
        try {
            this.client.putEntities(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("2")});
            Assertions.fail((String)"Sync calls are expected to throw exception");
        }
        catch (YarnException e) {
            Assertions.assertEquals((Object)"ActualException", (Object)e.getCause().getMessage(), (String)"Same exception needs to be thrown");
        }
    }

    @Test
    void testConfigurableNumberOfMerges() throws Exception {
        this.client.setSleepBeforeReturn(true);
        try {
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("1")});
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("2")});
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("3")});
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("4")});
            this.client.putEntities(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("5")});
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("6")});
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("7")});
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("8")});
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("9")});
            this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("10")});
        }
        catch (YarnException e) {
            Assertions.fail((String)"No exception expected");
        }
        Thread.sleep(300L);
        this.printReceivedEntities();
        for (TimelineEntities publishedEntities : this.client.publishedEntities) {
            Assertions.assertTrue((publishedEntities.getEntities().size() <= 3 ? 1 : 0) != 0, (String)("Number of entities should not be greater than 3 for each publish, but was " + publishedEntities.getEntities().size()));
        }
    }

    @Test
    void testSetTimelineToken() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        Assertions.assertEquals((int)0, (int)ugi.getTokens().size());
        Assertions.assertNull((Object)this.client.currentTimelineToken, (String)"Timeline token in v2 client should not be set");
        Token token = Token.newInstance((byte[])new byte[0], (String)"kind", (byte[])new byte[0], (String)"service");
        this.client.setTimelineCollectorInfo(CollectorInfo.newInstance(null, (Token)token));
        Assertions.assertNull((Object)this.client.currentTimelineToken, (String)"Timeline token in v2 client should not be set as token kind is unexepcted.");
        Assertions.assertEquals((int)0, (int)ugi.getTokens().size());
        token = Token.newInstance((byte[])new byte[0], (String)TimelineDelegationTokenIdentifier.KIND_NAME.toString(), (byte[])new byte[0], null);
        this.client.setTimelineCollectorInfo(CollectorInfo.newInstance(null, (Token)token));
        Assertions.assertNull((Object)this.client.currentTimelineToken, (String)"Timeline token in v2 client should not be set as serice is not set.");
        Assertions.assertEquals((int)0, (int)ugi.getTokens().size());
        TimelineDelegationTokenIdentifier ident = new TimelineDelegationTokenIdentifier(new Text(ugi.getUserName()), new Text("renewer"), null);
        ident.setSequenceNumber(1);
        token = Token.newInstance((byte[])ident.getBytes(), (String)TimelineDelegationTokenIdentifier.KIND_NAME.toString(), (byte[])new byte[0], (String)"localhost:1234");
        this.client.setTimelineCollectorInfo(CollectorInfo.newInstance(null, (Token)token));
        Assertions.assertEquals((int)1, (int)ugi.getTokens().size());
        Assertions.assertNotNull((Object)this.client.currentTimelineToken, (String)"Timeline token should be set in v2 client.");
        Assertions.assertEquals((Object)token, (Object)this.client.currentTimelineToken);
        ident.setSequenceNumber(20);
        Token newToken = Token.newInstance((byte[])ident.getBytes(), (String)TimelineDelegationTokenIdentifier.KIND_NAME.toString(), (byte[])new byte[0], (String)"localhost:1234");
        this.client.setTimelineCollectorInfo(CollectorInfo.newInstance(null, (Token)newToken));
        Assertions.assertEquals((int)1, (int)ugi.getTokens().size());
        Assertions.assertNotEquals((Object)token, (Object)this.client.currentTimelineToken);
        Assertions.assertEquals((Object)newToken, (Object)this.client.currentTimelineToken);
    }

    @Test
    void testAfterStop() throws Exception {
        this.client.setSleepBeforeReturn(true);
        try {
            this.client.putEntities(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("1")});
            for (int i = 2; i < 20; ++i) {
                this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("" + i)});
            }
            this.client.stop();
            try {
                this.client.putEntitiesAsync(new TimelineEntity[]{TestTimelineClientV2Impl.generateEntity("50")});
                Assertions.fail((String)"Exception expected");
            }
            catch (YarnException i) {}
        }
        catch (YarnException e) {
            Assertions.fail((String)"No exception expected");
        }
        for (int i = 0; i < 5; ++i) {
            TimelineEntities publishedEntities = (TimelineEntities)this.client.publishedEntities.get(this.client.publishedEntities.size() - 1);
            TimelineEntity timelineEntity = (TimelineEntity)publishedEntities.getEntities().get(publishedEntities.getEntities().size() - 1);
            if (timelineEntity.getId().equals("19")) continue;
            Thread.sleep(300L);
        }
        this.printReceivedEntities();
        TimelineEntities publishedEntities = (TimelineEntities)this.client.publishedEntities.get(this.client.publishedEntities.size() - 1);
        TimelineEntity timelineEntity = (TimelineEntity)publishedEntities.getEntities().get(publishedEntities.getEntities().size() - 1);
        Assertions.assertEquals((Object)"19", (Object)timelineEntity.getId(), (String)"");
    }

    private void printReceivedEntities() {
        for (int i = 0; i < this.client.getNumOfTimelineEntitiesPublished(); ++i) {
            TimelineEntities publishedEntities = this.client.getPublishedEntities(i);
            StringBuilder entitiesPerPublish = new StringBuilder();
            for (TimelineEntity entity : publishedEntities.getEntities()) {
                entitiesPerPublish.append(entity.getId());
                entitiesPerPublish.append(",");
            }
            LOG.info("Entities Published @ index " + i + " : " + entitiesPerPublish.toString());
        }
    }

    private static TimelineEntity generateEntity(String id) {
        TimelineEntity entity = new TimelineEntity();
        entity.setId(id);
        entity.setType("testEntity");
        entity.setCreatedTime(Long.valueOf(System.currentTimeMillis()));
        return entity;
    }

    @AfterEach
    public void tearDown() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    private class TestV2TimelineClient
    extends TestV2TimelineClientForExceptionHandling {
        private boolean sleepBeforeReturn;
        private List<TimelineEntities> publishedEntities;

        public TimelineEntities getPublishedEntities(int putIndex) {
            Assertions.assertTrue((putIndex < this.publishedEntities.size() ? 1 : 0) != 0, (String)"Not So many entities Published");
            return this.publishedEntities.get(putIndex);
        }

        public void setSleepBeforeReturn(boolean sleepBeforeReturn) {
            this.sleepBeforeReturn = sleepBeforeReturn;
        }

        public int getNumOfTimelineEntitiesPublished() {
            return this.publishedEntities.size();
        }

        public TestV2TimelineClient(ApplicationId id) {
            super(id);
            this.publishedEntities = new ArrayList<TimelineEntities>();
        }

        protected void putObjects(String path, MultivaluedMap<String, String> params, Object obj) throws IOException, YarnException {
            if (this.isThrowYarnException()) {
                throw new YarnException("ActualException");
            }
            this.publishedEntities.add((TimelineEntities)obj);
            if (this.sleepBeforeReturn) {
                try {
                    Thread.sleep(150L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private class TestV2TimelineClientForExceptionHandling
    extends TimelineV2ClientImpl {
        private boolean throwYarnException;

        public TestV2TimelineClientForExceptionHandling(ApplicationId id) {
            super(id);
        }

        public void setThrowYarnException(boolean throwYarnException) {
            this.throwYarnException = throwYarnException;
        }

        public boolean isThrowYarnException() {
            return this.throwYarnException;
        }

        protected void putObjects(URI base, String path, MultivaluedMap<String, String> params, Object obj) throws IOException, YarnException {
            if (this.throwYarnException) {
                throw new YarnException(TestTimelineClientV2Impl.EXCEPTION_MSG);
            }
            throw new IOException("Failed to get the response from the timeline server.");
        }
    }
}

