/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.filecontroller.ifile;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.ContainerLogFileInfo;
import org.apache.hadoop.yarn.logaggregation.ContainerLogMeta;
import org.apache.hadoop.yarn.logaggregation.ContainerLogsRequest;
import org.apache.hadoop.yarn.logaggregation.ExtendedLogMetaRequest;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerContext;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerFactory;
import org.apache.hadoop.yarn.logaggregation.filecontroller.ifile.LogAggregationIndexedFileController;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;

public class TestLogAggregationIndexedFileController
extends Configured {
    private final String rootLocalLogDir = "target/LocalLogs";
    private final Path rootLocalLogDirPath = new Path("target/LocalLogs");
    private final String remoteLogDir = "target/remote-app";
    private static final FsPermission LOG_FILE_UMASK = FsPermission.createImmutable((short)511);
    private static final UserGroupInformation USER_UGI = UserGroupInformation.createRemoteUser((String)"testUser");
    private static final String ZERO_FILE = "zero";
    private FileSystem fs;
    private ApplicationId appId;
    private ContainerId containerId;
    private NodeId nodeId;
    private ByteArrayOutputStream sysOutStream;

    private Configuration getTestConf() {
        Configuration conf = new Configuration();
        conf.set("yarn.log-aggregation.Indexed.remote-app-log-dir", "target/remote-app");
        conf.set("yarn.log-aggregation.Indexed.remote-app-log-dir-suffix", "logs");
        conf.set("yarn.nodemanager.log-aggregation.compression-type", "gz");
        return conf;
    }

    @BeforeEach
    public void setUp() throws IOException {
        this.setConf(this.getTestConf());
        this.appId = ApplicationId.newInstance((long)123456L, (int)1);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)this.appId, (int)1);
        this.containerId = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        this.nodeId = NodeId.newInstance((String)"localhost", (int)9999);
        this.fs = FileSystem.get((Configuration)this.getConf());
        this.sysOutStream = new ByteArrayOutputStream();
        PrintStream sysOut = new PrintStream(this.sysOutStream);
        System.setOut(sysOut);
        ByteArrayOutputStream sysErrStream = new ByteArrayOutputStream();
        PrintStream sysErr = new PrintStream(sysErrStream);
        System.setErr(sysErr);
    }

    @AfterEach
    public void teardown() throws Exception {
        this.fs.delete(this.rootLocalLogDirPath, true);
        this.fs.delete(new Path("target/remote-app"), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=15000L)
    void testLogAggregationIndexFileFormat() throws Exception {
        if (this.fs.exists(this.rootLocalLogDirPath)) {
            this.fs.delete(this.rootLocalLogDirPath, true);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fs.mkdirs(this.rootLocalLogDirPath));
        Path appLogsDir = new Path(this.rootLocalLogDirPath, this.appId.toString());
        if (this.fs.exists(appLogsDir)) {
            this.fs.delete(appLogsDir, true);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fs.mkdirs(appLogsDir));
        ArrayList<String> logTypes = new ArrayList<String>();
        logTypes.add("syslog");
        logTypes.add("stdout");
        logTypes.add("stderr");
        HashSet<File> files = new HashSet<File>();
        AggregatedLogFormat.LogKey key1 = new AggregatedLogFormat.LogKey(this.containerId.toString());
        for (String logType : logTypes) {
            File file = this.createAndWriteLocalLogFile(this.containerId, appLogsDir, logType);
            files.add(file);
        }
        files.add(this.createZeroLocalLogFile(appLogsDir));
        AggregatedLogFormat.LogValue value = (AggregatedLogFormat.LogValue)Mockito.mock(AggregatedLogFormat.LogValue.class);
        Mockito.when((Object)value.getPendingLogFilesToUploadForThisContainer()).thenReturn(files);
        final ControlledClock clock = new ControlledClock();
        clock.setTime(System.currentTimeMillis());
        LogAggregationIndexedFileController fileFormat = new LogAggregationIndexedFileController(){
            private int rollOverCheck = 0;

            public Clock getSystemClock() {
                return clock;
            }

            public boolean isRollover(FileContext fc, Path candidate) throws IOException {
                ++this.rollOverCheck;
                return this.rollOverCheck >= 3;
            }
        };
        fileFormat.initialize(this.getConf(), "Indexed");
        HashMap appAcls = new HashMap();
        Path appDir = fileFormat.getRemoteAppLogDir(this.appId, USER_UGI.getShortUserName());
        if (this.fs.exists(appDir)) {
            this.fs.delete(appDir, true);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fs.mkdirs(appDir));
        Path logPath = fileFormat.getRemoteNodeLogFileForApp(this.appId, USER_UGI.getShortUserName(), this.nodeId);
        LogAggregationFileControllerContext context = new LogAggregationFileControllerContext(logPath, logPath, true, 1000L, this.appId, appAcls, this.nodeId, USER_UGI);
        fileFormat.initializeWriter(context);
        fileFormat.write(key1, value);
        fileFormat.postWrite(context);
        fileFormat.closeWriter();
        ContainerLogsRequest logRequest = new ContainerLogsRequest();
        logRequest.setAppId(this.appId);
        logRequest.setNodeId(this.nodeId.toString());
        logRequest.setAppOwner(USER_UGI.getShortUserName());
        logRequest.setContainerId(this.containerId.toString());
        logRequest.setBytes(Long.MAX_VALUE);
        List meta = fileFormat.readAggregatedLogsMeta(logRequest);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)meta.size());
        ArrayList<String> fileNames = new ArrayList<String>();
        for (Object log : meta) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.containerId.toString(), (Object)log.getContainerId());
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.nodeId.toString(), (Object)log.getNodeId());
            org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)log.getContainerLogMeta().size());
            for (ContainerLogFileInfo file : log.getContainerLogMeta()) {
                fileNames.add(file.getFileName());
            }
        }
        fileNames.removeAll(logTypes);
        fileNames.remove(ZERO_FILE);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fileNames.isEmpty());
        boolean foundLogs = fileFormat.readAggregatedLogs(logRequest, (OutputStream)System.out);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)foundLogs);
        for (String logType : logTypes) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.sysOutStream.toString().contains(this.logMessage(this.containerId, logType)));
        }
        this.assertZeroFileIsContained(this.sysOutStream.toString());
        this.sysOutStream.reset();
        Configuration factoryConf = new Configuration(this.getConf());
        factoryConf.set("yarn.log-aggregation.file-formats", "Indexed");
        factoryConf.set("yarn.log-aggregation.file-controller.Indexed.class", "org.apache.hadoop.yarn.logaggregation.filecontroller.ifile.LogAggregationIndexedFileController");
        LogAggregationFileControllerFactory factory = new LogAggregationFileControllerFactory(factoryConf);
        LogAggregationFileController fileController = factory.getFileControllerForRead(this.appId, USER_UGI.getShortUserName());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(fileController instanceof LogAggregationIndexedFileController));
        foundLogs = fileController.readAggregatedLogs(logRequest, (OutputStream)System.out);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)foundLogs);
        for (String logType : logTypes) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.sysOutStream.toString().contains(this.logMessage(this.containerId, logType)));
        }
        this.sysOutStream.reset();
        Path checksumFile = new Path(fileFormat.getRemoteAppLogDir(this.appId, USER_UGI.getShortUserName()), LogAggregationUtils.getNodeString((NodeId)this.nodeId) + "-checksum");
        FSDataOutputStream fInput = null;
        try {
            String nodeName = logPath.getName() + "_" + clock.getTime();
            fInput = FileSystem.create((FileSystem)this.fs, (Path)checksumFile, (FsPermission)LOG_FILE_UMASK);
            fInput.writeInt(nodeName.length());
            fInput.write(nodeName.getBytes(Charset.forName("UTF-8")));
            fInput.writeLong(0L);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(fInput);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)fInput);
        meta = fileFormat.readAggregatedLogsMeta(logRequest);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)meta.isEmpty());
        foundLogs = fileFormat.readAggregatedLogs(logRequest, (OutputStream)System.out);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)foundLogs);
        this.sysOutStream.reset();
        this.fs.delete(checksumFile, false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.fs.exists(checksumFile));
        ArrayList<String> newLogTypes = new ArrayList<String>(logTypes);
        files.clear();
        newLogTypes.add("test1");
        files.add(this.createAndWriteLocalLogFile(this.containerId, appLogsDir, "test1"));
        newLogTypes.add("test2");
        files.add(this.createAndWriteLocalLogFile(this.containerId, appLogsDir, "test2"));
        AggregatedLogFormat.LogValue value2 = (AggregatedLogFormat.LogValue)Mockito.mock(AggregatedLogFormat.LogValue.class);
        Mockito.when((Object)value2.getPendingLogFilesToUploadForThisContainer()).thenReturn(files);
        fileFormat.initializeWriter(context);
        fileFormat.write(key1, value2);
        fileFormat.closeWriter();
        meta = fileFormat.readAggregatedLogsMeta(logRequest);
        Assertions.assertThat((int)meta.size()).isEqualTo(1);
        for (ContainerLogMeta log : meta) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.containerId.toString(), (Object)log.getContainerId());
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.nodeId.toString(), (Object)log.getNodeId());
            org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)log.getContainerLogMeta().size());
            for (ContainerLogFileInfo file : log.getContainerLogMeta()) {
                fileNames.add(file.getFileName());
            }
        }
        fileNames.removeAll(logTypes);
        fileNames.remove(ZERO_FILE);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fileNames.isEmpty());
        foundLogs = fileFormat.readAggregatedLogs(logRequest, (OutputStream)System.out);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)foundLogs);
        for (String logType : logTypes) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.sysOutStream.toString().contains(this.logMessage(this.containerId, logType)));
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.sysOutStream.toString().contains(this.logMessage(this.containerId, "test1")));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.sysOutStream.toString().contains(this.logMessage(this.containerId, "test2")));
        this.sysOutStream.reset();
        fileFormat.initializeWriter(context);
        fileFormat.write(key1, value2);
        fileFormat.postWrite(context);
        fileFormat.closeWriter();
        meta = fileFormat.readAggregatedLogsMeta(logRequest);
        Assertions.assertThat((int)meta.size()).isEqualTo(2);
        for (ContainerLogMeta log : meta) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.containerId.toString(), (Object)log.getContainerId());
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.nodeId.toString(), (Object)log.getNodeId());
            for (ContainerLogFileInfo file : log.getContainerLogMeta()) {
                fileNames.add(file.getFileName());
            }
        }
        fileNames.removeAll(newLogTypes);
        fileNames.remove(ZERO_FILE);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fileNames.isEmpty());
        foundLogs = fileFormat.readAggregatedLogs(logRequest, (OutputStream)System.out);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)foundLogs);
        for (String logType : newLogTypes) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.sysOutStream.toString().contains(this.logMessage(this.containerId, logType)));
        }
        this.sysOutStream.reset();
        clock.setTime(System.currentTimeMillis());
        fileFormat.initializeWriter(context);
        fileFormat.write(key1, value2);
        fileFormat.postWrite(context);
        fileFormat.closeWriter();
        FileStatus[] status = this.fs.listStatus(logPath.getParent());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)status.length);
        meta = fileFormat.readAggregatedLogsMeta(logRequest);
        Assertions.assertThat((int)meta.size()).isEqualTo(3);
        for (ContainerLogMeta log : meta) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.containerId.toString(), (Object)log.getContainerId());
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.nodeId.toString(), (Object)log.getNodeId());
            for (ContainerLogFileInfo file : log.getContainerLogMeta()) {
                fileNames.add(file.getFileName());
            }
        }
        fileNames.removeAll(newLogTypes);
        fileNames.remove(ZERO_FILE);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fileNames.isEmpty());
        foundLogs = fileFormat.readAggregatedLogs(logRequest, (OutputStream)System.out);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)foundLogs);
        for (String logType : newLogTypes) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.sysOutStream.toString().contains(this.logMessage(this.containerId, logType)));
        }
        this.sysOutStream.reset();
    }

    @Test
    @Timeout(value=15000L)
    void testFetchApplictionLogsHar() throws Exception {
        ArrayList<String> newLogTypes = new ArrayList<String>();
        newLogTypes.add("syslog");
        newLogTypes.add("stdout");
        newLogTypes.add("stderr");
        newLogTypes.add("test1");
        newLogTypes.add("test2");
        URL harUrl = ClassLoader.getSystemClassLoader().getResource("application_123456_0001.har");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)harUrl);
        Path path = new Path("target/remote-app/" + USER_UGI.getShortUserName() + "/logs/application_123456_0001");
        if (this.fs.exists(path)) {
            this.fs.delete(path, true);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fs.mkdirs(path));
        Path harPath = new Path(path, "application_123456_0001.har");
        this.fs.copyFromLocalFile(false, new Path(harUrl.toURI()), harPath);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fs.exists(harPath));
        LogAggregationIndexedFileController fileFormat = new LogAggregationIndexedFileController();
        fileFormat.initialize(this.getConf(), "Indexed");
        ContainerLogsRequest logRequest = new ContainerLogsRequest();
        logRequest.setAppId(this.appId);
        logRequest.setNodeId(this.nodeId.toString());
        logRequest.setAppOwner(USER_UGI.getShortUserName());
        logRequest.setContainerId(this.containerId.toString());
        logRequest.setBytes(Long.MAX_VALUE);
        List meta = fileFormat.readAggregatedLogsMeta(logRequest);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)meta.size());
        ArrayList<String> fileNames = new ArrayList<String>();
        for (ContainerLogMeta log : meta) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.containerId.toString(), (Object)log.getContainerId());
            org.junit.jupiter.api.Assertions.assertEquals((Object)this.nodeId.toString(), (Object)log.getNodeId());
            for (ContainerLogFileInfo file : log.getContainerLogMeta()) {
                fileNames.add(file.getFileName());
            }
        }
        fileNames.removeAll(newLogTypes);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fileNames.isEmpty());
        boolean foundLogs = fileFormat.readAggregatedLogs(logRequest, (OutputStream)System.out);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)foundLogs);
        for (String logType : newLogTypes) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.sysOutStream.toString().contains(this.logMessage(this.containerId, logType)));
        }
        this.sysOutStream.reset();
    }

    private void assertZeroFileIsContained(String outStream) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)outStream.contains("LogContents:\n\nEnd of LogType:zero"));
    }

    private File createZeroLocalLogFile(Path localLogDir) throws IOException {
        return this.createAndWriteLocalLogFile(localLogDir, ZERO_FILE, "");
    }

    private File createAndWriteLocalLogFile(ContainerId containerId, Path localLogDir, String logType) throws IOException {
        return this.createAndWriteLocalLogFile(localLogDir, logType, this.logMessage(containerId, logType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createAndWriteLocalLogFile(Path localLogDir, String logType, String message) throws IOException {
        File file;
        File file2 = new File(localLogDir.toString(), logType);
        if (file2.exists()) {
            file2.delete();
        }
        file2.createNewFile();
        FileWriter writer = null;
        try {
            writer = new FileWriter(file2);
            writer.write(message);
            ((Writer)writer).close();
            file = file2;
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(writer);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)writer);
        return file;
    }

    private String logMessage(ContainerId containerId, String logType) {
        return "Hello " + containerId + " in " + logType + "!";
    }

    @Test
    void testGetRollOverLogMaxSize() {
        String fileControllerName = "testController";
        String remoteDirConf = String.format("yarn.log-aggregation.%s.remote-app-log-dir", fileControllerName);
        Configuration conf = new Configuration();
        LogAggregationIndexedFileController fileFormat = new LogAggregationIndexedFileController();
        long defaultRolloverSize = 0x280000000L;
        fileFormat.initialize(conf, fileControllerName);
        Assertions.assertThat((long)fileFormat.getRollOverLogMaxSize(conf)).isEqualTo(defaultRolloverSize);
        conf.set(remoteDirConf, "webhdfs://localhost/path");
        fileFormat.initialize(conf, fileControllerName);
        Assertions.assertThat((long)fileFormat.getRollOverLogMaxSize(conf)).isEqualTo(defaultRolloverSize);
        conf.set(remoteDirConf, "s3a://test/path");
        fileFormat.initialize(conf, fileControllerName);
        Assertions.assertThat((long)fileFormat.getRollOverLogMaxSize(conf)).isZero();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetLogMetaFilesOfNode() throws Exception {
        if (this.fs.exists(this.rootLocalLogDirPath)) {
            this.fs.delete(this.rootLocalLogDirPath, true);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fs.mkdirs(this.rootLocalLogDirPath));
        Path appLogsDir = new Path(this.rootLocalLogDirPath, this.appId.toString());
        if (this.fs.exists(appLogsDir)) {
            this.fs.delete(appLogsDir, true);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fs.mkdirs(appLogsDir));
        ArrayList<String> logTypes = new ArrayList<String>();
        logTypes.add("syslog");
        logTypes.add("stdout");
        logTypes.add("stderr");
        HashSet<File> files = new HashSet<File>();
        AggregatedLogFormat.LogKey key1 = new AggregatedLogFormat.LogKey(this.containerId.toString());
        for (String logType : logTypes) {
            File file = this.createAndWriteLocalLogFile(this.containerId, appLogsDir, logType);
            files.add(file);
        }
        files.add(this.createZeroLocalLogFile(appLogsDir));
        AggregatedLogFormat.LogValue value = (AggregatedLogFormat.LogValue)Mockito.mock(AggregatedLogFormat.LogValue.class);
        Mockito.when((Object)value.getPendingLogFilesToUploadForThisContainer()).thenReturn(files);
        LogAggregationIndexedFileController fileFormat = new LogAggregationIndexedFileController();
        fileFormat.initialize(this.getConf(), "Indexed");
        HashMap appAcls = new HashMap();
        Path appDir = fileFormat.getRemoteAppLogDir(this.appId, USER_UGI.getShortUserName());
        if (this.fs.exists(appDir)) {
            this.fs.delete(appDir, true);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fs.mkdirs(appDir));
        Path logPath = fileFormat.getRemoteNodeLogFileForApp(this.appId, USER_UGI.getShortUserName(), this.nodeId);
        LogAggregationFileControllerContext context = new LogAggregationFileControllerContext(logPath, logPath, true, 1000L, this.appId, appAcls, this.nodeId, USER_UGI);
        fileFormat.initializeWriter(context);
        fileFormat.write(key1, value);
        fileFormat.postWrite(context);
        fileFormat.closeWriter();
        ContainerLogsRequest logRequest = new ContainerLogsRequest();
        logRequest.setAppId(this.appId);
        logRequest.setNodeId(this.nodeId.toString());
        logRequest.setAppOwner(USER_UGI.getShortUserName());
        logRequest.setContainerId(this.containerId.toString());
        logRequest.setBytes(Long.MAX_VALUE);
        ControlledClock clock = new ControlledClock();
        clock.setTime(System.currentTimeMillis());
        Path checksumFile = new Path(fileFormat.getRemoteAppLogDir(this.appId, USER_UGI.getShortUserName()), LogAggregationUtils.getNodeString((NodeId)this.nodeId) + "-checksum");
        FSDataOutputStream fInput = null;
        try {
            String nodeName = logPath.getName() + "_" + clock.getTime();
            fInput = FileSystem.create((FileSystem)this.fs, (Path)checksumFile, (FsPermission)LOG_FILE_UMASK);
            fInput.writeInt(nodeName.length());
            fInput.write(nodeName.getBytes(Charset.forName("UTF-8")));
            fInput.writeLong(0L);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(fInput);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)fInput);
        Path nodePath = LogAggregationUtils.getRemoteAppLogDir((Path)fileFormat.getRemoteRootLogDir(), (ApplicationId)this.appId, (String)USER_UGI.getShortUserName(), (String)fileFormat.getRemoteRootLogDirSuffix());
        FileStatus[] nodes = this.fs.listStatus(nodePath);
        ExtendedLogMetaRequest req = new ExtendedLogMetaRequest.ExtendedLogMetaRequestBuilder().build();
        for (FileStatus node : nodes) {
            Map metas = fileFormat.getLogMetaFilesOfNode(req, node, this.appId);
            if (node.getPath().getName().contains("-checksum")) {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)metas.isEmpty(), (String)"Checksum node files should not contain any logs");
                continue;
            }
            org.junit.jupiter.api.Assertions.assertFalse((boolean)metas.isEmpty(), (String)"Non-checksum node files should contain log files");
            org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)((List)metas.values().stream().findFirst().get()).size());
        }
    }
}

