/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.net.URISyntaxException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.TestContainerId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestConverterUtils {
    @Test
    void testConvertUrlWithNoPort() throws URISyntaxException {
        Path expectedPath = new Path("hdfs://foo.com");
        URL url = URL.fromPath((Path)expectedPath);
        Path actualPath = url.toPath();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedPath, (Object)actualPath);
    }

    @Test
    void testConvertUrlWithUserinfo() throws URISyntaxException {
        Path expectedPath = new Path("foo://username:password@example.com:8042");
        URL url = URL.fromPath((Path)expectedPath);
        Path actualPath = url.toPath();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedPath, (Object)actualPath);
    }

    @Test
    void testContainerId() throws URISyntaxException {
        ContainerId id = TestContainerId.newContainerId(0, 0, 0L, 0L);
        String cid = id.toString();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"container_0_0000_00_000000", (Object)cid);
        ContainerId gen = ContainerId.fromString((String)cid);
        org.junit.jupiter.api.Assertions.assertEquals((Object)gen, (Object)id);
    }

    @Test
    void testContainerIdWithEpoch() throws URISyntaxException {
        ContainerId id = TestContainerId.newContainerId(0, 0, 0L, 25645811L);
        String cid = id.toString();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"container_0_0000_00_25645811", (Object)cid);
        ContainerId gen = ContainerId.fromString((String)cid);
        org.junit.jupiter.api.Assertions.assertEquals((Object)gen.toString(), (Object)id.toString());
        long ts = System.currentTimeMillis();
        ContainerId id2 = TestContainerId.newContainerId(36473, 4365472, ts, 4298334883325L);
        String cid2 = id2.toString();
        org.junit.jupiter.api.Assertions.assertEquals((Object)("container_e03_" + ts + "_36473_4365472_999799999997"), (Object)cid2);
        ContainerId gen2 = ContainerId.fromString((String)cid2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)gen2.toString(), (Object)id2.toString());
        ContainerId id3 = TestContainerId.newContainerId(36473, 4365472, ts, 0x2FFFFFFFFFFFDL);
        String cid3 = id3.toString();
        org.junit.jupiter.api.Assertions.assertEquals((Object)("container_e767_" + ts + "_36473_4365472_1099511627773"), (Object)cid3);
        ContainerId gen3 = ContainerId.fromString((String)cid3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)gen3.toString(), (Object)id3.toString());
    }

    @Test
    void testContainerIdNull() throws URISyntaxException {
        org.junit.jupiter.api.Assertions.assertNull((Object)ConverterUtils.toString((ContainerId)null));
    }

    @Test
    void testNodeIdWithDefaultPort() throws URISyntaxException {
        NodeId nid = ConverterUtils.toNodeIdWithDefaultPort((String)"node:10");
        Assertions.assertThat((int)nid.getPort()).isEqualTo(10);
        Assertions.assertThat((String)nid.getHost()).isEqualTo((Object)"node");
        nid = ConverterUtils.toNodeIdWithDefaultPort((String)"node");
        Assertions.assertThat((int)nid.getPort()).isEqualTo(0);
        Assertions.assertThat((String)nid.getHost()).isEqualTo((Object)"node");
    }

    @Test
    void testInvalidContainerId() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ContainerId.fromString((String)"container_e20_1423221031460_0003_01"));
    }

    @Test
    void testInvalidAppattemptId() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ConverterUtils.toApplicationAttemptId((String)"appattempt_1423221031460"));
    }

    @Test
    void testApplicationId() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ConverterUtils.toApplicationId((String)"application_1423221031460"));
    }
}

