/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheLoader;
import org.apache.hadoop.thirdparty.com.google.common.cache.LoadingCache;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.util.FSDownload;
import org.apache.hadoop.yarn.util.Times;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFSDownload {
    private static final Logger LOG = LoggerFactory.getLogger(TestFSDownload.class);
    private static AtomicLong uniqueNumberGenerator = new AtomicLong(System.currentTimeMillis());
    private Configuration conf = new Configuration();
    static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    @AfterAll
    public static void deleteTestDir() throws IOException {
        FileContext fs = FileContext.getLocalFSFileContext();
        fs.delete(new Path("target", TestFSDownload.class.getSimpleName()), true);
    }

    static LocalResource createFile(FileContext files, Path p, int len, Random r, LocalResourceVisibility vis) throws IOException {
        TestFSDownload.createFile(files, p, len, r);
        LocalResource ret = (LocalResource)recordFactory.newRecordInstance(LocalResource.class);
        ret.setResource(URL.fromPath((Path)p));
        ret.setSize((long)len);
        ret.setType(LocalResourceType.FILE);
        ret.setVisibility(vis);
        ret.setTimestamp(files.getFileStatus(p).getModificationTime());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createFile(FileContext files, Path p, int len, Random r) throws IOException {
        try (FSDataOutputStream out = null;){
            byte[] bytes = new byte[len];
            out = files.create(p, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
            r.nextBytes(bytes);
            out.write(bytes);
        }
    }

    static LocalResource createJar(FileContext files, Path p, LocalResourceVisibility vis) throws IOException {
        LOG.info("Create jar file " + p);
        File jarFile = new File(files.makeQualified(p).toUri());
        FileOutputStream stream = new FileOutputStream(jarFile);
        LOG.info("Create jar out stream ");
        JarOutputStream out = new JarOutputStream((OutputStream)stream, new Manifest());
        ZipEntry entry = new ZipEntry("classes/1.class");
        out.putNextEntry(entry);
        out.write(1);
        out.write(2);
        out.write(3);
        out.closeEntry();
        ZipEntry entry2 = new ZipEntry("classes/2.class");
        out.putNextEntry(entry2);
        out.write(1);
        out.write(2);
        out.write(3);
        out.closeEntry();
        LOG.info("Done writing jar stream ");
        out.close();
        LocalResource ret = (LocalResource)recordFactory.newRecordInstance(LocalResource.class);
        ret.setResource(URL.fromPath((Path)p));
        FileStatus status = files.getFileStatus(p);
        ret.setSize(status.getLen());
        ret.setTimestamp(status.getModificationTime());
        ret.setType(LocalResourceType.PATTERN);
        ret.setVisibility(vis);
        ret.setPattern("classes/.*");
        return ret;
    }

    static LocalResource createTarFile(FileContext files, Path p, int len, Random r, LocalResourceVisibility vis) throws IOException, URISyntaxException {
        byte[] bytes = new byte[len];
        r.nextBytes(bytes);
        File archiveFile = new File(p.toUri().getPath() + ".tar");
        archiveFile.createNewFile();
        TarArchiveOutputStream out = new TarArchiveOutputStream((OutputStream)new FileOutputStream(archiveFile));
        TarArchiveEntry entry = new TarArchiveEntry(p.getName());
        entry.setSize((long)bytes.length);
        out.putArchiveEntry((ArchiveEntry)entry);
        out.write(bytes);
        out.closeArchiveEntry();
        out.close();
        LocalResource ret = (LocalResource)recordFactory.newRecordInstance(LocalResource.class);
        ret.setResource(URL.fromPath((Path)new Path(p.toString() + ".tar")));
        ret.setSize((long)len);
        ret.setType(LocalResourceType.ARCHIVE);
        ret.setVisibility(vis);
        ret.setTimestamp(files.getFileStatus(new Path(p.toString() + ".tar")).getModificationTime());
        return ret;
    }

    static LocalResource createTgzFile(FileContext files, Path p, int len, Random r, LocalResourceVisibility vis) throws IOException, URISyntaxException {
        byte[] bytes = new byte[len];
        r.nextBytes(bytes);
        File gzipFile = new File(p.toUri().getPath() + ".tar.gz");
        gzipFile.createNewFile();
        TarArchiveOutputStream out = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream(gzipFile)));
        TarArchiveEntry entry = new TarArchiveEntry(p.getName());
        entry.setSize((long)bytes.length);
        out.putArchiveEntry((ArchiveEntry)entry);
        out.write(bytes);
        out.closeArchiveEntry();
        out.close();
        LocalResource ret = (LocalResource)recordFactory.newRecordInstance(LocalResource.class);
        ret.setResource(URL.fromPath((Path)new Path(p.toString() + ".tar.gz")));
        ret.setSize((long)len);
        ret.setType(LocalResourceType.ARCHIVE);
        ret.setVisibility(vis);
        ret.setTimestamp(files.getFileStatus(new Path(p.toString() + ".tar.gz")).getModificationTime());
        return ret;
    }

    static LocalResource createJarFile(FileContext files, Path p, int len, Random r, LocalResourceVisibility vis) throws IOException, URISyntaxException {
        byte[] bytes = new byte[len];
        r.nextBytes(bytes);
        File archiveFile = new File(p.toUri().getPath() + ".jar");
        archiveFile.createNewFile();
        JarOutputStream out = new JarOutputStream(new FileOutputStream(archiveFile));
        out.putNextEntry(new JarEntry(p.getName()));
        out.write(bytes);
        out.closeEntry();
        out.close();
        LocalResource ret = (LocalResource)recordFactory.newRecordInstance(LocalResource.class);
        ret.setResource(URL.fromPath((Path)new Path(p.toString() + ".jar")));
        ret.setSize((long)len);
        ret.setType(LocalResourceType.ARCHIVE);
        ret.setVisibility(vis);
        ret.setTimestamp(files.getFileStatus(new Path(p.toString() + ".jar")).getModificationTime());
        return ret;
    }

    static LocalResource createZipFile(FileContext files, Path p, int len, Random r, LocalResourceVisibility vis) throws IOException, URISyntaxException {
        byte[] bytes = new byte[len];
        r.nextBytes(bytes);
        File archiveFile = new File(p.toUri().getPath() + ".ZIP");
        archiveFile.createNewFile();
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(archiveFile));
        out.putNextEntry(new ZipEntry(p.getName()));
        out.write(bytes);
        out.closeEntry();
        out.close();
        LocalResource ret = (LocalResource)recordFactory.newRecordInstance(LocalResource.class);
        ret.setResource(URL.fromPath((Path)new Path(p.toString() + ".ZIP")));
        ret.setSize((long)len);
        ret.setType(LocalResourceType.ARCHIVE);
        ret.setVisibility(vis);
        ret.setTimestamp(files.getFileStatus(new Path(p.toString() + ".ZIP")).getModificationTime());
        return ret;
    }

    @Test
    @Timeout(value=10000L)
    void testDownloadBadPublic() throws IOException, URISyntaxException, InterruptedException {
        this.conf.set("fs.permissions.umask-mode", "077");
        FileContext files = FileContext.getLocalFSFileContext((Configuration)this.conf);
        Path basedir = files.makeQualified(new Path("target", TestFSDownload.class.getSimpleName()));
        files.mkdir(basedir, null, true);
        this.conf.setStrings(TestFSDownload.class.getName(), new String[]{basedir.toString()});
        HashMap<LocalResource, LocalResourceVisibility> rsrcVis = new HashMap<LocalResource, LocalResourceVisibility>();
        Random rand = new Random();
        long sharedSeed = rand.nextLong();
        rand.setSeed(sharedSeed);
        System.out.println("SEED: " + sharedSeed);
        HashMap pending = new HashMap();
        ExecutorService exec = HadoopExecutors.newSingleThreadExecutor();
        LocalDirAllocator dirs = new LocalDirAllocator(TestFSDownload.class.getName());
        int size = 512;
        LocalResourceVisibility vis = LocalResourceVisibility.PUBLIC;
        Path path = new Path(basedir, "test-file");
        LocalResource rsrc = TestFSDownload.createFile(files, path, size, rand, vis);
        rsrcVis.put(rsrc, vis);
        Path destPath = dirs.getLocalPathForWrite(basedir.toString(), (long)size, this.conf);
        destPath = new Path(destPath, Long.toString(uniqueNumberGenerator.incrementAndGet()));
        FSDownload fsd = new FSDownload(files, UserGroupInformation.getCurrentUser(), this.conf, destPath, rsrc);
        pending.put(rsrc, exec.submit(fsd));
        exec.shutdown();
        while (!exec.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
        }
        Assertions.assertTrue((boolean)((Future)pending.get(rsrc)).isDone());
        try {
            for (Map.Entry p : pending.entrySet()) {
                ((Future)p.getValue()).get();
                Assertions.fail((String)"We localized a file that is not public.");
            }
        }
        catch (ExecutionException e) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60000L)
    void testDownloadPublicWithStatCache() throws IOException, URISyntaxException, InterruptedException, ExecutionException {
        FileContext files = FileContext.getLocalFSFileContext((Configuration)this.conf);
        Path basedir = files.makeQualified(new Path("target", TestFSDownload.class.getSimpleName()));
        FileSystem f = basedir.getFileSystem(this.conf);
        Assumptions.assumeTrue((boolean)FSDownload.ancestorsHaveExecutePermissions((FileSystem)f, (Path)basedir, null));
        files.mkdir(basedir, null, true);
        this.conf.setStrings(TestFSDownload.class.getName(), new String[]{basedir.toString()});
        int size = 512;
        final ConcurrentHashMap counts = new ConcurrentHashMap();
        final CacheLoader loader = FSDownload.createStatusCacheLoader((Configuration)this.conf);
        final LoadingCache statCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Path, Future<FileStatus>>(){

            public Future<FileStatus> load(Path path) throws Exception {
                AtomicInteger existing;
                AtomicInteger count = (AtomicInteger)counts.get(path);
                if (count == null && (existing = counts.putIfAbsent(path, count = new AtomicInteger(0))) != null) {
                    count = existing;
                }
                count.incrementAndGet();
                return (Future)loader.load((Object)path);
            }
        });
        int fileCount = 3;
        ArrayList<2> tasks = new ArrayList<2>();
        for (int i = 0; i < 3; ++i) {
            Random rand = new Random();
            long sharedSeed = rand.nextLong();
            rand.setSeed(sharedSeed);
            System.out.println("SEED: " + sharedSeed);
            final Path path = new Path(basedir, "test-file-" + i);
            TestFSDownload.createFile(files, path, size, rand);
            final FileSystem fs = path.getFileSystem(this.conf);
            final FileStatus sStat = fs.getFileStatus(path);
            tasks.add(new Callable<Boolean>(){

                @Override
                public Boolean call() throws IOException {
                    return FSDownload.isPublic((FileSystem)fs, (Path)path, (FileStatus)sStat, (LoadingCache)statCache);
                }
            });
        }
        ExecutorService exec = HadoopExecutors.newFixedThreadPool((int)3);
        try {
            List futures = exec.invokeAll(tasks);
            for (Future future : futures) {
                Assertions.assertTrue((boolean)((Boolean)future.get()));
            }
            for (AtomicInteger count : counts.values()) {
                Assertions.assertSame((Object)count.get(), (Object)1);
            }
        }
        finally {
            exec.shutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    @Timeout(value=10000L)
    void testDownload() throws IOException, URISyntaxException, InterruptedException {
        this.conf.set("fs.permissions.umask-mode", "077");
        FileContext files = FileContext.getLocalFSFileContext((Configuration)this.conf);
        Path basedir = files.makeQualified(new Path("target", TestFSDownload.class.getSimpleName()));
        files.mkdir(basedir, null, true);
        this.conf.setStrings(TestFSDownload.class.getName(), new String[]{basedir.toString()});
        HashMap<LocalResource, void> rsrcVis = new HashMap<LocalResource, void>();
        Random rand = new Random();
        long sharedSeed = rand.nextLong();
        rand.setSeed(sharedSeed);
        System.out.println("SEED: " + sharedSeed);
        HashMap pending = new HashMap();
        ExecutorService exec = HadoopExecutors.newSingleThreadExecutor();
        LocalDirAllocator dirs = new LocalDirAllocator(TestFSDownload.class.getName());
        int[] sizes = new int[10];
        for (int i = 0; i < 10; ++i) {
            void var12_13;
            sizes[i] = rand.nextInt(512) + 512;
            LocalResourceVisibility localResourceVisibility = LocalResourceVisibility.PRIVATE;
            if (i % 2 == 1) {
                LocalResourceVisibility localResourceVisibility2 = LocalResourceVisibility.APPLICATION;
            }
            Path p = new Path(basedir, "" + i);
            LocalResource rsrc = TestFSDownload.createFile(files, p, sizes[i], rand, (LocalResourceVisibility)var12_13);
            rsrcVis.put(rsrc, var12_13);
            Path destPath = dirs.getLocalPathForWrite(basedir.toString(), (long)sizes[i], this.conf);
            destPath = new Path(destPath, Long.toString(uniqueNumberGenerator.incrementAndGet()));
            FSDownload fsd = new FSDownload(files, UserGroupInformation.getCurrentUser(), this.conf, destPath, rsrc);
            pending.put(rsrc, exec.submit(fsd));
        }
        exec.shutdown();
        while (!exec.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
        }
        for (Future future : pending.values()) {
            Assertions.assertTrue((boolean)future.isDone());
        }
        try {
            for (Map.Entry entry : pending.entrySet()) {
                Path localized = (Path)((Future)entry.getValue()).get();
                Assertions.assertEquals((long)sizes[Integer.parseInt(localized.getName())], (long)((LocalResource)entry.getKey()).getSize());
                FileStatus status = files.getFileStatus(localized.getParent());
                FsPermission perm = status.getPermission();
                Assertions.assertEquals((Object)new FsPermission(493), (Object)perm, (String)"Cache directory permissions are incorrect");
                status = files.getFileStatus(localized);
                perm = status.getPermission();
                System.out.println("File permission " + perm + " for rsrc vis " + ((LocalResource)entry.getKey()).getVisibility().name());
                assert (rsrcVis.containsKey(entry.getKey()));
                Assertions.assertTrue((perm.toShort() == FSDownload.PRIVATE_FILE_PERMS.toShort() ? 1 : 0) != 0, (String)"Private file should be 500");
            }
        }
        catch (ExecutionException e) {
            throw new IOException("Failed exec", e);
        }
    }

    private void downloadWithFileType(TEST_FILE_TYPE fileType) throws IOException, URISyntaxException, InterruptedException {
        this.conf.set("fs.permissions.umask-mode", "077");
        FileContext files = FileContext.getLocalFSFileContext((Configuration)this.conf);
        Path basedir = files.makeQualified(new Path("target", TestFSDownload.class.getSimpleName()));
        files.mkdir(basedir, null, true);
        this.conf.setStrings(TestFSDownload.class.getName(), new String[]{basedir.toString()});
        Random rand = new Random();
        long sharedSeed = rand.nextLong();
        rand.setSeed(sharedSeed);
        System.out.println("SEED: " + sharedSeed);
        HashMap pending = new HashMap();
        ExecutorService exec = HadoopExecutors.newSingleThreadExecutor();
        LocalDirAllocator dirs = new LocalDirAllocator(TestFSDownload.class.getName());
        int size = rand.nextInt(512) + 512;
        LocalResourceVisibility vis = LocalResourceVisibility.PRIVATE;
        Path p = new Path(basedir, "1");
        String strFileName = "";
        LocalResource rsrc = null;
        switch (fileType) {
            case TAR: {
                rsrc = TestFSDownload.createTarFile(files, p, size, rand, vis);
                break;
            }
            case JAR: {
                rsrc = TestFSDownload.createJarFile(files, p, size, rand, vis);
                rsrc.setType(LocalResourceType.PATTERN);
                break;
            }
            case ZIP: {
                rsrc = TestFSDownload.createZipFile(files, p, size, rand, vis);
                strFileName = p.getName() + ".ZIP";
                break;
            }
            case TGZ: {
                rsrc = TestFSDownload.createTgzFile(files, p, size, rand, vis);
            }
        }
        Path destPath = dirs.getLocalPathForWrite(basedir.toString(), (long)size, this.conf);
        destPath = new Path(destPath, Long.toString(uniqueNumberGenerator.incrementAndGet()));
        FSDownload fsd = new FSDownload(files, UserGroupInformation.getCurrentUser(), this.conf, destPath, rsrc);
        pending.put(rsrc, exec.submit(fsd));
        exec.shutdown();
        while (!exec.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
        }
        try {
            FileStatus[] filesstatus;
            ((Future)pending.get(rsrc)).get();
            for (FileStatus filestatus : filesstatus = files.getDefaultFileSystem().listStatus(basedir)) {
                FileStatus[] childFiles;
                if (!filestatus.isDirectory()) continue;
                for (FileStatus childfile : childFiles = files.getDefaultFileSystem().listStatus(filestatus.getPath())) {
                    if (strFileName.endsWith(".ZIP") && childfile.getPath().getName().equals(strFileName) && !childfile.isDirectory()) {
                        Assertions.fail((String)("Failure...After unzip, there should have been a directory formed with zip file name but found a file. " + childfile.getPath()));
                    }
                    if (!childfile.getPath().getName().startsWith("tmp")) continue;
                    Assertions.fail((String)("Tmp File should not have been there " + childfile.getPath()));
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Failed exec", e);
        }
    }

    @Test
    @Timeout(value=10000L)
    void testDownloadArchive() throws IOException, URISyntaxException, InterruptedException {
        this.downloadWithFileType(TEST_FILE_TYPE.TAR);
    }

    @Test
    @Timeout(value=10000L)
    void testDownloadPatternJar() throws IOException, URISyntaxException, InterruptedException {
        this.downloadWithFileType(TEST_FILE_TYPE.JAR);
    }

    @Test
    @Timeout(value=10000L)
    void testDownloadArchiveZip() throws IOException, URISyntaxException, InterruptedException {
        this.downloadWithFileType(TEST_FILE_TYPE.ZIP);
    }

    @Test
    @Timeout(value=10000L)
    void testDownloadArchiveZipWithTurkishLocale() throws IOException, URISyntaxException, InterruptedException {
        Locale defaultLocale = Locale.getDefault();
        Locale turkishLocale = new Locale("tr", "TR");
        Locale.setDefault(turkishLocale);
        this.downloadWithFileType(TEST_FILE_TYPE.ZIP);
        Locale.setDefault(defaultLocale);
    }

    @Test
    @Timeout(value=10000L)
    void testDownloadArchiveTgz() throws IOException, URISyntaxException, InterruptedException {
        this.downloadWithFileType(TEST_FILE_TYPE.TGZ);
    }

    private void verifyPermsRecursively(FileSystem fs, FileContext files, Path p, LocalResourceVisibility vis) throws IOException {
        FileStatus status = files.getFileStatus(p);
        if (status.isDirectory()) {
            if (vis == LocalResourceVisibility.PUBLIC) {
                Assertions.assertTrue((status.getPermission().toShort() == FSDownload.PUBLIC_DIR_PERMS.toShort() ? 1 : 0) != 0);
            } else {
                Assertions.assertTrue((status.getPermission().toShort() == FSDownload.PRIVATE_DIR_PERMS.toShort() ? 1 : 0) != 0);
            }
            if (!status.isSymlink()) {
                FileStatus[] statuses;
                for (FileStatus stat : statuses = fs.listStatus(p)) {
                    this.verifyPermsRecursively(fs, files, stat.getPath(), vis);
                }
            }
        } else if (vis == LocalResourceVisibility.PUBLIC) {
            Assertions.assertTrue((status.getPermission().toShort() == FSDownload.PUBLIC_FILE_PERMS.toShort() ? 1 : 0) != 0);
        } else {
            Assertions.assertTrue((status.getPermission().toShort() == FSDownload.PRIVATE_FILE_PERMS.toShort() ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    @Timeout(value=10000L)
    void testDirDownload() throws IOException, InterruptedException {
        FileContext files = FileContext.getLocalFSFileContext((Configuration)this.conf);
        Path basedir = files.makeQualified(new Path("target", TestFSDownload.class.getSimpleName()));
        files.mkdir(basedir, null, true);
        this.conf.setStrings(TestFSDownload.class.getName(), new String[]{basedir.toString()});
        HashMap<LocalResource, void> rsrcVis = new HashMap<LocalResource, void>();
        Random rand = new Random();
        long sharedSeed = rand.nextLong();
        rand.setSeed(sharedSeed);
        System.out.println("SEED: " + sharedSeed);
        HashMap pending = new HashMap();
        ExecutorService exec = HadoopExecutors.newSingleThreadExecutor();
        LocalDirAllocator dirs = new LocalDirAllocator(TestFSDownload.class.getName());
        for (int i = 0; i < 5; ++i) {
            void var11_12;
            LocalResourceVisibility localResourceVisibility = LocalResourceVisibility.PRIVATE;
            if (i % 2 == 1) {
                LocalResourceVisibility localResourceVisibility2 = LocalResourceVisibility.APPLICATION;
            }
            Path p = new Path(basedir, "dir" + i + ".jar");
            LocalResource rsrc = TestFSDownload.createJar(files, p, (LocalResourceVisibility)var11_12);
            rsrcVis.put(rsrc, var11_12);
            Path destPath = dirs.getLocalPathForWrite(basedir.toString(), this.conf);
            destPath = new Path(destPath, Long.toString(uniqueNumberGenerator.incrementAndGet()));
            FSDownload fsd = new FSDownload(files, UserGroupInformation.getCurrentUser(), this.conf, destPath, rsrc);
            pending.put(rsrc, exec.submit(fsd));
        }
        exec.shutdown();
        while (!exec.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
        }
        for (Future future : pending.values()) {
            Assertions.assertTrue((boolean)future.isDone());
        }
        try {
            for (Map.Entry entry : pending.entrySet()) {
                Path localized = (Path)((Future)entry.getValue()).get();
                FileStatus status = files.getFileStatus(localized);
                System.out.println("Testing path " + localized);
                assert (status.isDirectory());
                assert (rsrcVis.containsKey(entry.getKey()));
                this.verifyPermsRecursively(localized.getFileSystem(this.conf), files, localized, (LocalResourceVisibility)rsrcVis.get(entry.getKey()));
            }
        }
        catch (ExecutionException e) {
            throw new IOException("Failed exec", e);
        }
    }

    @Test
    @Timeout(value=10000L)
    void testUniqueDestinationPath() throws Exception {
        FileContext files = FileContext.getLocalFSFileContext((Configuration)this.conf);
        Path basedir = files.makeQualified(new Path("target", TestFSDownload.class.getSimpleName()));
        files.mkdir(basedir, null, true);
        this.conf.setStrings(TestFSDownload.class.getName(), new String[]{basedir.toString()});
        ExecutorService singleThreadedExec = HadoopExecutors.newSingleThreadExecutor();
        LocalDirAllocator dirs = new LocalDirAllocator(TestFSDownload.class.getName());
        Path destPath = dirs.getLocalPathForWrite(basedir.toString(), this.conf);
        destPath = new Path(destPath, Long.toString(uniqueNumberGenerator.incrementAndGet()));
        Path p = new Path(basedir, "dir0.jar");
        LocalResourceVisibility vis = LocalResourceVisibility.PRIVATE;
        LocalResource rsrc = TestFSDownload.createJar(files, p, vis);
        FSDownload fsd = new FSDownload(files, UserGroupInformation.getCurrentUser(), this.conf, destPath, rsrc);
        Future rPath = singleThreadedExec.submit(fsd);
        singleThreadedExec.shutdown();
        while (!singleThreadedExec.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
        }
        Assertions.assertTrue((boolean)rPath.isDone());
        Assertions.assertEquals((Object)destPath, (Object)((Path)rPath.get()).getParent());
    }

    @Test
    @Timeout(value=10000L)
    void testResourceTimestampChangeDuringDownload() throws IOException, InterruptedException {
        this.conf = new Configuration();
        FileContext files = FileContext.getLocalFSFileContext((Configuration)this.conf);
        Path basedir = files.makeQualified(new Path("target", TestFSDownload.class.getSimpleName()));
        files.mkdir(basedir, null, true);
        this.conf.setStrings(TestFSDownload.class.getName(), new String[]{basedir.toString()});
        LocalDirAllocator dirs = new LocalDirAllocator(TestFSDownload.class.getName());
        Path path = new Path(basedir, "test-file");
        Random rand = new Random();
        long sharedSeed = rand.nextLong();
        rand.setSeed(sharedSeed);
        int size = 512;
        LocalResourceVisibility vis = LocalResourceVisibility.PUBLIC;
        LocalResource localResource = TestFSDownload.createFile(files, path, size, rand, vis);
        Path destPath = dirs.getLocalPathForWrite(basedir.toString(), (long)size, this.conf);
        destPath = new Path(destPath, Long.toString(uniqueNumberGenerator.incrementAndGet()));
        FSDownload fsDownload = new FSDownload(files, UserGroupInformation.getCurrentUser(), this.conf, destPath, localResource);
        long origLRTimestamp = localResource.getTimestamp();
        long msInADay = 86400000L;
        long modifiedFSTimestamp = origLRTimestamp - 86400000L;
        try {
            Path sourceFsPath = localResource.getResource().toPath();
            FileSystem sourceFs = sourceFsPath.getFileSystem(this.conf);
            sourceFs.setTimes(sourceFsPath, modifiedFSTimestamp, modifiedFSTimestamp);
        }
        catch (URISyntaxException use) {
            Assertions.fail((String)"No exception expected.");
        }
        HashMap pending = new HashMap();
        ExecutorService exec = HadoopExecutors.newSingleThreadExecutor();
        pending.put(localResource, exec.submit(fsDownload));
        exec.shutdown();
        exec.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        Assertions.assertTrue((boolean)((Future)pending.get(localResource)).isDone());
        try {
            for (Map.Entry p : pending.entrySet()) {
                ((Future)p.getValue()).get();
            }
            Assertions.fail((String)"Exception expected from timestamp update during download");
        }
        catch (ExecutionException ee) {
            Assertions.assertTrue((boolean)(ee.getCause() instanceof IOException));
            Assertions.assertTrue((boolean)ee.getMessage().contains(Times.formatISO8601((long)origLRTimestamp)), (String)"Exception contains original timestamp");
            Assertions.assertTrue((boolean)ee.getMessage().contains(Times.formatISO8601((long)modifiedFSTimestamp)), (String)"Exception contains modified timestamp");
        }
    }

    private static enum TEST_FILE_TYPE {
        TAR,
        JAR,
        ZIP,
        TGZ;

    }
}

