/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.thirdparty.com.google.common.collect.Iterables;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.hadoop.yarn.webapp.Router;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.apache.hadoop.yarn.webapp.view.ErrorPage;
import org.apache.hadoop.yarn.webapp.view.RobotsTextPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
@Singleton
public class Dispatcher
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    static final Logger LOG = LoggerFactory.getLogger(Dispatcher.class);
    static final String ERROR_COOKIE = "last-error";
    static final String STATUS_COOKIE = "last-status";
    private final transient Injector injector;
    private final transient Router router;
    private final transient WebApp webApp;
    private volatile boolean devMode = false;

    @Inject
    Dispatcher(WebApp webApp, Injector injector, Router router) {
        this.webApp = webApp;
        this.injector = injector;
        this.router = router;
    }

    public void doOptions(HttpServletRequest req, HttpServletResponse res) {
        res.setHeader("Allow", "GET, POST");
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Router.Dest dest;
        Controller.RequestContext rc;
        String pathInfo;
        String uri;
        block19: {
            Cookie ec;
            String redirectPath;
            res.setCharacterEncoding("UTF-8");
            uri = HtmlQuoting.quoteHtmlChars((String)req.getRequestURI());
            if (uri == null) {
                uri = "/";
            }
            if (this.devMode && uri.equals("/__stop")) {
                res.setStatus(204);
                LOG.info("dev mode restart requested");
                this.prepareToExit();
                return;
            }
            if (uri.equals("/") && (redirectPath = this.webApp.getRedirectPath()) != null && !redirectPath.isEmpty()) {
                if (req.getQueryString() != null) {
                    StringBuilder query = new StringBuilder();
                    query.append(redirectPath);
                    query.append("?");
                    query.append(req.getQueryString().replaceAll("\r", "").replaceAll("\n", ""));
                    redirectPath = query.toString();
                }
                res.sendRedirect(redirectPath);
                return;
            }
            String method = req.getMethod();
            if (method.equals("OPTIONS")) {
                this.doOptions(req, res);
                return;
            }
            if (method.equals("TRACE")) {
                this.doTrace(req, res);
                return;
            }
            if (method.equals("HEAD")) {
                this.doGet(req, res);
                return;
            }
            pathInfo = req.getPathInfo();
            if (pathInfo == null) {
                pathInfo = "/";
            }
            rc = (Controller.RequestContext)this.injector.getInstance(Controller.RequestContext.class);
            if (uri.equals("/robots.txt")) {
                rc.setStatus(302);
                this.render(RobotsTextPage.class);
                return;
            }
            if (this.setCookieParams(rc, req) > 0 && (ec = rc.cookies().get(ERROR_COOKIE)) != null) {
                rc.setStatus(Integer.parseInt(rc.cookies().get(STATUS_COOKIE).getValue()));
                Dispatcher.removeErrorCookies(res, uri);
                rc.set("error.details", ec.getValue());
                this.render(ErrorPage.class);
                return;
            }
            rc.prefix = this.webApp.name();
            dest = null;
            try {
                dest = this.router.resolve(method, pathInfo);
            }
            catch (WebAppException e) {
                rc.error = e;
                if (e.getMessage().contains("not found")) break block19;
                rc.setStatus(500);
                this.render(ErrorPage.class);
                return;
            }
        }
        if (dest == null) {
            rc.setStatus(404);
            this.render(ErrorPage.class);
            return;
        }
        rc.devMode = this.devMode;
        this.setMoreParams(rc, pathInfo, dest);
        Controller controller = (Controller)this.injector.getInstance(dest.controllerClass);
        try {
            dest.action.invoke((Object)controller, (Object[])null);
            if (!rc.rendered) {
                if (dest.defaultViewClass != null) {
                    this.render(dest.defaultViewClass);
                } else if (rc.status == 200) {
                    throw new IllegalStateException("No view rendered for 200");
                }
            }
        }
        catch (Exception e) {
            LOG.error("error handling URI: " + uri, (Throwable)e);
            Dispatcher.redirectToErrorPage(res, e, uri, this.devMode);
        }
    }

    public static void redirectToErrorPage(HttpServletResponse res, Throwable e, String path, boolean devMode) {
        String st = devMode ? ErrorPage.toStackTrace(e, 3072) : "See logs for stack trace";
        res.setStatus(302);
        Cookie cookie = Dispatcher.createCookie(STATUS_COOKIE, String.valueOf(500));
        cookie.setPath(path);
        res.addCookie(cookie);
        cookie = Dispatcher.createCookie(ERROR_COOKIE, st);
        cookie.setPath(path);
        res.addCookie(cookie);
        res.setHeader("Location", path);
    }

    public static void removeErrorCookies(HttpServletResponse res, String path) {
        Dispatcher.removeCookie(res, ERROR_COOKIE, path);
        Dispatcher.removeCookie(res, STATUS_COOKIE, path);
    }

    public static void removeCookie(HttpServletResponse res, String name, String path) {
        LOG.debug("removing cookie {} on {}", (Object)name, (Object)path);
        Cookie c = Dispatcher.createCookie(name, "");
        c.setMaxAge(0);
        c.setPath(path);
        res.addCookie(c);
    }

    private void render(Class<? extends View> cls) {
        ((View)this.injector.getInstance(cls)).render();
    }

    private void setMoreParams(Controller.RequestContext rc, String pathInfo, Router.Dest dest) {
        Preconditions.checkState((boolean)pathInfo.startsWith(dest.prefix), (Object)"prefix should match");
        if (dest.pathParams.size() == 0 || dest.prefix.length() == pathInfo.length()) {
            return;
        }
        String[] parts = (String[])Iterables.toArray((Iterable)WebApp.pathSplitter.split((CharSequence)pathInfo.substring(dest.prefix.length())), String.class);
        LOG.debug("parts={}, params={}", (Object)parts, dest.pathParams);
        for (int i = 0; i < dest.pathParams.size() && i < parts.length; ++i) {
            String key = (String)dest.pathParams.get(i);
            if (key.charAt(0) != ':') continue;
            rc.moreParams().put(key.substring(1), parts[i]);
        }
    }

    private int setCookieParams(Controller.RequestContext rc, HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                rc.cookies().put(cookie.getName(), cookie);
            }
            return cookies.length;
        }
        return 0;
    }

    public void setDevMode(boolean choice) {
        this.devMode = choice;
    }

    private void prepareToExit() {
        Preconditions.checkState((boolean)this.devMode, (Object)"only in dev mode");
        new Timer("webapp exit", true).schedule(new TimerTask(){

            @Override
            public void run() {
                LOG.info("WebAppp /{} exiting...", (Object)Dispatcher.this.webApp.name());
                Dispatcher.this.webApp.stop();
                System.exit(0);
            }
        }, 18L);
    }

    private static Cookie createCookie(String name, String val) {
        Cookie cookie = new Cookie(name, val);
        cookie.setHttpOnly(true);
        return cookie;
    }
}

