/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.client.binding;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.registry.client.exceptions.InvalidRecordException;
import org.apache.hadoop.registry.client.types.Endpoint;
import org.apache.hadoop.registry.client.types.ServiceRecord;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RegistryTypeUtils {
    public static Endpoint urlEndpoint(String api, String protocolType, URI ... uris) {
        return new Endpoint(api, protocolType, uris);
    }

    public static Endpoint restEndpoint(String api, URI ... uris) {
        return RegistryTypeUtils.urlEndpoint((String)api, (String)"REST", (URI[])uris);
    }

    public static Endpoint webEndpoint(String api, URI ... uris) {
        return RegistryTypeUtils.urlEndpoint((String)api, (String)"webui", (URI[])uris);
    }

    public static Endpoint inetAddrEndpoint(String api, String protocolType, String hostname, int port) {
        Preconditions.checkArgument((api != null ? 1 : 0) != 0, (Object)"null API");
        Preconditions.checkArgument((protocolType != null ? 1 : 0) != 0, (Object)"null protocolType");
        Preconditions.checkArgument((hostname != null ? 1 : 0) != 0, (Object)"null hostname");
        return new Endpoint(api, "host/port", protocolType, RegistryTypeUtils.hostnamePortPair((String)hostname, (int)port));
    }

    public static Endpoint ipcEndpoint(String api, InetSocketAddress address) {
        return new Endpoint(api, "host/port", "hadoop/IPC", address == null ? null : RegistryTypeUtils.hostnamePortPair((InetSocketAddress)address));
    }

    public static Map<String, String> map(String key, String val) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(key, val);
        return map;
    }

    public static Map<String, String> uri(String uri) {
        return RegistryTypeUtils.map((String)"uri", (String)uri);
    }

    public static Map<String, String> hostnamePortPair(String hostname, int port) {
        Map map = RegistryTypeUtils.map((String)"host", (String)hostname);
        map.put("port", Integer.toString(port));
        return map;
    }

    public static Map<String, String> hostnamePortPair(InetSocketAddress address) {
        return RegistryTypeUtils.hostnamePortPair((String)address.getHostName(), (int)address.getPort());
    }

    public static void requireAddressType(String required, Endpoint epr) throws InvalidRecordException {
        if (!required.equals(epr.addressType)) {
            throw new InvalidRecordException(epr.toString(), "Address type of " + epr.addressType + " does not match required type of " + required);
        }
    }

    public static List<String> retrieveAddressesUriType(Endpoint epr) throws InvalidRecordException {
        if (epr == null) {
            return null;
        }
        RegistryTypeUtils.requireAddressType((String)"uri", (Endpoint)epr);
        List addresses = epr.addresses;
        if (addresses.size() < 1) {
            throw new InvalidRecordException(epr.toString(), "No addresses in endpoint");
        }
        ArrayList<String> results = new ArrayList<String>(addresses.size());
        for (Map address : addresses) {
            results.add(RegistryTypeUtils.getAddressField((Map)address, (String)"uri"));
        }
        return results;
    }

    public static String getAddressField(Map<String, String> address, String field) throws InvalidRecordException {
        String val = address.get(field);
        if (val == null) {
            throw new InvalidRecordException("", "Missing address field: " + field);
        }
        return val;
    }

    public static List<URL> retrieveAddressURLs(Endpoint epr) throws InvalidRecordException, MalformedURLException {
        if (epr == null) {
            throw new InvalidRecordException("", "Null endpoint");
        }
        List addresses = RegistryTypeUtils.retrieveAddressesUriType((Endpoint)epr);
        ArrayList<URL> results = new ArrayList<URL>(addresses.size());
        for (String address : addresses) {
            results.add(new URL(address));
        }
        return results;
    }

    public static void validateServiceRecord(String path, ServiceRecord record) throws InvalidRecordException {
        if (record == null) {
            throw new InvalidRecordException(path, "Null record");
        }
        if (!"JSONServiceRecord".equals(record.type)) {
            throw new InvalidRecordException(path, "invalid record type field: \"" + record.type + "\"");
        }
        if (record.external != null) {
            for (Endpoint endpoint : record.external) {
                RegistryTypeUtils.validateEndpoint((String)path, (Endpoint)endpoint);
            }
        }
        if (record.internal != null) {
            for (Endpoint endpoint : record.internal) {
                RegistryTypeUtils.validateEndpoint((String)path, (Endpoint)endpoint);
            }
        }
    }

    public static void validateEndpoint(String path, Endpoint endpoint) throws InvalidRecordException {
        if (endpoint == null) {
            throw new InvalidRecordException(path, "Null endpoint");
        }
        try {
            endpoint.validate();
        }
        catch (RuntimeException e) {
            throw new InvalidRecordException(path, e.toString());
        }
    }
}

