/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.client.impl;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.CuratorEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorEventCatcher
implements BackgroundCallback {
    private static final Logger LOG = LoggerFactory.getLogger(CuratorEventCatcher.class);
    public final BlockingQueue<CuratorEvent> events = new LinkedBlockingQueue(1);
    private final AtomicInteger eventCounter = new AtomicInteger(0);

    public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
        LOG.info("received {}", (Object)event);
        this.eventCounter.incrementAndGet();
        this.events.put(event);
    }

    public int getCount() {
        return this.eventCounter.get();
    }

    public CuratorEvent take() throws InterruptedException {
        return (CuratorEvent)this.events.take();
    }
}

