/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.failover;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.client.RMFailoverProxyProvider;
import org.apache.hadoop.yarn.client.RMProxy;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocol;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FederationRMFailoverProxyProvider<T>
implements RMFailoverProxyProvider<T> {
    private static final Logger LOG = LoggerFactory.getLogger(FederationRMFailoverProxyProvider.class);
    private RMProxy<T> rmProxy;
    private Class<T> protocol;
    private T current;
    private YarnConfiguration conf;
    private FederationStateStoreFacade facade;
    private SubClusterId subClusterId;
    private UserGroupInformation originalUser;
    private boolean federationFailoverEnabled = false;

    public void init(Configuration configuration, RMProxy<T> proxy, Class<T> proto) {
        this.rmProxy = proxy;
        this.protocol = proto;
        this.rmProxy.checkAllowedProtocols(this.protocol);
        String clusterId = configuration.get("yarn.resourcemanager.cluster-id");
        Preconditions.checkNotNull((Object)clusterId, (Object)"Missing RM ClusterId");
        this.subClusterId = SubClusterId.newInstance(clusterId);
        FederationRMFailoverProxyProvider federationRMFailoverProxyProvider = this;
        this.facade = federationRMFailoverProxyProvider.facade.getInstance();
        if (configuration instanceof YarnConfiguration) {
            this.conf = (YarnConfiguration)configuration;
        }
        this.federationFailoverEnabled = this.conf.getBoolean("yarn.federation.failover.enabled", true);
        this.conf.setInt("ipc.client.connect.max.retries", this.conf.getInt("yarn.client.failover-retries", 0));
        this.conf.setInt("ipc.client.connect.max.retries.on.timeouts", this.conf.getInt("yarn.client.failover-retries-on-socket-timeouts", 0));
        try {
            this.originalUser = UserGroupInformation.getCurrentUser();
            LOG.info("Initialized Federation proxy for user: {}", (Object)this.originalUser.getUserName());
        }
        catch (IOException e) {
            LOG.warn("Could not get information of requester, ignoring for now.");
            this.originalUser = null;
        }
    }

    @VisibleForTesting
    protected T createRMProxy(InetSocketAddress rmAddress) throws IOException {
        return (T)this.rmProxy.getProxy((Configuration)this.conf, this.protocol, rmAddress);
    }

    private T getProxyInternal(boolean isFailover) {
        Object proxy;
        block4: {
            proxy = this.current;
            try {
                LOG.info("Failing over to the ResourceManager for SubClusterId: {}", (Object)this.subClusterId);
                SubClusterInfo subClusterInfo = this.facade.getSubCluster(this.subClusterId, isFailover);
                this.updateRMAddress(subClusterInfo);
                if (this.originalUser == null) {
                    InetSocketAddress rmAddress = this.rmProxy.getRMAddress(this.conf, this.protocol);
                    LOG.info("Connecting to {} subClusterId {} with protocol {} without a proxy user", new Object[]{rmAddress, this.subClusterId, this.protocol.getSimpleName()});
                    proxy = this.createRMProxy(rmAddress);
                } else {
                    proxy = this.originalUser.doAs(new PrivilegedExceptionAction<T>(){

                        @Override
                        public T run() throws IOException {
                            InetSocketAddress rmAddress = FederationRMFailoverProxyProvider.this.rmProxy.getRMAddress(FederationRMFailoverProxyProvider.this.conf, FederationRMFailoverProxyProvider.this.protocol);
                            LOG.info("Connecting to {} subClusterId {} with protocol {} as user {}", new Object[]{rmAddress, FederationRMFailoverProxyProvider.this.subClusterId, FederationRMFailoverProxyProvider.this.protocol.getSimpleName(), FederationRMFailoverProxyProvider.this.originalUser});
                            return FederationRMFailoverProxyProvider.this.createRMProxy(rmAddress);
                        }
                    });
                }
            }
            catch (Exception e) {
                LOG.error("Exception while trying to create proxy to the ResourceManager for SubClusterId: {}", (Object)this.subClusterId, (Object)e);
                if (proxy != null) break block4;
                throw new YarnRuntimeException(String.format("Create initial proxy to the ResourceManager for SubClusterId %s failed", this.subClusterId), (Throwable)e);
            }
        }
        return proxy;
    }

    private void updateRMAddress(SubClusterInfo subClusterInfo) {
        if (subClusterInfo != null) {
            if (this.protocol == ApplicationClientProtocol.class) {
                this.conf.set("yarn.resourcemanager.address", subClusterInfo.getClientRMServiceAddress());
            } else if (this.protocol == ApplicationMasterProtocol.class) {
                this.conf.set("yarn.resourcemanager.scheduler.address", subClusterInfo.getAMRMServiceAddress());
            } else if (this.protocol == ResourceManagerAdministrationProtocol.class) {
                this.conf.set("yarn.resourcemanager.admin.address", subClusterInfo.getRMAdminServiceAddress());
            }
        }
    }

    public synchronized FailoverProxyProvider.ProxyInfo<T> getProxy() {
        if (this.current == null) {
            this.current = this.getProxyInternal(false);
        }
        return new FailoverProxyProvider.ProxyInfo(this.current, this.subClusterId.getId());
    }

    public synchronized void performFailover(T currentProxy) {
        this.current = this.getProxyInternal(this.federationFailoverEnabled);
        if (this.current != currentProxy) {
            this.closeInternal(currentProxy);
        }
    }

    public Class<T> getInterface() {
        return this.protocol;
    }

    private void closeInternal(T currentProxy) {
        if (currentProxy != null) {
            if (currentProxy instanceof Closeable) {
                try {
                    ((Closeable)currentProxy).close();
                }
                catch (IOException e) {
                    LOG.warn("Exception while trying to close proxy", (Throwable)e);
                }
            } else {
                RPC.stopProxy(currentProxy);
            }
        }
    }

    public synchronized void close() throws IOException {
        this.closeInternal(this.current);
    }
}

