/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.protocolrecords;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.api.records.AppCollectorsMap;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Private
public abstract class ReportNewCollectorInfoRequest {
    public static ReportNewCollectorInfoRequest newInstance(List<AppCollectorsMap> appCollectorsList) {
        ReportNewCollectorInfoRequest request = (ReportNewCollectorInfoRequest)Records.newRecord(ReportNewCollectorInfoRequest.class);
        request.setAppCollectorsList(appCollectorsList);
        return request;
    }

    public static ReportNewCollectorInfoRequest newInstance(ApplicationId id, String collectorAddr) {
        ReportNewCollectorInfoRequest request = (ReportNewCollectorInfoRequest)Records.newRecord(ReportNewCollectorInfoRequest.class);
        request.setAppCollectorsList(Arrays.asList(AppCollectorsMap.newInstance(id, collectorAddr)));
        return request;
    }

    public abstract List<AppCollectorsMap> getAppCollectorsList();

    public abstract void setAppCollectorsList(List<AppCollectorsMap> var1);
}

