/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.records.impl.pb;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerCommonServiceProtos;
import org.apache.hadoop.yarn.server.api.records.AppCollectorsMap;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AppCollectorsMapPBImpl
extends AppCollectorsMap {
    private YarnServerCommonServiceProtos.AppCollectorsMapProto proto = YarnServerCommonServiceProtos.AppCollectorsMapProto.getDefaultInstance();
    private YarnServerCommonServiceProtos.AppCollectorsMapProto.Builder builder = null;
    private boolean viaProto = false;
    private ApplicationId appId = null;
    private String collectorAddr = null;

    public AppCollectorsMapPBImpl() {
        this.builder = YarnServerCommonServiceProtos.AppCollectorsMapProto.newBuilder();
    }

    public AppCollectorsMapPBImpl(YarnServerCommonServiceProtos.AppCollectorsMapProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServerCommonServiceProtos.AppCollectorsMapProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((AppCollectorsMapPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    @Override
    public ApplicationId getApplicationId() {
        YarnServerCommonServiceProtos.AppCollectorsMapProtoOrBuilder p;
        YarnServerCommonServiceProtos.AppCollectorsMapProtoOrBuilder appCollectorsMapProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.appId == null && p.hasAppId()) {
            this.appId = this.convertFromProtoFormat(p.getAppId());
        }
        return this.appId;
    }

    @Override
    public String getCollectorAddr() {
        YarnServerCommonServiceProtos.AppCollectorsMapProtoOrBuilder p;
        YarnServerCommonServiceProtos.AppCollectorsMapProtoOrBuilder appCollectorsMapProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.collectorAddr == null && p.hasAppCollectorAddr()) {
            this.collectorAddr = p.getAppCollectorAddr();
        }
        return this.collectorAddr;
    }

    @Override
    public void setApplicationId(ApplicationId id) {
        this.maybeInitBuilder();
        if (id == null) {
            this.builder.clearAppId();
        }
        this.appId = id;
    }

    @Override
    public void setCollectorAddr(String collectorAddr) {
        this.maybeInitBuilder();
        if (collectorAddr == null) {
            this.builder.clearAppCollectorAddr();
        }
        this.collectorAddr = collectorAddr;
    }

    private ApplicationIdPBImpl convertFromProtoFormat(YarnProtos.ApplicationIdProto p) {
        return new ApplicationIdPBImpl(p);
    }

    private YarnProtos.ApplicationIdProto convertToProtoFormat(ApplicationId t) {
        return ((ApplicationIdPBImpl)t).getProto();
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServerCommonServiceProtos.AppCollectorsMapProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void mergeLocalToBuilder() {
        if (this.appId != null) {
            this.builder.setAppId(this.convertToProtoFormat(this.appId));
        }
        if (this.collectorAddr != null) {
            this.builder.setAppCollectorAddr(this.collectorAddr);
        }
    }
}

