/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.scheduler;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoteNode;
import org.apache.hadoop.yarn.server.scheduler.OpportunisticContainerAllocator;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpportunisticContainerContext {
    private static final Logger LOG = LoggerFactory.getLogger(OpportunisticContainerContext.class);
    private OpportunisticContainerAllocator.AllocationParams appParams = new OpportunisticContainerAllocator.AllocationParams();
    private OpportunisticContainerAllocator.ContainerIdGenerator containerIdGenerator = new OpportunisticContainerAllocator.ContainerIdGenerator();
    private volatile List<RemoteNode> nodeList = new LinkedList<RemoteNode>();
    private final Map<String, RemoteNode> nodeMap = new LinkedHashMap<String, RemoteNode>();
    private final Set<String> blacklist = new HashSet<String>();
    private final TreeMap<SchedulerRequestKey, Map<Resource, ResourceRequest>> outstandingOpReqs = new TreeMap();

    public OpportunisticContainerAllocator.AllocationParams getAppParams() {
        return this.appParams;
    }

    public OpportunisticContainerAllocator.ContainerIdGenerator getContainerIdGenerator() {
        return this.containerIdGenerator;
    }

    public void setContainerIdGenerator(OpportunisticContainerAllocator.ContainerIdGenerator containerIdGenerator) {
        this.containerIdGenerator = containerIdGenerator;
    }

    public Map<String, RemoteNode> getNodeMap() {
        return Collections.unmodifiableMap(this.nodeMap);
    }

    public synchronized void updateNodeList(List<RemoteNode> newNodeList) {
        if (newNodeList != this.nodeList) {
            this.nodeList = newNodeList;
            this.nodeMap.clear();
            for (RemoteNode n : this.nodeList) {
                this.nodeMap.put(n.getNodeId().getHost(), n);
            }
        }
    }

    public void updateAllocationParams(Resource minResource, Resource maxResource, Resource incrResource, int containerTokenExpiryInterval) {
        this.appParams.setMinResource(minResource);
        this.appParams.setMaxResource(maxResource);
        this.appParams.setIncrementResource(incrResource);
        this.appParams.setContainerTokenExpiryInterval(containerTokenExpiryInterval);
    }

    public Set<String> getBlacklist() {
        return this.blacklist;
    }

    public TreeMap<SchedulerRequestKey, Map<Resource, ResourceRequest>> getOutstandingOpReqs() {
        return this.outstandingOpReqs;
    }

    public void addToOutstandingReqs(List<ResourceRequest> resourceAsks) {
        for (ResourceRequest request : resourceAsks) {
            ResourceRequest resourceRequest;
            SchedulerRequestKey schedulerKey = SchedulerRequestKey.create(request);
            if (!ResourceRequest.isAnyLocation((String)request.getResourceName()) || request.getNumContainers() == 0) continue;
            Map<Resource, ResourceRequest> reqMap = this.outstandingOpReqs.get(schedulerKey);
            if (reqMap == null) {
                reqMap = new HashMap<Resource, ResourceRequest>();
                this.outstandingOpReqs.put(schedulerKey, reqMap);
            }
            if ((resourceRequest = reqMap.get(request.getCapability())) == null) {
                resourceRequest = request;
                reqMap.put(request.getCapability(), request);
            } else {
                resourceRequest.setNumContainers(resourceRequest.getNumContainers() + request.getNumContainers());
            }
            if (!ResourceRequest.isAnyLocation((String)request.getResourceName())) continue;
            LOG.info("# of outstandingOpReqs in ANY (at priority = " + schedulerKey.getPriority() + ", allocationReqId = " + schedulerKey.getAllocationRequestId() + ", with capability = " + request.getCapability() + " ) : " + resourceRequest.getNumContainers());
        }
    }

    public void matchAllocationToOutstandingRequest(Resource capability, List<Container> allocatedContainers) {
        for (Container c : allocatedContainers) {
            ResourceRequest rr;
            SchedulerRequestKey schedulerKey = SchedulerRequestKey.extractFrom(c);
            Map<Resource, ResourceRequest> asks = this.outstandingOpReqs.get(schedulerKey);
            if (asks == null || (rr = asks.get(capability)) == null) continue;
            rr.setNumContainers(rr.getNumContainers() - 1);
            if (rr.getNumContainers() != 0) continue;
            asks.remove(capability);
        }
    }
}

