/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp.dao;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.exceptions.YarnException;

@XmlRootElement(name="containerLogsInfo")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ContainerLogsInfo {
    @XmlElement(name="containerLogInfo")
    protected List<ContainerLogInfo> containerLogsInfo;

    public ContainerLogsInfo() {
    }

    public ContainerLogsInfo(Map<String, String> containerLogMeta) throws YarnException {
        this.containerLogsInfo = new ArrayList<ContainerLogInfo>();
        for (Map.Entry<String, String> meta : containerLogMeta.entrySet()) {
            ContainerLogInfo info = new ContainerLogInfo(meta.getKey(), meta.getValue());
            this.containerLogsInfo.add(info);
        }
    }

    public List<ContainerLogInfo> getContainerLogsInfo() {
        return this.containerLogsInfo;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static class ContainerLogInfo {
        private String fileName;
        private String fileSize;

        public ContainerLogInfo() {
        }

        public ContainerLogInfo(String fileName, String fileSize) {
            this.setFileName(fileName);
            this.setFileSize(fileSize);
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(String fileSize) {
            this.fileSize = fileSize;
        }
    }
}

