/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.store.FederationApplicationHomeSubClusterStore;
import org.apache.hadoop.yarn.server.federation.store.FederationDelegationTokenStateStore;
import org.apache.hadoop.yarn.server.federation.store.FederationMembershipStateStore;
import org.apache.hadoop.yarn.server.federation.store.FederationPolicyStore;
import org.apache.hadoop.yarn.server.federation.store.FederationReservationHomeSubClusterStore;
import org.apache.hadoop.yarn.server.federation.store.exception.FederationStateVersionIncompatibleException;
import org.apache.hadoop.yarn.server.records.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface FederationStateStore
extends FederationApplicationHomeSubClusterStore,
FederationMembershipStateStore,
FederationPolicyStore,
FederationReservationHomeSubClusterStore,
FederationDelegationTokenStateStore {
    public static final Logger LOG = LoggerFactory.getLogger(FederationStateStore.class);

    public void init(Configuration var1) throws YarnException;

    public void close() throws Exception;

    public Version getCurrentVersion();

    public Version loadVersion() throws Exception;

    public void storeVersion() throws Exception;

    default public void checkVersion() throws Exception {
        Version loadedVersion = this.loadVersion();
        LOG.info("Loaded Router State Version Info = {}.", (Object)loadedVersion);
        Version currentVersion = this.getCurrentVersion();
        if (loadedVersion != null && loadedVersion.equals(currentVersion)) {
            return;
        }
        if (loadedVersion == null) {
            loadedVersion = currentVersion;
        }
        if (!loadedVersion.isCompatibleTo(currentVersion)) {
            throw new FederationStateVersionIncompatibleException("Expecting Router state version " + currentVersion + ", but loading version " + loadedVersion);
        }
        LOG.info("Storing Router State Version Info {}.", (Object)currentVersion);
        this.storeVersion();
    }
}

