/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.sql;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.yarn.server.federation.store.sql.DatabaseProduct;
import org.apache.hadoop.yarn.server.federation.store.sql.FederationSQLOutParameter;
import org.apache.hadoop.yarn.server.federation.store.sql.ResultSetHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationQueryRunner {
    public static final String YARN_ROUTER_SEQUENCE_NUM = "YARN_ROUTER_SEQUENCE_NUM";
    public static final String YARN_ROUTER_CURRENT_KEY_ID = "YARN_ROUTER_CURRENT_KEY_ID";
    public static final String QUERY_SEQUENCE_TABLE_SQL = "SELECT nextVal FROM sequenceTable WHERE sequenceName = %s";
    public static final String INSERT_SEQUENCE_TABLE_SQL = "INSERT INTO sequenceTable(sequenceName, nextVal) VALUES(%s, %d)";
    public static final String UPDATE_SEQUENCE_TABLE_SQL = "UPDATE sequenceTable SET nextVal = %d WHERE sequenceName = %s";
    public static final Logger LOG = LoggerFactory.getLogger(FederationQueryRunner.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Connection conn, String procedure, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (procedure == null) {
            throw new SQLException("Null Procedure SQL statement");
        }
        if (rsh == null) {
            throw new SQLException("Null ResultSetHandler");
        }
        CallableStatement stmt = null;
        T results = null;
        try {
            stmt = this.getCallableStatement(conn, procedure);
            this.fillStatement(stmt, params);
            stmt.executeUpdate();
            this.retrieveOutParameters(stmt, params);
            results = rsh.handle(params);
        }
        catch (SQLException e) {
            this.rethrow(e, procedure, params);
        }
        finally {
            this.close(stmt);
        }
        return results;
    }

    @VisibleForTesting
    protected CallableStatement getCallableStatement(Connection conn, String procedure) throws SQLException {
        return conn.prepareCall(procedure);
    }

    public void fillStatement(CallableStatement stmt, Object ... params) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == null || stmt == null) continue;
            if (params[i] instanceof FederationSQLOutParameter) {
                FederationSQLOutParameter sqlOutParameter = (FederationSQLOutParameter)params[i];
                sqlOutParameter.register(stmt, i + 1);
                continue;
            }
            stmt.setObject(i + 1, params[i]);
        }
    }

    public void close(Statement stmt) throws SQLException {
        if (stmt != null) {
            stmt.close();
            stmt = null;
        }
    }

    private void retrieveOutParameters(CallableStatement stmt, Object[] params) throws SQLException {
        if (params != null && stmt != null) {
            for (int i = 0; i < params.length; ++i) {
                if (!(params[i] instanceof FederationSQLOutParameter)) continue;
                FederationSQLOutParameter sqlOutParameter = (FederationSQLOutParameter)params[i];
                sqlOutParameter.setValue(stmt, i + 1);
            }
        }
    }

    protected void rethrow(SQLException cause, String sql, Object ... params) throws SQLException {
        String causeMessage = cause.getMessage();
        if (causeMessage == null) {
            causeMessage = "";
        }
        StringBuffer msg = new StringBuffer(causeMessage);
        msg.append(" Query: ");
        msg.append(sql);
        msg.append(" Parameters: ");
        if (params == null) {
            msg.append("[]");
        } else {
            msg.append(Arrays.deepToString(params));
        }
        SQLException e = new SQLException(msg.toString(), cause.getSQLState(), cause.getErrorCode());
        e.setNextException(cause);
        throw e;
    }

    public int selectOrUpdateSequenceTable(Connection connection, String sequenceName, boolean isUpdate) throws SQLException {
        int nextSequenceValue2;
        Statement statement;
        block15: {
            int maxSequenceValue = 0;
            boolean insertDone = false;
            boolean committed = false;
            statement = null;
            try {
                while (maxSequenceValue == 0) {
                    String sql = String.format(QUERY_SEQUENCE_TABLE_SQL, FederationQueryRunner.quoteString(sequenceName));
                    DatabaseProduct.DbType dbType = DatabaseProduct.getDbType(connection);
                    String forUpdateSQL = DatabaseProduct.addForUpdateClause(dbType, sql);
                    statement = connection.createStatement();
                    ResultSet rs = statement.executeQuery(forUpdateSQL);
                    if (rs.next()) {
                        maxSequenceValue = rs.getInt("nextVal");
                        continue;
                    }
                    if (insertDone) {
                        throw new SQLException("Invalid state of SEQUENCE_TABLE for " + sequenceName);
                    }
                    insertDone = true;
                    this.close(statement);
                    statement = connection.createStatement();
                    String insertSQL = String.format(INSERT_SEQUENCE_TABLE_SQL, FederationQueryRunner.quoteString(sequenceName), 1);
                    try {
                        statement.executeUpdate(insertSQL);
                    }
                    catch (SQLException e) {
                        if (DatabaseProduct.isDuplicateKeyError(dbType, e)) continue;
                        LOG.error("Unable to insert into SEQUENCE_TABLE for {}.", (Object)sequenceName, (Object)e);
                        throw e;
                    }
                    finally {
                        this.close(statement);
                    }
                }
                if (isUpdate) {
                    int nextSequenceValue2 = maxSequenceValue + 1;
                    this.close(statement);
                    statement = connection.createStatement();
                    String updateSQL = String.format(UPDATE_SEQUENCE_TABLE_SQL, nextSequenceValue2, FederationQueryRunner.quoteString(sequenceName));
                    statement.executeUpdate(updateSQL);
                    maxSequenceValue = nextSequenceValue2;
                }
                connection.commit();
                committed = true;
                nextSequenceValue2 = maxSequenceValue;
                if (committed) break block15;
            }
            catch (SQLException e) {
                try {
                    throw new SQLException("Unable to selectOrUpdateSequenceTable due to: " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    if (!committed) {
                        FederationQueryRunner.rollbackDBConn(connection);
                    }
                    this.close(statement);
                    throw throwable;
                }
            }
            FederationQueryRunner.rollbackDBConn(connection);
        }
        this.close(statement);
        return nextSequenceValue2;
    }

    public void updateSequenceTable(Connection connection, String sequenceName, int sequenceValue) throws SQLException {
        String updateSQL = String.format(UPDATE_SEQUENCE_TABLE_SQL, sequenceValue, FederationQueryRunner.quoteString(sequenceName));
        boolean committed = false;
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.executeUpdate(updateSQL);
            connection.commit();
            committed = true;
        }
        catch (SQLException e) {
            throw new SQLException("Unable to updateSequenceTable due to: " + e.getMessage());
        }
        finally {
            if (!committed) {
                FederationQueryRunner.rollbackDBConn(connection);
            }
            this.close(statement);
        }
    }

    static void rollbackDBConn(Connection dbConn) {
        try {
            if (dbConn != null && !dbConn.isClosed()) {
                dbConn.rollback();
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to rollback db connection ", (Throwable)e);
        }
    }

    static String quoteString(String input) {
        return "'" + input + "'";
    }
}

