/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerDiagnosticsUpdateEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainerLaunch;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerLivenessContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerReacquisitionContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerSignalContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.ContainerStartContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.DeletionAsUserContext;
import org.apache.hadoop.yarn.server.nodemanager.executor.LocalizerStartContext;
import org.apache.hadoop.yarn.server.nodemanager.util.NodeManagerHardwareUtils;
import org.apache.hadoop.yarn.server.nodemanager.util.ProcessIdFileReader;

public abstract class ContainerExecutor
implements Configurable {
    private static final Log LOG = LogFactory.getLog(ContainerExecutor.class);
    public static final FsPermission TASK_LAUNCH_SCRIPT_PERMISSION = FsPermission.createImmutable((short)448);
    public static final String DIRECTORY_CONTENTS = "directory.info";
    private Configuration conf;
    private ConcurrentMap<ContainerId, Path> pidFiles = new ConcurrentHashMap<ContainerId, Path>();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public abstract void init() throws IOException;

    public Path localizeClasspathJar(Path classPathJar, Path pwd, String owner) throws IOException {
        return classPathJar;
    }

    public abstract void startLocalizer(LocalizerStartContext var1) throws IOException, InterruptedException;

    public abstract int launchContainer(ContainerStartContext var1) throws IOException;

    public abstract boolean signalContainer(ContainerSignalContext var1) throws IOException;

    public abstract void deleteAsUser(DeletionAsUserContext var1) throws IOException, InterruptedException;

    public abstract boolean isContainerAlive(ContainerLivenessContext var1) throws IOException;

    public int reacquireContainer(ContainerReacquisitionContext ctx) throws IOException, InterruptedException {
        int msecLeft;
        Container container = ctx.getContainer();
        String user = ctx.getUser();
        ContainerId containerId = ctx.getContainerId();
        Path pidPath = this.getPidFilePath(containerId);
        if (pidPath == null) {
            LOG.warn((Object)(containerId + " is not active, returning terminated error"));
            return ExitCode.TERMINATED.getExitCode();
        }
        String pid = null;
        pid = ProcessIdFileReader.getProcessId(pidPath);
        if (pid == null) {
            throw new IOException("Unable to determine pid for " + containerId);
        }
        LOG.info((Object)("Reacquiring " + containerId + " with pid " + pid));
        ContainerLivenessContext livenessContext = new ContainerLivenessContext.Builder().setContainer(container).setUser(user).setPid(pid).build();
        while (this.isContainerAlive(livenessContext)) {
            Thread.sleep(1000L);
        }
        String exitCodeFile = ContainerLaunch.getExitCodeFile(pidPath.toString());
        File file = new File(exitCodeFile);
        int sleepMsec = 100;
        for (msecLeft = 2000; !file.exists() && msecLeft >= 0; msecLeft -= 100) {
            if (!this.isContainerActive(containerId)) {
                LOG.info((Object)(containerId + " was deactivated"));
                return ExitCode.TERMINATED.getExitCode();
            }
            Thread.sleep(100L);
        }
        if (msecLeft < 0) {
            throw new IOException("Timeout while waiting for exit code from " + containerId);
        }
        try {
            return Integer.parseInt(FileUtils.readFileToString((File)file).trim());
        }
        catch (NumberFormatException e) {
            throw new IOException("Error parsing exit code from pid " + pid, e);
        }
    }

    public void writeLaunchEnv(OutputStream out, Map<String, String> environment, Map<Path, List<String>> resources, List<String> command, Path logDir) throws IOException {
        this.writeLaunchEnv(out, environment, resources, command, logDir, ContainerLaunch.CONTAINER_SCRIPT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void writeLaunchEnv(OutputStream out, Map<String, String> environment, Map<Path, List<String>> resources, List<String> command, Path logDir, String outFilename) throws IOException {
        ContainerLaunch.ShellScriptBuilder sb = ContainerLaunch.ShellScriptBuilder.create();
        HashSet<String> whitelist = new HashSet<String>();
        whitelist.add("yarn.nodemanager.docker-container-executor.image-name");
        whitelist.add(ApplicationConstants.Environment.HADOOP_YARN_HOME.name());
        whitelist.add(ApplicationConstants.Environment.HADOOP_COMMON_HOME.name());
        whitelist.add(ApplicationConstants.Environment.HADOOP_HDFS_HOME.name());
        whitelist.add(ApplicationConstants.Environment.HADOOP_CONF_DIR.name());
        whitelist.add(ApplicationConstants.Environment.JAVA_HOME.name());
        if (environment != null) {
            for (Map.Entry<String, Object> entry : environment.entrySet()) {
                if (!whitelist.contains(entry.getKey())) {
                    sb.env(entry.getKey().toString(), ((String)entry.getValue()).toString());
                    continue;
                }
                sb.whitelistedEnv(entry.getKey().toString(), ((String)entry.getValue()).toString());
            }
        }
        if (resources != null) {
            for (Map.Entry<String, Object> entry : resources.entrySet()) {
                for (String linkName : (List)entry.getValue()) {
                    sb.symlink((Path)entry.getKey(), new Path(linkName));
                }
            }
        }
        if (this.getConf() != null && this.getConf().getBoolean("yarn.nodemanager.log-container-debug-info.enabled", false)) {
            sb.copyDebugInformation(new Path(outFilename), new Path(logDir, outFilename));
            sb.listDebugInformation(new Path(logDir, DIRECTORY_CONTENTS));
        }
        sb.command(command);
        PrintStream pout = null;
        try {
            pout = new PrintStream(out, false, "UTF-8");
            sb.write(pout);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    protected void logOutput(String output) {
        String shExecOutput = output;
        if (shExecOutput != null) {
            for (String str : shExecOutput.split("\n")) {
                LOG.info((Object)str);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Path getPidFilePath(ContainerId containerId) {
        try {
            this.readLock.lock();
            Path path = (Path)this.pidFiles.get(containerId);
            return path;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected String[] getRunCommand(String command, String groupId, String userName, Path pidFile, Configuration conf) {
        return this.getRunCommand(command, groupId, userName, pidFile, conf, null);
    }

    protected String[] getRunCommand(String command, String groupId, String userName, Path pidFile, Configuration conf, Resource resource) {
        boolean containerSchedPriorityIsSet = false;
        int containerSchedPriorityAdjustment = 0;
        if (conf.get("yarn.nodemanager.container-executor.os.sched.priority.adjustment") != null) {
            containerSchedPriorityIsSet = true;
            containerSchedPriorityAdjustment = conf.getInt("yarn.nodemanager.container-executor.os.sched.priority.adjustment", 0);
        }
        if (Shell.WINDOWS) {
            int cpuRate = -1;
            int memory = -1;
            if (resource != null) {
                if (conf.getBoolean("yarn.nodemanager.windows-container.memory-limit.enabled", false)) {
                    memory = resource.getMemory();
                }
                if (conf.getBoolean("yarn.nodemanager.windows-container.cpu-limit.enabled", false)) {
                    int containerVCores = resource.getVirtualCores();
                    int nodeVCores = NodeManagerHardwareUtils.getVCores(conf);
                    int nodeCpuPercentage = NodeManagerHardwareUtils.getNodeCpuPercentage(conf);
                    float containerCpuPercentage = (float)(nodeCpuPercentage * containerVCores) / (float)nodeVCores;
                    cpuRate = Math.min(10000, (int)(containerCpuPercentage * 100.0f));
                }
            }
            return new String[]{Shell.getWinUtilsPath(), "task", "create", "-m", String.valueOf(memory), "-c", String.valueOf(cpuRate), groupId, "cmd /c " + command};
        }
        ArrayList<String> retCommand = new ArrayList<String>();
        if (containerSchedPriorityIsSet) {
            retCommand.addAll(Arrays.asList("nice", "-n", Integer.toString(containerSchedPriorityAdjustment)));
        }
        retCommand.addAll(Arrays.asList("bash", command));
        return retCommand.toArray(new String[retCommand.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isContainerActive(ContainerId containerId) {
        try {
            this.readLock.lock();
            boolean bl = this.pidFiles.containsKey(containerId);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateContainer(ContainerId containerId, Path pidFilePath) {
        try {
            this.writeLock.lock();
            this.pidFiles.put(containerId, pidFilePath);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivateContainer(ContainerId containerId) {
        try {
            this.writeLock.lock();
            this.pidFiles.remove(containerId);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String getProcessId(ContainerId containerID) {
        String pid = null;
        Path pidFile = (Path)this.pidFiles.get(containerID);
        if (pidFile == null) {
            return pid;
        }
        try {
            pid = ProcessIdFileReader.getProcessId(pidFile);
        }
        catch (IOException e) {
            LOG.error((Object)("Got exception reading pid from pid-file " + pidFile), (Throwable)e);
        }
        return pid;
    }

    public static class DelayedProcessKiller
    extends Thread {
        private Container container;
        private final String user;
        private final String pid;
        private final long delay;
        private final Signal signal;
        private final ContainerExecutor containerExecutor;

        public DelayedProcessKiller(Container container, String user, String pid, long delay, Signal signal, ContainerExecutor containerExecutor) {
            this.container = container;
            this.user = user;
            this.pid = pid;
            this.delay = delay;
            this.signal = signal;
            this.containerExecutor = containerExecutor;
            this.setName("Task killer for " + pid);
            this.setDaemon(false);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.delay);
                this.containerExecutor.signalContainer(new ContainerSignalContext.Builder().setContainer(this.container).setUser(this.user).setPid(this.pid).setSignal(this.signal).build());
            }
            catch (InterruptedException e) {
                return;
            }
            catch (IOException e) {
                String message = "Exception when user " + this.user + " killing task " + this.pid + " in DelayedProcessKiller: " + StringUtils.stringifyException((Throwable)e);
                LOG.warn((Object)message);
                this.container.handle((Event)new ContainerDiagnosticsUpdateEvent(this.container.getContainerId(), message));
            }
        }
    }

    public static enum Signal {
        NULL(0, "NULL"),
        QUIT(3, "SIGQUIT"),
        KILL(9, "SIGKILL"),
        TERM(15, "SIGTERM");

        private final int value;
        private final String str;

        private Signal(int value, String str) {
            this.str = str;
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.str;
        }
    }

    public static enum ExitCode {
        FORCE_KILLED(137),
        TERMINATED(143),
        LOST(154);

        private final int code;

        private ExitCode(int exitCode) {
            this.code = exitCode;
        }

        public int getExitCode() {
            return this.code;
        }

        public String toString() {
            return String.valueOf(this.code);
        }
    }
}

