/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import com.google.inject.Injector;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import java.io.IOException;
import java.io.PrintWriter;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.webapp.Controller;

@Singleton
public class NMWebAppFilter
extends GuiceContainer {
    private Injector injector;
    private Context nmContext;
    private static final long serialVersionUID = 1L;

    @Inject
    public NMWebAppFilter(Injector injector, Context nmContext) {
        super(injector);
        this.injector = injector;
        this.nmContext = nmContext;
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String uri = HtmlQuoting.quoteHtmlChars((String)request.getRequestURI());
        String redirectPath = this.containerLogPageRedirectPath(uri);
        if (redirectPath != null) {
            String redirectMsg = "Redirecting to log server : " + redirectPath;
            PrintWriter out = response.getWriter();
            out.println(redirectMsg);
            response.setHeader("Location", redirectPath);
            response.setStatus(307);
            return;
        }
        super.doFilter(request, response, chain);
    }

    private String containerLogPageRedirectPath(String uri) {
        String redirectPath = null;
        if (!uri.contains("/ws/v1/node") && uri.contains("/containerlogs")) {
            String[] parts = uri.split("/");
            String containerIdStr = parts[3];
            String appOwner = parts[4];
            if (containerIdStr != null && !containerIdStr.isEmpty()) {
                ContainerId containerId = null;
                try {
                    containerId = ContainerId.fromString((String)containerIdStr);
                }
                catch (IllegalArgumentException ex) {
                    return redirectPath;
                }
                ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
                Application app = (Application)this.nmContext.getApplications().get(appId);
                Configuration nmConf = this.nmContext.getLocalDirsHandler().getConfig();
                if (app == null && nmConf.getBoolean("yarn.log-aggregation-enable", false)) {
                    String logServerUrl = nmConf.get("yarn.log.server.url");
                    if (logServerUrl != null && !logServerUrl.isEmpty()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(logServerUrl);
                        sb.append("/");
                        sb.append(this.nmContext.getNodeId().toString());
                        sb.append("/");
                        sb.append(containerIdStr);
                        sb.append("/");
                        sb.append(containerIdStr);
                        sb.append("/");
                        sb.append(appOwner);
                        redirectPath = sb.toString();
                    } else {
                        ((Controller.RequestContext)this.injector.getInstance(Controller.RequestContext.class)).set("redirect.url", "false");
                    }
                }
            }
        }
        return redirectPath;
    }
}

