/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.ResourceView;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.webapp.ContainerLogsUtils;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.ContainersInfo;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.NodeInfo;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.apache.hadoop.yarn.webapp.WebApp;

@Singleton
@Path(value="/ws/v1/node")
public class NMWebServices {
    private Context nmContext;
    private ResourceView rview;
    private WebApp webapp;
    private static RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    @javax.ws.rs.core.Context
    private HttpServletRequest request;
    @javax.ws.rs.core.Context
    private HttpServletResponse response;
    @javax.ws.rs.core.Context
    UriInfo uriInfo;

    @Inject
    public NMWebServices(Context nm, ResourceView view, WebApp webapp) {
        this.nmContext = nm;
        this.rview = view;
        this.webapp = webapp;
    }

    private void init() {
        this.response.setContentType(null);
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public NodeInfo get() {
        return this.getNodeInfo();
    }

    @GET
    @Path(value="/info")
    @Produces(value={"application/json", "application/xml"})
    public NodeInfo getNodeInfo() {
        this.init();
        return new NodeInfo(this.nmContext, this.rview);
    }

    @GET
    @Path(value="/apps")
    @Produces(value={"application/json", "application/xml"})
    public AppsInfo getNodeApps(@QueryParam(value="state") String stateQuery, @QueryParam(value="user") String userQuery) {
        this.init();
        AppsInfo allApps = new AppsInfo();
        for (Map.Entry entry : this.nmContext.getApplications().entrySet()) {
            AppInfo appInfo = new AppInfo((Application)entry.getValue());
            if (stateQuery != null && !stateQuery.isEmpty()) {
                ApplicationState.valueOf(stateQuery);
                if (!appInfo.getState().equalsIgnoreCase(stateQuery)) continue;
            }
            if (userQuery != null) {
                if (userQuery.isEmpty()) {
                    String msg = "Error: You must specify a non-empty string for the user";
                    throw new BadRequestException(msg);
                }
                if (!appInfo.getUser().equals(userQuery)) continue;
            }
            allApps.add(appInfo);
        }
        return allApps;
    }

    @GET
    @Path(value="/apps/{appid}")
    @Produces(value={"application/json", "application/xml"})
    public AppInfo getNodeApp(@PathParam(value="appid") String appId) {
        this.init();
        ApplicationId id = ConverterUtils.toApplicationId((RecordFactory)recordFactory, (String)appId);
        if (id == null) {
            throw new NotFoundException("app with id " + appId + " not found");
        }
        Application app = (Application)this.nmContext.getApplications().get(id);
        if (app == null) {
            throw new NotFoundException("app with id " + appId + " not found");
        }
        return new AppInfo(app);
    }

    @GET
    @Path(value="/containers")
    @Produces(value={"application/json", "application/xml"})
    public ContainersInfo getNodeContainers(@javax.ws.rs.core.Context HttpServletRequest hsr) {
        this.init();
        ContainersInfo allContainers = new ContainersInfo();
        for (Map.Entry entry : this.nmContext.getContainers().entrySet()) {
            if (entry.getValue() == null) continue;
            ContainerInfo info = new ContainerInfo(this.nmContext, (Container)entry.getValue(), this.uriInfo.getBaseUri().toString(), this.webapp.name(), hsr.getRemoteUser());
            allContainers.add(info);
        }
        return allContainers;
    }

    @GET
    @Path(value="/containers/{containerid}")
    @Produces(value={"application/json", "application/xml"})
    public ContainerInfo getNodeContainer(@javax.ws.rs.core.Context HttpServletRequest hsr, @PathParam(value="containerid") String id) {
        ContainerId containerId = null;
        this.init();
        try {
            containerId = ConverterUtils.toContainerId((String)id);
        }
        catch (Exception e) {
            throw new BadRequestException("invalid container id, " + id);
        }
        Container container = (Container)this.nmContext.getContainers().get(containerId);
        if (container == null) {
            throw new NotFoundException("container with id, " + id + ", not found");
        }
        return new ContainerInfo(this.nmContext, container, this.uriInfo.getBaseUri().toString(), this.webapp.name(), hsr.getRemoteUser());
    }

    @GET
    @Path(value="/containerlogs/{containerid}/{filename}")
    @Produces(value={"text/plain"})
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public Response getLogs(@PathParam(value="containerid") String containerIdStr, @PathParam(value="filename") String filename) {
        ContainerId containerId;
        try {
            containerId = ConverterUtils.toContainerId((String)containerIdStr);
        }
        catch (IllegalArgumentException ex) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        File logFile = null;
        try {
            logFile = ContainerLogsUtils.getContainerLogFile(containerId, filename, this.request.getRemoteUser(), this.nmContext);
        }
        catch (NotFoundException ex) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ex.getMessage()).build();
        }
        catch (YarnException ex) {
            return Response.serverError().entity((Object)ex.getMessage()).build();
        }
        try {
            final FileInputStream fis = ContainerLogsUtils.openLogFileForRead(containerIdStr, logFile, this.nmContext);
            StreamingOutput stream = new StreamingOutput(){

                public void write(OutputStream os) throws IOException, WebApplicationException {
                    int len;
                    int bufferSize = 65536;
                    byte[] buf = new byte[bufferSize];
                    while ((len = fis.read(buf, 0, bufferSize)) > 0) {
                        os.write(buf, 0, len);
                    }
                    os.flush();
                }
            };
            return Response.ok((Object)stream).build();
        }
        catch (IOException ex) {
            return Response.serverError().entity((Object)ex.getMessage()).build();
        }
    }
}

