/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.amrmproxy;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.api.protocolrecords.DistributedSchedulingAllocateRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.DistributedSchedulingAllocateResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterDistributedSchedulingAMResponse;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.AMRMProxyApplicationContext;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.RequestInterceptor;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMStateStoreService;

public abstract class AbstractRequestInterceptor
implements RequestInterceptor {
    private Configuration conf;
    private AMRMProxyApplicationContext appContext;
    private RequestInterceptor nextInterceptor;

    @Override
    public void setNextInterceptor(RequestInterceptor nextInterceptor) {
        this.nextInterceptor = nextInterceptor;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        if (this.nextInterceptor != null) {
            this.nextInterceptor.setConf(conf);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void init(AMRMProxyApplicationContext appContext) {
        Preconditions.checkState((this.appContext == null ? 1 : 0) != 0, (Object)("init is called multiple times on this interceptor: " + this.getClass().getName()));
        this.appContext = appContext;
        if (this.nextInterceptor != null) {
            this.nextInterceptor.init(appContext);
        }
    }

    @Override
    public void recover(Map<String, byte[]> recoveredDataMap) {
        if (this.nextInterceptor != null) {
            this.nextInterceptor.recover(recoveredDataMap);
        }
    }

    @Override
    public void shutdown() {
        if (this.nextInterceptor != null) {
            this.nextInterceptor.shutdown();
        }
    }

    @Override
    public RequestInterceptor getNextInterceptor() {
        return this.nextInterceptor;
    }

    @Override
    public AMRMProxyApplicationContext getApplicationContext() {
        return this.appContext;
    }

    public DistributedSchedulingAllocateResponse allocateForDistributedScheduling(DistributedSchedulingAllocateRequest request) throws YarnException, IOException {
        return this.nextInterceptor != null ? this.nextInterceptor.allocateForDistributedScheduling(request) : null;
    }

    public RegisterDistributedSchedulingAMResponse registerApplicationMasterForDistributedScheduling(RegisterApplicationMasterRequest request) throws YarnException, IOException {
        return this.nextInterceptor != null ? this.nextInterceptor.registerApplicationMasterForDistributedScheduling(request) : null;
    }

    public NMStateStoreService getNMStateStore() {
        if (this.appContext == null || this.appContext.getNMCotext() == null) {
            return null;
        }
        return this.appContext.getNMCotext().getNMStateStore();
    }
}

