/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.RMStateVersion;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MemoryRMStateStore
extends RMStateStore {
    RMStateStore.RMState state = new RMStateStore.RMState();
    private int epoch = 0;

    @VisibleForTesting
    public RMStateStore.RMState getState() {
        return this.state;
    }

    public void checkVersion() throws Exception {
    }

    public synchronized int getAndIncrementEpoch() throws Exception {
        int currentEpoch = this.epoch++;
        return currentEpoch;
    }

    public synchronized RMStateStore.RMState loadState() throws Exception {
        RMStateStore.RMState returnState = new RMStateStore.RMState();
        returnState.appState.putAll(this.state.appState);
        returnState.rmSecretManagerState.getMasterKeyState().addAll(this.state.rmSecretManagerState.getMasterKeyState());
        returnState.rmSecretManagerState.getTokenState().putAll(this.state.rmSecretManagerState.getTokenState());
        returnState.rmSecretManagerState.dtSequenceNumber = this.state.rmSecretManagerState.dtSequenceNumber;
        return returnState;
    }

    public synchronized void initInternal(Configuration conf) {
    }

    protected synchronized void startInternal() throws Exception {
    }

    protected synchronized void closeInternal() throws Exception {
    }

    public void storeApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateData) throws Exception {
        RMStateStore.ApplicationState appState = new RMStateStore.ApplicationState(appStateData.getSubmitTime(), appStateData.getStartTime(), appStateData.getApplicationSubmissionContext(), appStateData.getUser());
        this.state.appState.put(appId, appState);
    }

    public void updateApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateData) throws Exception {
        RMStateStore.ApplicationState updatedAppState = new RMStateStore.ApplicationState(appStateData.getSubmitTime(), appStateData.getStartTime(), appStateData.getApplicationSubmissionContext(), appStateData.getUser(), appStateData.getState(), appStateData.getDiagnostics(), appStateData.getFinishTime());
        LOG.info((Object)("Updating final state " + appStateData.getState() + " for app: " + appId));
        if (this.state.appState.get(appId) != null) {
            updatedAppState.attempts.putAll(((RMStateStore.ApplicationState)this.state.appState.get((Object)appId)).attempts);
        }
        this.state.appState.put(appId, updatedAppState);
    }

    public synchronized void storeApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptStateData) throws Exception {
        Credentials credentials = null;
        if (attemptStateData.getAppAttemptTokens() != null) {
            DataInputByteBuffer dibb = new DataInputByteBuffer();
            credentials = new Credentials();
            dibb.reset(new ByteBuffer[]{attemptStateData.getAppAttemptTokens()});
            credentials.readTokenStorageStream((DataInputStream)dibb);
        }
        RMStateStore.ApplicationAttemptState attemptState = new RMStateStore.ApplicationAttemptState(appAttemptId, attemptStateData.getMasterContainer(), credentials, attemptStateData.getStartTime());
        RMStateStore.ApplicationState appState = (RMStateStore.ApplicationState)this.state.getApplicationState().get(attemptState.getAttemptId().getApplicationId());
        if (appState == null) {
            throw new YarnRuntimeException("Application doesn't exist");
        }
        appState.attempts.put(attemptState.getAttemptId(), attemptState);
    }

    public synchronized void updateApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptStateData) throws Exception {
        Credentials credentials = null;
        if (attemptStateData.getAppAttemptTokens() != null) {
            DataInputByteBuffer dibb = new DataInputByteBuffer();
            credentials = new Credentials();
            dibb.reset(new ByteBuffer[]{attemptStateData.getAppAttemptTokens()});
            credentials.readTokenStorageStream((DataInputStream)dibb);
        }
        RMStateStore.ApplicationAttemptState updatedAttemptState = new RMStateStore.ApplicationAttemptState(appAttemptId, attemptStateData.getMasterContainer(), credentials, attemptStateData.getStartTime(), attemptStateData.getState(), attemptStateData.getFinalTrackingUrl(), attemptStateData.getDiagnostics(), attemptStateData.getFinalApplicationStatus(), attemptStateData.getAMContainerExitStatus());
        RMStateStore.ApplicationState appState = (RMStateStore.ApplicationState)this.state.getApplicationState().get(updatedAttemptState.getAttemptId().getApplicationId());
        if (appState == null) {
            throw new YarnRuntimeException("Application doesn't exist");
        }
        LOG.info((Object)("Updating final state " + updatedAttemptState.getState() + " for attempt: " + updatedAttemptState.getAttemptId()));
        appState.attempts.put(updatedAttemptState.getAttemptId(), updatedAttemptState);
    }

    public synchronized void removeApplicationStateInternal(RMStateStore.ApplicationState appState) throws Exception {
        ApplicationId appId = appState.getAppId();
        RMStateStore.ApplicationState removed = (RMStateStore.ApplicationState)this.state.appState.remove(appId);
        if (removed == null) {
            throw new YarnRuntimeException("Removing non-exsisting application state");
        }
    }

    public synchronized void storeRMDelegationTokenAndSequenceNumberState(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate, int latestSequenceNumber) throws Exception {
        Map rmDTState = this.state.rmSecretManagerState.getTokenState();
        if (rmDTState.containsKey(rmDTIdentifier)) {
            IOException e = new IOException("RMDelegationToken: " + rmDTIdentifier + "is already stored.");
            LOG.info((Object)("Error storing info for RMDelegationToken: " + rmDTIdentifier), (Throwable)e);
            throw e;
        }
        rmDTState.put(rmDTIdentifier, renewDate);
        this.state.rmSecretManagerState.dtSequenceNumber = latestSequenceNumber;
        LOG.info((Object)("Store RMDT with sequence number " + rmDTIdentifier.getSequenceNumber() + ". And the latest sequence number is " + latestSequenceNumber));
    }

    public synchronized void removeRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier) throws Exception {
        Map rmDTState = this.state.rmSecretManagerState.getTokenState();
        rmDTState.remove(rmDTIdentifier);
        LOG.info((Object)("Remove RMDT with sequence number " + rmDTIdentifier.getSequenceNumber()));
    }

    protected void updateRMDelegationTokenAndSequenceNumberInternal(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate, int latestSequenceNumber) throws Exception {
        this.removeRMDelegationTokenState(rmDTIdentifier);
        this.storeRMDelegationTokenAndSequenceNumberState(rmDTIdentifier, renewDate, latestSequenceNumber);
        LOG.info((Object)("Update RMDT with sequence number " + rmDTIdentifier.getSequenceNumber()));
    }

    public synchronized void storeRMDTMasterKeyState(DelegationKey delegationKey) throws Exception {
        Set rmDTMasterKeyState = this.state.rmSecretManagerState.getMasterKeyState();
        if (rmDTMasterKeyState.contains(delegationKey)) {
            IOException e = new IOException("RMDTMasterKey with keyID: " + delegationKey.getKeyId() + " is already stored");
            LOG.info((Object)("Error storing info for RMDTMasterKey with keyID: " + delegationKey.getKeyId()), (Throwable)e);
            throw e;
        }
        this.state.getRMDTSecretManagerState().getMasterKeyState().add(delegationKey);
        LOG.info((Object)("Store RMDT master key with key id: " + delegationKey.getKeyId() + ". Currently rmDTMasterKeyState size: " + rmDTMasterKeyState.size()));
    }

    public synchronized void removeRMDTMasterKeyState(DelegationKey delegationKey) throws Exception {
        LOG.info((Object)("Remove RMDT master key with key id: " + delegationKey.getKeyId()));
        Set rmDTMasterKeyState = this.state.rmSecretManagerState.getMasterKeyState();
        rmDTMasterKeyState.remove(delegationKey);
    }

    protected RMStateVersion loadVersion() throws Exception {
        return null;
    }

    protected void storeVersion() throws Exception {
    }

    protected RMStateVersion getCurrentVersion() {
        return null;
    }
}

