/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.FileSystemRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.TestFSRMStateStore;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestFSRMStateStore
extends RMStateStoreTestBase {
    public static final Log LOG = LogFactory.getLog(TestFSRMStateStore.class);
    private TestFSRMStateStoreTester fsTester;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testFSRMStateStore() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            this.fsTester = new TestFSRMStateStoreTester(this, cluster);
            FSDataOutputStream fsOut = null;
            FileSystemRMStateStore fileSystemRMStateStore = (FileSystemRMStateStore)this.fsTester.getRMStateStore();
            String appAttemptIdStr3 = "appattempt_1352994193343_0001_000003";
            ApplicationAttemptId attemptId3 = ConverterUtils.toApplicationAttemptId((String)appAttemptIdStr3);
            Path appDir = this.fsTester.store.getAppDir(attemptId3.getApplicationId().toString());
            Path tempAppAttemptFile = new Path(appDir, attemptId3.toString() + ".tmp");
            fsOut = fileSystemRMStateStore.fs.create(tempAppAttemptFile, false);
            fsOut.write("Some random data ".getBytes());
            fsOut.close();
            this.testRMAppStateStore((RMStateStoreTestBase.RMStateStoreHelper)this.fsTester);
            Assert.assertFalse((boolean)this.fsTester.workingDirPathURI.getFileSystem((Configuration)conf).exists(tempAppAttemptFile));
            this.testRMDTSecretManagerStateStore((RMStateStoreTestBase.RMStateStoreHelper)this.fsTester);
            this.testCheckVersion((RMStateStoreTestBase.RMStateStoreHelper)this.fsTester);
            this.testEpoch((RMStateStoreTestBase.RMStateStoreHelper)this.fsTester);
            this.testAppDeletion((RMStateStoreTestBase.RMStateStoreHelper)this.fsTester);
        }
        finally {
            cluster.shutdown();
        }
    }

    protected void modifyAppState() throws Exception {
        String appAttemptIdStr1 = "appattempt_1352994193343_0001_000001";
        ApplicationAttemptId attemptId1 = ConverterUtils.toApplicationAttemptId((String)appAttemptIdStr1);
        Path appDir = this.fsTester.store.getAppDir(attemptId1.getApplicationId().toString());
        Path appAttemptFile1 = new Path(appDir, attemptId1.toString() + ".new");
        FileSystemRMStateStore fileSystemRMStateStore = (FileSystemRMStateStore)this.fsTester.getRMStateStore();
        fileSystemRMStateStore.renameFile(appAttemptFile1, new Path(appAttemptFile1.getParent(), appAttemptFile1.getName() + ".new"));
    }

    protected void modifyRMDelegationTokenState() throws Exception {
        Path nodeCreatePath = this.fsTester.store.getNodePath(this.fsTester.store.rmDTSecretManagerRoot, "RMDelegationToken_0");
        FileSystemRMStateStore fileSystemRMStateStore = (FileSystemRMStateStore)this.fsTester.getRMStateStore();
        fileSystemRMStateStore.renameFile(nodeCreatePath, new Path(nodeCreatePath.getParent(), nodeCreatePath.getName() + ".new"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testFSRMStateStoreClientRetry() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        cluster.waitActive();
        try {
            TestFSRMStateStoreTester fsTester = new TestFSRMStateStoreTester(this, cluster);
            RMStateStore store = fsTester.getRMStateStore();
            store.setRMDispatcher((Dispatcher)new RMStateStoreTestBase.TestDispatcher());
            AtomicBoolean assertionFailedInThread = new AtomicBoolean(false);
            cluster.shutdownNameNodes();
            1 clientThread = new /* Unavailable Anonymous Inner Class!! */;
            Thread.sleep(2000L);
            clientThread.start();
            cluster.restartNameNode(new String[0]);
            clientThread.join();
            Assert.assertFalse((boolean)assertionFailedInThread.get());
        }
        finally {
            cluster.shutdown();
        }
    }
}

