/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppFailedAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppFinishedAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppNewSavedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRejectedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppUpdateSavedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.TestRMAppTransitions;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptUpdateSavedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

/*
 * Exception performing whole class analysis ignored.
 */
@RunWith(value=Parameterized.class)
public class TestRMAppTransitions {
    static final Log LOG = LogFactory.getLog(TestRMAppTransitions.class);
    private boolean isSecurityEnabled;
    private Configuration conf;
    private RMContext rmContext;
    private static int maxAppAttempts = 2;
    private static int appId = 1;
    private DrainDispatcher rmDispatcher;
    private RMStateStore store;
    private RMApplicationHistoryWriter writer;
    private YarnScheduler scheduler;
    private TestSchedulerEventDispatcher schedulerDispatcher;

    @Parameterized.Parameters
    public static Collection<Object[]> getTestParameters() {
        return Arrays.asList({Boolean.FALSE}, {Boolean.TRUE});
    }

    public TestRMAppTransitions(boolean isSecurityEnabled) {
        this.isSecurityEnabled = isSecurityEnabled;
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        UserGroupInformation.AuthenticationMethod authMethod = UserGroupInformation.AuthenticationMethod.SIMPLE;
        if (this.isSecurityEnabled) {
            authMethod = UserGroupInformation.AuthenticationMethod.KERBEROS;
        }
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)authMethod, (Configuration)this.conf);
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        this.rmDispatcher = new DrainDispatcher();
        ContainerAllocationExpirer containerAllocationExpirer = (ContainerAllocationExpirer)Mockito.mock(ContainerAllocationExpirer.class);
        AMLivelinessMonitor amLivelinessMonitor = (AMLivelinessMonitor)Mockito.mock(AMLivelinessMonitor.class);
        AMLivelinessMonitor amFinishingMonitor = (AMLivelinessMonitor)Mockito.mock(AMLivelinessMonitor.class);
        this.store = (RMStateStore)Mockito.mock(RMStateStore.class);
        this.writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        this.rmContext = new RMContextImpl((Dispatcher)this.rmDispatcher, containerAllocationExpirer, amLivelinessMonitor, amFinishingMonitor, null, new AMRMTokenSecretManager(this.conf), new RMContainerTokenSecretManager(this.conf), new NMTokenSecretManagerInRM(this.conf), new ClientToAMTokenSecretManagerInRM(), this.writer);
        ((RMContextImpl)this.rmContext).setStateStore(this.store);
        this.rmDispatcher.register(RMAppAttemptEventType.class, (EventHandler)new TestApplicationAttemptEventDispatcher(this.rmContext));
        this.rmDispatcher.register(RMAppEventType.class, (EventHandler)new TestApplicationEventDispatcher(this.rmContext));
        this.rmDispatcher.register(RMAppManagerEventType.class, (EventHandler)new TestApplicationManagerEventDispatcher(null));
        this.schedulerDispatcher = new TestSchedulerEventDispatcher(null);
        this.rmDispatcher.register(SchedulerEventType.class, (EventHandler)this.schedulerDispatcher);
        this.rmDispatcher.init(this.conf);
        this.rmDispatcher.start();
    }

    protected RMApp createNewTestApp(ApplicationSubmissionContext submissionContext) {
        ApplicationId applicationId = MockApps.newAppID((int)appId++);
        String user = MockApps.newUserName();
        String name = MockApps.newAppName();
        String queue = MockApps.newQueue();
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", maxAppAttempts);
        this.scheduler = (YarnScheduler)Mockito.mock(YarnScheduler.class);
        ApplicationMasterService masterService = new ApplicationMasterService(this.rmContext, this.scheduler);
        if (submissionContext == null) {
            submissionContext = new ApplicationSubmissionContextPBImpl();
        }
        submissionContext.setApplicationId(applicationId);
        RMAppImpl application = new RMAppImpl(applicationId, this.rmContext, this.conf, name, user, queue, submissionContext, this.scheduler, masterService, System.currentTimeMillis(), "YARN", null);
        TestRMAppTransitions.testAppStartState((ApplicationId)applicationId, (String)user, (String)name, (String)queue, (RMApp)application);
        this.rmContext.getRMApps().putIfAbsent(application.getApplicationId(), application);
        return application;
    }

    private static void testAppStartState(ApplicationId applicationId, String user, String name, String queue, RMApp application) {
        Assert.assertTrue((String)"application start time is not greater then 0", (application.getStartTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"application start time is before currentTime", (application.getStartTime() <= System.currentTimeMillis() ? 1 : 0) != 0);
        Assert.assertEquals((String)"application user is not correct", (Object)user, (Object)application.getUser());
        Assert.assertEquals((String)"application id is not correct", (Object)applicationId, (Object)application.getApplicationId());
        Assert.assertEquals((String)"application progress is not correct", (float)0.0f, (float)application.getProgress(), (float)0.0f);
        Assert.assertEquals((String)"application queue is not correct", (Object)queue, (Object)application.getQueue());
        Assert.assertEquals((String)"application name is not correct", (Object)name, (Object)application.getName());
        Assert.assertEquals((String)"application finish time is not 0 and should be", (long)0L, (long)application.getFinishTime());
        Assert.assertEquals((String)"application tracking url is not correct", null, (Object)application.getTrackingUrl());
        StringBuilder diag = application.getDiagnostics();
        Assert.assertEquals((String)"application diagnostics is not correct", (long)0L, (long)diag.length());
    }

    private static void assertStartTimeSet(RMApp application) {
        Assert.assertTrue((String)"application start time is not greater then 0", (application.getStartTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"application start time is before currentTime", (application.getStartTime() <= System.currentTimeMillis() ? 1 : 0) != 0);
    }

    private static void assertAppState(RMAppState state, RMApp application) {
        Assert.assertEquals((String)("application state should have been " + state), (Object)state, (Object)application.getState());
    }

    private static void assertFinalAppStatus(FinalApplicationStatus status, RMApp application) {
        Assert.assertEquals((String)("Final application status should have been " + status), (Object)status, (Object)application.getFinalApplicationStatus());
    }

    private void assertTimesAtFinish(RMApp application) {
        TestRMAppTransitions.assertStartTimeSet((RMApp)application);
        Assert.assertTrue((String)"application finish time is not greater then 0", (application.getFinishTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"application finish time is not >= then start time", (application.getFinishTime() >= application.getStartTime() ? 1 : 0) != 0);
    }

    private void assertAppFinalStateSaved(RMApp application) {
        ((RMStateStore)Mockito.verify((Object)this.store, (VerificationMode)Mockito.times((int)1))).updateApplicationState((RMStateStore.ApplicationState)Matchers.any(RMStateStore.ApplicationState.class));
    }

    private void assertAppFinalStateNotSaved(RMApp application) {
        ((RMStateStore)Mockito.verify((Object)this.store, (VerificationMode)Mockito.times((int)0))).updateApplicationState((RMStateStore.ApplicationState)Matchers.any(RMStateStore.ApplicationState.class));
    }

    private void assertKilled(RMApp application) {
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.KILLED, (RMApp)application);
        TestRMAppTransitions.assertFinalAppStatus((FinalApplicationStatus)FinalApplicationStatus.KILLED, (RMApp)application);
        StringBuilder diag = application.getDiagnostics();
        Assert.assertEquals((String)"application diagnostics is not correct", (Object)"Application killed by user.", (Object)diag.toString());
    }

    private void assertFailed(RMApp application, String regex) {
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.FAILED, (RMApp)application);
        TestRMAppTransitions.assertFinalAppStatus((FinalApplicationStatus)FinalApplicationStatus.FAILED, (RMApp)application);
        StringBuilder diag = application.getDiagnostics();
        Assert.assertTrue((String)"application diagnostics is not correct", (boolean)diag.toString().matches(regex));
    }

    private void sendAppUpdateSavedEvent(RMApp application) {
        RMAppUpdateSavedEvent event = new RMAppUpdateSavedEvent(application.getApplicationId(), null);
        application.handle((Event)event);
        this.rmDispatcher.await();
    }

    private void sendAttemptUpdateSavedEvent(RMApp application) {
        application.getCurrentAppAttempt().handle((Event)new RMAppAttemptUpdateSavedEvent(application.getCurrentAppAttempt().getAppAttemptId(), null));
    }

    protected RMApp testCreateAppNewSaving(ApplicationSubmissionContext submissionContext) throws IOException {
        RMApp application = this.createNewTestApp(submissionContext);
        ((RMApplicationHistoryWriter)Mockito.verify((Object)this.writer)).applicationStarted((RMApp)Matchers.any(RMApp.class));
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.START);
        application.handle((Event)event);
        TestRMAppTransitions.assertStartTimeSet((RMApp)application);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.NEW_SAVING, (RMApp)application);
        return application;
    }

    protected RMApp testCreateAppSubmittedNoRecovery(ApplicationSubmissionContext submissionContext) throws IOException {
        RMApp application = this.testCreateAppNewSaving(submissionContext);
        RMAppNewSavedEvent event = new RMAppNewSavedEvent(application.getApplicationId(), null);
        application.handle((Event)event);
        TestRMAppTransitions.assertStartTimeSet((RMApp)application);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.SUBMITTED, (RMApp)application);
        return application;
    }

    protected RMApp testCreateAppSubmittedRecovery(ApplicationSubmissionContext submissionContext) throws IOException {
        RMApp application = this.createNewTestApp(submissionContext);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.RECOVER);
        application.handle((Event)event);
        TestRMAppTransitions.assertStartTimeSet((RMApp)application);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.SUBMITTED, (RMApp)application);
        return application;
    }

    protected RMApp testCreateAppAccepted(ApplicationSubmissionContext submissionContext) throws IOException {
        RMApp application = this.testCreateAppSubmittedNoRecovery(submissionContext);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_ACCEPTED);
        application.handle((Event)event);
        TestRMAppTransitions.assertStartTimeSet((RMApp)application);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.ACCEPTED, (RMApp)application);
        return application;
    }

    protected RMApp testCreateAppRunning(ApplicationSubmissionContext submissionContext) throws IOException {
        RMApp application = this.testCreateAppAccepted(submissionContext);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_REGISTERED);
        application.handle((Event)event);
        TestRMAppTransitions.assertStartTimeSet((RMApp)application);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.RUNNING, (RMApp)application);
        TestRMAppTransitions.assertFinalAppStatus((FinalApplicationStatus)FinalApplicationStatus.UNDEFINED, (RMApp)application);
        return application;
    }

    protected RMApp testCreateAppFinalSaving(ApplicationSubmissionContext submissionContext) throws IOException {
        RMApp application = this.testCreateAppRunning(submissionContext);
        RMAppEvent finishingEvent = new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_UNREGISTERED);
        application.handle((Event)finishingEvent);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.FINAL_SAVING, (RMApp)application);
        this.assertAppFinalStateSaved(application);
        return application;
    }

    protected RMApp testCreateAppFinishing(ApplicationSubmissionContext submissionContext) throws IOException {
        assert (submissionContext == null || !submissionContext.getUnmanagedAM());
        RMApp application = this.testCreateAppFinalSaving(submissionContext);
        RMAppUpdateSavedEvent appUpdated = new RMAppUpdateSavedEvent(application.getApplicationId(), null);
        application.handle((Event)appUpdated);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.FINISHING, (RMApp)application);
        this.assertTimesAtFinish(application);
        return application;
    }

    protected RMApp testCreateAppFinished(ApplicationSubmissionContext submissionContext, String diagnostics) throws IOException {
        RMApp application = null;
        application = submissionContext != null && submissionContext.getUnmanagedAM() ? this.testCreateAppRunning(submissionContext) : this.testCreateAppFinishing(submissionContext);
        RMAppFinishedAttemptEvent finishedEvent = new RMAppFinishedAttemptEvent(application.getApplicationId(), diagnostics);
        application.handle((Event)finishedEvent);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.FINISHED, (RMApp)application);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertFinalAppStatus((FinalApplicationStatus)FinalApplicationStatus.FAILED, (RMApp)application);
        Assert.assertTrue((String)"Finished app missing diagnostics", (application.getDiagnostics().indexOf(diagnostics) != -1 ? 1 : 0) != 0);
        return application;
    }

    @Test
    public void testUnmanagedApp() throws IOException {
        ApplicationSubmissionContextPBImpl subContext = new ApplicationSubmissionContextPBImpl();
        subContext.setUnmanagedAM(true);
        LOG.info((Object)"--- START: testUnmanagedAppSuccessPath ---");
        String diagMsg = "some diagnostics";
        RMApp application = this.testCreateAppFinished((ApplicationSubmissionContext)subContext, "some diagnostics");
        Assert.assertTrue((String)"Finished app missing diagnostics", (application.getDiagnostics().indexOf("some diagnostics") != -1 ? 1 : 0) != 0);
        Mockito.reset((Object[])new RMApplicationHistoryWriter[]{this.writer});
        LOG.info((Object)"--- START: testUnmanagedAppFailPath ---");
        application = this.testCreateAppRunning((ApplicationSubmissionContext)subContext);
        RMAppFailedAttemptEvent event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, "", false);
        application.handle((Event)event);
        this.rmDispatcher.await();
        RMAppAttempt appAttempt = application.getCurrentAppAttempt();
        Assert.assertEquals((long)1L, (long)appAttempt.getAppAttemptId().getAttemptId());
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, ".*Unmanaged application.*Failing the application.*");
        this.assertAppFinalStateSaved(application);
    }

    @Test
    public void testAppSuccessPath() throws IOException {
        LOG.info((Object)"--- START: testAppSuccessPath ---");
        String diagMsg = "some diagnostics";
        RMApp application = this.testCreateAppFinished(null, "some diagnostics");
        Assert.assertTrue((String)"Finished application missing diagnostics", (application.getDiagnostics().indexOf("some diagnostics") != -1 ? 1 : 0) != 0);
    }

    @Test(timeout=30000L)
    public void testAppRecoverPath() throws IOException {
        LOG.info((Object)"--- START: testAppRecoverPath ---");
        this.testCreateAppSubmittedRecovery(null);
    }

    @Test(timeout=30000L)
    public void testAppNewKill() throws IOException {
        LOG.info((Object)"--- START: testAppNewKill ---");
        RMApp application = this.createNewTestApp(null);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertKilled(application);
        this.assertAppFinalStateNotSaved(application);
        this.verifyApplicationFinished(RMAppState.KILLED);
        this.verifyAppRemovedSchedulerEvent(RMAppState.KILLED);
    }

    @Test
    public void testAppNewReject() throws IOException {
        LOG.info((Object)"--- START: testAppNewReject ---");
        RMApp application = this.createNewTestApp(null);
        String rejectedText = "Test Application Rejected";
        RMAppRejectedEvent event = new RMAppRejectedEvent(application.getApplicationId(), rejectedText);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, rejectedText);
        this.assertAppFinalStateNotSaved(application);
        this.verifyApplicationFinished(RMAppState.FAILED);
    }

    @Test(timeout=30000L)
    public void testAppNewSavingKill() throws IOException {
        LOG.info((Object)"--- START: testAppNewSavingKill ---");
        RMApp application = this.testCreateAppNewSaving(null);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertKilled(application);
        this.verifyApplicationFinished(RMAppState.KILLED);
        this.verifyAppRemovedSchedulerEvent(RMAppState.KILLED);
    }

    @Test(timeout=30000L)
    public void testAppNewSavingReject() throws IOException {
        LOG.info((Object)"--- START: testAppNewSavingReject ---");
        RMApp application = this.testCreateAppNewSaving(null);
        String rejectedText = "Test Application Rejected";
        RMAppRejectedEvent event = new RMAppRejectedEvent(application.getApplicationId(), rejectedText);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, rejectedText);
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.FAILED);
    }

    @Test(timeout=30000L)
    public void testAppSubmittedRejected() throws IOException {
        LOG.info((Object)"--- START: testAppSubmittedRejected ---");
        RMApp application = this.testCreateAppSubmittedNoRecovery(null);
        String rejectedText = "app rejected";
        RMAppRejectedEvent event = new RMAppRejectedEvent(application.getApplicationId(), rejectedText);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, rejectedText);
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.FAILED);
    }

    @Test
    public void testAppSubmittedKill() throws IOException, InterruptedException {
        LOG.info((Object)"--- START: testAppSubmittedKill---");
        RMApp application = this.testCreateAppSubmittedNoRecovery(null);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertKilled(application);
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.KILLED);
        this.verifyAppRemovedSchedulerEvent(RMAppState.KILLED);
    }

    @Test
    public void testAppAcceptedFailed() throws IOException {
        RMAppFailedAttemptEvent event;
        LOG.info((Object)"--- START: testAppAcceptedFailed ---");
        RMApp application = this.testCreateAppAccepted(null);
        Assert.assertTrue((maxAppAttempts > 1 ? 1 : 0) != 0);
        for (int i = 1; i < maxAppAttempts; ++i) {
            event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, "", false);
            application.handle((Event)event);
            TestRMAppTransitions.assertAppState((RMAppState)RMAppState.ACCEPTED, (RMApp)application);
            event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_ACCEPTED);
            application.handle((Event)event);
            this.rmDispatcher.await();
            TestRMAppTransitions.assertAppState((RMAppState)RMAppState.ACCEPTED, (RMApp)application);
        }
        String message = "Test fail";
        event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, message, false);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, ".*" + message + ".*Failing the application.*");
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.FAILED);
    }

    @Test
    public void testAppAcceptedKill() throws IOException, InterruptedException {
        LOG.info((Object)"--- START: testAppAcceptedKill ---");
        RMApp application = this.testCreateAppAccepted(null);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL);
        application.handle((Event)event);
        this.rmDispatcher.await();
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.KILLING, (RMApp)application);
        RMAppEvent appAttemptKilled = new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_KILLED);
        application.handle((Event)appAttemptKilled);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.FINAL_SAVING, (RMApp)application);
        this.sendAppUpdateSavedEvent(application);
        this.assertKilled(application);
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.KILLED);
        this.verifyAppRemovedSchedulerEvent(RMAppState.KILLED);
    }

    @Test
    public void testAppRunningKill() throws IOException {
        LOG.info((Object)"--- START: testAppRunningKill ---");
        RMApp application = this.testCreateAppRunning(null);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL);
        application.handle((Event)event);
        this.rmDispatcher.await();
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.KILLING, (RMApp)application);
        RMAppFinishedAttemptEvent finishEvent = new RMAppFinishedAttemptEvent(application.getApplicationId(), null);
        application.handle((Event)finishEvent);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.KILLING, (RMApp)application);
        this.sendAttemptUpdateSavedEvent(application);
        this.sendAppUpdateSavedEvent(application);
        this.assertKilled(application);
        this.verifyApplicationFinished(RMAppState.KILLED);
        this.verifyAppRemovedSchedulerEvent(RMAppState.KILLED);
    }

    @Test
    public void testAppRunningFailed() throws IOException {
        LOG.info((Object)"--- START: testAppRunningFailed ---");
        RMApp application = this.testCreateAppRunning(null);
        RMAppAttempt appAttempt = application.getCurrentAppAttempt();
        int expectedAttemptId = 1;
        Assert.assertEquals((long)expectedAttemptId, (long)appAttempt.getAppAttemptId().getAttemptId());
        Assert.assertTrue((maxAppAttempts > 1 ? 1 : 0) != 0);
        for (int i = 1; i < maxAppAttempts; ++i) {
            RMAppFailedAttemptEvent event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, "", false);
            application.handle((Event)event);
            this.rmDispatcher.await();
            TestRMAppTransitions.assertAppState((RMAppState)RMAppState.ACCEPTED, (RMApp)application);
            appAttempt = application.getCurrentAppAttempt();
            Assert.assertEquals((long)(++expectedAttemptId), (long)appAttempt.getAppAttemptId().getAttemptId());
            event = new RMAppEvent(application.getApplicationId(), RMAppEventType.APP_ACCEPTED);
            application.handle((Event)event);
            this.rmDispatcher.await();
            TestRMAppTransitions.assertAppState((RMAppState)RMAppState.ACCEPTED, (RMApp)application);
            event = new RMAppEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_REGISTERED);
            application.handle((Event)event);
            this.rmDispatcher.await();
            TestRMAppTransitions.assertAppState((RMAppState)RMAppState.RUNNING, (RMApp)application);
        }
        RMAppFailedAttemptEvent event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, "", false);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertFailed(application, ".*Failing the application.*");
        this.assertAppFinalStateSaved(application);
        event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertFailed(application, ".*Failing the application.*");
        this.assertAppFinalStateSaved(application);
        this.verifyApplicationFinished(RMAppState.FAILED);
    }

    @Test
    public void testAppAtFinishingIgnoreKill() throws IOException {
        LOG.info((Object)"--- START: testAppAtFinishingIgnoreKill ---");
        RMApp application = this.testCreateAppFinishing(null);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL);
        application.handle((Event)event);
        this.rmDispatcher.await();
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.FINISHING, (RMApp)application);
    }

    @Test
    public void testAppFinalSavingToFinished() throws IOException {
        LOG.info((Object)"--- START: testAppFinalSavingToFinished ---");
        RMApp application = this.testCreateAppFinalSaving(null);
        String diagMsg = "some diagnostics";
        RMAppFinishedAttemptEvent event = new RMAppFinishedAttemptEvent(application.getApplicationId(), "some diagnostics");
        application.handle((Event)event);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.FINAL_SAVING, (RMApp)application);
        RMAppUpdateSavedEvent appUpdated = new RMAppUpdateSavedEvent(application.getApplicationId(), null);
        application.handle((Event)appUpdated);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.FINISHED, (RMApp)application);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertFinalAppStatus((FinalApplicationStatus)FinalApplicationStatus.FAILED, (RMApp)application);
        Assert.assertTrue((String)"Finished app missing diagnostics", (application.getDiagnostics().indexOf("some diagnostics") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testAppFinishedFinished() throws IOException {
        LOG.info((Object)"--- START: testAppFinishedFinished ---");
        RMApp application = this.testCreateAppFinished(null, "");
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.FINISHED, (RMApp)application);
        StringBuilder diag = application.getDiagnostics();
        Assert.assertEquals((String)"application diagnostics is not correct", (Object)"", (Object)diag.toString());
        this.verifyApplicationFinished(RMAppState.FINISHED);
    }

    @Test(timeout=30000L)
    public void testAppFailedFailed() throws IOException {
        LOG.info((Object)"--- START: testAppFailedFailed ---");
        RMApp application = this.testCreateAppNewSaving(null);
        RMAppRejectedEvent event = new RMAppRejectedEvent(application.getApplicationId(), "");
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAppUpdateSavedEvent(application);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.FAILED, (RMApp)application);
        event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.FAILED, (RMApp)application);
        this.verifyApplicationFinished(RMAppState.FAILED);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.FAILED, (RMApp)application);
    }

    @Test(timeout=30000L)
    public void testAppKilledKilled() throws IOException {
        LOG.info((Object)"--- START: testAppKilledKilled ---");
        RMApp application = this.testCreateAppRunning(null);
        RMAppEvent event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.sendAttemptUpdateSavedEvent(application);
        this.sendAppUpdateSavedEvent(application);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.KILLED, (RMApp)application);
        event = new RMAppFinishedAttemptEvent(application.getApplicationId(), "");
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.KILLED, (RMApp)application);
        event = new RMAppFailedAttemptEvent(application.getApplicationId(), RMAppEventType.ATTEMPT_FAILED, "", false);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.KILLED, (RMApp)application);
        event = new RMAppEvent(application.getApplicationId(), RMAppEventType.KILL);
        application.handle((Event)event);
        this.rmDispatcher.await();
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.KILLED, (RMApp)application);
        this.verifyApplicationFinished(RMAppState.KILLED);
        this.assertTimesAtFinish(application);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.KILLED, (RMApp)application);
    }

    @Test(timeout=30000L)
    public void testAppsRecoveringStates() throws Exception {
        RMStateStore.RMState state = new RMStateStore.RMState();
        Map applicationState = state.getApplicationState();
        this.createRMStateForApplications(applicationState, RMAppState.FINISHED);
        this.createRMStateForApplications(applicationState, RMAppState.KILLED);
        this.createRMStateForApplications(applicationState, RMAppState.FAILED);
        for (RMStateStore.ApplicationState appState : applicationState.values()) {
            this.testRecoverApplication(appState, state);
        }
    }

    public void testRecoverApplication(RMStateStore.ApplicationState appState, RMStateStore.RMState rmState) throws Exception {
        ApplicationSubmissionContext submissionContext = appState.getApplicationSubmissionContext();
        RMAppImpl application = new RMAppImpl(appState.getAppId(), this.rmContext, this.conf, submissionContext.getApplicationName(), null, submissionContext.getQueue(), submissionContext, null, null, appState.getSubmitTime(), submissionContext.getApplicationType(), submissionContext.getApplicationTags());
        Assert.assertEquals((Object)RMAppState.NEW, (Object)application.getState());
        application.recover(rmState);
        Assert.assertTrue((String)"Application is not in recoveredFinalStatus.", (boolean)RMAppImpl.isAppInFinalState((RMApp)application));
        application.handle(new RMAppEvent(appState.getAppId(), RMAppEventType.RECOVER));
        this.rmDispatcher.await();
        RMAppState finalState = appState.getState();
        Assert.assertEquals((String)"Application is not in finalState.", (Object)finalState, (Object)application.getState());
    }

    public void createRMStateForApplications(Map<ApplicationId, RMStateStore.ApplicationState> applicationState, RMAppState rmAppState) {
        RMApp app = this.createNewTestApp(null);
        RMStateStore.ApplicationState appState = new RMStateStore.ApplicationState(app.getSubmitTime(), app.getStartTime(), app.getApplicationSubmissionContext(), app.getUser(), rmAppState, null, app.getFinishTime());
        applicationState.put(app.getApplicationId(), appState);
    }

    @Test
    public void testGetAppReport() {
        RMApp app = this.createNewTestApp(null);
        TestRMAppTransitions.assertAppState((RMAppState)RMAppState.NEW, (RMApp)app);
        ApplicationReport report = app.createAndGetApplicationReport(null, true);
        Assert.assertNotNull((Object)report.getApplicationResourceUsageReport());
        Assert.assertEquals((Object)report.getApplicationResourceUsageReport(), (Object)RMServerUtils.DUMMY_APPLICATION_RESOURCE_USAGE_REPORT);
        report = app.createAndGetApplicationReport("clientuser", true);
        Assert.assertNotNull((Object)report.getApplicationResourceUsageReport());
    }

    private void verifyApplicationFinished(RMAppState state) {
        ArgumentCaptor finalState = ArgumentCaptor.forClass(RMAppState.class);
        ((RMApplicationHistoryWriter)Mockito.verify((Object)this.writer)).applicationFinished((RMApp)Matchers.any(RMApp.class), (RMAppState)finalState.capture());
        Assert.assertEquals((Object)state, (Object)finalState.getValue());
    }

    private void verifyAppRemovedSchedulerEvent(RMAppState finalState) {
        Assert.assertEquals((Object)SchedulerEventType.APP_REMOVED, (Object)this.schedulerDispatcher.lastSchedulerEvent.getType());
        if (this.schedulerDispatcher.lastSchedulerEvent instanceof AppRemovedSchedulerEvent) {
            AppRemovedSchedulerEvent appRemovedEvent = (AppRemovedSchedulerEvent)this.schedulerDispatcher.lastSchedulerEvent;
            Assert.assertEquals((Object)finalState, (Object)appRemovedEvent.getFinalState());
        }
    }
}

