/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.SecretKey;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEvent;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Recoverable;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptLaunchFailedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptNewSavedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptUnregistrationEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.webproxy.ProxyUriUtils;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class RMAppAttemptImpl
implements RMAppAttempt,
Recoverable {
    private static final Log LOG = LogFactory.getLog(RMAppAttemptImpl.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    public static final Priority AM_CONTAINER_PRIORITY = (Priority)recordFactory.newRecordInstance(Priority.class);
    private final StateMachine<RMAppAttemptState, RMAppAttemptEventType, RMAppAttemptEvent> stateMachine;
    private final RMContext rmContext;
    private final EventHandler eventHandler;
    private final YarnScheduler scheduler;
    private final ApplicationMasterService masterService;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final ApplicationAttemptId applicationAttemptId;
    private final ApplicationSubmissionContext submissionContext;
    private Token<AMRMTokenIdentifier> amrmToken = null;
    private SecretKey clientTokenMasterKey = null;
    private List<ContainerStatus> justFinishedContainers = new ArrayList();
    private Container masterContainer;
    private float progress = 0.0f;
    private String host = "N/A";
    private int rpcPort = -1;
    private String originalTrackingUrl = "N/A";
    private String proxiedTrackingUrl = "N/A";
    private long startTime = 0L;
    private FinalApplicationStatus finalStatus = null;
    private final StringBuilder diagnostics = new StringBuilder();
    private int amContainerExitStatus = -1000;
    private Configuration conf;
    private final boolean maybeLastAttempt;
    private static final ExpiredTransition EXPIRED_TRANSITION;
    private RMAppAttemptEvent eventCausingFinalSaving;
    private RMAppAttemptState targetedFinalState;
    private RMAppAttemptState recoveredFinalState;
    private RMAppAttemptState stateBeforeFinalSaving;
    private Object transitionTodo;
    private static final StateMachineFactory<RMAppAttemptImpl, RMAppAttemptState, RMAppAttemptEventType, RMAppAttemptEvent> stateMachineFactory;
    private static final List<ContainerId> EMPTY_CONTAINER_RELEASE_LIST;
    private static final List<ResourceRequest> EMPTY_CONTAINER_REQUEST_LIST;

    public RMAppAttemptImpl(ApplicationAttemptId appAttemptId, RMContext rmContext, YarnScheduler scheduler, ApplicationMasterService masterService, ApplicationSubmissionContext submissionContext, Configuration conf, boolean maybeLastAttempt) {
        this.conf = conf;
        this.applicationAttemptId = appAttemptId;
        this.rmContext = rmContext;
        this.eventHandler = rmContext.getDispatcher().getEventHandler();
        this.submissionContext = submissionContext;
        this.scheduler = scheduler;
        this.masterService = masterService;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.proxiedTrackingUrl = this.generateProxyUriWithScheme(null);
        this.maybeLastAttempt = maybeLastAttempt;
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    public ApplicationAttemptId getAppAttemptId() {
        return this.applicationAttemptId;
    }

    public ApplicationSubmissionContext getSubmissionContext() {
        return this.submissionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FinalApplicationStatus getFinalApplicationStatus() {
        this.readLock.lock();
        try {
            FinalApplicationStatus finalApplicationStatus = this.finalStatus;
            return finalApplicationStatus;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMAppAttemptState getAppAttemptState() {
        this.readLock.lock();
        try {
            RMAppAttemptState rMAppAttemptState = (RMAppAttemptState)this.stateMachine.getCurrentState();
            return rMAppAttemptState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHost() {
        this.readLock.lock();
        try {
            String string = this.host;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRpcPort() {
        this.readLock.lock();
        try {
            int n = this.rpcPort;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTrackingUrl() {
        this.readLock.lock();
        try {
            String string = this.getSubmissionContext().getUnmanagedAM() ? this.originalTrackingUrl : this.proxiedTrackingUrl;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOriginalTrackingUrl() {
        this.readLock.lock();
        try {
            String string = this.originalTrackingUrl;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWebProxyBase() {
        this.readLock.lock();
        try {
            String string = ProxyUriUtils.getPath((ApplicationId)this.applicationAttemptId.getApplicationId());
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateProxyUriWithScheme(String trackingUriWithoutScheme) {
        this.readLock.lock();
        try {
            String scheme = WebAppUtils.getHttpSchemePrefix((Configuration)this.conf);
            URI trackingUri = StringUtils.isEmpty((String)trackingUriWithoutScheme) ? null : ProxyUriUtils.getUriFromAMUrl((String)scheme, (String)trackingUriWithoutScheme);
            String proxy = WebAppUtils.getProxyHostAndPort((Configuration)this.conf);
            URI proxyUri = ProxyUriUtils.getUriFromAMUrl((String)scheme, (String)proxy);
            URI result = ProxyUriUtils.getProxyUri((URI)trackingUri, (URI)proxyUri, (ApplicationId)this.applicationAttemptId.getApplicationId());
            String string = result.toASCIIString();
            return string;
        }
        catch (URISyntaxException e) {
            LOG.warn((Object)("Could not proxify " + trackingUriWithoutScheme), (Throwable)e);
            String string = trackingUriWithoutScheme;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void setTrackingUrlToRMAppPage() {
        this.proxiedTrackingUrl = this.originalTrackingUrl = StringHelper.pjoin((Object[])new Object[]{WebAppUtils.getResolvedRMWebAppURLWithScheme((Configuration)this.conf), "cluster", "app", this.getAppAttemptId().getApplicationId()});
    }

    private void invalidateAMHostAndPort() {
        this.host = "N/A";
        this.rpcPort = -1;
    }

    public SecretKey getClientTokenMasterKey() {
        return this.clientTokenMasterKey;
    }

    public Token<AMRMTokenIdentifier> getAMRMToken() {
        return this.amrmToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token<ClientToAMTokenIdentifier> createClientToken(String client) {
        this.readLock.lock();
        try {
            Token token = null;
            ClientToAMTokenSecretManagerInRM secretMgr = this.rmContext.getClientToAMTokenSecretManager();
            if (client != null && secretMgr.getMasterKey(this.applicationAttemptId) != null) {
                token = new Token((TokenIdentifier)new ClientToAMTokenIdentifier(this.applicationAttemptId, client), (SecretManager)secretMgr);
            }
            Token token2 = token;
            return token2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDiagnostics() {
        this.readLock.lock();
        try {
            String string = this.diagnostics.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAMContainerExitStatus() {
        this.readLock.lock();
        try {
            int n = this.amContainerExitStatus;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getProgress() {
        this.readLock.lock();
        try {
            float f = this.progress;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ContainerStatus> getJustFinishedContainers() {
        this.readLock.lock();
        try {
            List list = this.justFinishedContainers;
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ContainerStatus> pullJustFinishedContainers() {
        this.writeLock.lock();
        try {
            ArrayList<ContainerStatus> returnList = new ArrayList<ContainerStatus>(this.justFinishedContainers.size());
            returnList.addAll(this.justFinishedContainers);
            this.justFinishedContainers.clear();
            ArrayList<ContainerStatus> arrayList = returnList;
            return arrayList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Container getMasterContainer() {
        this.readLock.lock();
        try {
            Container container = this.masterContainer;
            return container;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setMasterContainer(Container container) {
        this.masterContainer = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RMAppAttemptEvent event) {
        this.writeLock.lock();
        try {
            ApplicationAttemptId appAttemptID = event.getApplicationAttemptId();
            LOG.debug((Object)("Processing event for " + appAttemptID + " of type " + event.getType()));
            RMAppAttemptState oldState = this.getAppAttemptState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
            }
            if (oldState != this.getAppAttemptState()) {
                LOG.info((Object)(appAttemptID + " State change from " + oldState + " to " + this.getAppAttemptState()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationResourceUsageReport getApplicationResourceUsageReport() {
        this.readLock.lock();
        try {
            ApplicationResourceUsageReport report = this.scheduler.getAppResourceUsageReport(this.getAppAttemptId());
            if (report == null) {
                report = RMServerUtils.DUMMY_APPLICATION_RESOURCE_USAGE_REPORT;
            }
            ApplicationResourceUsageReport applicationResourceUsageReport = report;
            return applicationResourceUsageReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void recover(RMStateStore.RMState state) throws Exception {
        RMStateStore.ApplicationState appState = (RMStateStore.ApplicationState)state.getApplicationState().get(this.getAppAttemptId().getApplicationId());
        RMStateStore.ApplicationAttemptState attemptState = appState.getAttempt(this.getAppAttemptId());
        assert (attemptState != null);
        LOG.info((Object)("Recovering attempt: " + this.getAppAttemptId() + " with final state: " + attemptState.getState()));
        this.diagnostics.append("Attempt recovered after RM restart");
        this.diagnostics.append(attemptState.getDiagnostics());
        this.amContainerExitStatus = attemptState.getAMContainerExitStatus();
        this.setMasterContainer(attemptState.getMasterContainer());
        this.recoverAppAttemptCredentials(attemptState.getAppAttemptCredentials());
        this.recoveredFinalState = attemptState.getState();
        this.originalTrackingUrl = attemptState.getFinalTrackingUrl();
        this.proxiedTrackingUrl = this.generateProxyUriWithScheme(this.originalTrackingUrl);
        this.finalStatus = attemptState.getFinalApplicationStatus();
        this.startTime = attemptState.getStartTime();
    }

    public void transferStateFromPreviousAttempt(RMAppAttempt attempt) {
        this.justFinishedContainers = attempt.getJustFinishedContainers();
    }

    private void recoverAppAttemptCredentials(Credentials appAttemptTokens) throws IOException {
        if (appAttemptTokens == null) {
            return;
        }
        if (UserGroupInformation.isSecurityEnabled()) {
            byte[] clientTokenMasterKeyBytes = appAttemptTokens.getSecretKey(RMStateStore.AM_CLIENT_TOKEN_MASTER_KEY_NAME);
            this.clientTokenMasterKey = this.rmContext.getClientToAMTokenSecretManager().registerMasterKey(this.applicationAttemptId, clientTokenMasterKeyBytes);
        }
        this.amrmToken = appAttemptTokens.getToken(RMStateStore.AM_RM_TOKEN_SERVICE);
        this.rmContext.getAMRMTokenSecretManager().addPersistedPassword(this.amrmToken);
    }

    private void retryFetchingAMContainer(RMAppAttemptImpl appAttempt) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void rememberTargetTransitions(RMAppAttemptEvent event, Object transitionToDo, RMAppAttemptState targetFinalState) {
        this.transitionTodo = transitionToDo;
        this.targetedFinalState = targetFinalState;
        this.eventCausingFinalSaving = event;
    }

    private void rememberTargetTransitionsAndStoreState(RMAppAttemptEvent event, Object transitionToDo, RMAppAttemptState targetFinalState, RMAppAttemptState stateToBeStored) {
        this.rememberTargetTransitions(event, transitionToDo, targetFinalState);
        this.stateBeforeFinalSaving = this.getState();
        String diags = null;
        String finalTrackingUrl = null;
        FinalApplicationStatus finalStatus = null;
        int exitStatus = -1000;
        switch (2.$SwitchMap$org$apache$hadoop$yarn$server$resourcemanager$rmapp$attempt$RMAppAttemptEventType[((RMAppAttemptEventType)event.getType()).ordinal()]) {
            case 1: {
                RMAppAttemptLaunchFailedEvent launchFaileEvent = (RMAppAttemptLaunchFailedEvent)event;
                diags = launchFaileEvent.getMessage();
                break;
            }
            case 2: {
                diags = RMAppAttemptImpl.getUnexpectedAMRegisteredDiagnostics();
                break;
            }
            case 3: {
                RMAppAttemptUnregistrationEvent unregisterEvent = (RMAppAttemptUnregistrationEvent)event;
                diags = unregisterEvent.getDiagnostics();
                finalTrackingUrl = RMAppAttemptImpl.sanitizeTrackingUrl((String)unregisterEvent.getFinalTrackingUrl());
                finalStatus = unregisterEvent.getFinalApplicationStatus();
                break;
            }
            case 4: {
                RMAppAttemptContainerFinishedEvent finishEvent = (RMAppAttemptContainerFinishedEvent)event;
                diags = RMAppAttemptImpl.getAMContainerCrashedDiagnostics((RMAppAttemptContainerFinishedEvent)finishEvent);
                exitStatus = finishEvent.getContainerStatus().getExitStatus();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                diags = RMAppAttemptImpl.getAMExpiredDiagnostics((RMAppAttemptEvent)event);
                break;
            }
        }
        RMStateStore rmStore = this.rmContext.getStateStore();
        RMStateStore.ApplicationAttemptState attemptState = new RMStateStore.ApplicationAttemptState(this.applicationAttemptId, this.getMasterContainer(), rmStore.getCredentialsFromAppAttempt((RMAppAttempt)this), this.startTime, stateToBeStored, finalTrackingUrl, diags, finalStatus, exitStatus);
        LOG.info((Object)("Updating application attempt " + this.applicationAttemptId + " with final state: " + this.targetedFinalState + ", and exit status: " + exitStatus));
        rmStore.updateApplicationAttemptState(attemptState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldCountTowardsMaxAttemptRetry() {
        try {
            this.readLock.lock();
            int exitStatus = this.getAMContainerExitStatus();
            boolean bl = exitStatus != -102 && exitStatus != -100 && exitStatus != -101 && exitStatus != -106;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void setAMContainerCrashedDiagnosticsAndExitStatus(RMAppAttemptContainerFinishedEvent finishEvent) {
        ContainerStatus status = finishEvent.getContainerStatus();
        String diagnostics = RMAppAttemptImpl.getAMContainerCrashedDiagnostics((RMAppAttemptContainerFinishedEvent)finishEvent);
        this.diagnostics.append(diagnostics);
        this.amContainerExitStatus = status.getExitStatus();
    }

    private static String getAMContainerCrashedDiagnostics(RMAppAttemptContainerFinishedEvent finishEvent) {
        ContainerStatus status = finishEvent.getContainerStatus();
        String diagnostics = "AM Container for " + finishEvent.getApplicationAttemptId() + " exited with " + " exitCode: " + status.getExitStatus() + " due to: " + status.getDiagnostics() + "." + "Failing this attempt.";
        return diagnostics;
    }

    private static String getAMExpiredDiagnostics(RMAppAttemptEvent event) {
        String diag = "ApplicationMaster for attempt " + event.getApplicationAttemptId() + " timed out";
        return diag;
    }

    private static String getUnexpectedAMRegisteredDiagnostics() {
        return "Unmanaged AM must register after AM attempt reaches LAUNCHED state.";
    }

    private void updateInfoOnAMUnregister(RMAppAttemptEvent event) {
        this.progress = 1.0f;
        RMAppAttemptUnregistrationEvent unregisterEvent = (RMAppAttemptUnregistrationEvent)event;
        this.diagnostics.append(unregisterEvent.getDiagnostics());
        this.originalTrackingUrl = RMAppAttemptImpl.sanitizeTrackingUrl((String)unregisterEvent.getFinalTrackingUrl());
        this.proxiedTrackingUrl = this.generateProxyUriWithScheme(this.originalTrackingUrl);
        this.finalStatus = unregisterEvent.getFinalApplicationStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStartTime() {
        this.readLock.lock();
        try {
            long l = this.startTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMAppAttemptState getState() {
        this.readLock.lock();
        try {
            RMAppAttemptState rMAppAttemptState = (RMAppAttemptState)this.stateMachine.getCurrentState();
            return rMAppAttemptState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public YarnApplicationAttemptState createApplicationAttemptState() {
        RMAppAttemptState state = this.getState();
        if (state.equals((Object)RMAppAttemptState.FINAL_SAVING)) {
            state = this.stateBeforeFinalSaving;
        }
        return RMServerUtils.createApplicationAttemptState((RMAppAttemptState)state);
    }

    private void launchAttempt() {
        this.eventHandler.handle((Event)new AMLauncherEvent(AMLauncherEventType.LAUNCH, (RMAppAttempt)this));
    }

    private void attemptLaunched() {
        this.rmContext.getAMLivelinessMonitor().register((Object)this.getAppAttemptId());
    }

    private void checkAttemptStoreError(RMAppAttemptEvent event) {
        RMAppAttemptNewSavedEvent storeEvent = (RMAppAttemptNewSavedEvent)event;
        if (storeEvent.getStoredException() != null) {
            LOG.error((Object)("Failed to store attempt: " + this.getAppAttemptId()), (Throwable)storeEvent.getStoredException());
            ExitUtil.terminate((int)1, (Throwable)storeEvent.getStoredException());
        }
    }

    private void storeAttempt() {
        LOG.info((Object)("Storing attempt: AppId: " + this.getAppAttemptId().getApplicationId() + " AttemptId: " + this.getAppAttemptId() + " MasterContainer: " + this.masterContainer));
        this.rmContext.getStateStore().storeNewApplicationAttempt((RMAppAttempt)this);
    }

    private void removeCredentials(RMAppAttemptImpl appAttempt) {
        if (UserGroupInformation.isSecurityEnabled()) {
            appAttempt.rmContext.getClientToAMTokenSecretManager().unRegisterApplication(appAttempt.getAppAttemptId());
        }
        appAttempt.rmContext.getAMRMTokenSecretManager().applicationMasterFinished(appAttempt.getAppAttemptId());
    }

    private static String sanitizeTrackingUrl(String url) {
        return url == null || url.trim().isEmpty() ? "N/A" : url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationAttemptReport createApplicationAttemptReport() {
        this.readLock.lock();
        ApplicationAttemptReport attemptReport = null;
        try {
            ContainerId amId = this.masterContainer == null ? null : this.masterContainer.getId();
            attemptReport = ApplicationAttemptReport.newInstance((ApplicationAttemptId)this.getAppAttemptId(), (String)this.getHost(), (int)this.getRpcPort(), (String)this.getTrackingUrl(), (String)this.getDiagnostics(), (YarnApplicationAttemptState)YarnApplicationAttemptState.valueOf((String)this.getState().toString()), (ContainerId)amId);
        }
        finally {
            this.readLock.unlock();
        }
        return attemptReport;
    }

    public boolean mayBeLastAttempt() {
        return this.maybeLastAttempt;
    }

    static /* synthetic */ long access$1702(RMAppAttemptImpl x0, long x1) {
        x0.startTime = x1;
        return x0.startTime;
    }

    static /* synthetic */ ApplicationAttemptId access$1800(RMAppAttemptImpl x0) {
        return x0.applicationAttemptId;
    }

    static /* synthetic */ ApplicationMasterService access$1900(RMAppAttemptImpl x0) {
        return x0.masterService;
    }

    static /* synthetic */ SecretKey access$2002(RMAppAttemptImpl x0, SecretKey x1) {
        x0.clientTokenMasterKey = x1;
        return x0.clientTokenMasterKey;
    }

    static /* synthetic */ RMContext access$2100(RMAppAttemptImpl x0) {
        return x0.rmContext;
    }

    static /* synthetic */ Token access$2202(RMAppAttemptImpl x0, Token x1) {
        x0.amrmToken = x1;
        return x0.amrmToken;
    }

    static /* synthetic */ EventHandler access$2300(RMAppAttemptImpl x0) {
        return x0.eventHandler;
    }

    static /* synthetic */ ApplicationSubmissionContext access$2400(RMAppAttemptImpl x0) {
        return x0.submissionContext;
    }

    static /* synthetic */ List access$2500() {
        return EMPTY_CONTAINER_RELEASE_LIST;
    }

    static /* synthetic */ YarnScheduler access$2600(RMAppAttemptImpl x0) {
        return x0.scheduler;
    }

    static /* synthetic */ void access$2700(RMAppAttemptImpl x0) {
        x0.storeAttempt();
    }

    static /* synthetic */ List access$2800() {
        return EMPTY_CONTAINER_REQUEST_LIST;
    }

    static /* synthetic */ void access$2900(RMAppAttemptImpl x0, RMAppAttemptImpl x1) {
        x0.retryFetchingAMContainer(x1);
    }

    static /* synthetic */ Log access$3000() {
        return LOG;
    }

    static /* synthetic */ void access$3100(RMAppAttemptImpl x0, RMAppAttemptEvent x1) {
        x0.checkAttemptStoreError(x1);
    }

    static /* synthetic */ void access$3200(RMAppAttemptImpl x0) {
        x0.launchAttempt();
    }

    static /* synthetic */ RMAppAttemptState access$3300(RMAppAttemptImpl x0) {
        return x0.recoveredFinalState;
    }

    static /* synthetic */ float access$3402(RMAppAttemptImpl x0, float x1) {
        x0.progress = x1;
        return x0.progress;
    }

    static /* synthetic */ void access$3500(RMAppAttemptImpl x0, RMAppAttemptEvent x1, Object x2, RMAppAttemptState x3, RMAppAttemptState x4) {
        x0.rememberTargetTransitionsAndStoreState(x1, x2, x3, x4);
    }

    static /* synthetic */ RMAppAttemptEvent access$3600(RMAppAttemptImpl x0) {
        return x0.eventCausingFinalSaving;
    }

    static /* synthetic */ Object access$3700(RMAppAttemptImpl x0) {
        return x0.transitionTodo;
    }

    static /* synthetic */ RMAppAttemptState access$3800(RMAppAttemptImpl x0) {
        return x0.targetedFinalState;
    }

    static /* synthetic */ void access$3900(RMAppAttemptImpl x0) {
        x0.setTrackingUrlToRMAppPage();
    }

    static /* synthetic */ void access$4000(RMAppAttemptImpl x0) {
        x0.invalidateAMHostAndPort();
    }

    static /* synthetic */ boolean access$4100(RMAppAttemptImpl x0) {
        return x0.maybeLastAttempt;
    }

    static /* synthetic */ void access$4200(RMAppAttemptImpl x0, RMAppAttemptImpl x1) {
        x0.removeCredentials(x1);
    }

    static /* synthetic */ void access$4300(RMAppAttemptImpl x0) {
        x0.attemptLaunched();
    }

    static /* synthetic */ StringBuilder access$4400(RMAppAttemptImpl x0) {
        return x0.diagnostics;
    }

    static /* synthetic */ String access$4502(RMAppAttemptImpl x0, String x1) {
        x0.host = x1;
        return x0.host;
    }

    static /* synthetic */ int access$4602(RMAppAttemptImpl x0, int x1) {
        x0.rpcPort = x1;
        return x0.rpcPort;
    }

    static /* synthetic */ String access$4702(RMAppAttemptImpl x0, String x1) {
        x0.originalTrackingUrl = x1;
        return x0.originalTrackingUrl;
    }

    static /* synthetic */ String access$4800(String x0) {
        return RMAppAttemptImpl.sanitizeTrackingUrl((String)x0);
    }

    static /* synthetic */ String access$4902(RMAppAttemptImpl x0, String x1) {
        x0.proxiedTrackingUrl = x1;
        return x0.proxiedTrackingUrl;
    }

    static /* synthetic */ String access$4700(RMAppAttemptImpl x0) {
        return x0.originalTrackingUrl;
    }

    static /* synthetic */ String access$5000(RMAppAttemptImpl x0, String x1) {
        return x0.generateProxyUriWithScheme(x1);
    }

    static /* synthetic */ void access$5100(RMAppAttemptImpl x0, RMAppAttemptContainerFinishedEvent x1) {
        x0.setAMContainerCrashedDiagnosticsAndExitStatus(x1);
    }

    static /* synthetic */ String access$5200(RMAppAttemptEvent x0) {
        return RMAppAttemptImpl.getAMExpiredDiagnostics((RMAppAttemptEvent)x0);
    }

    static /* synthetic */ String access$5300() {
        return RMAppAttemptImpl.getUnexpectedAMRegisteredDiagnostics();
    }

    static /* synthetic */ void access$5400(RMAppAttemptImpl x0, RMAppAttemptEvent x1) {
        x0.updateInfoOnAMUnregister(x1);
    }

    static /* synthetic */ Container access$5600(RMAppAttemptImpl x0) {
        return x0.masterContainer;
    }

    static /* synthetic */ List access$5700(RMAppAttemptImpl x0) {
        return x0.justFinishedContainers;
    }

    static /* synthetic */ void access$5800(RMAppAttemptImpl x0, RMAppAttemptEvent x1, Object x2, RMAppAttemptState x3) {
        x0.rememberTargetTransitions(x1, x2, x3);
    }

    static {
        AM_CONTAINER_PRIORITY.setPriority(0);
        EXPIRED_TRANSITION = new ExpiredTransition();
        stateMachineFactory = new StateMachineFactory((Enum)RMAppAttemptState.NEW).addTransition((Enum)RMAppAttemptState.NEW, (Enum)RMAppAttemptState.SUBMITTED, (Enum)RMAppAttemptEventType.START, (SingleArcTransition)new AttemptStartedTransition(null)).addTransition((Enum)RMAppAttemptState.NEW, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition((Object)new BaseFinalTransition(RMAppAttemptState.KILLED), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.NEW, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.REGISTERED, (SingleArcTransition)new FinalSavingTransition((Object)new UnexpectedAMRegisteredTransition(), RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.NEW, EnumSet.of(RMAppAttemptState.FINISHED, RMAppAttemptState.KILLED, RMAppAttemptState.FAILED, RMAppAttemptState.LAUNCHED), (Enum)RMAppAttemptEventType.RECOVER, (MultipleArcTransition)new AttemptRecoveredTransition(null)).addTransition((Enum)RMAppAttemptState.SUBMITTED, EnumSet.of(RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING, RMAppAttemptState.SCHEDULED), (Enum)RMAppAttemptEventType.ATTEMPT_ADDED, (MultipleArcTransition)new ScheduleTransition(null)).addTransition((Enum)RMAppAttemptState.SUBMITTED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition((Object)new BaseFinalTransition(RMAppAttemptState.KILLED), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.SUBMITTED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.REGISTERED, (SingleArcTransition)new FinalSavingTransition((Object)new UnexpectedAMRegisteredTransition(), RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.SCHEDULED, EnumSet.of(RMAppAttemptState.ALLOCATED_SAVING, RMAppAttemptState.SCHEDULED), (Enum)RMAppAttemptEventType.CONTAINER_ALLOCATED, (MultipleArcTransition)new AMContainerAllocatedTransition(null)).addTransition((Enum)RMAppAttemptState.SCHEDULED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition((Object)new BaseFinalTransition(RMAppAttemptState.KILLED), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.ALLOCATED_SAVING, (Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptEventType.ATTEMPT_NEW_SAVED, (SingleArcTransition)new AttemptStoredTransition(null)).addTransition((Enum)RMAppAttemptState.ALLOCATED_SAVING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition((Object)new BaseFinalTransition(RMAppAttemptState.KILLED), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING, (Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptEventType.ATTEMPT_NEW_SAVED, (SingleArcTransition)new UnmanagedAMAttemptSavedTransition(null)).addTransition((Enum)RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.REGISTERED, (SingleArcTransition)new FinalSavingTransition((Object)new UnexpectedAMRegisteredTransition(), RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition((Object)new BaseFinalTransition(RMAppAttemptState.KILLED), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptEventType.LAUNCHED, (SingleArcTransition)new AMLaunchedTransition(null)).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.LAUNCH_FAILED, (SingleArcTransition)new FinalSavingTransition((Object)new LaunchFailedTransition(), RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition((Object)new KillAllocatedAMTransition(), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (SingleArcTransition)new FinalSavingTransition((Object)new AMContainerCrashedBeforeRunningTransition(), RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptEventType.REGISTERED, (SingleArcTransition)new AMRegisteredTransition(null)).addTransition((Enum)RMAppAttemptState.LAUNCHED, EnumSet.of(RMAppAttemptState.LAUNCHED, RMAppAttemptState.FINAL_SAVING), (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (MultipleArcTransition)new ContainerFinishedTransition((BaseTransition)new AMContainerCrashedBeforeRunningTransition(), RMAppAttemptState.LAUNCHED)).addTransition((Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.EXPIRE, (SingleArcTransition)new FinalSavingTransition((Object)EXPIRED_TRANSITION, RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition((Object)new FinalTransition(RMAppAttemptState.KILLED), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.RUNNING, EnumSet.of(RMAppAttemptState.FINAL_SAVING, RMAppAttemptState.FINISHED), (Enum)RMAppAttemptEventType.UNREGISTERED, (MultipleArcTransition)new AMUnregisteredTransition(null)).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptEventType.STATUS_UPDATE, (SingleArcTransition)new StatusUpdateTransition(null)).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptEventType.CONTAINER_ALLOCATED).addTransition((Enum)RMAppAttemptState.RUNNING, EnumSet.of(RMAppAttemptState.RUNNING, RMAppAttemptState.FINAL_SAVING), (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (MultipleArcTransition)new ContainerFinishedTransition((BaseTransition)new AMContainerCrashedAtRunningTransition(null), RMAppAttemptState.RUNNING)).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.EXPIRE, (SingleArcTransition)new FinalSavingTransition((Object)EXPIRED_TRANSITION, RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalSavingTransition((Object)new FinalTransition(RMAppAttemptState.KILLED), RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.FINAL_SAVING, EnumSet.of(RMAppAttemptState.FINISHING, RMAppAttemptState.FAILED, RMAppAttemptState.KILLED, RMAppAttemptState.FINISHED), (Enum)RMAppAttemptEventType.ATTEMPT_UPDATE_SAVED, (MultipleArcTransition)new FinalStateSavedTransition(null)).addTransition((Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (SingleArcTransition)new ContainerFinishedAtFinalSavingTransition(null)).addTransition((Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptEventType.EXPIRE, (SingleArcTransition)new AMExpiredAtFinalSavingTransition(null)).addTransition((Enum)RMAppAttemptState.FINAL_SAVING, (Enum)RMAppAttemptState.FINAL_SAVING, EnumSet.of(RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.STATUS_UPDATE, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.ATTEMPT_NEW_SAVED, RMAppAttemptEventType.KILL)).addTransition((Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (SingleArcTransition)new ContainerFinishedAtFailedTransition(null)).addTransition((Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptState.FAILED, EnumSet.of(RMAppAttemptEventType.EXPIRE, RMAppAttemptEventType.KILL, RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.STATUS_UPDATE, RMAppAttemptEventType.CONTAINER_ALLOCATED)).addTransition((Enum)RMAppAttemptState.FINISHING, EnumSet.of(RMAppAttemptState.FINISHING, RMAppAttemptState.FINISHED), (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (MultipleArcTransition)new AMFinishingContainerFinishedTransition(null)).addTransition((Enum)RMAppAttemptState.FINISHING, (Enum)RMAppAttemptState.FINISHED, (Enum)RMAppAttemptEventType.EXPIRE, (SingleArcTransition)new FinalTransition(RMAppAttemptState.FINISHED)).addTransition((Enum)RMAppAttemptState.FINISHING, (Enum)RMAppAttemptState.FINISHING, EnumSet.of(RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.STATUS_UPDATE, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.KILL)).addTransition((Enum)RMAppAttemptState.FINISHED, (Enum)RMAppAttemptState.FINISHED, EnumSet.of(RMAppAttemptEventType.EXPIRE, RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.CONTAINER_FINISHED, RMAppAttemptEventType.KILL)).addTransition((Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptState.KILLED, EnumSet.of(RMAppAttemptEventType.ATTEMPT_ADDED, new RMAppAttemptEventType[]{RMAppAttemptEventType.EXPIRE, RMAppAttemptEventType.LAUNCHED, RMAppAttemptEventType.LAUNCH_FAILED, RMAppAttemptEventType.EXPIRE, RMAppAttemptEventType.REGISTERED, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.CONTAINER_FINISHED, RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.KILL, RMAppAttemptEventType.STATUS_UPDATE})).installTopology();
        EMPTY_CONTAINER_RELEASE_LIST = new ArrayList();
        EMPTY_CONTAINER_REQUEST_LIST = new ArrayList();
    }
}

