/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.util.resource.Resources;

public class AllocationConfiguration {
    private static final AccessControlList EVERYBODY_ACL = new AccessControlList("*");
    private static final AccessControlList NOBODY_ACL = new AccessControlList(" ");
    private final Map<String, Resource> minQueueResources;
    @VisibleForTesting
    final Map<String, Resource> maxQueueResources;
    private final Map<String, ResourceWeights> queueWeights;
    @VisibleForTesting
    final Map<String, Integer> queueMaxApps;
    @VisibleForTesting
    final Map<String, Integer> userMaxApps;
    private final int userMaxAppsDefault;
    private final int queueMaxAppsDefault;
    final Map<String, Float> queueMaxAMShares;
    private final float queueMaxAMShareDefault;
    private final Map<String, Map<QueueACL, AccessControlList>> queueAcls;
    private final Map<String, Long> minSharePreemptionTimeouts;
    private final long defaultMinSharePreemptionTimeout;
    private final long fairSharePreemptionTimeout;
    private final Map<String, SchedulingPolicy> schedulingPolicies;
    private final SchedulingPolicy defaultSchedulingPolicy;
    @VisibleForTesting
    QueuePlacementPolicy placementPolicy;
    @VisibleForTesting
    Map<FSQueueType, Set<String>> configuredQueues;

    public AllocationConfiguration(Map<String, Resource> minQueueResources, Map<String, Resource> maxQueueResources, Map<String, Integer> queueMaxApps, Map<String, Integer> userMaxApps, Map<String, ResourceWeights> queueWeights, Map<String, Float> queueMaxAMShares, int userMaxAppsDefault, int queueMaxAppsDefault, float queueMaxAMShareDefault, Map<String, SchedulingPolicy> schedulingPolicies, SchedulingPolicy defaultSchedulingPolicy, Map<String, Long> minSharePreemptionTimeouts, Map<String, Map<QueueACL, AccessControlList>> queueAcls, long fairSharePreemptionTimeout, long defaultMinSharePreemptionTimeout, QueuePlacementPolicy placementPolicy, Map<FSQueueType, Set<String>> configuredQueues) {
        this.minQueueResources = minQueueResources;
        this.maxQueueResources = maxQueueResources;
        this.queueMaxApps = queueMaxApps;
        this.userMaxApps = userMaxApps;
        this.queueMaxAMShares = queueMaxAMShares;
        this.queueWeights = queueWeights;
        this.userMaxAppsDefault = userMaxAppsDefault;
        this.queueMaxAppsDefault = queueMaxAppsDefault;
        this.queueMaxAMShareDefault = queueMaxAMShareDefault;
        this.defaultSchedulingPolicy = defaultSchedulingPolicy;
        this.schedulingPolicies = schedulingPolicies;
        this.minSharePreemptionTimeouts = minSharePreemptionTimeouts;
        this.queueAcls = queueAcls;
        this.fairSharePreemptionTimeout = fairSharePreemptionTimeout;
        this.defaultMinSharePreemptionTimeout = defaultMinSharePreemptionTimeout;
        this.placementPolicy = placementPolicy;
        this.configuredQueues = configuredQueues;
    }

    public AllocationConfiguration(Configuration conf) {
        this.minQueueResources = new HashMap();
        this.maxQueueResources = new HashMap();
        this.queueWeights = new HashMap();
        this.queueMaxApps = new HashMap();
        this.userMaxApps = new HashMap();
        this.queueMaxAMShares = new HashMap();
        this.userMaxAppsDefault = Integer.MAX_VALUE;
        this.queueMaxAppsDefault = Integer.MAX_VALUE;
        this.queueMaxAMShareDefault = -1.0f;
        this.queueAcls = new HashMap();
        this.minSharePreemptionTimeouts = new HashMap();
        this.defaultMinSharePreemptionTimeout = Long.MAX_VALUE;
        this.fairSharePreemptionTimeout = Long.MAX_VALUE;
        this.schedulingPolicies = new HashMap();
        this.defaultSchedulingPolicy = SchedulingPolicy.DEFAULT_POLICY;
        this.configuredQueues = new HashMap();
        for (FSQueueType queueType : FSQueueType.values()) {
            this.configuredQueues.put(queueType, new HashSet());
        }
        this.placementPolicy = QueuePlacementPolicy.fromConfiguration((Configuration)conf, (Map)this.configuredQueues);
    }

    public AccessControlList getQueueAcl(String queue, QueueACL operation) {
        AccessControlList operationAcl;
        Map queueAcls = (Map)this.queueAcls.get(queue);
        if (queueAcls != null && (operationAcl = (AccessControlList)queueAcls.get(operation)) != null) {
            return operationAcl;
        }
        return queue.equals("root") ? EVERYBODY_ACL : NOBODY_ACL;
    }

    public long getMinSharePreemptionTimeout(String queueName) {
        Long minSharePreemptionTimeout = (Long)this.minSharePreemptionTimeouts.get(queueName);
        return minSharePreemptionTimeout == null ? this.defaultMinSharePreemptionTimeout : minSharePreemptionTimeout;
    }

    public long getFairSharePreemptionTimeout() {
        return this.fairSharePreemptionTimeout;
    }

    public ResourceWeights getQueueWeight(String queue) {
        ResourceWeights weight = (ResourceWeights)this.queueWeights.get(queue);
        return weight == null ? ResourceWeights.NEUTRAL : weight;
    }

    public int getUserMaxApps(String user) {
        Integer maxApps = (Integer)this.userMaxApps.get(user);
        return maxApps == null ? this.userMaxAppsDefault : maxApps;
    }

    public int getQueueMaxApps(String queue) {
        Integer maxApps = (Integer)this.queueMaxApps.get(queue);
        return maxApps == null ? this.queueMaxAppsDefault : maxApps;
    }

    public float getQueueMaxAMShare(String queue) {
        Float maxAMShare = (Float)this.queueMaxAMShares.get(queue);
        return maxAMShare == null ? this.queueMaxAMShareDefault : maxAMShare.floatValue();
    }

    public Resource getMinResources(String queue) {
        Resource minQueueResource = (Resource)this.minQueueResources.get(queue);
        return minQueueResource == null ? Resources.none() : minQueueResource;
    }

    public Resource getMaxResources(String queueName) {
        Resource maxQueueResource = (Resource)this.maxQueueResources.get(queueName);
        return maxQueueResource == null ? Resources.unbounded() : maxQueueResource;
    }

    public boolean hasAccess(String queueName, QueueACL acl, UserGroupInformation user) {
        int lastPeriodIndex = queueName.length();
        while (lastPeriodIndex != -1) {
            String queue = queueName.substring(0, lastPeriodIndex);
            if (this.getQueueAcl(queue, acl).isUserAllowed(user)) {
                return true;
            }
            lastPeriodIndex = queueName.lastIndexOf(46, lastPeriodIndex - 1);
        }
        return false;
    }

    public SchedulingPolicy getSchedulingPolicy(String queueName) {
        SchedulingPolicy policy = (SchedulingPolicy)this.schedulingPolicies.get(queueName);
        return policy == null ? this.defaultSchedulingPolicy : policy;
    }

    public SchedulingPolicy getDefaultSchedulingPolicy() {
        return this.defaultSchedulingPolicy;
    }

    public Map<FSQueueType, Set<String>> getConfiguredQueues() {
        return this.configuredQueues;
    }

    public QueuePlacementPolicy getPlacementPolicy() {
        return this.placementPolicy;
    }
}

