/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AppSchedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FSLeafQueue
extends FSQueue {
    private static final Log LOG = LogFactory.getLog((String)FSLeafQueue.class.getName());
    private final List<AppSchedulable> runnableAppScheds = new ArrayList();
    private final List<AppSchedulable> nonRunnableAppScheds = new ArrayList();
    private Resource demand = Resources.createResource((int)0);
    private long lastTimeAtMinShare;
    private long lastTimeAtHalfFairShare;
    private Resource amResourceUsage;
    private final ActiveUsersManager activeUsersManager;

    public FSLeafQueue(String name, FairScheduler scheduler, FSParentQueue parent) {
        super(name, scheduler, parent);
        this.lastTimeAtMinShare = scheduler.getClock().getTime();
        this.lastTimeAtHalfFairShare = scheduler.getClock().getTime();
        this.activeUsersManager = new ActiveUsersManager((QueueMetrics)this.getMetrics());
        this.amResourceUsage = Resource.newInstance((int)0, (int)0);
    }

    public void addApp(FSSchedulerApp app, boolean runnable) {
        AppSchedulable appSchedulable = new AppSchedulable(this.scheduler, app, this);
        app.setAppSchedulable(appSchedulable);
        if (runnable) {
            this.runnableAppScheds.add(appSchedulable);
        } else {
            this.nonRunnableAppScheds.add(appSchedulable);
        }
    }

    void addAppSchedulable(AppSchedulable appSched) {
        this.runnableAppScheds.add(appSched);
    }

    public boolean removeApp(FSSchedulerApp app) {
        if (this.runnableAppScheds.remove(app.getAppSchedulable())) {
            if (app.isAmRunning() && app.getAMResource() != null) {
                Resources.subtractFrom((Resource)this.amResourceUsage, (Resource)app.getAMResource());
            }
            return true;
        }
        if (this.nonRunnableAppScheds.remove(app.getAppSchedulable())) {
            return false;
        }
        throw new IllegalStateException("Given app to remove " + app + " does not exist in queue " + this);
    }

    public Collection<AppSchedulable> getRunnableAppSchedulables() {
        return this.runnableAppScheds;
    }

    public List<AppSchedulable> getNonRunnableAppSchedulables() {
        return this.nonRunnableAppScheds;
    }

    public void collectSchedulerApplications(Collection<ApplicationAttemptId> apps) {
        for (AppSchedulable appSched : this.runnableAppScheds) {
            apps.add(appSched.getApp().getApplicationAttemptId());
        }
        for (AppSchedulable appSched : this.nonRunnableAppScheds) {
            apps.add(appSched.getApp().getApplicationAttemptId());
        }
    }

    public void setPolicy(SchedulingPolicy policy) throws AllocationConfigurationException {
        if (!SchedulingPolicy.isApplicableTo((SchedulingPolicy)policy, (byte)1)) {
            this.throwPolicyDoesnotApplyException(policy);
        }
        this.policy = policy;
    }

    public void recomputeShares() {
        this.policy.computeShares(this.getRunnableAppSchedulables(), this.getFairShare());
    }

    public Resource getDemand() {
        return this.demand;
    }

    public Resource getResourceUsage() {
        Resource usage = Resources.createResource((int)0);
        for (AppSchedulable app : this.runnableAppScheds) {
            Resources.addTo((Resource)usage, (Resource)app.getResourceUsage());
        }
        for (AppSchedulable app : this.nonRunnableAppScheds) {
            Resources.addTo((Resource)usage, (Resource)app.getResourceUsage());
        }
        return usage;
    }

    public Resource getAmResourceUsage() {
        return this.amResourceUsage;
    }

    public void updateDemand() {
        Resource maxRes = this.scheduler.getAllocationConfiguration().getMaxResources(this.getName());
        this.demand = Resources.createResource((int)0);
        for (AppSchedulable sched : this.runnableAppScheds) {
            if (Resources.equals((Resource)this.demand, (Resource)maxRes)) break;
            this.updateDemandForApp(sched, maxRes);
        }
        for (AppSchedulable sched : this.nonRunnableAppScheds) {
            if (Resources.equals((Resource)this.demand, (Resource)maxRes)) break;
            this.updateDemandForApp(sched, maxRes);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The updated demand for " + this.getName() + " is " + this.demand + "; the max is " + maxRes));
        }
    }

    private void updateDemandForApp(AppSchedulable sched, Resource maxRes) {
        sched.updateDemand();
        Resource toAdd = sched.getDemand();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Counting resource from " + sched.getName() + " " + toAdd + "; Total resource consumption for " + this.getName() + " now " + this.demand));
        }
        this.demand = Resources.add((Resource)this.demand, (Resource)toAdd);
        this.demand = Resources.componentwiseMin((Resource)this.demand, (Resource)maxRes);
    }

    public Resource assignContainer(FSSchedulerNode node) {
        AppSchedulable sched;
        Resource assigned = Resources.none();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Node " + node.getNodeName() + " offered to queue: " + this.getName()));
        }
        if (!this.assignContainerPreCheck(node)) {
            return assigned;
        }
        Comparator comparator = this.policy.getComparator();
        Collections.sort(this.runnableAppScheds, comparator);
        Iterator i$ = this.runnableAppScheds.iterator();
        while (i$.hasNext() && (SchedulerAppUtils.isBlacklisted((SchedulerApplicationAttempt)(sched = (AppSchedulable)i$.next()).getApp(), (SchedulerNode)node, (Log)LOG) || (assigned = sched.assignContainer(node)).equals((Object)Resources.none()))) {
        }
        return assigned;
    }

    public RMContainer preemptContainer() {
        RMContainer toBePreempted = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Queue " + this.getName() + " is going to preempt a container " + "from its applications."));
        }
        if (!this.preemptContainerPreCheck()) {
            return toBePreempted;
        }
        Comparator comparator = this.policy.getComparator();
        AppSchedulable candidateSched = null;
        for (AppSchedulable sched : this.runnableAppScheds) {
            if (candidateSched != null && comparator.compare(sched, candidateSched) <= 0) continue;
            candidateSched = sched;
        }
        if (candidateSched != null) {
            toBePreempted = candidateSched.preemptContainer();
        }
        return toBePreempted;
    }

    public List<FSQueue> getChildQueues() {
        return new ArrayList<FSQueue>(1);
    }

    public List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation user) {
        QueueUserACLInfo userAclInfo = (QueueUserACLInfo)this.recordFactory.newRecordInstance(QueueUserACLInfo.class);
        ArrayList<QueueACL> operations = new ArrayList<QueueACL>();
        for (QueueACL operation : QueueACL.values()) {
            if (!this.hasAccess(operation, user)) continue;
            operations.add(operation);
        }
        userAclInfo.setQueueName(this.getQueueName());
        userAclInfo.setUserAcls(operations);
        return Collections.singletonList(userAclInfo);
    }

    public long getLastTimeAtMinShare() {
        return this.lastTimeAtMinShare;
    }

    public void setLastTimeAtMinShare(long lastTimeAtMinShare) {
        this.lastTimeAtMinShare = lastTimeAtMinShare;
    }

    public long getLastTimeAtHalfFairShare() {
        return this.lastTimeAtHalfFairShare;
    }

    public void setLastTimeAtHalfFairShare(long lastTimeAtHalfFairShare) {
        this.lastTimeAtHalfFairShare = lastTimeAtHalfFairShare;
    }

    public int getNumRunnableApps() {
        return this.runnableAppScheds.size();
    }

    public ActiveUsersManager getActiveUsersManager() {
        return this.activeUsersManager;
    }

    public boolean canRunAppAM(Resource amResource) {
        float maxAMShare = this.scheduler.getAllocationConfiguration().getQueueMaxAMShare(this.getName());
        if ((double)Math.abs(maxAMShare - -1.0f) < 1.0E-4) {
            return true;
        }
        Resource maxAMResource = Resources.multiply((Resource)this.getFairShare(), (double)maxAMShare);
        Resource ifRunAMResource = Resources.add((Resource)this.amResourceUsage, (Resource)amResource);
        return !this.policy.checkIfAMResourceUsageOverLimit(ifRunAMResource, maxAMResource);
    }

    public void addAMResourceUsage(Resource amResource) {
        if (amResource != null) {
            Resources.addTo((Resource)this.amResourceUsage, (Resource)amResource);
        }
    }

    public void recoverContainer(Resource clusterResource, SchedulerApplicationAttempt schedulerAttempt, RMContainer rmContainer) {
    }
}

