/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.QueueACLsTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;

public class TestFairSchedulerQueueACLs
extends QueueACLsTestBase {
    protected Configuration createConfiguration() throws IOException {
        FairSchedulerConfiguration fsConf = new FairSchedulerConfiguration();
        String TEST_DIR = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
        String ALLOC_FILE = new File(TEST_DIR, "test-queues.xml").getAbsolutePath();
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("  <aclSubmitApps> </aclSubmitApps>");
        out.println("  <aclAdministerApps>root_admin </aclAdministerApps>");
        out.println("  <queue name=\"queueA\">");
        out.println("    <aclSubmitApps>queueA_user,common_user </aclSubmitApps>");
        out.println("    <aclAdministerApps>queueA_admin </aclAdministerApps>");
        out.println("  </queue>");
        out.println("  <queue name=\"queueB\">");
        out.println("    <aclSubmitApps>queueB_user,common_user </aclSubmitApps>");
        out.println("    <aclAdministerApps>queueB_admin </aclAdministerApps>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        fsConf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        fsConf.setBoolean("yarn.acl.enable", true);
        fsConf.set("yarn.resourcemanager.scheduler.class", FairScheduler.class.getName());
        return fsConf;
    }
}

