/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.TestAMAuthorization;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestAMRMTokens {
    private static final Log LOG = LogFactory.getLog(TestAMRMTokens.class);
    private final Configuration conf;
    private static final int maxWaitAttempts = 50;

    @Parameterized.Parameters
    public static Collection<Object[]> configs() {
        Configuration conf = new Configuration();
        Configuration confWithSecurity = new Configuration();
        confWithSecurity.set("hadoop.security.authentication", "kerberos");
        return Arrays.asList({conf}, {confWithSecurity});
    }

    public TestAMRMTokens(Configuration conf) {
        this.conf = conf;
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTokenExpiry() throws Exception {
        TestAMAuthorization.MyContainerManager containerManager = new TestAMAuthorization.MyContainerManager();
        TestAMAuthorization.MockRMWithAMS rm = new TestAMAuthorization.MockRMWithAMS(this.conf, (ContainerManagementProtocol)containerManager);
        rm.start();
        Configuration conf = rm.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        ApplicationMasterProtocol rmClient = null;
        try {
            MockNM nm1 = rm.registerNode("localhost:1234", 5120);
            RMApp app = rm.submitApp(1024);
            nm1.nodeHeartbeat(true);
            int waitCount = 0;
            while (containerManager.containerTokens == null && waitCount++ < 20) {
                LOG.info((Object)"Waiting for AM Launch to happen..");
                Thread.sleep(1000L);
            }
            Assert.assertNotNull((Object)containerManager.containerTokens);
            RMAppAttempt attempt = app.getCurrentAppAttempt();
            ApplicationAttemptId applicationAttemptId = attempt.getAppAttemptId();
            UserGroupInformation currentUser = UserGroupInformation.createRemoteUser((String)applicationAttemptId.toString());
            Credentials credentials = containerManager.getContainerCredentials();
            InetSocketAddress rmBindAddress = rm.getApplicationMasterService().getBindAddress();
            Token amRMToken = TestAMAuthorization.MockRMWithAMS.setupAndReturnAMRMToken((InetSocketAddress)rmBindAddress, (Collection)credentials.getAllTokens());
            currentUser.addToken(amRMToken);
            rmClient = this.createRMClient((MockRM)rm, conf, rpc, currentUser);
            RegisterApplicationMasterRequest request = (RegisterApplicationMasterRequest)Records.newRecord(RegisterApplicationMasterRequest.class);
            rmClient.registerApplicationMaster(request);
            FinishApplicationMasterRequest finishAMRequest = (FinishApplicationMasterRequest)Records.newRecord(FinishApplicationMasterRequest.class);
            finishAMRequest.setFinalApplicationStatus(FinalApplicationStatus.SUCCEEDED);
            finishAMRequest.setDiagnostics("diagnostics");
            finishAMRequest.setTrackingUrl("url");
            rmClient.finishApplicationMaster(finishAMRequest);
            ContainerStatus containerStatus = BuilderUtils.newContainerStatus((ContainerId)attempt.getMasterContainer().getId(), (ContainerState)ContainerState.COMPLETE, (String)"AM Container Finished", (int)0);
            rm.getRMContext().getDispatcher().getEventHandler().handle((Event)new RMAppAttemptContainerFinishedEvent(applicationAttemptId, containerStatus));
            for (int count = 0; attempt.getState() != RMAppAttemptState.FINISHED && count < 50; ++count) {
                Thread.sleep(100L);
            }
            Assert.assertTrue((attempt.getState() == RMAppAttemptState.FINISHED ? 1 : 0) != 0);
            rpc.stopProxy((Object)rmClient, conf);
            rmClient = this.createRMClient((MockRM)rm, conf, rpc, currentUser);
            AllocateRequest allocateRequest = (AllocateRequest)Records.newRecord(AllocateRequest.class);
            try {
                rmClient.allocate(allocateRequest);
                Assert.fail((String)"You got to be kidding me! Using App tokens after app-finish should fail!");
            }
            catch (Throwable t) {
                LOG.info((Object)"Exception found is ", t);
                Assert.assertTrue((boolean)t.getCause().getMessage().contains("Password not found for ApplicationAttempt " + applicationAttemptId.toString()));
            }
        }
        catch (Throwable throwable) {
            rm.stop();
            if (rmClient != null) {
                rpc.stopProxy(rmClient, conf);
            }
            throw throwable;
        }
        rm.stop();
        if (rmClient != null) {
            rpc.stopProxy((Object)rmClient, conf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterKeyRollOver() throws Exception {
        TestAMAuthorization.MyContainerManager containerManager = new TestAMAuthorization.MyContainerManager();
        TestAMAuthorization.MockRMWithAMS rm = new TestAMAuthorization.MockRMWithAMS(this.conf, (ContainerManagementProtocol)containerManager);
        rm.start();
        Configuration conf = rm.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        ApplicationMasterProtocol rmClient = null;
        try {
            MockNM nm1 = rm.registerNode("localhost:1234", 5120);
            RMApp app = rm.submitApp(1024);
            nm1.nodeHeartbeat(true);
            int waitCount = 0;
            while (containerManager.containerTokens == null && waitCount++ < 20) {
                LOG.info((Object)"Waiting for AM Launch to happen..");
                Thread.sleep(1000L);
            }
            Assert.assertNotNull((Object)containerManager.containerTokens);
            RMAppAttempt attempt = app.getCurrentAppAttempt();
            ApplicationAttemptId applicationAttemptId = attempt.getAppAttemptId();
            UserGroupInformation currentUser = UserGroupInformation.createRemoteUser((String)applicationAttemptId.toString());
            Credentials credentials = containerManager.getContainerCredentials();
            InetSocketAddress rmBindAddress = rm.getApplicationMasterService().getBindAddress();
            Token amRMToken = TestAMAuthorization.MockRMWithAMS.setupAndReturnAMRMToken((InetSocketAddress)rmBindAddress, (Collection)credentials.getAllTokens());
            currentUser.addToken(amRMToken);
            rmClient = this.createRMClient((MockRM)rm, conf, rpc, currentUser);
            RegisterApplicationMasterRequest request = (RegisterApplicationMasterRequest)Records.newRecord(RegisterApplicationMasterRequest.class);
            rmClient.registerApplicationMaster(request);
            AllocateRequest allocateRequest = (AllocateRequest)Records.newRecord(AllocateRequest.class);
            Assert.assertTrue((rmClient.allocate(allocateRequest).getAMCommand() == null ? 1 : 0) != 0);
            AMRMTokenSecretManager appTokenSecretManager = rm.getRMContext().getAMRMTokenSecretManager();
            SecretKey oldKey = appTokenSecretManager.getMasterKey();
            appTokenSecretManager.rollMasterKey();
            SecretKey newKey = appTokenSecretManager.getMasterKey();
            Assert.assertFalse((String)"Master key should have changed!", (boolean)oldKey.equals(newKey));
            rpc.stopProxy((Object)rmClient, conf);
            rmClient = this.createRMClient((MockRM)rm, conf, rpc, currentUser);
            allocateRequest = (AllocateRequest)Records.newRecord(AllocateRequest.class);
            Assert.assertTrue((rmClient.allocate(allocateRequest).getAMCommand() == null ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            rm.stop();
            if (rmClient != null) {
                rpc.stopProxy(rmClient, conf);
            }
            throw throwable;
        }
        rm.stop();
        if (rmClient != null) {
            rpc.stopProxy((Object)rmClient, conf);
        }
    }

    private ApplicationMasterProtocol createRMClient(MockRM rm, Configuration conf, YarnRPC rpc, UserGroupInformation currentUser) {
        return (ApplicationMasterProtocol)currentUser.doAs((PrivilegedAction)new /* Unavailable Anonymous Inner Class!! */);
    }
}

