/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.sun.jersey.api.client.ClientResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.Callable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationSubmissionContextInfo;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestRMWebServicesDelegationTokenAuthentication {
    private static final File testRootDir = new File("target", TestRMWebServicesDelegationTokenAuthentication.class.getName() + "-root");
    private static File httpSpnegoKeytabFile = new File(KerberosTestUtils.getKeytabFile());
    private static String httpSpnegoPrincipal = KerberosTestUtils.getServerPrincipal();
    private static boolean miniKDCStarted = false;
    private static MiniKdc testMiniKDC;
    private static MockRM rm;
    static final String DelegationTokenHeader = "Hadoop-YARN-Auth-Delegation-Token";

    @BeforeClass
    public static void setUp() {
        try {
            testMiniKDC = new MiniKdc(MiniKdc.createConf(), testRootDir);
            TestRMWebServicesDelegationTokenAuthentication.setupKDC();
            TestRMWebServicesDelegationTokenAuthentication.setupAndStartRM();
        }
        catch (Exception e) {
            Assert.assertTrue((String)"Couldn't create MiniKDC", (boolean)false);
        }
    }

    @AfterClass
    public static void tearDown() {
        if (testMiniKDC != null) {
            testMiniKDC.stop();
        }
        if (rm != null) {
            rm.stop();
        }
    }

    private static void setupAndStartRM() throws Exception {
        Configuration rmconf = new Configuration();
        rmconf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        rmconf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
        rmconf.setBoolean("yarn.acl.enable", true);
        String httpPrefix = "hadoop.http.authentication.";
        rmconf.setStrings(httpPrefix + "type", new String[]{"kerberos"});
        rmconf.set(httpPrefix + "kerberos.principal", httpSpnegoPrincipal);
        rmconf.set(httpPrefix + "kerberos.keytab", httpSpnegoKeytabFile.getAbsolutePath());
        rmconf.set(httpPrefix + "signature.secret" + ".file", httpSpnegoKeytabFile.getAbsolutePath());
        rmconf.set("hadoop.security.authentication", "kerberos");
        rmconf.setBoolean("yarn.resourcemanager.webapp.delegation-token-auth-filter.enabled", true);
        rmconf.set("yarn.resourcemanager.webapp.spnego-principal", httpSpnegoPrincipal);
        rmconf.set("yarn.resourcemanager.keytab", httpSpnegoKeytabFile.getAbsolutePath());
        rmconf.set("yarn.resourcemanager.webapp.spnego-keytab-file", httpSpnegoKeytabFile.getAbsolutePath());
        rmconf.set("yarn.nodemanager.webapp.spnego-principal", httpSpnegoPrincipal);
        rmconf.set("yarn.nodemanager.webapp.spnego-keytab-file", httpSpnegoKeytabFile.getAbsolutePath());
        rmconf.setBoolean("mockrm.webapp.enabled", true);
        UserGroupInformation.setConfiguration((Configuration)rmconf);
        rm = new MockRM(rmconf);
        rm.start();
    }

    private static void setupKDC() throws Exception {
        if (!miniKDCStarted) {
            testMiniKDC.start();
            TestRMWebServicesDelegationTokenAuthentication.getKdc().createPrincipal(httpSpnegoKeytabFile, new String[]{"HTTP/localhost", "client", UserGroupInformation.getLoginUser().getShortUserName()});
            miniKDCStarted = true;
        }
    }

    private static MiniKdc getKdc() {
        return testMiniKDC;
    }

    @Test
    public void testDelegationTokenAuth() throws Exception {
        String token = this.getDelegationToken("test");
        ApplicationSubmissionContextInfo app = new ApplicationSubmissionContextInfo();
        String appid = "application_123_0";
        app.setApplicationId(appid);
        String requestBody = TestRMWebServicesDelegationTokenAuthentication.getMarshalledAppInfo((ApplicationSubmissionContextInfo)app);
        URL url = new URL("http://localhost:8088/ws/v1/cluster/apps");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        TestRMWebServicesDelegationTokenAuthentication.setupConn((HttpURLConnection)conn, (String)"POST", (String)"application/xml", (String)requestBody);
        try {
            conn.getInputStream();
            Assert.fail((String)"we should not be here");
        }
        catch (IOException e) {
            Assert.assertEquals((long)ClientResponse.Status.UNAUTHORIZED.getStatusCode(), (long)conn.getResponseCode());
        }
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Hadoop-YARN-Auth-Delegation-Token", token);
        TestRMWebServicesDelegationTokenAuthentication.setupConn((HttpURLConnection)conn, (String)"POST", (String)"application/xml", (String)requestBody);
        conn.getInputStream();
        boolean appExists = rm.getRMContext().getRMApps().containsKey(ConverterUtils.toApplicationId((String)appid));
        Assert.assertTrue((boolean)appExists);
        RMApp actualApp = (RMApp)rm.getRMContext().getRMApps().get(ConverterUtils.toApplicationId((String)appid));
        String owner = actualApp.getUser();
        Assert.assertEquals((Object)"client", (Object)owner);
    }

    @Test
    public void testCancelledDelegationToken() throws Exception {
        String token = this.getDelegationToken("client");
        this.cancelDelegationToken(token);
        ApplicationSubmissionContextInfo app = new ApplicationSubmissionContextInfo();
        String appid = "application_123_0";
        app.setApplicationId(appid);
        String requestBody = TestRMWebServicesDelegationTokenAuthentication.getMarshalledAppInfo((ApplicationSubmissionContextInfo)app);
        URL url = new URL("http://localhost:8088/ws/v1/cluster/apps");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Hadoop-YARN-Auth-Delegation-Token", token);
        TestRMWebServicesDelegationTokenAuthentication.setupConn((HttpURLConnection)conn, (String)"POST", (String)"application/xml", (String)requestBody);
        try {
            conn.getInputStream();
            Assert.fail((String)"Authentication should fail with expired delegation tokens");
        }
        catch (IOException e) {
            Assert.assertEquals((long)ClientResponse.Status.FORBIDDEN.getStatusCode(), (long)conn.getResponseCode());
        }
    }

    @Test
    public void testDelegationTokenOps() throws Exception {
        String[] requests;
        String token = this.getDelegationToken("client");
        String createRequest = "{\"renewer\":\"test\"}";
        String renewRequest = "{\"token\": \"" + token + "\"}";
        for (String requestBody : requests = new String[]{createRequest, renewRequest}) {
            URL url = new URL("http://localhost:8088/ws/v1/cluster/delegation-token");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("Hadoop-YARN-Auth-Delegation-Token", token);
            TestRMWebServicesDelegationTokenAuthentication.setupConn((HttpURLConnection)conn, (String)"POST", (String)"application/json", (String)requestBody);
            try {
                conn.getInputStream();
                Assert.fail((String)"Creation/Renewing delegation tokens should not be allowed with token auth");
            }
            catch (IOException e) {
                Assert.assertEquals((long)ClientResponse.Status.FORBIDDEN.getStatusCode(), (long)conn.getResponseCode());
            }
        }
        URL url = new URL("http://localhost:8088/ws/v1/cluster/delegation-token");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Hadoop-YARN-Auth-Delegation-Token", token);
        conn.setRequestProperty("Hadoop-YARN-RM-Delegation-Token", token);
        TestRMWebServicesDelegationTokenAuthentication.setupConn((HttpURLConnection)conn, (String)"DELETE", null, null);
        try {
            conn.getInputStream();
            Assert.fail((String)"Cancelling delegation tokens should not be allowed with token auth");
        }
        catch (IOException e) {
            Assert.assertEquals((long)ClientResponse.Status.FORBIDDEN.getStatusCode(), (long)conn.getResponseCode());
        }
    }

    private String getDelegationToken(String renewer) throws Exception {
        String token = (String)KerberosTestUtils.doAsClient((Callable)new /* Unavailable Anonymous Inner Class!! */);
        return token;
    }

    private void cancelDelegationToken(String tokenString) throws Exception {
        KerberosTestUtils.doAsClient((Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    static String getMarshalledAppInfo(ApplicationSubmissionContextInfo appInfo) throws Exception {
        StringWriter writer = new StringWriter();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ApplicationSubmissionContextInfo.class});
        Marshaller m = context.createMarshaller();
        m.marshal((Object)appInfo, (Writer)writer);
        return writer.toString();
    }

    static void setupConn(HttpURLConnection conn, String method, String contentType, String body) throws Exception {
        conn.setRequestMethod(method);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept-Charset", "UTF8");
        if (contentType != null && !contentType.isEmpty()) {
            conn.setRequestProperty("Content-Type", contentType + ";charset=UTF8");
            if (body != null && !body.isEmpty()) {
                OutputStream stream = conn.getOutputStream();
                stream.write(body.getBytes("UTF8"));
                stream.close();
            }
        }
    }
}

