/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.JerseyTest;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Callable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesDelegationTokens;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.DelegationToken;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
@RunWith(value=Parameterized.class)
public class TestRMWebServicesDelegationTokens
extends JerseyTest {
    private static File testRootDir;
    private static File httpSpnegoKeytabFile;
    private static String httpSpnegoPrincipal;
    private static MiniKdc testMiniKDC;
    private static MockRM rm;
    private Injector injector;
    private boolean isKerberosAuth = false;
    final String yarnTokenHeader = "Hadoop-YARN-RM-Delegation-Token";

    private Injector getSimpleAuthInjector() {
        return Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    private Injector getKerberosAuthInjector() {
        return Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    @Parameterized.Parameters
    public static Collection<Object[]> guiceConfigs() {
        return Arrays.asList({0}, {1});
    }

    public TestRMWebServicesDelegationTokens(int run) throws Exception {
        super((AppDescriptor)new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.resourcemanager.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
        switch (run) {
            default: {
                this.injector = this.getKerberosAuthInjector();
                break;
            }
            case 1: {
                this.injector = this.getSimpleAuthInjector();
            }
        }
    }

    @BeforeClass
    public static void setupKDC() throws Exception {
        testRootDir = new File("target", TestRMWebServicesDelegationTokens.class.getName() + "-root");
        testMiniKDC = new MiniKdc(MiniKdc.createConf(), testRootDir);
        testMiniKDC.start();
        testMiniKDC.createPrincipal(httpSpnegoKeytabFile, new String[]{"HTTP/localhost", "client", "client2", "client3"});
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        httpSpnegoKeytabFile.deleteOnExit();
        testRootDir.deleteOnExit();
    }

    @AfterClass
    public static void shutdownKdc() {
        if (testMiniKDC != null) {
            testMiniKDC.stop();
        }
    }

    @After
    public void tearDown() throws Exception {
        rm.stop();
        super.tearDown();
    }

    @Test
    public void testCreateDelegationToken() throws Exception {
        rm.start();
        this.client().addFilter((ClientFilter)new LoggingFilter(System.out));
        String renewer = "test-renewer";
        String jsonBody = "{ \"renewer\" : \"test-renewer\" }";
        String xmlBody = "<delegation-token><renewer>test-renewer</renewer></delegation-token>";
        String[] mediaTypes = new String[]{"application/json", "application/xml"};
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("application/json", jsonBody);
        bodyMap.put("application/xml", xmlBody);
        for (String mediaType : mediaTypes) {
            String body = (String)bodyMap.get(mediaType);
            for (String contentType : mediaTypes) {
                if (this.isKerberosAuth) {
                    this.verifyKerberosAuthCreate(mediaType, contentType, body, "test-renewer");
                    continue;
                }
                this.verifySimpleAuthCreate(mediaType, contentType, body);
            }
        }
        rm.stop();
    }

    private void verifySimpleAuthCreate(String mediaType, String contentType, String body) {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.resource().path("ws").path("v1").path("cluster").path("delegation-token").queryParam("user.name", "testuser").accept(new String[]{contentType}).entity((Object)body, mediaType)).post(ClientResponse.class);
        Assert.assertEquals((Object)ClientResponse.Status.FORBIDDEN, (Object)response.getClientResponseStatus());
    }

    private void verifyKerberosAuthCreate(String mType, String cType, String reqBody, String renUser) throws Exception {
        String mediaType = mType;
        String contentType = cType;
        String body = reqBody;
        String renewer = renUser;
        KerberosTestUtils.doAsClient((Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test
    public void testRenewDelegationToken() throws Exception {
        String[] mediaTypes;
        this.client().addFilter((ClientFilter)new LoggingFilter(System.out));
        rm.start();
        String renewer = "client2";
        this.client().addFilter((ClientFilter)new LoggingFilter(System.out));
        DelegationToken dummyToken = new DelegationToken();
        dummyToken.setRenewer("client2");
        for (String mediaType : mediaTypes = new String[]{"application/json", "application/xml"}) {
            for (String contentType : mediaTypes) {
                if (!this.isKerberosAuth) {
                    this.verifySimpleAuthRenew(mediaType, contentType);
                    continue;
                }
                DelegationToken responseToken = (DelegationToken)KerberosTestUtils.doAsClient((Callable)new /* Unavailable Anonymous Inner Class!! */);
                KerberosTestUtils.doAs((String)"client2", (Callable)new /* Unavailable Anonymous Inner Class!! */);
                KerberosTestUtils.doAs((String)"client3", (Callable)new /* Unavailable Anonymous Inner Class!! */);
                KerberosTestUtils.doAsClient((Callable)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        rm.stop();
    }

    private void verifySimpleAuthRenew(String mediaType, String contentType) {
        String token = "TEST_TOKEN_STRING";
        String body = "";
        if (mediaType.equals("application/json")) {
            body = "{\"token\": \"" + token + "\" }";
            body = "{\"abcd\": \"test-123\" }";
        } else {
            body = "<delegation-token><token>" + token + "</token></delegation-token>";
            body = "<delegation-token><xml>abcd</xml></delegation-token>";
        }
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.resource().path("ws").path("v1").path("cluster").path("delegation-token").queryParam("user.name", "testuser").accept(new String[]{contentType}).entity((Object)body, mediaType)).post(ClientResponse.class);
        Assert.assertEquals((Object)ClientResponse.Status.FORBIDDEN, (Object)response.getClientResponseStatus());
    }

    @Test
    public void testCancelDelegationToken() throws Exception {
        String[] mediaTypes;
        rm.start();
        this.client().addFilter((ClientFilter)new LoggingFilter(System.out));
        if (!this.isKerberosAuth) {
            this.verifySimpleAuthCancel();
            return;
        }
        DelegationToken dtoken = new DelegationToken();
        String renewer = "client2";
        dtoken.setRenewer(renewer);
        for (String mediaType : mediaTypes = new String[]{"application/json", "application/xml"}) {
            for (String contentType : mediaTypes) {
                KerberosTestUtils.doAsClient((Callable)new /* Unavailable Anonymous Inner Class!! */);
                DelegationToken tmpToken = (DelegationToken)KerberosTestUtils.doAsClient((Callable)new /* Unavailable Anonymous Inner Class!! */);
                KerberosTestUtils.doAs((String)renewer, (Callable)new /* Unavailable Anonymous Inner Class!! */);
                DelegationToken tmpToken2 = (DelegationToken)KerberosTestUtils.doAsClient((Callable)new /* Unavailable Anonymous Inner Class!! */);
                KerberosTestUtils.doAs((String)"client3", (Callable)new /* Unavailable Anonymous Inner Class!! */);
                this.testCancelTokenBadRequests(mediaType, contentType);
            }
        }
        rm.stop();
    }

    private void testCancelTokenBadRequests(String mType, String cType) throws Exception {
        String mediaType = mType;
        String contentType = cType;
        DelegationToken dtoken = new DelegationToken();
        String renewer = "client2";
        dtoken.setRenewer(renewer);
        KerberosTestUtils.doAsClient((Callable)new /* Unavailable Anonymous Inner Class!! */);
        KerberosTestUtils.doAsClient((Callable)new /* Unavailable Anonymous Inner Class!! */);
        DelegationToken tmpToken = (DelegationToken)KerberosTestUtils.doAsClient((Callable)new /* Unavailable Anonymous Inner Class!! */);
        KerberosTestUtils.doAs((String)renewer, (Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void verifySimpleAuthCancel() {
        ClientResponse response = (ClientResponse)this.resource().path("ws").path("v1").path("cluster").path("delegation-token").queryParam("user.name", "testuser").header("Hadoop-YARN-RM-Delegation-Token", (Object)"random").delete(ClientResponse.class);
        Assert.assertEquals((Object)ClientResponse.Status.FORBIDDEN, (Object)response.getClientResponseStatus());
    }

    private DelegationToken getDelegationTokenFromResponse(ClientResponse response) throws IOException, ParserConfigurationException, SAXException, JSONException {
        if (response.getType().toString().equals("application/json")) {
            return TestRMWebServicesDelegationTokens.getDelegationTokenFromJson((JSONObject)((JSONObject)response.getEntity(JSONObject.class)));
        }
        return TestRMWebServicesDelegationTokens.getDelegationTokenFromXML((String)((String)response.getEntity(String.class)));
    }

    public static DelegationToken getDelegationTokenFromXML(String tokenXML) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(tokenXML));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("delegation-token");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        Element element = (Element)nodes.item(0);
        DelegationToken ret = new DelegationToken();
        String token = WebServicesTestUtils.getXmlString((Element)element, (String)"token");
        if (token != null) {
            ret.setToken(token);
        } else {
            long expiration = WebServicesTestUtils.getXmlLong((Element)element, (String)"expiration-time");
            ret.setNextExpirationTime(expiration);
        }
        return ret;
    }

    public static DelegationToken getDelegationTokenFromJson(JSONObject json) throws JSONException {
        DelegationToken ret = new DelegationToken();
        if (json.has("token")) {
            ret.setToken(json.getString("token"));
        } else if (json.has("expiration-time")) {
            ret.setNextExpirationTime(json.getLong("expiration-time"));
        }
        return ret;
    }

    private void assertValidRMToken(String encodedToken) throws IOException {
        Token realToken = new Token();
        realToken.decodeFromUrlString(encodedToken);
        RMDelegationTokenIdentifier ident = (RMDelegationTokenIdentifier)realToken.decodeIdentifier();
        rm.getRMContext().getRMDelegationTokenSecretManager().verifyToken((AbstractDelegationTokenIdentifier)ident, realToken.getPassword());
        Assert.assertTrue((boolean)rm.getRMContext().getRMDelegationTokenSecretManager().getAllTokens().containsKey(ident));
    }

    private void assertTokenCancelled(String encodedToken) throws Exception {
        Token realToken = new Token();
        realToken.decodeFromUrlString(encodedToken);
        RMDelegationTokenIdentifier ident = (RMDelegationTokenIdentifier)realToken.decodeIdentifier();
        boolean exceptionCaught = false;
        try {
            rm.getRMContext().getRMDelegationTokenSecretManager().verifyToken((AbstractDelegationTokenIdentifier)ident, realToken.getPassword());
        }
        catch (SecretManager.InvalidToken it) {
            exceptionCaught = true;
        }
        Assert.assertTrue((String)"InvalidToken exception not thrown", (boolean)exceptionCaught);
        Assert.assertFalse((boolean)rm.getRMContext().getRMDelegationTokenSecretManager().getAllTokens().containsKey(ident));
    }

    private static String generateRenewTokenBody(String mediaType, String token) {
        String body = "";
        body = mediaType.equals("application/json") ? "{\"token\": \"" + token + "\" }" : "<delegation-token><token>" + token + "</token></delegation-token>";
        return body;
    }

    static /* synthetic */ String access$000() {
        return httpSpnegoPrincipal;
    }

    static /* synthetic */ File access$100() {
        return httpSpnegoKeytabFile;
    }

    static /* synthetic */ MockRM access$202(MockRM x0) {
        rm = x0;
        return rm;
    }

    static /* synthetic */ MockRM access$200() {
        return rm;
    }

    static /* synthetic */ boolean access$300(TestRMWebServicesDelegationTokens x0) {
        return x0.isKerberosAuth;
    }

    static /* synthetic */ boolean access$302(TestRMWebServicesDelegationTokens x0, boolean x1) {
        x0.isKerberosAuth = x1;
        return x0.isKerberosAuth;
    }

    static /* synthetic */ Injector access$500(TestRMWebServicesDelegationTokens x0) {
        return x0.injector;
    }

    static /* synthetic */ DelegationToken access$600(TestRMWebServicesDelegationTokens x0, ClientResponse x1) throws IOException, ParserConfigurationException, SAXException, JSONException {
        return x0.getDelegationTokenFromResponse(x1);
    }

    static /* synthetic */ void access$700(TestRMWebServicesDelegationTokens x0, String x1) throws IOException {
        x0.assertValidRMToken(x1);
    }

    static /* synthetic */ String access$800(String x0, String x1) {
        return TestRMWebServicesDelegationTokens.generateRenewTokenBody((String)x0, (String)x1);
    }

    static /* synthetic */ void access$900(TestRMWebServicesDelegationTokens x0, String x1) throws Exception {
        x0.assertTokenCancelled(x1);
    }

    static {
        httpSpnegoKeytabFile = new File(KerberosTestUtils.getKeytabFile());
        httpSpnegoPrincipal = KerberosTestUtils.getServerPrincipal();
    }
}

