/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.TestApplicationACLs;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.junit.Before;

public abstract class ACLsTestBase {
    protected static final String COMMON_USER = "common_user";
    protected static final String QUEUE_A_USER = "queueA_user";
    protected static final String QUEUE_B_USER = "queueB_user";
    protected static final String ROOT_ADMIN = "root_admin";
    protected static final String QUEUE_A_ADMIN = "queueA_admin";
    protected static final String QUEUE_B_ADMIN = "queueB_admin";
    protected static final String QUEUEA = "queueA";
    protected static final String QUEUEB = "queueB";
    protected static final String QUEUEC = "queueC";
    protected static final Log LOG = LogFactory.getLog(TestApplicationACLs.class);
    MockRM resourceManager;
    Configuration conf;
    YarnRPC rpc;
    InetSocketAddress rmAddress;

    @Before
    public void setup() throws InterruptedException, IOException {
        this.conf = this.createConfiguration();
        this.rpc = YarnRPC.create((Configuration)this.conf);
        this.rmAddress = this.conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
        AccessControlList adminACL = new AccessControlList("");
        this.conf.set("yarn.admin.acl", adminACL.getAclString());
        this.resourceManager = new MockRM(this.conf){

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService(this.getRMContext(), (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager());
            }

            @Override
            protected Dispatcher createDispatcher() {
                return new DrainDispatcher();
            }

            protected void doSecureLogin() throws IOException {
            }
        };
        new Thread(){

            @Override
            public void run() {
                ACLsTestBase.this.resourceManager.start();
            }
        }.start();
        int waitCount = 0;
        while (this.resourceManager.getServiceState() == Service.STATE.INITED && waitCount++ < 60) {
            LOG.info((Object)"Waiting for RM to start...");
            Thread.sleep(1500L);
        }
        if (this.resourceManager.getServiceState() != Service.STATE.STARTED) {
            throw new IOException("ResourceManager failed to start. Final state is " + this.resourceManager.getServiceState());
        }
    }

    protected ApplicationClientProtocol getRMClientForUser(String user) throws IOException, InterruptedException {
        UserGroupInformation userUGI = UserGroupInformation.createRemoteUser((String)user);
        ApplicationClientProtocol userClient = (ApplicationClientProtocol)userUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ApplicationClientProtocol>(){

            @Override
            public ApplicationClientProtocol run() throws Exception {
                return (ApplicationClientProtocol)ACLsTestBase.this.rpc.getProxy(ApplicationClientProtocol.class, ACLsTestBase.this.rmAddress, ACLsTestBase.this.conf);
            }
        });
        return userClient;
    }

    protected abstract Configuration createConfiguration() throws IOException;
}

