/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.junit.Before;

public abstract class ParameterizedSchedulerTestBase {
    protected static final String TEST_DIR = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
    private static final String FS_ALLOC_FILE = new File(TEST_DIR, "test-fs-queues.xml").getAbsolutePath();
    private SchedulerType schedulerType;
    private YarnConfiguration conf = null;

    public YarnConfiguration getConf() {
        return this.conf;
    }

    @Before
    public void configureScheduler() throws IOException, ClassNotFoundException {
        this.conf = new YarnConfiguration();
        Class schedulerClass = this.conf.getClass("yarn.resourcemanager.scheduler.class", Class.forName("org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler"));
        if (schedulerClass == FairScheduler.class) {
            this.schedulerType = SchedulerType.FAIR;
            this.configureFairScheduler(this.conf);
        } else if (schedulerClass == CapacityScheduler.class) {
            this.schedulerType = SchedulerType.CAPACITY;
        }
    }

    private void configureFairScheduler(YarnConfiguration conf) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(FS_ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queueMaxAMShareDefault>-1.0</queueMaxAMShareDefault>");
        out.println("<defaultQueueSchedulingPolicy>fair</defaultQueueSchedulingPolicy>");
        out.println("<queue name=\"root\">");
        out.println("  <schedulingPolicy>drf</schedulingPolicy>");
        out.println("  <weight>1.0</weight>");
        out.println("  <fairSharePreemptionTimeout>100</fairSharePreemptionTimeout>");
        out.println("  <minSharePreemptionTimeout>120</minSharePreemptionTimeout>");
        out.println("  <fairSharePreemptionThreshold>.5</fairSharePreemptionThreshold>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        conf.set("yarn.resourcemanager.scheduler.class", FairScheduler.class.getName());
        conf.set("yarn.scheduler.fair.allocation.file", FS_ALLOC_FILE);
    }

    public SchedulerType getSchedulerType() {
        return this.schedulerType;
    }

    public static enum SchedulerType {
        CAPACITY,
        FAIR;

    }
}

