/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.Application;
import org.apache.hadoop.yarn.server.resourcemanager.NodeManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;

public class Task {
    private static final Log LOG = LogFactory.getLog(Task.class);
    private final ApplicationId applicationId;
    private final int taskId;
    private final Priority priority;
    private final Set<String> hosts = new HashSet<String>();
    private final Set<String> racks = new HashSet<String>();
    private ContainerId containerId;
    private NodeManager nodeManager;
    private State state;

    public Task(Application application, Priority priority2, String[] hosts) {
        this.applicationId = application.getApplicationId();
        this.priority = priority2;
        this.taskId = application.getNextTaskId();
        this.state = State.PENDING;
        if (hosts.length != 1 || !hosts[0].equals("*")) {
            for (String host : hosts) {
                this.hosts.add(host);
                this.racks.add(Application.resolve(host));
            }
        }
        LOG.info((Object)("Task " + this.taskId + " added to application " + this.applicationId + " with " + this.hosts.size() + " hosts, " + this.racks.size() + " racks"));
    }

    public int getTaskId() {
        return this.taskId;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    public ContainerId getContainerId() {
        return this.containerId;
    }

    public ApplicationId getApplicationID() {
        return this.applicationId;
    }

    public String[] getHosts() {
        return this.hosts.toArray(new String[this.hosts.size()]);
    }

    public String[] getRacks() {
        return this.racks.toArray(new String[this.racks.size()]);
    }

    public boolean canSchedule(NodeType type, String hostName) {
        if (type == NodeType.NODE_LOCAL) {
            return this.hosts.contains(hostName);
        }
        if (type == NodeType.RACK_LOCAL) {
            return this.racks.contains(Application.resolve(hostName));
        }
        return true;
    }

    public void start(NodeManager nodeManager, ContainerId containerId) {
        this.nodeManager = nodeManager;
        this.containerId = containerId;
        this.setState(State.RUNNING);
    }

    public void stop() {
        if (this.getState() != State.RUNNING) {
            throw new IllegalStateException("Trying to stop a non-running task: " + this.getTaskId() + " of application " + this.getApplicationID());
        }
        this.nodeManager = null;
        this.containerId = null;
        this.setState(State.COMPLETE);
    }

    public State getState() {
        return this.state;
    }

    private void setState(State state) {
        this.state = state;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Task) {
            return ((Task)obj).taskId == this.taskId;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.taskId;
    }

    public static enum State {
        PENDING,
        ALLOCATED,
        RUNNING,
        COMPLETE;

    }
}

