/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CyclicBarrier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.ApplicationsRequestScope;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.ReservationAllocationState;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.ReservationRequests;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.security.QueueACLsManager;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.UTCClock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestClientRMService {
    private static final Log LOG = LogFactory.getLog(TestClientRMService.class);
    private RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private String appType = "MockApp";
    private static final String QUEUE_1 = "Q-1";
    private static final String QUEUE_2 = "Q-2";

    @Test
    public void testGetClusterNodes() throws Exception {
        MockRM rm = new MockRM(){

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager());
            }
        };
        rm.start();
        RMNodeLabelsManager labelsMgr = rm.getRMContext().getNodeLabelManager();
        labelsMgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        MockNM node = rm.registerNode("host1:1234", 1024);
        HashMap<NodeId, ImmutableSet> map = new HashMap<NodeId, ImmutableSet>();
        map.put(node.getNodeId(), ImmutableSet.of((Object)"x"));
        labelsMgr.replaceLabelsOnNode(map);
        rm.sendNodeStarted(node);
        node.nodeHeartbeat(true);
        MockNM lostNode = rm.registerNode("host2:1235", 1024);
        rm.sendNodeStarted(lostNode);
        lostNode.nodeHeartbeat(true);
        rm.NMwaitForState(lostNode.getNodeId(), NodeState.RUNNING);
        rm.sendNodeLost(lostNode);
        Configuration conf = new Configuration();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress rmAddress = rm.getClientRMService().getBindAddress();
        LOG.info((Object)("Connecting to ResourceManager at " + rmAddress));
        ApplicationClientProtocol client = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, rmAddress, conf);
        GetClusterNodesRequest request = GetClusterNodesRequest.newInstance(EnumSet.of(NodeState.RUNNING));
        List nodeReports = client.getClusterNodes(request).getNodeReports();
        Assert.assertEquals((long)1L, (long)nodeReports.size());
        Assert.assertNotSame((String)"Node is expected to be healthy!", (Object)NodeState.UNHEALTHY, (Object)((NodeReport)nodeReports.get(0)).getNodeState());
        Assert.assertTrue((boolean)((NodeReport)nodeReports.get(0)).getNodeLabels().contains("x"));
        node.nodeHeartbeat(false);
        rm.NMwaitForState(node.getNodeId(), NodeState.UNHEALTHY);
        nodeReports = client.getClusterNodes(request).getNodeReports();
        Assert.assertEquals((String)"Unhealthy nodes should not show up by default", (long)0L, (long)nodeReports.size());
        map = new HashMap();
        map.put(node.getNodeId(), ImmutableSet.of((Object)"y"));
        labelsMgr.replaceLabelsOnNode(map);
        request = GetClusterNodesRequest.newInstance(EnumSet.of(NodeState.UNHEALTHY));
        nodeReports = client.getClusterNodes(request).getNodeReports();
        Assert.assertEquals((long)1L, (long)nodeReports.size());
        Assert.assertEquals((String)"Node is expected to be unhealthy!", (Object)NodeState.UNHEALTHY, (Object)((NodeReport)nodeReports.get(0)).getNodeState());
        Assert.assertTrue((boolean)((NodeReport)nodeReports.get(0)).getNodeLabels().contains("y"));
        map = new HashMap();
        map.put(node.getNodeId(), ImmutableSet.of((Object)"y"));
        labelsMgr.removeLabelsFromNode(map);
        rm.registerNode("host3:1236", 1024);
        request = GetClusterNodesRequest.newInstance(EnumSet.allOf(NodeState.class));
        nodeReports = client.getClusterNodes(request).getNodeReports();
        Assert.assertEquals((long)3L, (long)nodeReports.size());
        for (NodeReport report : nodeReports) {
            Assert.assertTrue((report.getNodeLabels() != null && report.getNodeLabels().isEmpty() ? 1 : 0) != 0);
        }
        rpc.stopProxy((Object)client, conf);
        rm.close();
    }

    @Test
    public void testNonExistingApplicationReport() throws YarnException {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(new ConcurrentHashMap());
        ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, null);
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        GetApplicationReportRequest request = (GetApplicationReportRequest)recordFactory.newRecordInstance(GetApplicationReportRequest.class);
        request.setApplicationId(ApplicationId.newInstance((long)0L, (int)0));
        try {
            rmService.getApplicationReport(request);
            Assert.fail();
        }
        catch (ApplicationNotFoundException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)("Application with id '" + request.getApplicationId() + "' doesn't exist in RM."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetApplicationReport() throws Exception {
        YarnScheduler yarnScheduler = (YarnScheduler)Mockito.mock(YarnScheduler.class);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        ApplicationId appId1 = TestClientRMService.getApplicationId(1);
        ApplicationACLsManager mockAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        Mockito.when((Object)mockAclsManager.checkAccess(UserGroupInformation.getCurrentUser(), ApplicationAccessType.VIEW_APP, null, appId1)).thenReturn((Object)true);
        try (ClientRMService rmService = new ClientRMService(rmContext, yarnScheduler, null, mockAclsManager, null, null);){
            RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
            GetApplicationReportRequest request = (GetApplicationReportRequest)recordFactory.newRecordInstance(GetApplicationReportRequest.class);
            request.setApplicationId(appId1);
            GetApplicationReportResponse response = rmService.getApplicationReport(request);
            ApplicationReport report = response.getApplicationReport();
            ApplicationResourceUsageReport usageReport = report.getApplicationResourceUsageReport();
            Assert.assertEquals((long)10L, (long)usageReport.getMemorySeconds());
            Assert.assertEquals((long)3L, (long)usageReport.getVcoreSeconds());
            Assert.assertEquals((Object)"<Not set>", (Object)report.getAmNodeLabelExpression());
            Assert.assertEquals((Object)"<Not set>", (Object)report.getAppNodeLabelExpression());
            ApplicationId appId2 = TestClientRMService.getApplicationId(2);
            Mockito.when((Object)mockAclsManager.checkAccess(UserGroupInformation.getCurrentUser(), ApplicationAccessType.VIEW_APP, null, appId2)).thenReturn((Object)true);
            request.setApplicationId(appId2);
            response = rmService.getApplicationReport(request);
            report = response.getApplicationReport();
            Assert.assertEquals((Object)"<DEFAULT_PARTITION>", (Object)report.getAmNodeLabelExpression());
            Assert.assertEquals((Object)"<Not set>", (Object)report.getAppNodeLabelExpression());
            ApplicationId appId3 = TestClientRMService.getApplicationId(3);
            Mockito.when((Object)mockAclsManager.checkAccess(UserGroupInformation.getCurrentUser(), ApplicationAccessType.VIEW_APP, null, appId3)).thenReturn((Object)true);
            request.setApplicationId(appId3);
            response = rmService.getApplicationReport(request);
            report = response.getApplicationReport();
            Assert.assertEquals((Object)"high-mem", (Object)report.getAmNodeLabelExpression());
            Assert.assertEquals((Object)"high-mem", (Object)report.getAppNodeLabelExpression());
            GetApplicationReportRequest invalidRequest = (GetApplicationReportRequest)recordFactory.newRecordInstance(GetApplicationReportRequest.class);
            invalidRequest.setApplicationId(null);
            try {
                rmService.getApplicationReport(invalidRequest);
            }
            catch (YarnException e) {
                Assert.assertTrue((boolean)(e instanceof ApplicationNotFoundException));
            }
        }
    }

    @Test
    public void testGetApplicationAttemptReport() throws YarnException, IOException {
        ClientRMService rmService = this.createRMService();
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        GetApplicationAttemptReportRequest request = (GetApplicationAttemptReportRequest)recordFactory.newRecordInstance(GetApplicationAttemptReportRequest.class);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)123456L, (int)1), (int)1);
        request.setApplicationAttemptId(attemptId);
        try {
            GetApplicationAttemptReportResponse response = rmService.getApplicationAttemptReport(request);
            Assert.assertEquals((Object)attemptId, (Object)response.getApplicationAttemptReport().getApplicationAttemptId());
        }
        catch (ApplicationNotFoundException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testGetApplicationResourceUsageReportDummy() throws YarnException, IOException {
        ApplicationAttemptId attemptId = TestClientRMService.getApplicationAttemptId(1);
        YarnScheduler yarnScheduler = TestClientRMService.mockYarnScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)new EventHandler<Event>(){

            public void handle(Event event) {
            }
        });
        ApplicationSubmissionContext asContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        YarnConfiguration config = new YarnConfiguration();
        RMAppAttemptImpl rmAppAttemptImpl = new RMAppAttemptImpl(attemptId, rmContext, yarnScheduler, null, asContext, (Configuration)config, false, null);
        ApplicationResourceUsageReport report = rmAppAttemptImpl.getApplicationResourceUsageReport();
        Assert.assertEquals((Object)report, (Object)RMServerUtils.DUMMY_APPLICATION_RESOURCE_USAGE_REPORT);
    }

    @Test
    public void testGetApplicationAttempts() throws YarnException, IOException {
        ClientRMService rmService = this.createRMService();
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        GetApplicationAttemptsRequest request = (GetApplicationAttemptsRequest)recordFactory.newRecordInstance(GetApplicationAttemptsRequest.class);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)123456L, (int)1), (int)1);
        request.setApplicationId(ApplicationId.newInstance((long)123456L, (int)1));
        try {
            GetApplicationAttemptsResponse response = rmService.getApplicationAttempts(request);
            Assert.assertEquals((long)1L, (long)response.getApplicationAttemptList().size());
            Assert.assertEquals((Object)attemptId, (Object)((ApplicationAttemptReport)response.getApplicationAttemptList().get(0)).getApplicationAttemptId());
        }
        catch (ApplicationNotFoundException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testGetContainerReport() throws YarnException, IOException {
        ClientRMService rmService = this.createRMService();
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        GetContainerReportRequest request = (GetContainerReportRequest)recordFactory.newRecordInstance(GetContainerReportRequest.class);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)123456L, (int)1), (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        request.setContainerId(containerId);
        try {
            GetContainerReportResponse response = rmService.getContainerReport(request);
            Assert.assertEquals((Object)containerId, (Object)response.getContainerReport().getContainerId());
        }
        catch (ApplicationNotFoundException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testGetContainers() throws YarnException, IOException {
        ClientRMService rmService = this.createRMService();
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        GetContainersRequest request = (GetContainersRequest)recordFactory.newRecordInstance(GetContainersRequest.class);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)123456L, (int)1), (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        request.setApplicationAttemptId(attemptId);
        try {
            GetContainersResponse response = rmService.getContainers(request);
            Assert.assertEquals((Object)containerId, (Object)((ContainerReport)response.getContainerList().get(0)).getContainerId());
        }
        catch (ApplicationNotFoundException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    public ClientRMService createRMService() throws IOException {
        YarnScheduler yarnScheduler = TestClientRMService.mockYarnScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        ConcurrentHashMap<ApplicationId, RMApp> apps = this.getRMApps(rmContext, yarnScheduler);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(apps);
        Mockito.when((Object)rmContext.getYarnConfiguration()).thenReturn((Object)new Configuration());
        RMAppManager appManager = new RMAppManager(rmContext, yarnScheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)new EventHandler<Event>(){

            public void handle(Event event) {
            }
        });
        ApplicationACLsManager mockAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        QueueACLsManager mockQueueACLsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)mockQueueACLsManager.checkAccess((UserGroupInformation)Matchers.any(UserGroupInformation.class), (QueueACL)Matchers.any(QueueACL.class), Matchers.anyString(), (ApplicationId)Matchers.any(ApplicationId.class), Matchers.anyString())).thenReturn((Object)true);
        return new ClientRMService(rmContext, yarnScheduler, appManager, mockAclsManager, mockQueueACLsManager, null);
    }

    @Test
    public void testForceKillNonExistingApplication() throws YarnException {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(new ConcurrentHashMap());
        ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, null);
        ApplicationId applicationId = BuilderUtils.newApplicationId((long)System.currentTimeMillis(), (int)0);
        KillApplicationRequest request = KillApplicationRequest.newInstance((ApplicationId)applicationId);
        try {
            rmService.forceKillApplication(request);
            Assert.fail();
        }
        catch (ApplicationNotFoundException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)("Trying to kill an absent application " + request.getApplicationId()));
        }
    }

    @Test
    public void testForceKillApplication() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        MockRM rm = new MockRM();
        rm.init((Configuration)conf);
        rm.start();
        ClientRMService rmService = rm.getClientRMService();
        GetApplicationsRequest getRequest = GetApplicationsRequest.newInstance(EnumSet.of(YarnApplicationState.KILLED));
        RMApp app1 = rm.submitApp(1024);
        RMApp app2 = rm.submitApp(1024, true);
        Assert.assertEquals((String)"Incorrect number of apps in the RM", (long)0L, (long)rmService.getApplications(getRequest).getApplicationList().size());
        KillApplicationRequest killRequest1 = KillApplicationRequest.newInstance((ApplicationId)app1.getApplicationId());
        KillApplicationRequest killRequest2 = KillApplicationRequest.newInstance((ApplicationId)app2.getApplicationId());
        int killAttemptCount = 0;
        for (int i = 0; i < 100; ++i) {
            KillApplicationResponse killResponse1 = rmService.forceKillApplication(killRequest1);
            ++killAttemptCount;
            if (killResponse1.getIsKillCompleted()) break;
            Thread.sleep(10L);
        }
        Assert.assertTrue((String)"Kill attempt count should be greater than 1 for managed AMs", (killAttemptCount > 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Incorrect number of apps in the RM", (long)1L, (long)rmService.getApplications(getRequest).getApplicationList().size());
        KillApplicationResponse killResponse2 = rmService.forceKillApplication(killRequest2);
        Assert.assertTrue((String)"Killing UnmanagedAM should falsely acknowledge true", (boolean)killResponse2.getIsKillCompleted());
        for (int i = 0; i < 100 && 2 != rmService.getApplications(getRequest).getApplicationList().size(); ++i) {
            Thread.sleep(10L);
        }
        Assert.assertEquals((String)"Incorrect number of apps in the RM", (long)2L, (long)rmService.getApplications(getRequest).getApplicationList().size());
    }

    @Test(expected=ApplicationNotFoundException.class)
    public void testMoveAbsentApplication() throws YarnException {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(new ConcurrentHashMap());
        ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, null);
        ApplicationId applicationId = BuilderUtils.newApplicationId((long)System.currentTimeMillis(), (int)0);
        MoveApplicationAcrossQueuesRequest request = MoveApplicationAcrossQueuesRequest.newInstance((ApplicationId)applicationId, (String)"newqueue");
        rmService.moveApplicationAcrossQueues(request);
    }

    @Test
    public void testGetQueueInfo() throws Exception {
        YarnScheduler yarnScheduler = (YarnScheduler)Mockito.mock(YarnScheduler.class);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        ApplicationACLsManager mockAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        QueueACLsManager mockQueueACLsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)mockQueueACLsManager.checkAccess((UserGroupInformation)Matchers.any(UserGroupInformation.class), (QueueACL)Matchers.any(QueueACL.class), Matchers.anyString(), (ApplicationId)Matchers.any(ApplicationId.class), Matchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)mockAclsManager.checkAccess((UserGroupInformation)Matchers.any(UserGroupInformation.class), (ApplicationAccessType)Matchers.any(ApplicationAccessType.class), Matchers.anyString(), (ApplicationId)Matchers.any(ApplicationId.class))).thenReturn((Object)true);
        ClientRMService rmService = new ClientRMService(rmContext, yarnScheduler, null, mockAclsManager, mockQueueACLsManager, null);
        GetQueueInfoRequest request = (GetQueueInfoRequest)this.recordFactory.newRecordInstance(GetQueueInfoRequest.class);
        request.setQueueName("testqueue");
        request.setIncludeApplications(true);
        GetQueueInfoResponse queueInfo = rmService.getQueueInfo(request);
        List applications = queueInfo.getQueueInfo().getApplications();
        Assert.assertEquals((long)2L, (long)applications.size());
        request.setQueueName("nonexistentqueue");
        request.setIncludeApplications(true);
        queueInfo = rmService.getQueueInfo(request);
        ApplicationACLsManager mockAclsManager1 = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        QueueACLsManager mockQueueACLsManager1 = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)mockQueueACLsManager1.checkAccess((UserGroupInformation)Matchers.any(UserGroupInformation.class), (QueueACL)Matchers.any(QueueACL.class), Matchers.anyString(), (ApplicationId)Matchers.any(ApplicationId.class), Matchers.anyString())).thenReturn((Object)false);
        Mockito.when((Object)mockAclsManager1.checkAccess((UserGroupInformation)Matchers.any(UserGroupInformation.class), (ApplicationAccessType)Matchers.any(ApplicationAccessType.class), Matchers.anyString(), (ApplicationId)Matchers.any(ApplicationId.class))).thenReturn((Object)false);
        ClientRMService rmService1 = new ClientRMService(rmContext, yarnScheduler, null, mockAclsManager1, mockQueueACLsManager1, null);
        request.setQueueName("testqueue");
        request.setIncludeApplications(true);
        GetQueueInfoResponse queueInfo1 = rmService1.getQueueInfo(request);
        List applications1 = queueInfo1.getQueueInfo().getApplications();
        Assert.assertEquals((long)0L, (long)applications1.size());
    }

    @Test(timeout=30000L)
    public void testAppSubmit() throws Exception {
        YarnScheduler yarnScheduler = TestClientRMService.mockYarnScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        RMStateStore stateStore = (RMStateStore)Mockito.mock(RMStateStore.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)stateStore);
        RMAppManager appManager = new RMAppManager(rmContext, yarnScheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)new EventHandler<Event>(){

            public void handle(Event event) {
            }
        });
        ApplicationId appId1 = TestClientRMService.getApplicationId(100);
        ApplicationACLsManager mockAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        Mockito.when((Object)mockAclsManager.checkAccess(UserGroupInformation.getCurrentUser(), ApplicationAccessType.VIEW_APP, null, appId1)).thenReturn((Object)true);
        QueueACLsManager mockQueueACLsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)mockQueueACLsManager.checkAccess((UserGroupInformation)Matchers.any(UserGroupInformation.class), (QueueACL)Matchers.any(QueueACL.class), Matchers.anyString(), (ApplicationId)Matchers.any(ApplicationId.class), Matchers.anyString())).thenReturn((Object)true);
        ClientRMService rmService = new ClientRMService(rmContext, yarnScheduler, appManager, mockAclsManager, mockQueueACLsManager, null);
        SubmitApplicationRequest submitRequest1 = this.mockSubmitAppRequest(appId1, null, null);
        try {
            rmService.submitApplication(submitRequest1);
        }
        catch (YarnException e) {
            Assert.fail((String)"Exception is not expected.");
        }
        RMApp app1 = (RMApp)rmContext.getRMApps().get(appId1);
        Assert.assertNotNull((String)"app doesn't exist", (Object)app1);
        Assert.assertEquals((String)"app name doesn't match", (Object)"N/A", (Object)app1.getName());
        Assert.assertEquals((String)"app queue doesn't match", (Object)"default", (Object)app1.getQueue());
        String name = MockApps.newAppName();
        String queue = MockApps.newQueue();
        ApplicationId appId2 = TestClientRMService.getApplicationId(101);
        SubmitApplicationRequest submitRequest2 = this.mockSubmitAppRequest(appId2, name, queue);
        submitRequest2.getApplicationSubmissionContext().setApplicationType("matchType");
        try {
            rmService.submitApplication(submitRequest2);
        }
        catch (YarnException e) {
            Assert.fail((String)"Exception is not expected.");
        }
        RMApp app2 = (RMApp)rmContext.getRMApps().get(appId2);
        Assert.assertNotNull((String)"app doesn't exist", (Object)app2);
        Assert.assertEquals((String)"app name doesn't match", (Object)name, (Object)app2.getName());
        Assert.assertEquals((String)"app queue doesn't match", (Object)queue, (Object)app2.getQueue());
        try {
            rmService.submitApplication(submitRequest2);
        }
        catch (YarnException e) {
            Assert.fail((String)"Exception is not expected.");
        }
        GetApplicationsRequest getAllAppsRequest = GetApplicationsRequest.newInstance(new HashSet());
        GetApplicationsResponse getAllApplicationsResponse = rmService.getApplications(getAllAppsRequest);
        Assert.assertEquals((long)5L, (long)getAllApplicationsResponse.getApplicationList().size());
        HashSet<String> appTypes = new HashSet<String>();
        appTypes.add("matchType");
        getAllAppsRequest = GetApplicationsRequest.newInstance(appTypes);
        getAllApplicationsResponse = rmService.getApplications(getAllAppsRequest);
        Assert.assertEquals((long)1L, (long)getAllApplicationsResponse.getApplicationList().size());
        Assert.assertEquals((Object)appId2, (Object)((ApplicationReport)getAllApplicationsResponse.getApplicationList().get(0)).getApplicationId());
    }

    @Test
    public void testGetApplications() throws IOException, YarnException {
        YarnScheduler yarnScheduler = TestClientRMService.mockYarnScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        RMStateStore stateStore = (RMStateStore)Mockito.mock(RMStateStore.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)stateStore);
        RMAppManager appManager = new RMAppManager(rmContext, yarnScheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)new EventHandler<Event>(){

            public void handle(Event event) {
            }
        });
        ApplicationACLsManager mockAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        QueueACLsManager mockQueueACLsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)mockQueueACLsManager.checkAccess((UserGroupInformation)Matchers.any(UserGroupInformation.class), (QueueACL)Matchers.any(QueueACL.class), Matchers.anyString(), (ApplicationId)Matchers.any(ApplicationId.class), Matchers.anyString())).thenReturn((Object)true);
        ClientRMService rmService = new ClientRMService(rmContext, yarnScheduler, appManager, mockAclsManager, mockQueueACLsManager, null);
        String[] queues = new String[]{QUEUE_1, QUEUE_2};
        String[] appNames = new String[]{MockApps.newAppName(), MockApps.newAppName(), MockApps.newAppName()};
        ApplicationId[] appIds = new ApplicationId[]{TestClientRMService.getApplicationId(101), TestClientRMService.getApplicationId(102), TestClientRMService.getApplicationId(103)};
        List<String> tags = Arrays.asList("Tag1", "Tag2", "Tag3");
        long[] submitTimeMillis = new long[3];
        for (int i = 0; i < appIds.length; ++i) {
            ApplicationId appId = appIds[i];
            Mockito.when((Object)mockAclsManager.checkAccess(UserGroupInformation.getCurrentUser(), ApplicationAccessType.VIEW_APP, null, appId)).thenReturn((Object)true);
            SubmitApplicationRequest submitRequest = this.mockSubmitAppRequest(appId, appNames[i], queues[i % queues.length], new HashSet<String>(tags.subList(0, i + 1)));
            rmService.submitApplication(submitRequest);
            submitTimeMillis[i] = System.currentTimeMillis();
        }
        GetApplicationsRequest request = GetApplicationsRequest.newInstance();
        Assert.assertEquals((String)"Incorrect total number of apps", (long)6L, (long)rmService.getApplications(request).getApplicationList().size());
        request.setLimit(1L);
        Assert.assertEquals((String)"Failed to limit applications", (long)1L, (long)rmService.getApplications(request).getApplicationList().size());
        request = GetApplicationsRequest.newInstance();
        request.setStartRange(submitTimeMillis[0], System.currentTimeMillis());
        Assert.assertEquals((String)"Incorrect number of matching start range", (long)2L, (long)rmService.getApplications(request).getApplicationList().size());
        request.setStartRange(submitTimeMillis[1], System.currentTimeMillis());
        Assert.assertEquals((String)"Incorrect number of matching start range", (long)1L, (long)rmService.getApplications(request).getApplicationList().size());
        request.setStartRange(submitTimeMillis[2], System.currentTimeMillis());
        Assert.assertEquals((String)"Incorrect number of matching start range", (long)0L, (long)rmService.getApplications(request).getApplicationList().size());
        request = GetApplicationsRequest.newInstance();
        HashSet<String> queueSet = new HashSet<String>();
        request.setQueues(queueSet);
        queueSet.add(queues[0]);
        Assert.assertEquals((String)"Incorrect number of applications in queue", (long)2L, (long)rmService.getApplications(request).getApplicationList().size());
        Assert.assertEquals((String)"Incorrect number of applications in queue", (long)2L, (long)rmService.getApplications(request, false).getApplicationList().size());
        queueSet.add(queues[1]);
        Assert.assertEquals((String)"Incorrect number of applications in queue", (long)3L, (long)rmService.getApplications(request).getApplicationList().size());
        request = GetApplicationsRequest.newInstance();
        HashSet<String> userSet = new HashSet<String>();
        request.setUsers(userSet);
        userSet.add("random-user-name");
        Assert.assertEquals((String)"Incorrect number of applications for user", (long)0L, (long)rmService.getApplications(request).getApplicationList().size());
        userSet.add(UserGroupInformation.getCurrentUser().getShortUserName());
        Assert.assertEquals((String)"Incorrect number of applications for user", (long)3L, (long)rmService.getApplications(request).getApplicationList().size());
        request = GetApplicationsRequest.newInstance((ApplicationsRequestScope)ApplicationsRequestScope.ALL, null, null, null, null, null, null, null, null);
        HashSet tagSet = new HashSet();
        request.setApplicationTags(tagSet);
        Assert.assertEquals((String)"Incorrect number of matching tags", (long)6L, (long)rmService.getApplications(request).getApplicationList().size());
        tagSet = Sets.newHashSet((Object[])new String[]{tags.get(0)});
        request.setApplicationTags((Set)tagSet);
        Assert.assertEquals((String)"Incorrect number of matching tags", (long)3L, (long)rmService.getApplications(request).getApplicationList().size());
        tagSet = Sets.newHashSet((Object[])new String[]{tags.get(1)});
        request.setApplicationTags((Set)tagSet);
        Assert.assertEquals((String)"Incorrect number of matching tags", (long)2L, (long)rmService.getApplications(request).getApplicationList().size());
        tagSet = Sets.newHashSet((Object[])new String[]{tags.get(2)});
        request.setApplicationTags((Set)tagSet);
        Assert.assertEquals((String)"Incorrect number of matching tags", (long)1L, (long)rmService.getApplications(request).getApplicationList().size());
        request = GetApplicationsRequest.newInstance((ApplicationsRequestScope)ApplicationsRequestScope.VIEWABLE);
        Assert.assertEquals((String)"Incorrect number of applications for the scope", (long)6L, (long)rmService.getApplications(request).getApplicationList().size());
        request = GetApplicationsRequest.newInstance((ApplicationsRequestScope)ApplicationsRequestScope.OWN);
        Assert.assertEquals((String)"Incorrect number of applications for the scope", (long)3L, (long)rmService.getApplications(request).getApplicationList().size());
    }

    @Test(timeout=4000L)
    public void testConcurrentAppSubmit() throws IOException, InterruptedException, BrokenBarrierException, YarnException {
        YarnScheduler yarnScheduler = TestClientRMService.mockYarnScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        RMStateStore stateStore = (RMStateStore)Mockito.mock(RMStateStore.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)stateStore);
        RMAppManager appManager = new RMAppManager(rmContext, yarnScheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        final ApplicationId appId1 = TestClientRMService.getApplicationId(100);
        ApplicationId appId2 = TestClientRMService.getApplicationId(101);
        final SubmitApplicationRequest submitRequest1 = this.mockSubmitAppRequest(appId1, null, null);
        SubmitApplicationRequest submitRequest2 = this.mockSubmitAppRequest(appId2, null, null);
        final CyclicBarrier startBarrier = new CyclicBarrier(2);
        final CyclicBarrier endBarrier = new CyclicBarrier(2);
        EventHandler eventHandler = new EventHandler(){

            public void handle(Event rawEvent) {
                RMAppEvent event;
                if (rawEvent instanceof RMAppEvent && (event = (RMAppEvent)rawEvent).getApplicationId().equals((Object)appId1)) {
                    try {
                        startBarrier.await();
                        endBarrier.await();
                    }
                    catch (BrokenBarrierException e) {
                        LOG.warn((Object)"Broken Barrier", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Object)"Interrupted while awaiting barriers", (Throwable)e);
                    }
                }
            }
        };
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)eventHandler);
        final ClientRMService rmService = new ClientRMService(rmContext, yarnScheduler, appManager, null, null, null);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    rmService.submitApplication(submitRequest1);
                }
                catch (IOException | YarnException throwable) {
                    // empty catch block
                }
            }
        };
        t.start();
        startBarrier.await();
        rmService.submitApplication(submitRequest2);
        endBarrier.await();
        t.join();
    }

    private SubmitApplicationRequest mockSubmitAppRequest(ApplicationId appId, String name, String queue) {
        return this.mockSubmitAppRequest(appId, name, queue, null);
    }

    private SubmitApplicationRequest mockSubmitAppRequest(ApplicationId appId, String name, String queue, Set<String> tags) {
        return this.mockSubmitAppRequest(appId, name, queue, tags, false);
    }

    private SubmitApplicationRequest mockSubmitAppRequest(ApplicationId appId, String name, String queue, Set<String> tags, boolean unmanaged) {
        ContainerLaunchContext amContainerSpec = (ContainerLaunchContext)Mockito.mock(ContainerLaunchContext.class);
        Resource resource = Resources.createResource((int)1024);
        ApplicationSubmissionContext submissionContext = (ApplicationSubmissionContext)this.recordFactory.newRecordInstance(ApplicationSubmissionContext.class);
        submissionContext.setAMContainerSpec(amContainerSpec);
        submissionContext.setApplicationName(name);
        submissionContext.setQueue(queue);
        submissionContext.setApplicationId(appId);
        submissionContext.setResource(resource);
        submissionContext.setApplicationType(this.appType);
        submissionContext.setApplicationTags(tags);
        submissionContext.setUnmanagedAM(unmanaged);
        SubmitApplicationRequest submitRequest = (SubmitApplicationRequest)this.recordFactory.newRecordInstance(SubmitApplicationRequest.class);
        submitRequest.setApplicationSubmissionContext(submissionContext);
        return submitRequest;
    }

    private void mockRMContext(YarnScheduler yarnScheduler, RMContext rmContext) throws IOException {
        Dispatcher dispatcher = (Dispatcher)Mockito.mock(Dispatcher.class);
        Mockito.when((Object)rmContext.getDispatcher()).thenReturn((Object)dispatcher);
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        Mockito.when((Object)dispatcher.getEventHandler()).thenReturn((Object)eventHandler);
        QueueInfo queInfo = (QueueInfo)this.recordFactory.newRecordInstance(QueueInfo.class);
        queInfo.setQueueName("testqueue");
        Mockito.when((Object)yarnScheduler.getQueueInfo((String)Matchers.eq((Object)"testqueue"), Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)queInfo);
        Mockito.when((Object)yarnScheduler.getQueueInfo((String)Matchers.eq((Object)"nonexistentqueue"), Matchers.anyBoolean(), Matchers.anyBoolean())).thenThrow(new Throwable[]{new IOException("queue does not exist")});
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        Mockito.when((Object)rmContext.getRMApplicationHistoryWriter()).thenReturn((Object)writer);
        SystemMetricsPublisher publisher = (SystemMetricsPublisher)Mockito.mock(SystemMetricsPublisher.class);
        Mockito.when((Object)rmContext.getSystemMetricsPublisher()).thenReturn((Object)publisher);
        Mockito.when((Object)rmContext.getYarnConfiguration()).thenReturn((Object)new YarnConfiguration());
        ConcurrentHashMap<ApplicationId, RMApp> apps = this.getRMApps(rmContext, yarnScheduler);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(apps);
        Mockito.when((Object)yarnScheduler.getAppsInQueue((String)Matchers.eq((Object)"testqueue"))).thenReturn(this.getSchedulerApps(apps));
        ResourceScheduler rs = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        Mockito.when((Object)rmContext.getScheduler()).thenReturn((Object)rs);
    }

    private ConcurrentHashMap<ApplicationId, RMApp> getRMApps(RMContext rmContext, YarnScheduler yarnScheduler) {
        ConcurrentHashMap<ApplicationId, RMApp> apps = new ConcurrentHashMap<ApplicationId, RMApp>();
        ApplicationId applicationId1 = TestClientRMService.getApplicationId(1);
        ApplicationId applicationId2 = TestClientRMService.getApplicationId(2);
        ApplicationId applicationId3 = TestClientRMService.getApplicationId(3);
        YarnConfiguration config = new YarnConfiguration();
        apps.put(applicationId1, (RMApp)this.getRMApp(rmContext, yarnScheduler, applicationId1, config, "testqueue", 10L, 3L, null, null));
        apps.put(applicationId2, (RMApp)this.getRMApp(rmContext, yarnScheduler, applicationId2, config, "a", 20L, 2L, null, ""));
        apps.put(applicationId3, (RMApp)this.getRMApp(rmContext, yarnScheduler, applicationId3, config, "testqueue", 40L, 5L, "high-mem", "high-mem"));
        return apps;
    }

    private List<ApplicationAttemptId> getSchedulerApps(Map<ApplicationId, RMApp> apps) {
        ArrayList<ApplicationAttemptId> schedApps = new ArrayList<ApplicationAttemptId>();
        schedApps.add(ApplicationAttemptId.newInstance((ApplicationId)TestClientRMService.getApplicationId(1), (int)0));
        schedApps.add(ApplicationAttemptId.newInstance((ApplicationId)TestClientRMService.getApplicationId(3), (int)0));
        return schedApps;
    }

    private static ApplicationId getApplicationId(int id) {
        return ApplicationId.newInstance((long)123456L, (int)id);
    }

    private static ApplicationAttemptId getApplicationAttemptId(int id) {
        return ApplicationAttemptId.newInstance((ApplicationId)TestClientRMService.getApplicationId(id), (int)1);
    }

    private RMAppImpl getRMApp(RMContext rmContext, YarnScheduler yarnScheduler, ApplicationId applicationId3, YarnConfiguration config, String queueName, final long memorySeconds, final long vcoreSeconds, String appNodeLabelExpression, String amNodeLabelExpression) {
        ApplicationSubmissionContext asContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        Mockito.when((Object)asContext.getMaxAppAttempts()).thenReturn((Object)1);
        Mockito.when((Object)asContext.getNodeLabelExpression()).thenReturn((Object)appNodeLabelExpression);
        RMAppImpl app = (RMAppImpl)Mockito.spy((Object)new RMAppImpl(applicationId3, rmContext, (Configuration)config, null, null, queueName, asContext, yarnScheduler, null, System.currentTimeMillis(), "YARN", null, BuilderUtils.newResourceRequest((Priority)RMAppAttemptImpl.AM_CONTAINER_PRIORITY, (String)"*", (Resource)Resource.newInstance((int)1024, (int)1), (int)1)){

            public ApplicationReport createAndGetApplicationReport(String clientUserName, boolean allowAccess) {
                ApplicationReport report = super.createAndGetApplicationReport(clientUserName, allowAccess);
                ApplicationResourceUsageReport usageReport = report.getApplicationResourceUsageReport();
                usageReport.setMemorySeconds(memorySeconds);
                usageReport.setVcoreSeconds(vcoreSeconds);
                report.setApplicationResourceUsageReport(usageReport);
                return report;
            }
        });
        app.getAMResourceRequest().setNodeLabelExpression(amNodeLabelExpression);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)123456L, (int)1), (int)1);
        RMAppAttemptImpl rmAppAttemptImpl = (RMAppAttemptImpl)Mockito.spy((Object)new RMAppAttemptImpl(attemptId, rmContext, yarnScheduler, null, asContext, (Configuration)config, false, null));
        Container container = Container.newInstance((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L), null, (String)"", null, null, null);
        RMContainerImpl containerimpl = (RMContainerImpl)Mockito.spy((Object)new RMContainerImpl(container, attemptId, null, "", rmContext));
        HashMap<ApplicationAttemptId, RMAppAttemptImpl> attempts = new HashMap<ApplicationAttemptId, RMAppAttemptImpl>();
        attempts.put(attemptId, rmAppAttemptImpl);
        Mockito.when((Object)app.getCurrentAppAttempt()).thenReturn((Object)rmAppAttemptImpl);
        Mockito.when((Object)app.getAppAttempts()).thenReturn(attempts);
        Mockito.when((Object)rmAppAttemptImpl.getMasterContainer()).thenReturn((Object)container);
        ResourceScheduler rs = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        Mockito.when((Object)rmContext.getScheduler()).thenReturn((Object)rs);
        Mockito.when((Object)rmContext.getScheduler().getRMContainer((ContainerId)Matchers.any(ContainerId.class))).thenReturn((Object)containerimpl);
        SchedulerAppReport sAppReport = (SchedulerAppReport)Mockito.mock(SchedulerAppReport.class);
        Mockito.when((Object)rmContext.getScheduler().getSchedulerAppInfo((ApplicationAttemptId)Matchers.any(ApplicationAttemptId.class))).thenReturn((Object)sAppReport);
        ArrayList<RMContainerImpl> rmContainers = new ArrayList<RMContainerImpl>();
        rmContainers.add(containerimpl);
        Mockito.when((Object)rmContext.getScheduler().getSchedulerAppInfo(attemptId).getLiveContainers()).thenReturn(rmContainers);
        ContainerStatus cs = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)containerimpl.getFinishedStatus()).thenReturn((Object)cs);
        Mockito.when((Object)containerimpl.getDiagnosticsInfo()).thenReturn((Object)"N/A");
        Mockito.when((Object)containerimpl.getContainerExitStatus()).thenReturn((Object)0);
        Mockito.when((Object)containerimpl.getContainerState()).thenReturn((Object)ContainerState.COMPLETE);
        return app;
    }

    private static YarnScheduler mockYarnScheduler() {
        YarnScheduler yarnScheduler = (YarnScheduler)Mockito.mock(YarnScheduler.class);
        Mockito.when((Object)yarnScheduler.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024));
        Mockito.when((Object)yarnScheduler.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)8192));
        Mockito.when((Object)yarnScheduler.getAppsInQueue(QUEUE_1)).thenReturn(Arrays.asList(TestClientRMService.getApplicationAttemptId(101), TestClientRMService.getApplicationAttemptId(102)));
        Mockito.when((Object)yarnScheduler.getAppsInQueue(QUEUE_2)).thenReturn(Arrays.asList(TestClientRMService.getApplicationAttemptId(103)));
        ApplicationAttemptId attemptId = TestClientRMService.getApplicationAttemptId(1);
        Mockito.when((Object)yarnScheduler.getAppResourceUsageReport(attemptId)).thenReturn(null);
        ResourceCalculator rs = (ResourceCalculator)Mockito.mock(ResourceCalculator.class);
        Mockito.when((Object)yarnScheduler.getResourceCalculator()).thenReturn((Object)rs);
        return yarnScheduler;
    }

    @Test
    public void testReservationAPIs() {
        MockNM nm;
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        ReservationSystemTestUtil.setupQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setBoolean("yarn.resourcemanager.reservation-system.enable", true);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        try {
            nm = rm.registerNode("127.0.0.1:1", 102400, 100);
            Thread.sleep(1050L);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        ClientRMService clientService = rm.getClientRMService();
        UTCClock clock = new UTCClock();
        long arrival = clock.getTime();
        long duration = 60000L;
        long deadline = (long)((double)arrival + 1.05 * (double)duration);
        ReservationSubmissionRequest sRequest = ReservationSystemTestUtil.createSimpleReservationRequest(4, arrival, deadline, duration);
        ReservationSubmissionResponse sResponse = null;
        try {
            sResponse = clientService.submitReservation(sRequest);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)sResponse);
        ReservationId reservationID = sResponse.getReservationId();
        Assert.assertNotNull((Object)reservationID);
        LOG.info((Object)("Submit reservation response: " + reservationID));
        ReservationDefinition rDef = sRequest.getReservationDefinition();
        ReservationRequest rr = (ReservationRequest)rDef.getReservationRequests().getReservationResources().get(0);
        rr.setNumContainers(5);
        arrival = clock.getTime();
        duration = 30000L;
        deadline = (long)((double)arrival + 1.05 * (double)duration);
        rr.setDuration(duration);
        rDef.setArrival(arrival);
        rDef.setDeadline(deadline);
        ReservationUpdateRequest uRequest = ReservationUpdateRequest.newInstance((ReservationDefinition)rDef, (ReservationId)reservationID);
        ReservationUpdateResponse uResponse = null;
        try {
            uResponse = clientService.updateReservation(uRequest);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)sResponse);
        LOG.info((Object)("Update reservation response: " + uResponse));
        ReservationListRequest request = ReservationListRequest.newInstance((String)"dedicated", (String)reservationID.toString(), (long)-1L, (long)-1L, (boolean)false);
        ReservationListResponse response = null;
        try {
            response = clientService.listReservations(request);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)response.getReservationAllocationState().size(), (long)1L);
        Assert.assertEquals((long)((ReservationAllocationState)response.getReservationAllocationState().get(0)).getReservationId().getId(), (long)reservationID.getId());
        Assert.assertEquals((long)((ReservationAllocationState)response.getReservationAllocationState().get(0)).getResourceAllocationRequests().size(), (long)0L);
        request = ReservationListRequest.newInstance((String)"dedicated", (String)"", (long)1L, (long)Long.MAX_VALUE, (boolean)true);
        response = null;
        try {
            response = clientService.listReservations(request);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)1L, (long)response.getReservationAllocationState().size());
        Assert.assertEquals((long)((ReservationAllocationState)response.getReservationAllocationState().get(0)).getReservationId().getId(), (long)reservationID.getId());
        request = ReservationListRequest.newInstance((String)"dedicated", (String)"", (long)1L, (long)-1L, (boolean)true);
        response = null;
        try {
            response = clientService.listReservations(request);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)1L, (long)response.getReservationAllocationState().size());
        Assert.assertEquals((long)((ReservationAllocationState)response.getReservationAllocationState().get(0)).getReservationId().getId(), (long)reservationID.getId());
        request = ReservationListRequest.newInstance((String)"dedicated", (String)"", (long)1L, (long)-10L, (boolean)true);
        response = null;
        try {
            response = clientService.listReservations(request);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)1L, (long)response.getReservationAllocationState().size());
        Assert.assertEquals((long)((ReservationAllocationState)response.getReservationAllocationState().get(0)).getReservationId().getId(), (long)reservationID.getId());
        request = ReservationListRequest.newInstance((String)"dedicated", (String)"", (long)(arrival + duration / 2L), (long)(arrival + duration / 2L), (boolean)true);
        response = null;
        try {
            response = clientService.listReservations(request);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)1L, (long)response.getReservationAllocationState().size());
        Assert.assertEquals((long)((ReservationAllocationState)response.getReservationAllocationState().get(0)).getReservationId().getId(), (long)reservationID.getId());
        Assert.assertTrue((((ReservationAllocationState)response.getReservationAllocationState().get(0)).getResourceAllocationRequests().size() > 0 ? 1 : 0) != 0);
        ReservationRequests reservationRequests = ((ReservationAllocationState)response.getReservationAllocationState().get(0)).getReservationDefinition().getReservationRequests();
        Assert.assertTrue((boolean)reservationRequests.getInterpreter().toString().equals("R_ALL"));
        Assert.assertTrue((((ReservationRequest)reservationRequests.getReservationResources().get(0)).getDuration() == duration ? 1 : 0) != 0);
        request = ReservationListRequest.newInstance((String)"dedicated", (String)"", (long)Long.MAX_VALUE, (long)-1L, (boolean)false);
        response = null;
        try {
            response = clientService.listReservations(request);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)0L, (long)response.getReservationAllocationState().size());
        request = ReservationListRequest.newInstance((String)"dedicated", (String)"", (long)(deadline + duration), (long)(deadline + 2L * duration), (boolean)false);
        response = null;
        try {
            response = clientService.listReservations(request);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)response.getReservationAllocationState().size(), (long)0L);
        request = ReservationListRequest.newInstance((String)"dedicated", (String)"", (long)0L, (long)(arrival - duration), (boolean)false);
        response = null;
        try {
            response = clientService.listReservations(request);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)response.getReservationAllocationState().size(), (long)0L);
        request = ReservationListRequest.newInstance((String)"dedicated", (String)"", (long)0L, (long)1L, (boolean)false);
        response = null;
        try {
            response = clientService.listReservations(request);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)response.getReservationAllocationState().size(), (long)0L);
        ReservationDeleteRequest dRequest = ReservationDeleteRequest.newInstance((ReservationId)reservationID);
        ReservationDeleteResponse dResponse = null;
        try {
            dResponse = clientService.deleteReservation(dRequest);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)sResponse);
        LOG.info((Object)("Delete reservation response: " + dResponse));
        request = ReservationListRequest.newInstance((String)"dedicated", (String)reservationID.toString(), (long)-1L, (long)-1L, (boolean)false);
        response = null;
        try {
            response = clientService.listReservations(request);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)0L, (long)response.getReservationAllocationState().size());
        rm.stop();
        nm = null;
        rm = null;
    }

    @Test
    public void testGetNodeLabels() throws Exception {
        MockRM rm = new MockRM(){

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager());
            }
        };
        rm.start();
        NodeLabel labelX = NodeLabel.newInstance((String)"x", (boolean)false);
        NodeLabel labelY = NodeLabel.newInstance((String)"y");
        RMNodeLabelsManager labelsMgr = rm.getRMContext().getNodeLabelManager();
        labelsMgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)labelX, (Object)labelY));
        NodeId node1 = NodeId.newInstance((String)"host1", (int)1234);
        NodeId node2 = NodeId.newInstance((String)"host2", (int)1234);
        HashMap<NodeId, ImmutableSet> map = new HashMap<NodeId, ImmutableSet>();
        map.put(node1, ImmutableSet.of((Object)"x"));
        map.put(node2, ImmutableSet.of((Object)"y"));
        labelsMgr.replaceLabelsOnNode(map);
        Configuration conf = new Configuration();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress rmAddress = rm.getClientRMService().getBindAddress();
        LOG.info((Object)("Connecting to ResourceManager at " + rmAddress));
        ApplicationClientProtocol client = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, rmAddress, conf);
        GetClusterNodeLabelsResponse response = client.getClusterNodeLabels(GetClusterNodeLabelsRequest.newInstance());
        Assert.assertTrue((boolean)response.getNodeLabels().containsAll(Arrays.asList(labelX, labelY)));
        GetNodesToLabelsResponse response1 = client.getNodeToLabels(GetNodesToLabelsRequest.newInstance());
        Map nodeToLabels = response1.getNodeToLabels();
        Assert.assertTrue((boolean)nodeToLabels.keySet().containsAll(Arrays.asList(node1, node2)));
        Assert.assertTrue((boolean)((Set)nodeToLabels.get(node1)).containsAll(Arrays.asList(labelX)));
        Assert.assertTrue((boolean)((Set)nodeToLabels.get(node2)).containsAll(Arrays.asList(labelY)));
        for (NodeLabel x : (Set)nodeToLabels.get(node1)) {
            Assert.assertFalse((boolean)x.isExclusive());
        }
        for (NodeLabel y : (Set)nodeToLabels.get(node2)) {
            Assert.assertTrue((boolean)y.isExclusive());
        }
        Assert.assertFalse((boolean)((Set)nodeToLabels.get(node1)).containsAll(Arrays.asList(NodeLabel.newInstance((String)"x"))));
        rpc.stopProxy((Object)client, conf);
        rm.close();
    }

    @Test
    public void testGetLabelsToNodes() throws Exception {
        MockRM rm = new MockRM(){

            @Override
            protected ClientRMService createClientRMService() {
                return new ClientRMService((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager());
            }
        };
        rm.start();
        NodeLabel labelX = NodeLabel.newInstance((String)"x", (boolean)false);
        NodeLabel labelY = NodeLabel.newInstance((String)"y", (boolean)false);
        NodeLabel labelZ = NodeLabel.newInstance((String)"z", (boolean)false);
        RMNodeLabelsManager labelsMgr = rm.getRMContext().getNodeLabelManager();
        labelsMgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)labelX, (Object)labelY, (Object)labelZ));
        NodeId node1A = NodeId.newInstance((String)"host1", (int)1234);
        NodeId node1B = NodeId.newInstance((String)"host1", (int)5678);
        NodeId node2A = NodeId.newInstance((String)"host2", (int)1234);
        NodeId node3A = NodeId.newInstance((String)"host3", (int)1234);
        NodeId node3B = NodeId.newInstance((String)"host3", (int)5678);
        HashMap<NodeId, ImmutableSet> map = new HashMap<NodeId, ImmutableSet>();
        map.put(node1A, ImmutableSet.of((Object)"x"));
        map.put(node1B, ImmutableSet.of((Object)"z"));
        map.put(node2A, ImmutableSet.of((Object)"y"));
        map.put(node3A, ImmutableSet.of((Object)"y"));
        map.put(node3B, ImmutableSet.of((Object)"z"));
        labelsMgr.replaceLabelsOnNode(map);
        Configuration conf = new Configuration();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress rmAddress = rm.getClientRMService().getBindAddress();
        LOG.info((Object)("Connecting to ResourceManager at " + rmAddress));
        ApplicationClientProtocol client = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, rmAddress, conf);
        GetClusterNodeLabelsResponse response = client.getClusterNodeLabels(GetClusterNodeLabelsRequest.newInstance());
        Assert.assertTrue((boolean)response.getNodeLabels().containsAll(Arrays.asList(labelX, labelY, labelZ)));
        GetLabelsToNodesResponse response1 = client.getLabelsToNodes(GetLabelsToNodesRequest.newInstance());
        Map labelsToNodes = response1.getLabelsToNodes();
        for (Map.Entry nltn : labelsToNodes.entrySet()) {
            Assert.assertFalse((boolean)((NodeLabel)nltn.getKey()).isExclusive());
        }
        Assert.assertTrue((boolean)labelsToNodes.keySet().containsAll(Arrays.asList(labelX, labelY, labelZ)));
        Assert.assertTrue((boolean)((Set)labelsToNodes.get(labelX)).containsAll(Arrays.asList(node1A)));
        Assert.assertTrue((boolean)((Set)labelsToNodes.get(labelY)).containsAll(Arrays.asList(node2A, node3A)));
        Assert.assertTrue((boolean)((Set)labelsToNodes.get(labelZ)).containsAll(Arrays.asList(node1B, node3B)));
        HashSet<String> setlabels = new HashSet<String>(Arrays.asList("x", "z"));
        GetLabelsToNodesResponse response2 = client.getLabelsToNodes(GetLabelsToNodesRequest.newInstance(setlabels));
        labelsToNodes = response2.getLabelsToNodes();
        for (Map.Entry nltn : labelsToNodes.entrySet()) {
            Assert.assertFalse((boolean)((NodeLabel)nltn.getKey()).isExclusive());
        }
        Assert.assertTrue((boolean)labelsToNodes.keySet().containsAll(Arrays.asList(labelX, labelZ)));
        Assert.assertTrue((boolean)((Set)labelsToNodes.get(labelX)).containsAll(Arrays.asList(node1A)));
        Assert.assertTrue((boolean)((Set)labelsToNodes.get(labelZ)).containsAll(Arrays.asList(node1B, node3B)));
        Assert.assertEquals(labelsToNodes.get(labelY), null);
        rpc.stopProxy((Object)client, conf);
        rm.close();
    }

    @Test(timeout=120000L)
    public void testUpdateApplicationPriorityRequest() throws Exception {
        int maxPriority = 10;
        int appPriority = 5;
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.cluster.max-application-priority", maxPriority);
        MockRM rm = new MockRM((Configuration)conf);
        rm.init((Configuration)conf);
        rm.start();
        RMApp app1 = rm.submitApp(1024, Priority.newInstance((int)appPriority));
        Assert.assertEquals((String)"Incorrect priority has been set to application", (long)appPriority, (long)app1.getApplicationSubmissionContext().getPriority().getPriority());
        appPriority = 11;
        ClientRMService rmService = rm.getClientRMService();
        this.testApplicationPriorityUpdation(rmService, app1, appPriority, maxPriority);
        appPriority = 9;
        this.testApplicationPriorityUpdation(rmService, app1, appPriority, appPriority);
        rm.killApp(app1.getApplicationId());
        rm.waitForState(app1.getApplicationId(), RMAppState.KILLED);
        ApplicationId invalidAppId = ApplicationId.newInstance((long)123456789L, (int)3);
        UpdateApplicationPriorityRequest updateRequest = UpdateApplicationPriorityRequest.newInstance((ApplicationId)invalidAppId, (Priority)Priority.newInstance((int)appPriority));
        try {
            rmService.updateApplicationPriority(updateRequest);
            Assert.fail((String)"ApplicationNotFoundException should be thrown for invalid application id");
        }
        catch (ApplicationNotFoundException e) {
            // empty catch block
        }
        updateRequest = UpdateApplicationPriorityRequest.newInstance((ApplicationId)app1.getApplicationId(), (Priority)Priority.newInstance((int)11));
        Assert.assertEquals((String)"Incorrect priority has been set to application", (long)appPriority, (long)rmService.updateApplicationPriority(updateRequest).getApplicationPriority().getPriority());
        rm.stop();
    }

    private void testApplicationPriorityUpdation(ClientRMService rmService, RMApp app1, int tobeUpdatedPriority, int expected) throws YarnException, IOException {
        UpdateApplicationPriorityRequest updateRequest = UpdateApplicationPriorityRequest.newInstance((ApplicationId)app1.getApplicationId(), (Priority)Priority.newInstance((int)tobeUpdatedPriority));
        UpdateApplicationPriorityResponse updateApplicationPriority = rmService.updateApplicationPriority(updateRequest);
        Assert.assertEquals((String)"Incorrect priority has been set to application", (long)expected, (long)app1.getApplicationSubmissionContext().getPriority().getPriority());
        Assert.assertEquals((String)"Incorrect priority has been returned", (long)expected, (long)updateApplicationPriority.getApplicationPriority().getPriority());
    }
}

