/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerPreemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestRMDispatcher {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testSchedulerEventDispatcherForPreemptionEvents() {
        AsyncDispatcher rmDispatcher = new AsyncDispatcher();
        CapacityScheduler sched = (CapacityScheduler)Mockito.spy((Object)new CapacityScheduler());
        YarnConfiguration conf = new YarnConfiguration();
        ResourceManager.SchedulerEventDispatcher schedulerDispatcher = new ResourceManager.SchedulerEventDispatcher((ResourceScheduler)sched);
        rmDispatcher.register(SchedulerEventType.class, (EventHandler)schedulerDispatcher);
        rmDispatcher.init((Configuration)conf);
        rmDispatcher.start();
        schedulerDispatcher.init((Configuration)conf);
        schedulerDispatcher.start();
        try {
            ApplicationAttemptId appAttemptId = (ApplicationAttemptId)Mockito.mock(ApplicationAttemptId.class);
            RMContainer container = (RMContainer)Mockito.mock(RMContainer.class);
            ContainerPreemptEvent event1 = new ContainerPreemptEvent(appAttemptId, container, SchedulerEventType.KILL_RESERVED_CONTAINER);
            rmDispatcher.getEventHandler().handle((Event)event1);
            ContainerPreemptEvent event2 = new ContainerPreemptEvent(appAttemptId, container, SchedulerEventType.MARK_CONTAINER_FOR_KILLABLE);
            rmDispatcher.getEventHandler().handle((Event)event2);
            ContainerPreemptEvent event3 = new ContainerPreemptEvent(appAttemptId, container, SchedulerEventType.MARK_CONTAINER_FOR_PREEMPTION);
            rmDispatcher.getEventHandler().handle((Event)event3);
            Thread.sleep(1000L);
            ((CapacityScheduler)Mockito.verify((Object)sched, (VerificationMode)Mockito.times((int)3))).handle((SchedulerEvent)Mockito.any(SchedulerEvent.class));
            ((CapacityScheduler)Mockito.verify((Object)sched)).killReservedContainer(container);
            ((CapacityScheduler)Mockito.verify((Object)sched)).markContainerForPreemption(appAttemptId, container);
            ((CapacityScheduler)Mockito.verify((Object)sched)).markContainerForKillable(container);
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        finally {
            schedulerDispatcher.stop();
            rmDispatcher.stop();
        }
    }
}

