/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.blacklist;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.yarn.server.resourcemanager.blacklist.BlacklistUpdates;
import org.apache.hadoop.yarn.server.resourcemanager.blacklist.DisabledBlacklistManager;
import org.apache.hadoop.yarn.server.resourcemanager.blacklist.SimpleBlacklistManager;
import org.junit.Assert;
import org.junit.Test;

public class TestBlacklistManager {
    @Test
    public void testSimpleBlacklistBelowFailureThreshold() {
        int numberOfNodeManagerHosts = 3;
        double blacklistDisableFailureThreshold = 0.8;
        SimpleBlacklistManager manager = new SimpleBlacklistManager(3, 0.8);
        String anyNode = "foo";
        String anyNode2 = "bar";
        manager.addNode(anyNode);
        manager.addNode(anyNode2);
        BlacklistUpdates blacklist = manager.getBlacklistUpdates();
        List blacklistAdditions = blacklist.getAdditions();
        Collections.sort(blacklistAdditions);
        List blacklistRemovals = blacklist.getRemovals();
        Object[] expectedBlacklistAdditions = new String[]{anyNode2, anyNode};
        Assert.assertArrayEquals((String)"Blacklist additions was not as expected", (Object[])expectedBlacklistAdditions, (Object[])blacklistAdditions.toArray());
        Assert.assertTrue((String)("Blacklist removals should be empty but was " + blacklistRemovals), (boolean)blacklistRemovals.isEmpty());
    }

    @Test
    public void testSimpleBlacklistAboveFailureThreshold() {
        SimpleBlacklistManager manager = new SimpleBlacklistManager(3, 0.5);
        String anyNode = "foo";
        String anyNode2 = "bar";
        manager.addNode(anyNode);
        BlacklistUpdates blacklist = manager.getBlacklistUpdates();
        List blacklistAdditions = blacklist.getAdditions();
        Collections.sort(blacklistAdditions);
        List blacklistRemovals = blacklist.getRemovals();
        Object[] expectedBlacklistAdditions = new String[]{anyNode};
        Assert.assertArrayEquals((String)"Blacklist additions was not as expected", (Object[])expectedBlacklistAdditions, (Object[])blacklistAdditions.toArray());
        Assert.assertTrue((String)("Blacklist removals should be empty but was " + blacklistRemovals), (boolean)blacklistRemovals.isEmpty());
        manager.addNode(anyNode2);
        blacklist = manager.getBlacklistUpdates();
        blacklistAdditions = blacklist.getAdditions();
        Collections.sort(blacklistAdditions);
        blacklistRemovals = blacklist.getRemovals();
        Collections.sort(blacklistRemovals);
        Object[] expectedBlacklistRemovals = new String[]{anyNode2, anyNode};
        Assert.assertTrue((String)("Blacklist additions should be empty but was " + blacklistAdditions), (boolean)blacklistAdditions.isEmpty());
        Assert.assertArrayEquals((String)"Blacklist removals was not as expected", (Object[])expectedBlacklistRemovals, (Object[])blacklistRemovals.toArray());
    }

    @Test
    public void testDisabledBlacklist() {
        DisabledBlacklistManager disabled = new DisabledBlacklistManager();
        String anyNode = "foo";
        disabled.addNode(anyNode);
        BlacklistUpdates blacklist = disabled.getBlacklistUpdates();
        List blacklistAdditions = blacklist.getAdditions();
        List blacklistRemovals = blacklist.getRemovals();
        Assert.assertTrue((String)("Blacklist additions should be empty but was " + blacklistAdditions), (boolean)blacklistAdditions.isEmpty());
        Assert.assertTrue((String)("Blacklist removals should be empty but was " + blacklistRemovals), (boolean)blacklistRemovals.isEmpty());
    }
}

