/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.metrics;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryServer;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.timeline.MemoryTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineReader;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.recovery.MemoryTimelineStateStore;
import org.apache.hadoop.yarn.server.timeline.recovery.TimelineStateStore;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestSystemMetricsPublisher {
    private static ApplicationHistoryServer timelineServer;
    private static SystemMetricsPublisher metricsPublisher;
    private static TimelineStore store;

    @BeforeClass
    public static void setup() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.enabled", true);
        conf.setBoolean("yarn.resourcemanager.system-metrics-publisher.enabled", true);
        conf.setClass("yarn.timeline-service.store-class", MemoryTimelineStore.class, TimelineStore.class);
        conf.setClass("yarn.timeline-service.state-store-class", MemoryTimelineStateStore.class, TimelineStateStore.class);
        conf.setInt("yarn.resourcemanager.system-metrics-publisher.dispatcher.pool-size", 2);
        timelineServer = new ApplicationHistoryServer();
        timelineServer.init((Configuration)conf);
        timelineServer.start();
        store = timelineServer.getTimelineStore();
        metricsPublisher = new SystemMetricsPublisher();
        metricsPublisher.init((Configuration)conf);
        metricsPublisher.start();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (metricsPublisher != null) {
            metricsPublisher.stop();
        }
        if (timelineServer != null) {
            timelineServer.stop();
        }
    }

    @Test(timeout=10000L)
    public void testPublishApplicationMetrics() throws Exception {
        for (int i = 1; i <= 2; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)0L, (int)i);
            RMApp app = TestSystemMetricsPublisher.createRMApp(appId);
            metricsPublisher.appCreated(app, app.getStartTime());
            if (i == 1) {
                Mockito.when((Object)app.getQueue()).thenReturn((Object)"new test queue");
                ApplicationSubmissionContext asc = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
                Mockito.when((Object)asc.getUnmanagedAM()).thenReturn((Object)false);
                Mockito.when((Object)asc.getPriority()).thenReturn((Object)Priority.newInstance((int)1));
                Mockito.when((Object)asc.getNodeLabelExpression()).thenReturn((Object)"high-cpu");
                Mockito.when((Object)app.getApplicationSubmissionContext()).thenReturn((Object)asc);
                metricsPublisher.appUpdated(app, 4L);
            } else {
                metricsPublisher.appUpdated(app, 4L);
            }
            metricsPublisher.appFinished(app, RMAppState.FINISHED, app.getFinishTime());
            if (i == 1) {
                metricsPublisher.appACLsUpdated(app, "uers1,user2", 4L);
            } else {
                metricsPublisher.appACLsUpdated(app, null, 4L);
            }
            TimelineEntity entity = null;
            while ((entity = store.getEntity(appId.toString(), "YARN_APPLICATION", EnumSet.allOf(TimelineReader.Field.class))) == null || entity.getEvents().size() < 4) {
            }
            Assert.assertEquals((Object)"YARN_APPLICATION", (Object)entity.getEntityType());
            Assert.assertEquals((Object)app.getApplicationId().toString(), (Object)entity.getEntityId());
            Assert.assertEquals((Object)app.getName(), entity.getOtherInfo().get("YARN_APPLICATION_NAME"));
            if (i != 1) {
                Assert.assertEquals((Object)app.getQueue(), entity.getOtherInfo().get("YARN_APPLICATION_QUEUE"));
            }
            Assert.assertEquals((Object)app.getApplicationSubmissionContext().getUnmanagedAM(), entity.getOtherInfo().get("YARN_APPLICATION_UNMANAGED_APPLICATION"));
            if (i != 1) {
                Assert.assertEquals((Object)app.getApplicationSubmissionContext().getPriority().getPriority(), entity.getOtherInfo().get("YARN_APPLICATION_PRIORITY"));
            }
            Assert.assertEquals((Object)app.getAmNodeLabelExpression(), entity.getOtherInfo().get("YARN_AM_NODE_LABEL_EXPRESSION"));
            Assert.assertEquals((Object)app.getApplicationSubmissionContext().getNodeLabelExpression(), entity.getOtherInfo().get("YARN_APP_NODE_LABEL_EXPRESSION"));
            Assert.assertEquals((Object)app.getUser(), entity.getOtherInfo().get("YARN_APPLICATION_USER"));
            Assert.assertEquals((Object)app.getApplicationType(), entity.getOtherInfo().get("YARN_APPLICATION_TYPE"));
            Assert.assertEquals((Object)app.getSubmitTime(), entity.getOtherInfo().get("YARN_APPLICATION_SUBMITTED_TIME"));
            Assert.assertTrue((boolean)TestSystemMetricsPublisher.verifyAppTags(app.getApplicationTags(), entity.getOtherInfo()));
            if (i == 1) {
                Assert.assertEquals((Object)"uers1,user2", entity.getOtherInfo().get("YARN_APPLICATION_VIEW_ACLS"));
            } else {
                Assert.assertEquals((Object)"", entity.getOtherInfo().get("YARN_APPLICATION_VIEW_ACLS"));
                Assert.assertEquals((long)app.getRMAppMetrics().getMemorySeconds(), (long)Long.parseLong(entity.getOtherInfo().get("YARN_APPLICATION_MEM_METRIC").toString()));
                Assert.assertEquals((long)app.getRMAppMetrics().getVcoreSeconds(), (long)Long.parseLong(entity.getOtherInfo().get("YARN_APPLICATION_CPU_METRIC").toString()));
            }
            Assert.assertEquals((Object)"context", entity.getOtherInfo().get("YARN_APPLICATION_CALLER_CONTEXT"));
            boolean hasCreatedEvent = false;
            boolean hasUpdatedEvent = false;
            boolean hasFinishedEvent = false;
            boolean hasACLsUpdatedEvent = false;
            for (TimelineEvent event : entity.getEvents()) {
                if (event.getEventType().equals("YARN_APPLICATION_CREATED")) {
                    hasCreatedEvent = true;
                    Assert.assertEquals((long)app.getStartTime(), (long)event.getTimestamp());
                    continue;
                }
                if (event.getEventType().equals("YARN_APPLICATION_FINISHED")) {
                    hasFinishedEvent = true;
                    Assert.assertEquals((long)app.getFinishTime(), (long)event.getTimestamp());
                    Assert.assertEquals((Object)app.getDiagnostics().toString(), event.getEventInfo().get("YARN_APPLICATION_DIAGNOSTICS_INFO"));
                    Assert.assertEquals((Object)app.getFinalApplicationStatus().toString(), event.getEventInfo().get("YARN_APPLICATION_FINAL_STATUS"));
                    Assert.assertEquals((Object)YarnApplicationState.FINISHED.toString(), event.getEventInfo().get("YARN_APPLICATION_STATE"));
                    continue;
                }
                if (event.getEventType().equals("YARN_APPLICATION_UPDATED")) {
                    hasUpdatedEvent = true;
                    Assert.assertEquals((long)4L, (long)event.getTimestamp());
                    if (1 != i) continue;
                    Assert.assertEquals((Object)1, event.getEventInfo().get("YARN_APPLICATION_PRIORITY"));
                    Assert.assertEquals((Object)"new test queue", event.getEventInfo().get("YARN_APPLICATION_QUEUE"));
                    continue;
                }
                if (!event.getEventType().equals("YARN_APPLICATION_ACLS_UPDATED")) continue;
                hasACLsUpdatedEvent = true;
                Assert.assertEquals((long)4L, (long)event.getTimestamp());
            }
            Assert.assertTrue((hasCreatedEvent && hasFinishedEvent && hasACLsUpdatedEvent && hasUpdatedEvent ? 1 : 0) != 0);
        }
    }

    @Test(timeout=10000L)
    public void testPublishAppAttemptMetricsForUnmanagedAM() throws Exception {
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        RMAppAttempt appAttempt = TestSystemMetricsPublisher.createRMAppAttempt(appAttemptId, true);
        metricsPublisher.appAttemptRegistered(appAttempt, 0x80000000L);
        RMApp app = (RMApp)Mockito.mock(RMApp.class);
        Mockito.when((Object)app.getFinalApplicationStatus()).thenReturn((Object)FinalApplicationStatus.UNDEFINED);
        metricsPublisher.appAttemptFinished(appAttempt, RMAppAttemptState.FINISHED, app, 0x80000001L);
        TimelineEntity entity = null;
        while ((entity = store.getEntity(appAttemptId.toString(), "YARN_APPLICATION_ATTEMPT", EnumSet.allOf(TimelineReader.Field.class))) == null || entity.getEvents().size() < 2) {
        }
    }

    @Test(timeout=10000L)
    public void testPublishAppAttemptMetrics() throws Exception {
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1);
        RMAppAttempt appAttempt = TestSystemMetricsPublisher.createRMAppAttempt(appAttemptId, false);
        metricsPublisher.appAttemptRegistered(appAttempt, 0x80000000L);
        RMApp app = (RMApp)Mockito.mock(RMApp.class);
        Mockito.when((Object)app.getFinalApplicationStatus()).thenReturn((Object)FinalApplicationStatus.UNDEFINED);
        metricsPublisher.appAttemptFinished(appAttempt, RMAppAttemptState.FINISHED, app, 0x80000001L);
        TimelineEntity entity = null;
        while ((entity = store.getEntity(appAttemptId.toString(), "YARN_APPLICATION_ATTEMPT", EnumSet.allOf(TimelineReader.Field.class))) == null || entity.getEvents().size() < 2) {
        }
        Assert.assertEquals((Object)"YARN_APPLICATION_ATTEMPT", (Object)entity.getEntityType());
        Assert.assertEquals((Object)appAttemptId.toString(), (Object)entity.getEntityId());
        Assert.assertEquals((Object)appAttemptId.getApplicationId().toString(), ((Set)entity.getPrimaryFilters().get("YARN_APPLICATION_ATTEMPT_PARENT")).iterator().next());
        boolean hasRegisteredEvent = false;
        boolean hasFinishedEvent = false;
        for (TimelineEvent event : entity.getEvents()) {
            if (event.getEventType().equals("YARN_APPLICATION_ATTEMPT_REGISTERED")) {
                hasRegisteredEvent = true;
                Assert.assertEquals((Object)appAttempt.getHost(), event.getEventInfo().get("YARN_APPLICATION_ATTEMPT_HOST"));
                Assert.assertEquals((Object)appAttempt.getRpcPort(), event.getEventInfo().get("YARN_APPLICATION_ATTEMPT_RPC_PORT"));
                Assert.assertEquals((Object)appAttempt.getMasterContainer().getId().toString(), event.getEventInfo().get("YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER"));
                continue;
            }
            if (!event.getEventType().equals("YARN_APPLICATION_ATTEMPT_FINISHED")) continue;
            hasFinishedEvent = true;
            Assert.assertEquals((Object)appAttempt.getDiagnostics(), event.getEventInfo().get("YARN_APPLICATION_ATTEMPT_DIAGNOSTICS_INFO"));
            Assert.assertEquals((Object)appAttempt.getTrackingUrl(), event.getEventInfo().get("YARN_APPLICATION_ATTEMPT_TRACKING_URL"));
            Assert.assertEquals((Object)appAttempt.getOriginalTrackingUrl(), event.getEventInfo().get("YARN_APPLICATION_ATTEMPT_ORIGINAL_TRACKING_URL"));
            Assert.assertEquals((Object)FinalApplicationStatus.UNDEFINED.toString(), event.getEventInfo().get("YARN_APPLICATION_ATTEMPT_FINAL_STATUS"));
            Assert.assertEquals((Object)YarnApplicationAttemptState.FINISHED.toString(), event.getEventInfo().get("YARN_APPLICATION_ATTEMPT_STATE"));
        }
        Assert.assertTrue((hasRegisteredEvent && hasFinishedEvent ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testPublishContainerMetrics() throws Exception {
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (long)1L);
        RMContainer container = TestSystemMetricsPublisher.createRMContainer(containerId);
        metricsPublisher.containerCreated(container, container.getCreationTime());
        metricsPublisher.containerFinished(container, container.getFinishTime());
        TimelineEntity entity = null;
        while ((entity = store.getEntity(containerId.toString(), "YARN_CONTAINER", EnumSet.allOf(TimelineReader.Field.class))) == null || entity.getEvents().size() < 2) {
        }
        Assert.assertEquals((Object)"YARN_CONTAINER", (Object)entity.getEntityType());
        Assert.assertEquals((Object)containerId.toString(), (Object)entity.getEntityId());
        Assert.assertEquals((Object)containerId.getApplicationAttemptId().toString(), ((Set)entity.getPrimaryFilters().get("YARN_CONTAINER_PARENT")).iterator().next());
        Assert.assertEquals((Object)container.getAllocatedNode().getHost(), entity.getOtherInfo().get("YARN_CONTAINER_ALLOCATED_HOST"));
        Assert.assertEquals((Object)container.getAllocatedNode().getPort(), entity.getOtherInfo().get("YARN_CONTAINER_ALLOCATED_PORT"));
        Assert.assertEquals((Object)container.getAllocatedResource().getMemory(), entity.getOtherInfo().get("YARN_CONTAINER_ALLOCATED_MEMORY"));
        Assert.assertEquals((Object)container.getAllocatedResource().getVirtualCores(), entity.getOtherInfo().get("YARN_CONTAINER_ALLOCATED_VCORE"));
        Assert.assertEquals((Object)container.getAllocatedPriority().getPriority(), entity.getOtherInfo().get("YARN_CONTAINER_ALLOCATED_PRIORITY"));
        boolean hasCreatedEvent = false;
        boolean hasFinishedEvent = false;
        for (TimelineEvent event : entity.getEvents()) {
            if (event.getEventType().equals("YARN_CONTAINER_CREATED")) {
                hasCreatedEvent = true;
                Assert.assertEquals((long)container.getCreationTime(), (long)event.getTimestamp());
                continue;
            }
            if (!event.getEventType().equals("YARN_CONTAINER_FINISHED")) continue;
            hasFinishedEvent = true;
            Assert.assertEquals((long)container.getFinishTime(), (long)event.getTimestamp());
            Assert.assertEquals((Object)container.getDiagnosticsInfo(), event.getEventInfo().get("YARN_CONTAINER_DIAGNOSTICS_INFO"));
            Assert.assertEquals((Object)container.getContainerExitStatus(), event.getEventInfo().get("YARN_CONTAINER_EXIT_STATUS"));
            Assert.assertEquals((Object)container.getContainerState().toString(), event.getEventInfo().get("YARN_CONTAINER_STATE"));
        }
        Assert.assertTrue((hasCreatedEvent && hasFinishedEvent ? 1 : 0) != 0);
    }

    private static RMApp createRMApp(ApplicationId appId) {
        RMApp app = (RMApp)Mockito.mock(RMAppImpl.class);
        Mockito.when((Object)app.getApplicationId()).thenReturn((Object)appId);
        Mockito.when((Object)app.getName()).thenReturn((Object)"test app");
        Mockito.when((Object)app.getApplicationType()).thenReturn((Object)"test app type");
        Mockito.when((Object)app.getUser()).thenReturn((Object)"test user");
        Mockito.when((Object)app.getQueue()).thenReturn((Object)"test queue");
        Mockito.when((Object)app.getSubmitTime()).thenReturn((Object)0x80000000L);
        Mockito.when((Object)app.getStartTime()).thenReturn((Object)0x80000001L);
        Mockito.when((Object)app.getFinishTime()).thenReturn((Object)0x80000002L);
        Mockito.when((Object)app.getDiagnostics()).thenReturn((Object)new StringBuilder("test diagnostics info"));
        RMAppAttempt appAttempt = (RMAppAttempt)Mockito.mock(RMAppAttempt.class);
        Mockito.when((Object)appAttempt.getAppAttemptId()).thenReturn((Object)ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1));
        Mockito.when((Object)app.getCurrentAppAttempt()).thenReturn((Object)appAttempt);
        Mockito.when((Object)app.getFinalApplicationStatus()).thenReturn((Object)FinalApplicationStatus.UNDEFINED);
        Mockito.when((Object)app.getRMAppMetrics()).thenReturn((Object)new RMAppMetrics(null, 0, 0, Integer.MAX_VALUE, Long.MAX_VALUE));
        HashSet<String> appTags = new HashSet<String>();
        appTags.add("test");
        appTags.add("tags");
        Mockito.when((Object)app.getApplicationTags()).thenReturn(appTags);
        ApplicationSubmissionContext asc = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        Mockito.when((Object)asc.getUnmanagedAM()).thenReturn((Object)false);
        Mockito.when((Object)asc.getPriority()).thenReturn((Object)Priority.newInstance((int)10));
        Mockito.when((Object)asc.getNodeLabelExpression()).thenReturn((Object)"high-cpu");
        Mockito.when((Object)app.getApplicationSubmissionContext()).thenReturn((Object)asc);
        Mockito.when((Object)app.getAppNodeLabelExpression()).thenCallRealMethod();
        ResourceRequest amReq = (ResourceRequest)Mockito.mock(ResourceRequest.class);
        Mockito.when((Object)amReq.getNodeLabelExpression()).thenReturn((Object)"high-mem");
        Mockito.when((Object)app.getAMResourceRequest()).thenReturn((Object)amReq);
        Mockito.when((Object)app.getAmNodeLabelExpression()).thenCallRealMethod();
        Mockito.when((Object)app.getCallerContext()).thenReturn((Object)new CallerContext.Builder("context").build());
        return app;
    }

    private static RMAppAttempt createRMAppAttempt(ApplicationAttemptId appAttemptId, boolean unmanagedAMAttempt) {
        RMAppAttempt appAttempt = (RMAppAttempt)Mockito.mock(RMAppAttempt.class);
        Mockito.when((Object)appAttempt.getAppAttemptId()).thenReturn((Object)appAttemptId);
        Mockito.when((Object)appAttempt.getHost()).thenReturn((Object)"test host");
        Mockito.when((Object)appAttempt.getRpcPort()).thenReturn((Object)-100);
        if (!unmanagedAMAttempt) {
            Container container = (Container)Mockito.mock(Container.class);
            Mockito.when((Object)container.getId()).thenReturn((Object)ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L));
            Mockito.when((Object)appAttempt.getMasterContainer()).thenReturn((Object)container);
        }
        Mockito.when((Object)appAttempt.getDiagnostics()).thenReturn((Object)"test diagnostics info");
        Mockito.when((Object)appAttempt.getTrackingUrl()).thenReturn((Object)"test tracking url");
        Mockito.when((Object)appAttempt.getOriginalTrackingUrl()).thenReturn((Object)"test original tracking url");
        return appAttempt;
    }

    private static RMContainer createRMContainer(ContainerId containerId) {
        RMContainer container = (RMContainer)Mockito.mock(RMContainer.class);
        Mockito.when((Object)container.getContainerId()).thenReturn((Object)containerId);
        Mockito.when((Object)container.getAllocatedNode()).thenReturn((Object)NodeId.newInstance((String)"test host", (int)-100));
        Mockito.when((Object)container.getAllocatedResource()).thenReturn((Object)Resource.newInstance((int)-1, (int)-1));
        Mockito.when((Object)container.getAllocatedPriority()).thenReturn((Object)Priority.UNDEFINED);
        Mockito.when((Object)container.getCreationTime()).thenReturn((Object)0x80000000L);
        Mockito.when((Object)container.getFinishTime()).thenReturn((Object)0x80000001L);
        Mockito.when((Object)container.getDiagnosticsInfo()).thenReturn((Object)"test diagnostics info");
        Mockito.when((Object)container.getContainerExitStatus()).thenReturn((Object)-1);
        Mockito.when((Object)container.getContainerState()).thenReturn((Object)ContainerState.COMPLETE);
        Container mockContainer = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getContainer()).thenReturn((Object)mockContainer);
        Mockito.when((Object)mockContainer.getNodeHttpAddress()).thenReturn((Object)"http://localhost:1234");
        return container;
    }

    private static boolean verifyAppTags(Set<String> appTags, Map<String, Object> entityInfo) {
        if (!entityInfo.containsKey("YARN_APPLICATION_TAGS")) {
            return false;
        }
        Object obj = entityInfo.get("YARN_APPLICATION_TAGS");
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            if (collection.size() != appTags.size()) {
                return false;
            }
            for (String appTag : appTags) {
                boolean match = false;
                for (Object o : collection) {
                    if (!o.toString().equals(appTag)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

