/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TestProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.PreemptionManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.OrderingPolicy;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestProportionalCapacityPreemptionPolicyForNodePartitions {
    private static final Log LOG = LogFactory.getLog(TestProportionalCapacityPreemptionPolicyForNodePartitions.class);
    static final String ROOT = "root";
    private Map<String, CSQueue> nameToCSQueues = null;
    private Map<String, Resource> partitionToResource = null;
    private Map<NodeId, SchedulerNode> nodeIdToSchedulerNodes = null;
    private RMNodeLabelsManager nlm = null;
    private RMContext rmContext = null;
    private ResourceCalculator rc = new DefaultResourceCalculator();
    private Clock mClock = null;
    private Configuration conf = null;
    private CapacitySchedulerConfiguration csConf = null;
    private CapacityScheduler cs = null;
    private EventHandler<SchedulerEvent> mDisp = null;
    private ProportionalCapacityPreemptionPolicy policy = null;
    private Resource clusterResource = null;

    @Before
    public void setup() {
        Logger.getRootLogger().setLevel(Level.DEBUG);
        this.conf = new Configuration(false);
        this.conf.setLong("yarn.resourcemanager.monitor.capacity.preemption.max_wait_before_kill", 10000L);
        this.conf.setLong("yarn.resourcemanager.monitor.capacity.preemption.monitoring_interval", 3000L);
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.total_preemption_per_round", 1.0f);
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.natural_termination_factor", 1.0f);
        this.conf.set("yarn.resourcemanager.scheduler.monitor.policies", ProportionalCapacityPreemptionPolicy.class.getCanonicalName());
        this.conf.setBoolean("yarn.resourcemanager.scheduler.monitor.enable", true);
        this.conf.set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getName());
        this.mClock = (Clock)Mockito.mock(Clock.class);
        this.cs = (CapacityScheduler)Mockito.mock(CapacityScheduler.class);
        Mockito.when((Object)this.cs.getResourceCalculator()).thenReturn((Object)this.rc);
        Mockito.when((Object)this.cs.getPreemptionManager()).thenReturn((Object)new PreemptionManager());
        this.nlm = (RMNodeLabelsManager)Mockito.mock(RMNodeLabelsManager.class);
        this.mDisp = (EventHandler)Mockito.mock(EventHandler.class);
        this.rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)this.rmContext.getNodeLabelManager()).thenReturn((Object)this.nlm);
        Dispatcher disp = (Dispatcher)Mockito.mock(Dispatcher.class);
        Mockito.when((Object)this.rmContext.getDispatcher()).thenReturn((Object)disp);
        Mockito.when((Object)disp.getEventHandler()).thenReturn(this.mDisp);
        this.csConf = new CapacitySchedulerConfiguration();
        Mockito.when((Object)this.cs.getConfiguration()).thenReturn((Object)this.csConf);
        Mockito.when((Object)this.cs.getRMContext()).thenReturn((Object)this.rmContext);
        this.policy = new ProportionalCapacityPreemptionPolicy(this.conf, this.rmContext, this.cs, this.mClock);
        this.partitionToResource = new HashMap<String, Resource>();
        this.nodeIdToSchedulerNodes = new HashMap<NodeId, SchedulerNode>();
        this.nameToCSQueues = new HashMap<String, CSQueue>();
    }

    @Test
    public void testBuilder() throws Exception {
        String labelsConfig = "=200,true;red=100,false;blue=200,true";
        String nodesConfig = "n1=red;n2=blue;n3=";
        String queuesConfig = "root(=[200 200 100 100],red=[100 100 100 100],blue=[200 200 200 200]);-a(=[100 200 100 100],red=[0 0 0 0],blue=[200 200 200 200]);--a1(=[50 100 50 100],red=[0 0 0 0],blue=[100 200 200 0]);--a2(=[50 200 50 0],red=[0 0 0 0],blue=[100 200 0 200]);-b(=[100 200 0 0],red=[100 100 100 100],blue=[0 0 0 0])";
        String appsConfig = "a1\t(1,1,n3,red,50,false);a1\t(2,1,n2,,50,true)(2,1,n2,,50,false)(2,1,n2,blue,50,true)(2,1,n2,blue,50,true);a2\t(1,1,n3,red,50,false);b\t(1,1,n1,red,100,false);";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.checkAbsCapacities(this.cs.getQueue(ROOT), "", 1.0f, 1.0f, 0.5f);
        this.checkPendingResource(this.cs.getQueue(ROOT), "", 100);
        this.checkAbsCapacities(this.cs.getQueue(ROOT), "red", 1.0f, 1.0f, 1.0f);
        this.checkPendingResource(this.cs.getQueue(ROOT), "red", 100);
        this.checkAbsCapacities(this.cs.getQueue(ROOT), "blue", 1.0f, 1.0f, 1.0f);
        this.checkPendingResource(this.cs.getQueue(ROOT), "blue", 200);
        this.checkAbsCapacities(this.cs.getQueue("a"), "", 0.5f, 1.0f, 0.5f);
        this.checkPendingResource(this.cs.getQueue("a"), "", 100);
        this.checkAbsCapacities(this.cs.getQueue("a"), "red", 0.0f, 0.0f, 0.0f);
        this.checkPendingResource(this.cs.getQueue("a"), "red", 0);
        this.checkAbsCapacities(this.cs.getQueue("a"), "blue", 1.0f, 1.0f, 1.0f);
        this.checkPendingResource(this.cs.getQueue("a"), "blue", 200);
        this.checkAbsCapacities(this.cs.getQueue("a1"), "", 0.25f, 0.5f, 0.25f);
        this.checkPendingResource(this.cs.getQueue("a1"), "", 100);
        this.checkAbsCapacities(this.cs.getQueue("a1"), "red", 0.0f, 0.0f, 0.0f);
        this.checkPendingResource(this.cs.getQueue("a1"), "red", 0);
        this.checkAbsCapacities(this.cs.getQueue("a1"), "blue", 0.5f, 1.0f, 1.0f);
        this.checkPendingResource(this.cs.getQueue("a1"), "blue", 0);
        this.checkAbsCapacities(this.cs.getQueue("a2"), "", 0.25f, 1.0f, 0.25f);
        this.checkPendingResource(this.cs.getQueue("a2"), "", 0);
        this.checkAbsCapacities(this.cs.getQueue("a2"), "red", 0.0f, 0.0f, 0.0f);
        this.checkPendingResource(this.cs.getQueue("a2"), "red", 0);
        this.checkAbsCapacities(this.cs.getQueue("a2"), "blue", 0.5f, 1.0f, 0.0f);
        this.checkPendingResource(this.cs.getQueue("a2"), "blue", 200);
        this.checkAbsCapacities(this.cs.getQueue("b"), "", 0.5f, 1.0f, 0.0f);
        this.checkPendingResource(this.cs.getQueue("b"), "", 0);
        this.checkAbsCapacities(this.cs.getQueue("b"), "red", 1.0f, 1.0f, 1.0f);
        this.checkPendingResource(this.cs.getQueue("b"), "red", 100);
        this.checkAbsCapacities(this.cs.getQueue("b"), "blue", 0.0f, 0.0f, 0.0f);
        this.checkPendingResource(this.cs.getQueue("b"), "blue", 0);
        Assert.assertEquals((long)100L, (long)((TreeSet)((LeafQueue)this.cs.getQueue("a1")).getIgnoreExclusivityRMContainers().get("blue")).size());
        Assert.assertEquals((long)2L, (long)((LeafQueue)this.cs.getQueue("a1")).getApplications().size());
        Assert.assertEquals((long)1L, (long)((LeafQueue)this.cs.getQueue("a2")).getApplications().size());
        Assert.assertEquals((long)1L, (long)((LeafQueue)this.cs.getQueue("b")).getApplications().size());
        FiCaSchedulerApp app1 = this.getApp("a1", 1);
        FiCaSchedulerApp app2 = this.getApp("a1", 2);
        FiCaSchedulerApp app3 = this.getApp("a2", 3);
        FiCaSchedulerApp app4 = this.getApp("b", 4);
        Assert.assertEquals((long)50L, (long)app1.getLiveContainers().size());
        this.checkContainerNodesInApp(app1, 50, "n3");
        Assert.assertEquals((long)50L, (long)app2.getLiveContainers().size());
        Assert.assertEquals((long)150L, (long)app2.getReservedContainers().size());
        this.checkContainerNodesInApp(app2, 200, "n2");
        Assert.assertEquals((long)50L, (long)app3.getLiveContainers().size());
        this.checkContainerNodesInApp(app3, 50, "n3");
        Assert.assertEquals((long)100L, (long)app4.getLiveContainers().size());
        this.checkContainerNodesInApp(app4, 100, "n1");
    }

    @Test
    public void testNodePartitionPreemptionRespectGuaranteedCapacity() throws IOException {
        String labelsConfig = "=100,true;x=100,true";
        String nodesConfig = "n1=x;n2=";
        String queuesConfig = "root(=[100 100 100 100],x=[100 100 100 100]);-a(=[50 100 20 50],x=[50 100 80 50]);-b(=[50 100 80 50],x=[50 100 20 50])";
        String appsConfig = "a\t(1,1,n1,x,80,false);a\t(1,1,n2,,20,false);b\t(1,1,n1,x,20,false);b\t(1,1,n2,,80,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)30))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)30))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }

    @Test
    public void testNodePartitionPreemptionRespectMaximumCapacity() throws IOException {
        String labelsConfig = "=100,true;x=100,true";
        String nodesConfig = "n1=x;n2=";
        String queuesConfig = "root(=[100 100 100 100],x=[100 100 100 100]);-a(=[80 80 0 0],x=[80 80 0 0]);-b(=[10 100 0 0],x=[10 100 90 50]);-c(=[10 100 0 0],x=[10 30 10 50])";
        String appsConfig = "b\t(1,1,n1,x,90,false);c\t(1,1,n1,x,10,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)20))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }

    @Test
    public void testNodePartitionPreemptionOfIgnoreExclusivityAndRespectCapacity() throws IOException {
        String labelsConfig = "=100,true;x=100,false";
        String nodesConfig = "n1=x;n2=";
        String queuesConfig = "root(=[100 100 100 100],x=[100 100 100 100]);-a(=[50 100 0 0],x=[50 100 100 50]);-b(=[50 100 0 0],x=[50 100 0 100])";
        String appsConfig = "a\t(1,1,n1,x,1,false)(1,1,n1,,20,false);a\t(1,1,n1,x,79,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)20))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)30))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }

    @Test
    public void testNodePartitionPreemptionOfSkippingAMContainer() throws IOException {
        String labelsConfig = "=100,true;x=100,true";
        String nodesConfig = "n1=x;n2=";
        String queuesConfig = "root(=[100 100 100 100],x=[100 100 100 100]);-a(=[50 100 0 0],x=[20 100 100 50]);-b(=[50 100 0 0],x=[80 100 0 100])";
        String appsConfig = "a\t(1,1,n1,x,20,false);a\t(1,1,n1,x,20,false);a\t(1,1,n1,x,20,false);a\t(1,1,n1,x,20,false);a\t(1,1,n1,x,20,false);";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)4))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)19))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)19))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)19))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)19))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(5))));
    }

    @Test
    public void testNodePartitionPreemptionOfAMContainer() throws IOException {
        String labelsConfig = "=100,true;x=100,true";
        String nodesConfig = "n1=x;n2=";
        String queuesConfig = "root(=[100 100 100 100],x=[100 100 100 100]);-a(=[50 100 0 0],x=[3 100 100 50]);-b(=[50 100 0 0],x=[97 100 0 100])";
        String appsConfig = "a\t(1,1,n1,x,20,false);a\t(1,1,n1,x,20,false);a\t(1,1,n1,x,20,false);a\t(1,1,n1,x,20,false);a\t(1,1,n1,x,20,false);";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)19))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)19))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)19))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)20))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)20))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(5))));
    }

    @Test
    public void testNodePartitionDisablePreemptionForSingleLevelQueue() throws IOException {
        String labelsConfig = "=100,true;x=100,true";
        String nodesConfig = "n1=x;n2=";
        String queuesConfig = "root(=[100 100 100 100],x=[100 100 100 100]);-a(=[80 80 0 0],x=[40 100 50 50]);-b(=[10 100 0 0],x=[20 100 30 0]);-c(=[10 100 0 0],x=[40 100 20 50])";
        String appsConfig = "a\t(1,1,n1,x,50,false);b\t(1,1,n1,x,30,false);c\t(1,1,n1,x,20,false)";
        this.csConf.setPreemptionDisabled("root.b", true);
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }

    @Test
    public void testNodePartitionNonAccessibleQueuesSharePartitionedResource() throws IOException {
        String labelsConfig = "=100,true;x=100,false";
        String nodesConfig = "n1=x;n2=";
        String queuesConfig = "root(=[100 100 100 100],x=[100 100 100 100]);-a(=[25 100 0 0],x=[50 100 0 30]);-b(=[25 100 0 0],x=[50 100 30 0]);-c(=[25 100 1 0],x=[0 0 35 50]);-d(=[25 100 1 0],x=[0 0 35 50])";
        String appsConfig = "b\t(1,1,n1,x,30,false);c\t(1,1,n2,,1,false)(1,1,n1,,30,false);d\t(1,1,n2,,1,false)(1,1,n1,,30,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)15))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)15))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
    }

    @Test
    public void testHierarchyPreemptionForMultiplePartitions() throws IOException {
        String labelsConfig = "=100,true;x=100,true;y=100,true";
        String nodesConfig = "n1=x;n2=y;n3=";
        String queuesConfig = "root(=[100 100 0 0],x=[100 100 100 100],y=[100 100 100 100]);-a(=[50 100 0 0],x=[50 100 60 40],y=[50 100 40 40]);--a1(=[25 100 0 0],x=[25 100 35 20],y=[25 100 25 20]);--a2(=[25 100 0 0],x=[25 100 25 20],y=[25 100 15 20]);-b(=[50 100 0 0],x=[50 100 40 40],y=[50 100 60 40]);--b1(=[25 100 0 0],x=[25 100 15 20],y=[25 100 25 20]);--b2(=[25 100 0 0],x=[25 100 25 20],y=[25 100 35 20])";
        String appsConfig = "a1\t(1,1,n1,x,35,false)(1,1,n2,y,25,false);a2\t(1,1,n1,x,25,false)(1,1,n2,y,15,false);b1\t(1,1,n1,x,15,false)(1,1,n2,y,25,false);b2\t(1,1,n1,x,25,false)(1,1,n2,y,35,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }

    @Test
    public void testHierarchyPreemptionForDifferenceAcessibility() throws IOException {
        String labelsConfig = "=100,true;x=100,true;y=100,true";
        String nodesConfig = "n1=x;n2=y;n3=";
        String queuesConfig = "root(=[100 100 0 0],x=[100 100 100 100],y=[100 100 100 100]);-a(=[50 100 0 0],x=[100 100 100 100]);--a1(=[25 100 0 0],x=[50 100 100 0]);--a2(=[25 100 0 0],x=[50 100 0 100]);-b(=[50 100 0 0],y=[100 100 80 100]);--b1(=[25 100 0 0],y=[50 100 80 0]);--b2(=[25 100 0 0],y=[50 100 0 100])";
        String appsConfig = "a1\t(1,1,n1,x,100,false);b1\t(1,1,n2,y,80,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)50))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)30))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
    }

    @Test
    public void testNodePartitionPreemptionWithVCoreResource() throws IOException {
        String labelsConfig = "=100:200,true;x=100:200,true";
        String nodesConfig = "n1=x;n2=";
        String queuesConfig = "root(=[100:200 100:200 100:200 100:200],x=[100:200 100:200 100:200 100:200]);-a(=[50:100 100:200 20:40 50:100],x=[50:100 100:200 80:160 50:100]);-b(=[50:100 100:200 80:160 50:100],x=[50:100 100:200 20:40 50:100])";
        String appsConfig = "a\t(1,1:2,n1,x,80,false);a\t(1,1:2,n2,,20,false);b\t(1,1:2,n1,x,20,false);b\t(1,1:2,n2,,80,false)";
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig, true);
        this.policy.editSchedule();
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)30))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(1))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.times((int)30))).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(4))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(2))));
        ((EventHandler)Mockito.verify(this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Matchers.argThat((Matcher)new TestProportionalCapacityPreemptionPolicy.IsPreemptionRequestFor(this.getAppAttemptId(3))));
    }

    private ApplicationAttemptId getAppAttemptId(int id) {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)id);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        return appAttemptId;
    }

    private void checkContainerNodesInApp(FiCaSchedulerApp app, int expectedContainersNumber, String host) {
        NodeId nodeId = NodeId.newInstance((String)host, (int)1);
        int num = 0;
        for (RMContainer c : app.getLiveContainers()) {
            if (!c.getAllocatedNode().equals((Object)nodeId)) continue;
            ++num;
        }
        for (RMContainer c : app.getReservedContainers()) {
            if (!c.getAllocatedNode().equals((Object)nodeId)) continue;
            ++num;
        }
        Assert.assertEquals((long)expectedContainersNumber, (long)num);
    }

    private FiCaSchedulerApp getApp(String queueName, int appId) {
        for (FiCaSchedulerApp app : ((LeafQueue)this.cs.getQueue(queueName)).getApplications()) {
            if (app.getApplicationId().getId() != appId) continue;
            return app;
        }
        return null;
    }

    private void checkAbsCapacities(CSQueue queue, String partition, float guaranteed, float max, float used) {
        QueueCapacities qc = queue.getQueueCapacities();
        Assert.assertEquals((double)guaranteed, (double)qc.getAbsoluteCapacity(partition), (double)0.001);
        Assert.assertEquals((double)max, (double)qc.getAbsoluteMaximumCapacity(partition), (double)0.001);
        Assert.assertEquals((double)used, (double)qc.getAbsoluteUsedCapacity(partition), (double)0.001);
    }

    private void checkPendingResource(CSQueue queue, String partition, int pending) {
        ResourceUsage ru = queue.getQueueResourceUsage();
        Assert.assertEquals((long)pending, (long)ru.getPending(partition).getMemory());
    }

    private void buildEnv(String labelsConfig, String nodesConfig, String queuesConfig, String appsConfig) throws IOException {
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig, false);
    }

    private void buildEnv(String labelsConfig, String nodesConfig, String queuesConfig, String appsConfig, boolean useDominantResourceCalculator) throws IOException {
        if (useDominantResourceCalculator) {
            Mockito.when((Object)this.cs.getResourceCalculator()).thenReturn((Object)new DominantResourceCalculator());
        }
        this.mockNodeLabelsManager(labelsConfig);
        this.mockSchedulerNodes(nodesConfig);
        for (NodeId nodeId : this.nodeIdToSchedulerNodes.keySet()) {
            Mockito.when((Object)this.cs.getSchedulerNode(nodeId)).thenReturn((Object)this.nodeIdToSchedulerNodes.get(nodeId));
        }
        ParentQueue root = this.mockQueueHierarchy(queuesConfig);
        Mockito.when((Object)this.cs.getRootQueue()).thenReturn((Object)root);
        Mockito.when((Object)this.cs.getClusterResource()).thenReturn((Object)this.clusterResource);
        this.mockApplications(appsConfig);
        this.policy = new ProportionalCapacityPreemptionPolicy(this.conf, this.rmContext, this.cs, this.mClock);
    }

    private void mockContainers(String containersConfig, ApplicationAttemptId attemptId, String queueName, List<RMContainer> reservedContainers, List<RMContainer> liveContainers) {
        int containerId = 1;
        int start = containersConfig.indexOf("=") + 1;
        int end = -1;
        while (start < containersConfig.length()) {
            while (start < containersConfig.length() && containersConfig.charAt(start) != '(') {
                ++start;
            }
            if (start >= containersConfig.length()) {
                throw new IllegalArgumentException("Error containers specification, line=" + containersConfig);
            }
            for (end = start + 1; end < containersConfig.length() && containersConfig.charAt(end) != ')'; ++end) {
            }
            if (end >= containersConfig.length()) {
                throw new IllegalArgumentException("Error containers specification, line=" + containersConfig);
            }
            String[] values = containersConfig.substring(start + 1, end).split(",");
            if (values.length != 6) {
                throw new IllegalArgumentException("Format to define container is:(priority,resource,host,expression,repeat,reserved)");
            }
            Priority pri = Priority.newInstance((int)Integer.valueOf(values[0]));
            Resource res = this.parseResourceFromString(values[1]);
            NodeId host = NodeId.newInstance((String)values[2], (int)1);
            String exp = values[3];
            int repeat = Integer.valueOf(values[4]);
            boolean reserved = Boolean.valueOf(values[5]);
            for (int i = 0; i < repeat; ++i) {
                Container c = (Container)Mockito.mock(Container.class);
                Mockito.when((Object)c.getResource()).thenReturn((Object)res);
                Mockito.when((Object)c.getPriority()).thenReturn((Object)pri);
                RMContainerImpl rmc = (RMContainerImpl)Mockito.mock(RMContainerImpl.class);
                Mockito.when((Object)rmc.getAllocatedNode()).thenReturn((Object)host);
                Mockito.when((Object)rmc.getNodeLabelExpression()).thenReturn((Object)exp);
                Mockito.when((Object)rmc.getAllocatedResource()).thenReturn((Object)res);
                Mockito.when((Object)rmc.getContainer()).thenReturn((Object)c);
                Mockito.when((Object)rmc.getApplicationAttemptId()).thenReturn((Object)attemptId);
                final ContainerId cId = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)containerId);
                Mockito.when((Object)rmc.getContainerId()).thenReturn((Object)cId);
                ((RMContainerImpl)Mockito.doAnswer((Answer)new Answer<Integer>(){

                    public Integer answer(InvocationOnMock invocation) throws Throwable {
                        return cId.compareTo(((RMContainer)invocation.getArguments()[0]).getContainerId());
                    }
                }).when((Object)rmc)).compareTo((RMContainer)Matchers.any(RMContainer.class));
                if (containerId == 1) {
                    Mockito.when((Object)rmc.isAMContainer()).thenReturn((Object)true);
                }
                if (reserved) {
                    reservedContainers.add((RMContainer)rmc);
                } else {
                    liveContainers.add((RMContainer)rmc);
                }
                String partition = null;
                if (exp.isEmpty() && !(partition = this.nodeIdToSchedulerNodes.get(host).getPartition()).isEmpty()) {
                    LeafQueue queue = (LeafQueue)this.nameToCSQueues.get(queueName);
                    Map ignoreExclusivityContainers = queue.getIgnoreExclusivityRMContainers();
                    if (!ignoreExclusivityContainers.containsKey(partition)) {
                        ignoreExclusivityContainers.put(partition, new TreeSet());
                    }
                    ((TreeSet)ignoreExclusivityContainers.get(partition)).add(rmc);
                }
                LOG.debug((Object)("add container to app=" + attemptId + " res=" + res + " node=" + host + " nodeLabelExpression=" + exp + " partition=" + partition));
                ++containerId;
            }
            start = end + 1;
        }
    }

    private void mockApplications(String appsConfig) {
        int id = 1;
        for (String a : appsConfig.split(";")) {
            String[] strs = a.split("\t");
            String queueName = strs[0];
            ArrayList<RMContainer> liveContainers = new ArrayList<RMContainer>();
            ArrayList<RMContainer> reservedContainers = new ArrayList<RMContainer>();
            ApplicationId appId = ApplicationId.newInstance((long)0L, (int)id);
            ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
            this.mockContainers(strs[1], appAttemptId, queueName, reservedContainers, liveContainers);
            FiCaSchedulerApp app = (FiCaSchedulerApp)Mockito.mock(FiCaSchedulerApp.class);
            Mockito.when((Object)app.getLiveContainers()).thenReturn(liveContainers);
            Mockito.when((Object)app.getReservedContainers()).thenReturn(reservedContainers);
            Mockito.when((Object)app.getApplicationAttemptId()).thenReturn((Object)appAttemptId);
            Mockito.when((Object)app.getApplicationId()).thenReturn((Object)appId);
            Mockito.when((Object)app.getPriority()).thenReturn((Object)Priority.newInstance((int)0));
            LeafQueue queue = (LeafQueue)this.nameToCSQueues.get(queueName);
            queue.getApplications().add(app);
            ++id;
        }
    }

    private void mockSchedulerNodes(String schedulerNodesConfigStr) throws IOException {
        String[] nodesConfigStrArray;
        for (String p : nodesConfigStrArray = schedulerNodesConfigStr.split(";")) {
            NodeId nodeId = NodeId.newInstance((String)p.substring(0, p.indexOf("=")), (int)1);
            String partition = p.substring(p.indexOf("=") + 1, p.length());
            SchedulerNode sn = (SchedulerNode)Mockito.mock(SchedulerNode.class);
            Mockito.when((Object)sn.getNodeID()).thenReturn((Object)nodeId);
            Mockito.when((Object)sn.getPartition()).thenReturn((Object)partition);
            this.nodeIdToSchedulerNodes.put(nodeId, sn);
            LOG.debug((Object)("add scheduler node, id=" + nodeId + ", partition=" + partition));
        }
    }

    private void mockNodeLabelsManager(String nodeLabelsConfigStr) throws IOException {
        String[] partitionConfigArr = nodeLabelsConfigStr.split(";");
        this.clusterResource = Resources.createResource((int)0);
        for (String p : partitionConfigArr) {
            String partitionName = p.substring(0, p.indexOf("="));
            Resource res = this.parseResourceFromString(p.substring(p.indexOf("=") + 1, p.indexOf(",")));
            boolean exclusivity = Boolean.valueOf(p.substring(p.indexOf(",") + 1, p.length()));
            Mockito.when((Object)this.nlm.getResourceByLabel((String)Matchers.eq((Object)partitionName), (Resource)Matchers.any(Resource.class))).thenReturn((Object)res);
            Mockito.when((Object)this.nlm.isExclusiveNodeLabel((String)Matchers.eq((Object)partitionName))).thenReturn((Object)exclusivity);
            this.partitionToResource.put(partitionName, res);
            LOG.debug((Object)("add partition=" + partitionName + " totalRes=" + res + " exclusivity=" + exclusivity));
            Resources.addTo((Resource)this.clusterResource, (Resource)res);
        }
        Mockito.when((Object)this.nlm.getClusterNodeLabelNames()).thenReturn(this.partitionToResource.keySet());
    }

    private Resource parseResourceFromString(String p) {
        String[] resource = p.split(":");
        Resource res = Resources.createResource((int)0);
        res = resource.length == 1 ? Resources.createResource((int)Integer.valueOf(resource[0])) : Resources.createResource((int)Integer.valueOf(resource[0]), (int)Integer.valueOf(resource[1]));
        return res;
    }

    private ParentQueue mockQueueHierarchy(String queueExprs) {
        String[] queueExprArray = queueExprs.split(";");
        ParentQueue rootQueue = null;
        for (int idx = 0; idx < queueExprArray.length; ++idx) {
            ParentQueue queue;
            String q = queueExprArray[idx];
            if (this.isParent(queueExprArray, idx)) {
                ParentQueue parentQueue;
                queue = parentQueue = (ParentQueue)Mockito.mock(ParentQueue.class);
                ArrayList children = new ArrayList();
                Mockito.when((Object)parentQueue.getChildQueues()).thenReturn(children);
            } else {
                LeafQueue leafQueue = (LeafQueue)Mockito.mock(LeafQueue.class);
                final TreeSet<FiCaSchedulerApp> apps = new TreeSet<FiCaSchedulerApp>(new Comparator<FiCaSchedulerApp>(){

                    @Override
                    public int compare(FiCaSchedulerApp a1, FiCaSchedulerApp a2) {
                        return a1.getApplicationId().compareTo(a2.getApplicationId());
                    }
                });
                Mockito.when((Object)leafQueue.getApplications()).thenReturn(apps);
                OrderingPolicy so = (OrderingPolicy)Mockito.mock(OrderingPolicy.class);
                Mockito.when((Object)so.getPreemptionIterator()).thenAnswer(new Answer(){

                    public Object answer(InvocationOnMock invocation) {
                        return apps.descendingIterator();
                    }
                });
                Mockito.when((Object)leafQueue.getOrderingPolicy()).thenReturn((Object)so);
                HashMap ignorePartitionContainers = new HashMap();
                Mockito.when((Object)leafQueue.getIgnoreExclusivityRMContainers()).thenReturn(ignorePartitionContainers);
                queue = leafQueue;
            }
            this.setupQueue((CSQueue)queue, q, queueExprArray, idx);
            if (!queue.getQueueName().equals(ROOT)) continue;
            rootQueue = queue;
        }
        return rootQueue;
    }

    private void setupQueue(CSQueue queue, String q, String[] queueExprArray, int idx) {
        LOG.debug((Object)("*** Setup queue, source=" + q));
        String queuePath = null;
        int myLevel = this.getLevel(q);
        if (0 == myLevel) {
            Mockito.when((Object)queue.getQueueName()).thenReturn((Object)ROOT);
            queuePath = ROOT;
        }
        String queueName = this.getQueueName(q);
        Mockito.when((Object)queue.getQueueName()).thenReturn((Object)queueName);
        ParentQueue parentQueue = this.getParentQueue(queueExprArray, idx, myLevel);
        if (null != parentQueue) {
            Mockito.when((Object)queue.getParent()).thenReturn((Object)parentQueue);
            parentQueue.getChildQueues().add(queue);
            queuePath = parentQueue.getQueuePath() + "." + queueName;
        }
        Mockito.when((Object)queue.getQueuePath()).thenReturn((Object)queuePath);
        QueueCapacities qc = new QueueCapacities(0 == myLevel);
        ResourceUsage ru = new ResourceUsage();
        Mockito.when((Object)queue.getQueueCapacities()).thenReturn((Object)qc);
        Mockito.when((Object)queue.getQueueResourceUsage()).thenReturn((Object)ru);
        LOG.debug((Object)("Setup queue, name=" + queue.getQueueName() + " path=" + queue.getQueuePath()));
        LOG.debug((Object)("Parent=" + (parentQueue == null ? "null" : parentQueue.getQueueName())));
        String capacitySettingStr = q.substring(q.indexOf("(") + 1, q.indexOf(")"));
        for (String s : capacitySettingStr.split(",")) {
            String partitionName = s.substring(0, s.indexOf("="));
            String[] values = s.substring(s.indexOf("[") + 1, s.indexOf("]")).split(" ");
            float epsilon = 1.0E-6f;
            Resource totResoucePerPartition = this.partitionToResource.get(partitionName);
            float absGuaranteed = Resources.divide((ResourceCalculator)this.rc, (Resource)totResoucePerPartition, (Resource)this.parseResourceFromString(values[0].trim()), (Resource)totResoucePerPartition) + epsilon;
            float absMax = Resources.divide((ResourceCalculator)this.rc, (Resource)totResoucePerPartition, (Resource)this.parseResourceFromString(values[1].trim()), (Resource)totResoucePerPartition) + epsilon;
            float absUsed = Resources.divide((ResourceCalculator)this.rc, (Resource)totResoucePerPartition, (Resource)this.parseResourceFromString(values[2].trim()), (Resource)totResoucePerPartition) + epsilon;
            Resource pending = this.parseResourceFromString(values[3].trim());
            qc.setAbsoluteCapacity(partitionName, absGuaranteed);
            qc.setAbsoluteMaximumCapacity(partitionName, absMax);
            qc.setAbsoluteUsedCapacity(partitionName, absUsed);
            ru.setPending(partitionName, pending);
            if (!this.isParent(queueExprArray, idx)) {
                LeafQueue lq = (LeafQueue)queue;
                Mockito.when((Object)lq.getTotalPendingResourcesConsideringUserLimit((Resource)Matchers.isA(Resource.class), (String)Matchers.isA(String.class))).thenReturn((Object)pending);
            }
            ru.setUsed(partitionName, this.parseResourceFromString(values[2].trim()));
            LOG.debug((Object)("Setup queue=" + queueName + " partition=" + partitionName + " [abs_guaranteed=" + absGuaranteed + ",abs_max=" + absMax + ",abs_used" + absUsed + ",pending_resource=" + pending + "]"));
        }
        Mockito.when((Object)queue.getPreemptionDisabled()).thenReturn((Object)this.csConf.getPreemptionDisabled(queuePath, false));
        this.nameToCSQueues.put(queueName, queue);
        Mockito.when((Object)this.cs.getQueue((String)Matchers.eq((Object)queueName))).thenReturn((Object)queue);
    }

    private int getLevel(String q) {
        int level;
        for (level = 0; level < q.length() && q.charAt(level) == '-'; ++level) {
        }
        return level;
    }

    private String getQueueName(String q) {
        int idx;
        for (idx = 0; idx < q.length() && q.charAt(idx) == '-'; ++idx) {
        }
        if (idx == q.length()) {
            throw new IllegalArgumentException("illegal input:" + q);
        }
        String name = q.substring(idx, q.indexOf(40));
        if (name.isEmpty()) {
            throw new IllegalArgumentException("queue name shouldn't be empty:" + q);
        }
        if (name.contains(".")) {
            throw new IllegalArgumentException("queue name shouldn't contain '.':" + name);
        }
        return name;
    }

    private ParentQueue getParentQueue(String[] queueExprArray, int idx, int myLevel) {
        --idx;
        while (idx >= 0) {
            int level = this.getLevel(queueExprArray[idx]);
            if (level < myLevel) {
                String parentQueuName = this.getQueueName(queueExprArray[idx]);
                return (ParentQueue)this.nameToCSQueues.get(parentQueuName);
            }
            --idx;
        }
        return null;
    }

    private boolean isParent(String[] queues, int idx) {
        int myLevel = this.getLevel(queues[idx]);
        ++idx;
        while (idx < queues.length && this.getLevel(queues[idx]) == myLevel) {
            ++idx;
        }
        return idx < queues.length && this.getLevel(queues[idx]) >= myLevel;
    }
}

