/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateVersionIncompatibleException;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.AMRMTokenSecretManagerState;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemUtil;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AggregateAppResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.security.MasterKeyData;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.junit.Assert;
import org.mockito.Mockito;

public class RMStateStoreTestBase {
    public static final Log LOG = LogFactory.getLog(RMStateStoreTestBase.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitNotify(TestDispatcher dispatcher) {
        long startTime = System.currentTimeMillis();
        while (!dispatcher.notified) {
            TestDispatcher testDispatcher = dispatcher;
            synchronized (testDispatcher) {
                try {
                    dispatcher.wait(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (System.currentTimeMillis() - startTime <= 60000L) continue;
            Assert.fail((String)"Timed out attempt store notification");
        }
        dispatcher.notified = false;
    }

    protected RMApp storeApp(RMStateStore store, ApplicationId appId, long submitTime, long startTime) throws Exception {
        ApplicationSubmissionContextPBImpl context = new ApplicationSubmissionContextPBImpl();
        context.setApplicationId(appId);
        RMApp mockApp = (RMApp)Mockito.mock(RMApp.class);
        Mockito.when((Object)mockApp.getApplicationId()).thenReturn((Object)appId);
        Mockito.when((Object)mockApp.getSubmitTime()).thenReturn((Object)submitTime);
        Mockito.when((Object)mockApp.getStartTime()).thenReturn((Object)startTime);
        Mockito.when((Object)mockApp.getApplicationSubmissionContext()).thenReturn((Object)context);
        Mockito.when((Object)mockApp.getUser()).thenReturn((Object)"test");
        Mockito.when((Object)mockApp.getCallerContext()).thenReturn((Object)new CallerContext.Builder("context").build());
        store.storeNewApplication(mockApp);
        return mockApp;
    }

    protected RMAppAttempt storeAttempt(RMStateStore store, ApplicationAttemptId attemptId, String containerIdStr, Token<AMRMTokenIdentifier> appToken, SecretKey clientTokenMasterKey, TestDispatcher dispatcher) throws Exception {
        RMAppAttemptMetrics mockRmAppAttemptMetrics = (RMAppAttemptMetrics)Mockito.mock(RMAppAttemptMetrics.class);
        ContainerPBImpl container = new ContainerPBImpl();
        container.setId(ConverterUtils.toContainerId((String)containerIdStr));
        RMAppAttempt mockAttempt = (RMAppAttempt)Mockito.mock(RMAppAttempt.class);
        Mockito.when((Object)mockAttempt.getAppAttemptId()).thenReturn((Object)attemptId);
        Mockito.when((Object)mockAttempt.getMasterContainer()).thenReturn((Object)container);
        Mockito.when((Object)mockAttempt.getAMRMToken()).thenReturn(appToken);
        Mockito.when((Object)mockAttempt.getClientTokenMasterKey()).thenReturn((Object)clientTokenMasterKey);
        Mockito.when((Object)mockAttempt.getRMAppAttemptMetrics()).thenReturn((Object)mockRmAppAttemptMetrics);
        Mockito.when((Object)mockRmAppAttemptMetrics.getAggregateAppResourceUsage()).thenReturn((Object)new AggregateAppResourceUsage(0L, 0L));
        dispatcher.attemptId = attemptId;
        store.storeNewApplicationAttempt(mockAttempt);
        this.waitNotify(dispatcher);
        return mockAttempt;
    }

    void testRMAppStateStore(RMStateStoreHelper stateStoreHelper) throws Exception {
        this.testRMAppStateStore(stateStoreHelper, new StoreStateVerifier());
    }

    void testRMAppStateStore(RMStateStoreHelper stateStoreHelper, StoreStateVerifier verifier) throws Exception {
        long submitTime = System.currentTimeMillis();
        long startTime = System.currentTimeMillis() + 1234L;
        YarnConfiguration conf = new YarnConfiguration();
        RMStateStore store = stateStoreHelper.getRMStateStore();
        TestDispatcher dispatcher = new TestDispatcher();
        store.setRMDispatcher((Dispatcher)dispatcher);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)store);
        AMRMTokenSecretManager appTokenMgr = (AMRMTokenSecretManager)Mockito.spy((Object)new AMRMTokenSecretManager((Configuration)conf, rmContext));
        MasterKeyData masterKeyData = appTokenMgr.createNewMasterKey();
        Mockito.when((Object)appTokenMgr.getMasterKey()).thenReturn((Object)masterKeyData);
        ClientToAMTokenSecretManagerInRM clientToAMTokenMgr = new ClientToAMTokenSecretManagerInRM();
        ApplicationAttemptId attemptId1 = ConverterUtils.toApplicationAttemptId((String)"appattempt_1352994193343_0001_000001");
        ApplicationId appId1 = attemptId1.getApplicationId();
        this.storeApp(store, appId1, submitTime, startTime);
        verifier.afterStoreApp(store, appId1);
        Token<AMRMTokenIdentifier> appAttemptToken1 = this.generateAMRMToken(attemptId1, appTokenMgr);
        SecretKey clientTokenKey1 = clientToAMTokenMgr.createMasterKey(attemptId1);
        ContainerId containerId1 = this.storeAttempt(store, attemptId1, "container_1352994193343_0001_01_000001", appAttemptToken1, clientTokenKey1, dispatcher).getMasterContainer().getId();
        String appAttemptIdStr2 = "appattempt_1352994193343_0001_000002";
        ApplicationAttemptId attemptId2 = ConverterUtils.toApplicationAttemptId((String)appAttemptIdStr2);
        Token<AMRMTokenIdentifier> appAttemptToken2 = this.generateAMRMToken(attemptId2, appTokenMgr);
        SecretKey clientTokenKey2 = clientToAMTokenMgr.createMasterKey(attemptId2);
        ContainerId containerId2 = this.storeAttempt(store, attemptId2, "container_1352994193343_0001_02_000001", appAttemptToken2, clientTokenKey2, dispatcher).getMasterContainer().getId();
        ApplicationAttemptId attemptIdRemoved = ConverterUtils.toApplicationAttemptId((String)"appattempt_1352994193343_0002_000001");
        ApplicationId appIdRemoved = attemptIdRemoved.getApplicationId();
        this.storeApp(store, appIdRemoved, submitTime, startTime);
        this.storeAttempt(store, attemptIdRemoved, "container_1352994193343_0002_01_000001", null, null, dispatcher);
        verifier.afterStoreAppAttempt(store, attemptIdRemoved);
        RMApp mockRemovedApp = (RMApp)Mockito.mock(RMApp.class);
        RMAppAttemptMetrics mockRmAppAttemptMetrics = (RMAppAttemptMetrics)Mockito.mock(RMAppAttemptMetrics.class);
        HashMap<ApplicationAttemptId, RMAppAttempt> attempts = new HashMap<ApplicationAttemptId, RMAppAttempt>();
        ApplicationSubmissionContextPBImpl context = new ApplicationSubmissionContextPBImpl();
        context.setApplicationId(appIdRemoved);
        Mockito.when((Object)mockRemovedApp.getSubmitTime()).thenReturn((Object)submitTime);
        Mockito.when((Object)mockRemovedApp.getApplicationSubmissionContext()).thenReturn((Object)context);
        Mockito.when((Object)mockRemovedApp.getAppAttempts()).thenReturn(attempts);
        Mockito.when((Object)mockRemovedApp.getUser()).thenReturn((Object)"user1");
        RMAppAttempt mockRemovedAttempt = (RMAppAttempt)Mockito.mock(RMAppAttempt.class);
        Mockito.when((Object)mockRemovedAttempt.getAppAttemptId()).thenReturn((Object)attemptIdRemoved);
        Mockito.when((Object)mockRemovedAttempt.getRMAppAttemptMetrics()).thenReturn((Object)mockRmAppAttemptMetrics);
        Mockito.when((Object)mockRmAppAttemptMetrics.getAggregateAppResourceUsage()).thenReturn((Object)new AggregateAppResourceUsage(0L, 0L));
        attempts.put(attemptIdRemoved, mockRemovedAttempt);
        store.removeApplication(mockRemovedApp);
        this.storeApp(store, appIdRemoved, submitTime, startTime);
        this.storeAttempt(store, attemptIdRemoved, "container_1352994193343_0002_01_000001", null, null, dispatcher);
        store.removeApplication(mockRemovedApp);
        Thread.sleep(1000L);
        store.close();
        this.modifyAppState();
        store = stateStoreHelper.getRMStateStore();
        store.setRMDispatcher((Dispatcher)dispatcher);
        RMStateStore.RMState state = store.loadState();
        Map rmAppState = state.getApplicationState();
        ApplicationStateData appState = (ApplicationStateData)rmAppState.get(appId1);
        Assert.assertNotNull((Object)appState);
        Assert.assertEquals((long)submitTime, (long)appState.getSubmitTime());
        Assert.assertEquals((long)startTime, (long)appState.getStartTime());
        Assert.assertEquals((Object)appId1, (Object)appState.getApplicationSubmissionContext().getApplicationId());
        ApplicationAttemptStateData attemptState = appState.getAttempt(attemptId1);
        Assert.assertNotNull((Object)attemptState);
        Assert.assertEquals((Object)attemptId1, (Object)attemptState.getAttemptId());
        Assert.assertEquals((long)-1000L, (long)attemptState.getAMContainerExitStatus());
        Assert.assertEquals((Object)containerId1, (Object)attemptState.getMasterContainer().getId());
        Assert.assertArrayEquals((byte[])clientTokenKey1.getEncoded(), (byte[])attemptState.getAppAttemptTokens().getSecretKey(RMStateStore.AM_CLIENT_TOKEN_MASTER_KEY_NAME));
        Assert.assertEquals((Object)"context", (Object)appState.getCallerContext().getContext());
        attemptState = appState.getAttempt(attemptId2);
        Assert.assertNotNull((Object)attemptState);
        Assert.assertEquals((Object)attemptId2, (Object)attemptState.getAttemptId());
        Assert.assertEquals((Object)containerId2, (Object)attemptState.getMasterContainer().getId());
        Assert.assertArrayEquals((byte[])clientTokenKey2.getEncoded(), (byte[])attemptState.getAppAttemptTokens().getSecretKey(RMStateStore.AM_CLIENT_TOKEN_MASTER_KEY_NAME));
        ApplicationStateData appState2 = ApplicationStateData.newInstance((long)appState.getSubmitTime(), (long)appState.getStartTime(), (String)appState.getUser(), (ApplicationSubmissionContext)appState.getApplicationSubmissionContext(), (RMAppState)RMAppState.FINISHED, (String)"appDiagnostics", (long)1234L, (CallerContext)appState.getCallerContext());
        appState2.attempts.putAll(appState.attempts);
        store.updateApplicationState(appState2);
        ApplicationAttemptStateData oldAttemptState = attemptState;
        ApplicationAttemptStateData newAttemptState = ApplicationAttemptStateData.newInstance((ApplicationAttemptId)oldAttemptState.getAttemptId(), (Container)oldAttemptState.getMasterContainer(), (Credentials)oldAttemptState.getAppAttemptTokens(), (long)oldAttemptState.getStartTime(), (RMAppAttemptState)RMAppAttemptState.FINISHED, (String)"myTrackingUrl", (String)"attemptDiagnostics", (FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, (int)100, (long)oldAttemptState.getFinishTime(), (long)0L, (long)0L);
        store.updateApplicationAttemptState(newAttemptState);
        ApplicationId dummyAppId = ApplicationId.newInstance((long)1234L, (int)10);
        ApplicationSubmissionContextPBImpl dummyContext = new ApplicationSubmissionContextPBImpl();
        dummyContext.setApplicationId(dummyAppId);
        ApplicationStateData dummyApp = ApplicationStateData.newInstance((long)appState.getSubmitTime(), (long)appState.getStartTime(), (String)appState.getUser(), (ApplicationSubmissionContext)dummyContext, (RMAppState)RMAppState.FINISHED, (String)"appDiagnostics", (long)1234L, null);
        store.updateApplicationState(dummyApp);
        ApplicationAttemptId dummyAttemptId = ApplicationAttemptId.newInstance((ApplicationId)dummyAppId, (int)6);
        ApplicationAttemptStateData dummyAttempt = ApplicationAttemptStateData.newInstance((ApplicationAttemptId)dummyAttemptId, (Container)oldAttemptState.getMasterContainer(), (Credentials)oldAttemptState.getAppAttemptTokens(), (long)oldAttemptState.getStartTime(), (RMAppAttemptState)RMAppAttemptState.FINISHED, (String)"myTrackingUrl", (String)"attemptDiagnostics", (FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, (int)111, (long)oldAttemptState.getFinishTime(), (long)0L, (long)0L);
        store.updateApplicationAttemptState(dummyAttempt);
        Thread.sleep(1000L);
        store.close();
        store = stateStoreHelper.getRMStateStore();
        store.setRMDispatcher((Dispatcher)dispatcher);
        RMStateStore.RMState newRMState = store.loadState();
        Map newRMAppState = newRMState.getApplicationState();
        Assert.assertNotNull(newRMAppState.get(dummyApp.getApplicationSubmissionContext().getApplicationId()));
        ApplicationStateData updatedAppState = (ApplicationStateData)newRMAppState.get(appId1);
        Assert.assertEquals((Object)appState.getApplicationSubmissionContext().getApplicationId(), (Object)updatedAppState.getApplicationSubmissionContext().getApplicationId());
        Assert.assertEquals((long)appState.getSubmitTime(), (long)updatedAppState.getSubmitTime());
        Assert.assertEquals((long)appState.getStartTime(), (long)updatedAppState.getStartTime());
        Assert.assertEquals((Object)appState.getUser(), (Object)updatedAppState.getUser());
        Assert.assertEquals((Object)RMAppState.FINISHED, (Object)updatedAppState.getState());
        Assert.assertEquals((Object)"appDiagnostics", (Object)updatedAppState.getDiagnostics());
        Assert.assertEquals((long)1234L, (long)updatedAppState.getFinishTime());
        Assert.assertNotNull((Object)((ApplicationStateData)newRMAppState.get(dummyApp.getApplicationSubmissionContext().getApplicationId())).getAttempt(dummyAttemptId));
        ApplicationAttemptStateData updatedAttemptState = updatedAppState.getAttempt(newAttemptState.getAttemptId());
        Assert.assertEquals((Object)oldAttemptState.getAttemptId(), (Object)updatedAttemptState.getAttemptId());
        Assert.assertEquals((Object)containerId2, (Object)updatedAttemptState.getMasterContainer().getId());
        Assert.assertArrayEquals((byte[])clientTokenKey2.getEncoded(), (byte[])attemptState.getAppAttemptTokens().getSecretKey(RMStateStore.AM_CLIENT_TOKEN_MASTER_KEY_NAME));
        Assert.assertEquals((Object)RMAppAttemptState.FINISHED, (Object)updatedAttemptState.getState());
        Assert.assertEquals((Object)"myTrackingUrl", (Object)updatedAttemptState.getFinalTrackingUrl());
        Assert.assertEquals((Object)"attemptDiagnostics", (Object)updatedAttemptState.getDiagnostics());
        Assert.assertEquals((long)100L, (long)updatedAttemptState.getAMContainerExitStatus());
        Assert.assertEquals((Object)FinalApplicationStatus.SUCCEEDED, (Object)updatedAttemptState.getFinalApplicationStatus());
        Assert.assertTrue((boolean)stateStoreHelper.isFinalStateValid());
        store.close();
    }

    public void testRMDTSecretManagerStateStore(RMStateStoreHelper stateStoreHelper) throws Exception {
        RMStateStore store = stateStoreHelper.getRMStateStore();
        TestDispatcher dispatcher = new TestDispatcher();
        store.setRMDispatcher((Dispatcher)dispatcher);
        RMDelegationTokenIdentifier dtId1 = new RMDelegationTokenIdentifier(new Text("owner1"), new Text("renewer1"), new Text("realuser1"));
        int sequenceNumber = 1111;
        dtId1.setSequenceNumber(sequenceNumber);
        byte[] tokenBeforeStore = dtId1.getBytes();
        Long renewDate1 = new Long(System.currentTimeMillis());
        store.storeRMDelegationToken(dtId1, renewDate1);
        this.modifyRMDelegationTokenState();
        HashMap<RMDelegationTokenIdentifier, Long> token1 = new HashMap<RMDelegationTokenIdentifier, Long>();
        token1.put(dtId1, renewDate1);
        DelegationKey key = new DelegationKey(1234, 4321L, "keyBytes".getBytes());
        HashSet<DelegationKey> keySet = new HashSet<DelegationKey>();
        keySet.add(key);
        store.storeRMDTMasterKey(key);
        RMStateStore.RMDTSecretManagerState secretManagerState = store.loadState().getRMDTSecretManagerState();
        Assert.assertEquals(token1, (Object)secretManagerState.getTokenState());
        Assert.assertEquals(keySet, (Object)secretManagerState.getMasterKeyState());
        Assert.assertEquals((long)sequenceNumber, (long)secretManagerState.getDTSequenceNumber());
        RMDelegationTokenIdentifier tokenAfterStore = (RMDelegationTokenIdentifier)secretManagerState.getTokenState().keySet().iterator().next();
        Assert.assertTrue((boolean)Arrays.equals(tokenBeforeStore, tokenAfterStore.getBytes()));
        renewDate1 = new Long(System.currentTimeMillis());
        store.updateRMDelegationToken(dtId1, renewDate1);
        token1.put(dtId1, renewDate1);
        RMStateStore.RMDTSecretManagerState updateSecretManagerState = store.loadState().getRMDTSecretManagerState();
        Assert.assertEquals(token1, (Object)updateSecretManagerState.getTokenState());
        Assert.assertEquals(keySet, (Object)updateSecretManagerState.getMasterKeyState());
        Assert.assertEquals((long)sequenceNumber, (long)updateSecretManagerState.getDTSequenceNumber());
        store.removeRMDTMasterKey(key);
        keySet.clear();
        RMStateStore.RMDTSecretManagerState noKeySecretManagerState = store.loadState().getRMDTSecretManagerState();
        Assert.assertEquals(token1, (Object)noKeySecretManagerState.getTokenState());
        Assert.assertEquals(keySet, (Object)noKeySecretManagerState.getMasterKeyState());
        Assert.assertEquals((long)sequenceNumber, (long)noKeySecretManagerState.getDTSequenceNumber());
        store.removeRMDelegationToken(dtId1);
        RMStateStore.RMDTSecretManagerState noKeyAndTokenSecretManagerState = store.loadState().getRMDTSecretManagerState();
        token1.clear();
        Assert.assertEquals(token1, (Object)noKeyAndTokenSecretManagerState.getTokenState());
        Assert.assertEquals(keySet, (Object)noKeyAndTokenSecretManagerState.getMasterKeyState());
        Assert.assertEquals((long)sequenceNumber, (long)noKeySecretManagerState.getDTSequenceNumber());
        store.close();
    }

    protected Token<AMRMTokenIdentifier> generateAMRMToken(ApplicationAttemptId attemptId, AMRMTokenSecretManager appTokenMgr) {
        Token appToken = appTokenMgr.createAndGetAMRMToken(attemptId);
        appToken.setService(new Text("appToken service"));
        return appToken;
    }

    public void testCheckVersion(RMStateStoreHelper stateStoreHelper) throws Exception {
        RMStateStore store = stateStoreHelper.getRMStateStore();
        store.setRMDispatcher((Dispatcher)new TestDispatcher());
        Version defaultVersion = stateStoreHelper.getCurrentVersion();
        store.checkVersion();
        Assert.assertEquals((Object)defaultVersion, (Object)store.loadVersion());
        Version compatibleVersion = Version.newInstance((int)defaultVersion.getMajorVersion(), (int)(defaultVersion.getMinorVersion() + 2));
        stateStoreHelper.writeVersion(compatibleVersion);
        Assert.assertEquals((Object)compatibleVersion, (Object)store.loadVersion());
        store.checkVersion();
        Assert.assertEquals((Object)defaultVersion, (Object)store.loadVersion());
        Version incompatibleVersion = Version.newInstance((int)(defaultVersion.getMajorVersion() + 2), (int)defaultVersion.getMinorVersion());
        stateStoreHelper.writeVersion(incompatibleVersion);
        try {
            store.checkVersion();
            Assert.fail((String)"Invalid version, should fail.");
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)(t instanceof RMStateVersionIncompatibleException));
        }
    }

    public void testEpoch(RMStateStoreHelper stateStoreHelper) throws Exception {
        RMStateStore store = stateStoreHelper.getRMStateStore();
        store.setRMDispatcher((Dispatcher)new TestDispatcher());
        long firstTimeEpoch = store.getAndIncrementEpoch();
        Assert.assertEquals((long)0L, (long)firstTimeEpoch);
        long secondTimeEpoch = store.getAndIncrementEpoch();
        Assert.assertEquals((long)1L, (long)secondTimeEpoch);
        long thirdTimeEpoch = store.getAndIncrementEpoch();
        Assert.assertEquals((long)2L, (long)thirdTimeEpoch);
    }

    public void testAppDeletion(RMStateStoreHelper stateStoreHelper) throws Exception {
        RMStateStore store = stateStoreHelper.getRMStateStore();
        store.setRMDispatcher((Dispatcher)new TestDispatcher());
        ArrayList<RMApp> appList = this.createAndStoreApps(stateStoreHelper, store, 5);
        for (RMApp app : appList) {
            store.removeApplication(app);
            while (stateStoreHelper.appExists(app)) {
                Thread.sleep(100L);
            }
        }
    }

    private ArrayList<RMApp> createAndStoreApps(RMStateStoreHelper stateStoreHelper, RMStateStore store, int numApps) throws Exception {
        ArrayList<RMApp> appList = new ArrayList<RMApp>();
        for (int i = 0; i < numApps; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)1383183338L, (int)i);
            RMApp app = this.storeApp(store, appId, 123456789L, 987654321L);
            appList.add(app);
        }
        Assert.assertEquals((long)numApps, (long)appList.size());
        for (RMApp app : appList) {
            while (!stateStoreHelper.appExists(app)) {
                Thread.sleep(100L);
            }
        }
        return appList;
    }

    public void testDeleteStore(RMStateStoreHelper stateStoreHelper) throws Exception {
        RMStateStore store = stateStoreHelper.getRMStateStore();
        ArrayList<RMApp> appList = this.createAndStoreApps(stateStoreHelper, store, 5);
        store.deleteStore();
        for (RMApp app : appList) {
            Assert.assertFalse((boolean)stateStoreHelper.appExists(app));
        }
    }

    public void testRemoveApplication(RMStateStoreHelper stateStoreHelper) throws Exception {
        RMStateStore store = stateStoreHelper.getRMStateStore();
        int noOfApps = 2;
        ArrayList<RMApp> appList = this.createAndStoreApps(stateStoreHelper, store, noOfApps);
        RMApp rmApp1 = appList.get(0);
        store.removeApplication(rmApp1.getApplicationId());
        Assert.assertFalse((boolean)stateStoreHelper.appExists(rmApp1));
        RMApp rmApp2 = appList.get(1);
        Assert.assertTrue((boolean)stateStoreHelper.appExists(rmApp2));
    }

    public void testRemoveAttempt(RMStateStoreHelper stateStoreHelper) throws Exception {
        RMStateStore store = stateStoreHelper.getRMStateStore();
        TestDispatcher dispatcher = new TestDispatcher();
        store.setRMDispatcher((Dispatcher)dispatcher);
        ApplicationId appId = ApplicationId.newInstance((long)1383183339L, (int)6);
        this.storeApp(store, appId, 123456L, 564321L);
        ApplicationAttemptId attemptId1 = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        RMAppAttempt attempt1 = this.storeAttempt(store, attemptId1, ContainerId.newContainerId((ApplicationAttemptId)attemptId1, (long)1L).toString(), null, null, dispatcher);
        ApplicationAttemptId attemptId2 = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)2);
        RMAppAttempt attempt2 = this.storeAttempt(store, attemptId2, ContainerId.newContainerId((ApplicationAttemptId)attemptId2, (long)1L).toString(), null, null, dispatcher);
        store.removeApplicationAttemptInternal(attemptId1);
        Assert.assertFalse((boolean)stateStoreHelper.attemptExists(attempt1));
        Assert.assertTrue((boolean)stateStoreHelper.attemptExists(attempt2));
        Thread.sleep(1000L);
        store.close();
        store = stateStoreHelper.getRMStateStore();
        RMStateStore.RMState state = store.loadState();
        Map rmAppState = state.getApplicationState();
        ApplicationStateData appState = (ApplicationStateData)rmAppState.get(appId);
        Assert.assertNotNull((Object)appState);
        Assert.assertEquals((long)2L, (long)appState.getFirstAttemptId());
        Assert.assertNull((Object)appState.getAttempt(attemptId1));
        Assert.assertNotNull((Object)appState.getAttempt(attemptId2));
    }

    protected void modifyAppState() throws Exception {
    }

    protected void modifyRMDelegationTokenState() throws Exception {
    }

    public void testAMRMTokenSecretManagerStateStore(RMStateStoreHelper stateStoreHelper) throws Exception {
        System.out.println("Start testing");
        RMStateStore store = stateStoreHelper.getRMStateStore();
        TestDispatcher dispatcher = new TestDispatcher();
        store.setRMDispatcher((Dispatcher)dispatcher);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)store);
        YarnConfiguration conf = new YarnConfiguration();
        AMRMTokenSecretManager appTokenMgr = new AMRMTokenSecretManager((Configuration)conf, rmContext);
        MasterKeyData firstMasterKeyData = appTokenMgr.createNewMasterKey();
        AMRMTokenSecretManagerState state1 = AMRMTokenSecretManagerState.newInstance((MasterKey)firstMasterKeyData.getMasterKey(), null);
        rmContext.getStateStore().storeOrUpdateAMRMTokenSecretManager(state1, false);
        store = stateStoreHelper.getRMStateStore();
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)store);
        store.setRMDispatcher((Dispatcher)dispatcher);
        RMStateStore.RMState state = store.loadState();
        Assert.assertNotNull((Object)state.getAMRMTokenSecretManagerState());
        Assert.assertEquals((Object)firstMasterKeyData.getMasterKey(), (Object)state.getAMRMTokenSecretManagerState().getCurrentMasterKey());
        Assert.assertNull((Object)state.getAMRMTokenSecretManagerState().getNextMasterKey());
        MasterKeyData secondMasterKeyData = appTokenMgr.createNewMasterKey();
        AMRMTokenSecretManagerState state2 = AMRMTokenSecretManagerState.newInstance((MasterKey)firstMasterKeyData.getMasterKey(), (MasterKey)secondMasterKeyData.getMasterKey());
        rmContext.getStateStore().storeOrUpdateAMRMTokenSecretManager(state2, true);
        store = stateStoreHelper.getRMStateStore();
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)store);
        store.setRMDispatcher((Dispatcher)dispatcher);
        RMStateStore.RMState state_2 = store.loadState();
        Assert.assertNotNull((Object)state_2.getAMRMTokenSecretManagerState());
        Assert.assertEquals((Object)firstMasterKeyData.getMasterKey(), (Object)state_2.getAMRMTokenSecretManagerState().getCurrentMasterKey());
        Assert.assertEquals((Object)secondMasterKeyData.getMasterKey(), (Object)state_2.getAMRMTokenSecretManagerState().getNextMasterKey());
        appTokenMgr.recover(state_2);
        Assert.assertEquals((Object)appTokenMgr.getCurrnetMasterKeyData().getSecretKey(), (Object)firstMasterKeyData.getSecretKey());
        Assert.assertEquals((Object)appTokenMgr.getNextMasterKeyData().getSecretKey(), (Object)secondMasterKeyData.getSecretKey());
        store.close();
    }

    public void testReservationStateStore(RMStateStoreHelper stateStoreHelper) throws Exception {
        RMStateStore store = stateStoreHelper.getRMStateStore();
        TestDispatcher dispatcher = new TestDispatcher();
        store.setRMDispatcher((Dispatcher)dispatcher);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)store);
        long ts = System.currentTimeMillis();
        ReservationId r1 = ReservationId.newInstance((long)ts, (long)1L);
        int start = 1;
        int[] alloc = new int[]{10, 10, 10, 10, 10};
        DefaultResourceCalculator res = new DefaultResourceCalculator();
        Resource minAlloc = Resource.newInstance((int)1024, (int)1);
        boolean hasGang = true;
        String planName = "dedicated";
        ReservationDefinition rDef = ReservationSystemTestUtil.createSimpleReservationDefinition(start, start + alloc.length + 1, alloc.length);
        InMemoryReservationAllocation allocation = new InMemoryReservationAllocation(r1, rDef, "u3", planName, 0L, (long)(0 + alloc.length), ReservationSystemTestUtil.generateAllocation(0L, 1L, alloc), (ResourceCalculator)res, minAlloc, hasGang);
        YarnProtos.ReservationAllocationStateProto allocationStateProto = ReservationSystemUtil.buildStateProto((ReservationAllocation)allocation);
        this.assertAllocationStateEqual((ReservationAllocation)allocation, allocationStateProto);
        store = stateStoreHelper.getRMStateStore();
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)store);
        store.setRMDispatcher((Dispatcher)dispatcher);
        RMStateStore.RMState state = store.loadState();
        Map reservationState = state.getReservationState();
        Assert.assertNotNull((Object)reservationState);
        String reservationIdName = r1.toString();
        rmContext.getStateStore().storeNewReservation(allocationStateProto, planName, reservationIdName);
        this.validateStoredReservation(stateStoreHelper, dispatcher, rmContext, r1, planName, (ReservationAllocation)allocation, allocationStateProto);
        alloc = new int[]{6, 6, 6};
        hasGang = false;
        allocation = new InMemoryReservationAllocation(r1, rDef, "u3", planName, 2L, (long)(2 + alloc.length), ReservationSystemTestUtil.generateAllocation(1L, 2L, alloc), (ResourceCalculator)res, minAlloc, hasGang);
        allocationStateProto = ReservationSystemUtil.buildStateProto((ReservationAllocation)allocation);
        rmContext.getStateStore().removeReservation(planName, reservationIdName);
        rmContext.getStateStore().storeNewReservation(allocationStateProto, planName, reservationIdName);
        this.validateStoredReservation(stateStoreHelper, dispatcher, rmContext, r1, planName, (ReservationAllocation)allocation, allocationStateProto);
        ReservationId r2 = ReservationId.newInstance((long)ts, (long)2L);
        InMemoryReservationAllocation allocation2 = new InMemoryReservationAllocation(r2, rDef, "u3", planName, 0L, (long)(0 + alloc.length), ReservationSystemTestUtil.generateAllocation(0L, 1L, alloc), (ResourceCalculator)res, minAlloc, hasGang);
        YarnProtos.ReservationAllocationStateProto allocationStateProto2 = ReservationSystemUtil.buildStateProto((ReservationAllocation)allocation2);
        String reservationIdName2 = r2.toString();
        rmContext.getStateStore().storeNewReservation(allocationStateProto2, planName, reservationIdName2);
        rmContext.getStateStore().removeReservation(planName, reservationIdName);
        store = stateStoreHelper.getRMStateStore();
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)store);
        store.setRMDispatcher((Dispatcher)dispatcher);
        state = store.loadState();
        reservationState = state.getReservationState();
        Assert.assertNotNull((Object)reservationState);
        Map reservations = (Map)reservationState.get(planName);
        Assert.assertNotNull((Object)reservations);
        YarnProtos.ReservationAllocationStateProto storedReservationAllocation = (YarnProtos.ReservationAllocationStateProto)reservations.get(r1);
        Assert.assertNull((String)"Removed reservation should not be available in store", (Object)storedReservationAllocation);
        storedReservationAllocation = (YarnProtos.ReservationAllocationStateProto)reservations.get(r2);
        this.assertAllocationStateEqual(allocationStateProto2, storedReservationAllocation);
        this.assertAllocationStateEqual((ReservationAllocation)allocation2, storedReservationAllocation);
        rmContext.getStateStore().removeReservation(planName, reservationIdName2);
        store = stateStoreHelper.getRMStateStore();
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)store);
        store.setRMDispatcher((Dispatcher)dispatcher);
        state = store.loadState();
        reservationState = state.getReservationState();
        Assert.assertNotNull((Object)reservationState);
        reservations = (Map)reservationState.get(planName);
        Assert.assertNull((Object)reservations);
    }

    private void validateStoredReservation(RMStateStoreHelper stateStoreHelper, TestDispatcher dispatcher, RMContext rmContext, ReservationId r1, String planName, ReservationAllocation allocation, YarnProtos.ReservationAllocationStateProto allocationStateProto) throws Exception {
        RMStateStore store = stateStoreHelper.getRMStateStore();
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)store);
        store.setRMDispatcher((Dispatcher)dispatcher);
        RMStateStore.RMState state = store.loadState();
        Map reservationState = state.getReservationState();
        Assert.assertNotNull((Object)reservationState);
        Map reservations = (Map)reservationState.get(planName);
        Assert.assertNotNull((Object)reservations);
        YarnProtos.ReservationAllocationStateProto storedReservationAllocation = (YarnProtos.ReservationAllocationStateProto)reservations.get(r1);
        Assert.assertNotNull((Object)storedReservationAllocation);
        this.assertAllocationStateEqual(allocationStateProto, storedReservationAllocation);
        this.assertAllocationStateEqual(allocation, storedReservationAllocation);
    }

    void assertAllocationStateEqual(YarnProtos.ReservationAllocationStateProto expected, YarnProtos.ReservationAllocationStateProto actual) {
        Assert.assertEquals((long)expected.getAcceptanceTime(), (long)actual.getAcceptanceTime());
        Assert.assertEquals((long)expected.getStartTime(), (long)actual.getStartTime());
        Assert.assertEquals((long)expected.getEndTime(), (long)actual.getEndTime());
        Assert.assertEquals((Object)expected.getContainsGangs(), (Object)actual.getContainsGangs());
        Assert.assertEquals((Object)expected.getUser(), (Object)actual.getUser());
        Assert.assertEquals((Object)expected.getReservationDefinition(), (Object)actual.getReservationDefinition());
        Assert.assertEquals((Object)expected.getAllocationRequestsList(), (Object)actual.getAllocationRequestsList());
    }

    void assertAllocationStateEqual(ReservationAllocation expected, YarnProtos.ReservationAllocationStateProto actual) {
        Assert.assertEquals((long)expected.getAcceptanceTime(), (long)actual.getAcceptanceTime());
        Assert.assertEquals((long)expected.getStartTime(), (long)actual.getStartTime());
        Assert.assertEquals((long)expected.getEndTime(), (long)actual.getEndTime());
        Assert.assertEquals((Object)expected.containsGangs(), (Object)actual.getContainsGangs());
        Assert.assertEquals((Object)expected.getUser(), (Object)actual.getUser());
        Assert.assertEquals((Object)expected.getReservationDefinition(), (Object)ReservationSystemUtil.convertFromProtoFormat((YarnProtos.ReservationDefinitionProto)actual.getReservationDefinition()));
        Assert.assertEquals((Object)expected.getAllocationRequests(), (Object)ReservationSystemUtil.toAllocations((List)actual.getAllocationRequestsList()));
    }

    static interface RMStateStoreHelper {
        public RMStateStore getRMStateStore() throws Exception;

        public boolean isFinalStateValid() throws Exception;

        public void writeVersion(Version var1) throws Exception;

        public Version getCurrentVersion() throws Exception;

        public boolean appExists(RMApp var1) throws Exception;

        public boolean attemptExists(RMAppAttempt var1) throws Exception;
    }

    public static class StoreStateVerifier {
        void afterStoreApp(RMStateStore store, ApplicationId appId) {
        }

        void afterStoreAppAttempt(RMStateStore store, ApplicationAttemptId appAttId) {
        }
    }

    static class TestDispatcher
    implements Dispatcher,
    EventHandler<Event> {
        ApplicationAttemptId attemptId;
        boolean notified = false;

        TestDispatcher() {
        }

        public void register(Class<? extends Enum> eventType, EventHandler handler) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(Event event) {
            if (event instanceof RMAppAttemptEvent) {
                RMAppAttemptEvent rmAppAttemptEvent = (RMAppAttemptEvent)event;
                Assert.assertEquals((Object)this.attemptId, (Object)rmAppAttemptEvent.getApplicationAttemptId());
            }
            this.notified = true;
            TestDispatcher testDispatcher = this;
            synchronized (testDispatcher) {
                this.notifyAll();
            }
        }

        public EventHandler getEventHandler() {
            return this;
        }
    }
}

