/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMemoryRMStateStore {
    @Test
    public void testNotifyStoreOperationFailed() throws Exception {
        MemoryRMStateStore store = new MemoryRMStateStore(){

            public synchronized void removeRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier) throws Exception {
                throw new Exception("testNotifyStoreOperationFailed");
            }
        };
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        store.init(conf);
        ResourceManager mockRM = (ResourceManager)Mockito.mock(ResourceManager.class);
        store.setResourceManager(mockRM);
        RMDelegationTokenIdentifier mockTokenId = (RMDelegationTokenIdentifier)Mockito.mock(RMDelegationTokenIdentifier.class);
        store.removeRMDelegationToken(mockTokenId);
        Assert.assertTrue((String)"RMStateStore should have been in fenced state", (boolean)store.isFencedState());
        store = new MemoryRMStateStore(){

            public synchronized void removeRMDelegationToken(RMDelegationTokenIdentifier rmDTIdentifier) {
                this.notifyStoreOperationFailed(new Exception("testNotifyStoreOperationFailed"));
            }
        };
        store.init(conf);
        store.setResourceManager(mockRM);
        store.removeRMDelegationToken(mockTokenId);
        Assert.assertTrue((String)"RMStateStore should have been in fenced state", (boolean)store.isFencedState());
    }
}

