/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ReservationAllocationState;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemUtil;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestReservationSystemUtil {
    @Test
    public void testConvertAllocationsToReservationInfo() {
        long startTime = new Date().getTime();
        long step = 10000L;
        int[] alloc = new int[]{10, 10, 10};
        ReservationId id = ReservationSystemTestUtil.getNewReservationId();
        ReservationAllocation allocation = this.createReservationAllocation(startTime, startTime + 10L * step, step, alloc, id, this.createResource(4000, 2));
        List infoList = ReservationSystemUtil.convertAllocationsToReservationInfo(Collections.singleton(allocation), (boolean)true);
        Assert.assertEquals((long)infoList.size(), (long)1L);
        Assert.assertEquals((Object)((ReservationAllocationState)infoList.get(0)).getReservationId().toString(), (Object)id.toString());
        Assert.assertFalse((boolean)((ReservationAllocationState)infoList.get(0)).getResourceAllocationRequests().isEmpty());
    }

    @Test
    public void testConvertAllocationsToReservationInfoNoAllocations() {
        long startTime = new Date().getTime();
        long step = 10000L;
        int[] alloc = new int[]{10, 10, 10};
        ReservationId id = ReservationSystemTestUtil.getNewReservationId();
        ReservationAllocation allocation = this.createReservationAllocation(startTime, startTime + 10L * step, step, alloc, id, this.createResource(4000, 2));
        List infoList = ReservationSystemUtil.convertAllocationsToReservationInfo(Collections.singleton(allocation), (boolean)false);
        Assert.assertEquals((long)infoList.size(), (long)1L);
        Assert.assertEquals((Object)((ReservationAllocationState)infoList.get(0)).getReservationId().toString(), (Object)id.toString());
        Assert.assertTrue((boolean)((ReservationAllocationState)infoList.get(0)).getResourceAllocationRequests().isEmpty());
    }

    @Test
    public void testConvertAllocationsToReservationInfoEmptyAllocations() {
        long startTime = new Date().getTime();
        long step = 10000L;
        int[] alloc = new int[]{};
        ReservationId id = ReservationSystemTestUtil.getNewReservationId();
        ReservationAllocation allocation = this.createReservationAllocation(startTime, startTime + 10L * step, step, alloc, id, this.createResource(4000, 2));
        List infoList = ReservationSystemUtil.convertAllocationsToReservationInfo(Collections.singleton(allocation), (boolean)false);
        Assert.assertEquals((long)infoList.size(), (long)1L);
        Assert.assertEquals((Object)((ReservationAllocationState)infoList.get(0)).getReservationId().toString(), (Object)id.toString());
        Assert.assertTrue((boolean)((ReservationAllocationState)infoList.get(0)).getResourceAllocationRequests().isEmpty());
    }

    @Test
    public void testConvertAllocationsToReservationInfoEmptySet() {
        List infoList = ReservationSystemUtil.convertAllocationsToReservationInfo(Collections.emptySet(), (boolean)false);
        Assert.assertEquals((long)infoList.size(), (long)0L);
    }

    private ReservationAllocation createReservationAllocation(long startTime, long deadline, long step, int[] alloc, ReservationId id, Resource minAlloc) {
        Map<ReservationInterval, Resource> allocations = ReservationSystemTestUtil.generateAllocation(startTime, step, alloc);
        ResourceCalculator rs = (ResourceCalculator)Mockito.mock(ResourceCalculator.class);
        ReservationDefinition definition = ReservationSystemTestUtil.createSimpleReservationDefinition(startTime, deadline, step);
        return new InMemoryReservationAllocation(id, definition, "user", "dedicated", startTime, startTime + step, allocations, rs, minAlloc, false);
    }

    public Resource createResource(int memory, int vCores) {
        ResourcePBImpl resource = new ResourcePBImpl();
        resource.setMemory(memory);
        resource.setVirtualCores(vCores);
        return resource;
    }
}

