/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation.planning;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.api.records.ReservationRequests;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.CapacityOverTimePolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryPlan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.SharingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.AlignedPlannerWithGreedy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.ReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mortbay.log.Log;

public class TestAlignedPlanner {
    ReservationAgent agent;
    InMemoryPlan plan;
    Resource minAlloc = Resource.newInstance((int)1024, (int)1);
    ResourceCalculator res = new DefaultResourceCalculator();
    Resource maxAlloc = Resource.newInstance((int)8192, (int)8);
    Random rand = new Random();
    long step;

    @Test
    public void testSingleReservationAccept() throws PlanningException {
        int numJobsInScenario = this.initializeScenario1();
        ReservationDefinition rr1 = this.createReservationDefinition(5L * this.step, 20L * this.step, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)2048, (int)2), (int)10, (int)5, (long)(10L * this.step))}, ReservationRequestInterpreter.R_ORDER, "u1");
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        this.agent.createReservation(reservationID, "u1", (Plan)this.plan, rr1);
        Assert.assertTrue((String)"Agent-based allocation failed", (reservationID != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Agent-based allocation failed", (this.plan.getAllReservations().size() == numJobsInScenario + 1 ? 1 : 0) != 0);
        ReservationAllocation alloc1 = this.plan.getReservationById(reservationID);
        Assert.assertTrue((String)alloc1.toString(), (boolean)this.check(alloc1, 10L * this.step, 20L * this.step, 10, 2048, 2));
    }

    @Test
    public void testOrderNoGapImpossible() throws PlanningException {
        int numJobsInScenario = this.initializeScenario2();
        ReservationDefinition rr1 = this.createReservationDefinition(10L, 15L * this.step, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)20, (int)20, (long)this.step), ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)20, (int)20, (long)this.step)}, ReservationRequestInterpreter.R_ORDER_NO_GAP, "u1");
        try {
            ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
            this.agent.createReservation(reservationID, "u1", (Plan)this.plan, rr1);
            Assert.fail();
        }
        catch (PlanningException planningException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Agent-based allocation should have failed", (this.plan.getAllReservations().size() == numJobsInScenario ? 1 : 0) != 0);
    }

    @Test
    public void testOrderNoGapImpossible2() throws PlanningException {
        int numJobsInScenario = this.initializeScenario2();
        ReservationDefinition rr1 = this.createReservationDefinition(10L * this.step, 13L * this.step, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)20, (int)20, (long)this.step), ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)10, (int)10, (long)this.step)}, ReservationRequestInterpreter.R_ORDER_NO_GAP, "u1");
        try {
            ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
            this.agent.createReservation(reservationID, "u1", (Plan)this.plan, rr1);
            Assert.fail();
        }
        catch (PlanningException planningException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Agent-based allocation should have failed", (this.plan.getAllReservations().size() == numJobsInScenario ? 1 : 0) != 0);
    }

    @Test
    public void testOrderImpossible() throws PlanningException {
        int numJobsInScenario = this.initializeScenario2();
        ReservationDefinition rr1 = this.createReservationDefinition(10L * this.step, 15L * this.step, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)20, (int)20, (long)(2L * this.step)), ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)20, (int)20, (long)this.step)}, ReservationRequestInterpreter.R_ORDER, "u1");
        try {
            ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
            this.agent.createReservation(reservationID, "u1", (Plan)this.plan, rr1);
            Assert.fail();
        }
        catch (PlanningException planningException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Agent-based allocation should have failed", (this.plan.getAllReservations().size() == numJobsInScenario ? 1 : 0) != 0);
    }

    @Test
    public void testAnyImpossible() throws PlanningException {
        int numJobsInScenario = this.initializeScenario2();
        ReservationDefinition rr1 = this.createReservationDefinition(10L * this.step, 15L * this.step, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)20, (int)20, (long)(3L * this.step)), ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)20, (int)20, (long)(2L * this.step))}, ReservationRequestInterpreter.R_ANY, "u1");
        try {
            ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
            this.agent.createReservation(reservationID, "u1", (Plan)this.plan, rr1);
            Assert.fail();
        }
        catch (PlanningException planningException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Agent-based allocation should have failed", (this.plan.getAllReservations().size() == numJobsInScenario ? 1 : 0) != 0);
    }

    @Test
    public void testAnyAccept() throws PlanningException {
        int numJobsInScenario = this.initializeScenario2();
        ReservationDefinition rr1 = this.createReservationDefinition(10L * this.step, 15L * this.step, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)20, (int)20, (long)this.step), ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)20, (int)20, (long)(2L * this.step))}, ReservationRequestInterpreter.R_ANY, "u1");
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        this.agent.createReservation(reservationID, "u1", (Plan)this.plan, rr1);
        Assert.assertTrue((String)"Agent-based allocation failed", (reservationID != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Agent-based allocation failed", (this.plan.getAllReservations().size() == numJobsInScenario + 1 ? 1 : 0) != 0);
        ReservationAllocation alloc1 = this.plan.getReservationById(reservationID);
        Assert.assertTrue((String)alloc1.toString(), (boolean)this.check(alloc1, 14L * this.step, 15L * this.step, 20, 1024, 1));
    }

    @Test
    public void testAllAccept() throws PlanningException {
        int numJobsInScenario = this.initializeScenario2();
        ReservationDefinition rr1 = this.createReservationDefinition(10L * this.step, 15L * this.step, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)20, (int)20, (long)this.step), ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)20, (int)20, (long)this.step)}, ReservationRequestInterpreter.R_ALL, "u1");
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        this.agent.createReservation(reservationID, "u1", (Plan)this.plan, rr1);
        Assert.assertTrue((String)"Agent-based allocation failed", (reservationID != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Agent-based allocation failed", (this.plan.getAllReservations().size() == numJobsInScenario + 1 ? 1 : 0) != 0);
        ReservationAllocation alloc1 = this.plan.getReservationById(reservationID);
        Assert.assertTrue((String)alloc1.toString(), (boolean)this.check(alloc1, 10L * this.step, 11L * this.step, 20, 1024, 1));
        Assert.assertTrue((String)alloc1.toString(), (boolean)this.check(alloc1, 14L * this.step, 15L * this.step, 20, 1024, 1));
    }

    @Test
    public void testAllImpossible() throws PlanningException {
        int numJobsInScenario = this.initializeScenario2();
        ReservationDefinition rr1 = this.createReservationDefinition(10L * this.step, 15L * this.step, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)20, (int)20, (long)this.step), ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)20, (int)20, (long)(2L * this.step))}, ReservationRequestInterpreter.R_ALL, "u1");
        try {
            ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
            this.agent.createReservation(reservationID, "u1", (Plan)this.plan, rr1);
            Assert.fail();
        }
        catch (PlanningException planningException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Agent-based allocation should have failed", (this.plan.getAllReservations().size() == numJobsInScenario ? 1 : 0) != 0);
    }

    @Test
    public void testUpdate() throws PlanningException {
        ReservationDefinition rrFlex = this.createReservationDefinition(10L * this.step, 14L * this.step, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)100, (int)1, (long)(2L * this.step))}, ReservationRequestInterpreter.R_ALL, "u1");
        ReservationDefinition rrBlock = this.createReservationDefinition(10L * this.step, 11L * this.step, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)100, (int)100, (long)this.step)}, ReservationRequestInterpreter.R_ALL, "u1");
        ReservationId flexReservationID = ReservationSystemTestUtil.getNewReservationId();
        ReservationId blockReservationID = ReservationSystemTestUtil.getNewReservationId();
        this.agent.createReservation(blockReservationID, "uBlock", (Plan)this.plan, rrBlock);
        this.agent.createReservation(flexReservationID, "uFlex", (Plan)this.plan, rrFlex);
        this.agent.deleteReservation(blockReservationID, "uBlock", (Plan)this.plan);
        this.agent.updateReservation(flexReservationID, "uFlex", (Plan)this.plan, rrFlex);
        Assert.assertTrue((String)"Agent-based allocation failed", (flexReservationID != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Agent-based allocation failed", (this.plan.getAllReservations().size() == 1 ? 1 : 0) != 0);
        ReservationAllocation alloc1 = this.plan.getReservationById(flexReservationID);
        Assert.assertTrue((String)alloc1.toString(), (boolean)this.check(alloc1, 10L * this.step, 14L * this.step, 50, 1024, 1));
    }

    @Test
    public void testImpossibleDuration() throws PlanningException {
        ReservationDefinition rr1 = this.createReservationDefinition(10L * this.step, 15L * this.step, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)20, (int)20, (long)(10L * this.step))}, ReservationRequestInterpreter.R_ALL, "u1");
        try {
            ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
            this.agent.createReservation(reservationID, "u1", (Plan)this.plan, rr1);
            Assert.fail();
        }
        catch (PlanningException planningException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Agent-based allocation should have failed", (this.plan.getAllReservations().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLoadedDurationIntervals() throws PlanningException {
        int numJobsInScenario = this.initializeScenario3();
        ReservationDefinition rr1 = this.createReservationDefinition(10L * this.step, 13L * this.step, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)80, (int)10, (long)this.step)}, ReservationRequestInterpreter.R_ALL, "u1");
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        this.agent.createReservation(reservationID, "u1", (Plan)this.plan, rr1);
        Assert.assertTrue((String)"Agent-based allocation failed", (reservationID != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Agent-based allocation failed", (this.plan.getAllReservations().size() == numJobsInScenario + 1 ? 1 : 0) != 0);
        ReservationAllocation alloc1 = this.plan.getReservationById(reservationID);
        Assert.assertTrue((String)alloc1.toString(), (boolean)this.check(alloc1, 10L * this.step, 11L * this.step, 20, 1024, 1));
        Assert.assertTrue((String)alloc1.toString(), (boolean)this.check(alloc1, 11L * this.step, 12L * this.step, 20, 1024, 1));
        Assert.assertTrue((String)alloc1.toString(), (boolean)this.check(alloc1, 12L * this.step, 13L * this.step, 40, 1024, 1));
    }

    @Test
    public void testCostFunction() throws PlanningException {
        ReservationDefinition rr7Mem1Core = this.createReservationDefinition(10L * this.step, 11L * this.step, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)7168, (int)1), (int)1, (int)1, (long)this.step)}, ReservationRequestInterpreter.R_ALL, "u1");
        ReservationDefinition rr6Mem6Cores = this.createReservationDefinition(10L * this.step, 11L * this.step, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)6144, (int)6), (int)1, (int)1, (long)this.step)}, ReservationRequestInterpreter.R_ALL, "u2");
        ReservationDefinition rr = this.createReservationDefinition(10L * this.step, 12L * this.step, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)1, (int)1, (long)this.step)}, ReservationRequestInterpreter.R_ALL, "u3");
        ReservationId reservationID1 = ReservationSystemTestUtil.getNewReservationId();
        ReservationId reservationID2 = ReservationSystemTestUtil.getNewReservationId();
        ReservationId reservationID3 = ReservationSystemTestUtil.getNewReservationId();
        this.agent.createReservation(reservationID1, "u1", (Plan)this.plan, rr7Mem1Core);
        this.agent.createReservation(reservationID2, "u2", (Plan)this.plan, rr6Mem6Cores);
        this.agent.createReservation(reservationID3, "u3", (Plan)this.plan, rr);
        ReservationAllocation alloc3 = this.plan.getReservationById(reservationID3);
        Assert.assertTrue((String)alloc3.toString(), (boolean)this.check(alloc3, 10L * this.step, 11L * this.step, 0, 1024, 1));
        Assert.assertTrue((String)alloc3.toString(), (boolean)this.check(alloc3, 11L * this.step, 12L * this.step, 1, 1024, 1));
    }

    @Test
    public void testFromCluster() throws PlanningException {
        ArrayList<ReservationDefinition> list = new ArrayList<ReservationDefinition>();
        list.add(this.createReservationDefinition(1425716392178L, 1425722262791L, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)7, (int)1, (long)587000L)}, ReservationRequestInterpreter.R_ALL, "u1"));
        list.add(this.createReservationDefinition(1425716406178L, 1425721255841L, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)6, (int)1, (long)485000L)}, ReservationRequestInterpreter.R_ALL, "u2"));
        list.add(this.createReservationDefinition(1425716399178L, 1425723780138L, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)6, (int)1, (long)738000L)}, ReservationRequestInterpreter.R_ALL, "u3"));
        list.add(this.createReservationDefinition(1425716437178L, 1425722968378L, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)7, (int)1, (long)653000L)}, ReservationRequestInterpreter.R_ALL, "u4"));
        list.add(this.createReservationDefinition(1425716406178L, 1425721926090L, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)6, (int)1, (long)552000L)}, ReservationRequestInterpreter.R_ALL, "u5"));
        list.add(this.createReservationDefinition(1425716379178L, 1425722238553L, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)6, (int)1, (long)586000L)}, ReservationRequestInterpreter.R_ALL, "u6"));
        list.add(this.createReservationDefinition(1425716407178L, 1425722908317L, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)7, (int)1, (long)650000L)}, ReservationRequestInterpreter.R_ALL, "u7"));
        list.add(this.createReservationDefinition(1425716452178L, 1425722841562L, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)6, (int)1, (long)639000L)}, ReservationRequestInterpreter.R_ALL, "u8"));
        list.add(this.createReservationDefinition(1425716384178L, 1425721766129L, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)7, (int)1, (long)538000L)}, ReservationRequestInterpreter.R_ALL, "u9"));
        list.add(this.createReservationDefinition(1425716437178L, 1425722507886L, new ReservationRequest[]{ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)5, (int)1, (long)607000L)}, ReservationRequestInterpreter.R_ALL, "u10"));
        int i = 1;
        for (ReservationDefinition rr : list) {
            ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
            this.agent.createReservation(reservationID, "u" + Integer.toString(i), (Plan)this.plan, rr);
            ++i;
        }
        Assert.assertTrue((String)"Agent-based allocation failed", (this.plan.getAllReservations().size() == list.size() ? 1 : 0) != 0);
    }

    @Before
    public void setup() throws Exception {
        long seed = this.rand.nextLong();
        this.rand.setSeed(seed);
        Log.info((String)("Running with seed: " + seed));
        long timeWindow = 1000000L;
        int capacityMem = 102400;
        int capacityCores = 100;
        this.step = 60000L;
        Resource clusterCapacity = Resource.newInstance((int)capacityMem, (int)capacityCores);
        String reservationQ = ReservationSystemTestUtil.getFullReservationQueueName();
        float instConstraint = 100.0f;
        float avgConstraint = 100.0f;
        ReservationSchedulerConfiguration conf = ReservationSystemTestUtil.createConf(reservationQ, timeWindow, instConstraint, avgConstraint);
        CapacityOverTimePolicy policy = new CapacityOverTimePolicy();
        policy.init(reservationQ, conf);
        QueueMetrics queueMetrics = (QueueMetrics)Mockito.mock(QueueMetrics.class);
        RMContext context = ReservationSystemTestUtil.createMockRMContext();
        this.agent = new AlignedPlannerWithGreedy();
        this.plan = new InMemoryPlan(queueMetrics, (SharingPolicy)policy, this.agent, clusterCapacity, this.step, this.res, this.minAlloc, this.maxAlloc, "dedicated", null, true, context);
    }

    private int initializeScenario1() throws PlanningException {
        this.addFixedAllocation(0L, this.step, new int[]{10, 10, 20, 20, 20, 10, 10});
        System.out.println("--------BEFORE AGENT----------");
        System.out.println(this.plan.toString());
        System.out.println(this.plan.toCumulativeString());
        return 1;
    }

    private int initializeScenario2() throws PlanningException {
        this.addFixedAllocation(11L * this.step, this.step, new int[]{90, 90, 90});
        System.out.println("--------BEFORE AGENT----------");
        System.out.println(this.plan.toString());
        System.out.println(this.plan.toCumulativeString());
        return 1;
    }

    private int initializeScenario3() throws PlanningException {
        this.addFixedAllocation(10L * this.step, this.step, new int[]{70, 80, 60});
        System.out.println("--------BEFORE AGENT----------");
        System.out.println(this.plan.toString());
        System.out.println(this.plan.toCumulativeString());
        return 1;
    }

    private void addFixedAllocation(long start, long step, int[] f) throws PlanningException {
        ReservationDefinition rDef = ReservationSystemTestUtil.createSimpleReservationDefinition(start, start + (long)f.length * step, (long)f.length * step);
        Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(ReservationSystemTestUtil.getNewReservationId(), rDef, "user_fixed", "dedicated", start, start + (long)f.length * step, ReservationSystemTestUtil.generateAllocation(start, step, f), this.res, this.minAlloc), false));
    }

    private ReservationDefinition createReservationDefinition(long arrival, long deadline, ReservationRequest[] reservationRequests, ReservationRequestInterpreter rType, String username) {
        return ReservationDefinition.newInstance((long)arrival, (long)deadline, (ReservationRequests)ReservationRequests.newInstance(Arrays.asList(reservationRequests), (ReservationRequestInterpreter)rType), (String)username);
    }

    private boolean check(ReservationAllocation alloc, long start, long end, int containers, int mem, int cores) {
        Resource expectedResources = Resource.newInstance((int)(mem * containers), (int)(cores * containers));
        for (long i = start; i < end; ++i) {
            if (Resources.equals((Resource)alloc.getResourcesAtTime(i), (Resource)expectedResources)) continue;
            return false;
        }
        return true;
    }
}

