/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.NMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.ParameterizedSchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.MockRMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAbstractYarnScheduler
extends ParameterizedSchedulerTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaximimumAllocationMemory() throws Exception {
        int node1MaxMemory = 15360;
        int node2MaxMemory = 5120;
        int node3MaxMemory = 6144;
        int configuredMaxMemory = 10240;
        this.configureScheduler();
        YarnConfiguration conf = this.getConf();
        conf.setInt("yarn.scheduler.maximum-allocation-mb", 10240);
        conf.setLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 1000000L);
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            this.testMaximumAllocationMemoryHelper((YarnScheduler)rm.getResourceScheduler(), 15360, 5120, 6144, 10240, 10240, 10240, 10240, 10240, 10240);
        }
        finally {
            rm.stop();
        }
        conf.setLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 0L);
        rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            this.testMaximumAllocationMemoryHelper((YarnScheduler)rm.getResourceScheduler(), 15360, 5120, 6144, 10240, 10240, 10240, 5120, 6144, 5120);
        }
        finally {
            rm.stop();
        }
    }

    private void testMaximumAllocationMemoryHelper(YarnScheduler scheduler, int node1MaxMemory, int node2MaxMemory, int node3MaxMemory, int ... expectedMaxMemory) throws Exception {
        Assert.assertEquals((long)6L, (long)expectedMaxMemory.length);
        Assert.assertEquals((long)0L, (long)scheduler.getNumClusterNodes());
        int maxMemory = scheduler.getMaximumResourceCapability().getMemory();
        Assert.assertEquals((long)expectedMaxMemory[0], (long)maxMemory);
        RMNode node1 = MockNodes.newNodeInfo(0, Resources.createResource((int)node1MaxMemory), 1, "127.0.0.2");
        scheduler.handle((Event)new NodeAddedSchedulerEvent(node1));
        Assert.assertEquals((long)1L, (long)scheduler.getNumClusterNodes());
        maxMemory = scheduler.getMaximumResourceCapability().getMemory();
        Assert.assertEquals((long)expectedMaxMemory[1], (long)maxMemory);
        scheduler.handle((Event)new NodeRemovedSchedulerEvent(node1));
        Assert.assertEquals((long)0L, (long)scheduler.getNumClusterNodes());
        maxMemory = scheduler.getMaximumResourceCapability().getMemory();
        Assert.assertEquals((long)expectedMaxMemory[2], (long)maxMemory);
        RMNode node2 = MockNodes.newNodeInfo(0, Resources.createResource((int)node2MaxMemory), 2, "127.0.0.3");
        scheduler.handle((Event)new NodeAddedSchedulerEvent(node2));
        Assert.assertEquals((long)1L, (long)scheduler.getNumClusterNodes());
        maxMemory = scheduler.getMaximumResourceCapability().getMemory();
        Assert.assertEquals((long)expectedMaxMemory[3], (long)maxMemory);
        RMNode node3 = MockNodes.newNodeInfo(0, Resources.createResource((int)node3MaxMemory), 3, "127.0.0.4");
        scheduler.handle((Event)new NodeAddedSchedulerEvent(node3));
        Assert.assertEquals((long)2L, (long)scheduler.getNumClusterNodes());
        maxMemory = scheduler.getMaximumResourceCapability().getMemory();
        Assert.assertEquals((long)expectedMaxMemory[4], (long)maxMemory);
        scheduler.handle((Event)new NodeRemovedSchedulerEvent(node3));
        Assert.assertEquals((long)1L, (long)scheduler.getNumClusterNodes());
        maxMemory = scheduler.getMaximumResourceCapability().getMemory();
        Assert.assertEquals((long)expectedMaxMemory[5], (long)maxMemory);
        scheduler.handle((Event)new NodeRemovedSchedulerEvent(node2));
        Assert.assertEquals((long)0L, (long)scheduler.getNumClusterNodes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaximimumAllocationVCores() throws Exception {
        int node1MaxVCores = 15;
        int node2MaxVCores = 5;
        int node3MaxVCores = 6;
        int configuredMaxVCores = 10;
        this.configureScheduler();
        YarnConfiguration conf = this.getConf();
        conf.setInt("yarn.scheduler.maximum-allocation-vcores", 10);
        conf.setLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 1000000L);
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            this.testMaximumAllocationVCoresHelper((YarnScheduler)rm.getResourceScheduler(), 15, 5, 6, 10, 10, 10, 10, 10, 10);
        }
        finally {
            rm.stop();
        }
        conf.setLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 0L);
        rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            this.testMaximumAllocationVCoresHelper((YarnScheduler)rm.getResourceScheduler(), 15, 5, 6, 10, 10, 10, 5, 6, 5);
        }
        finally {
            rm.stop();
        }
    }

    private void testMaximumAllocationVCoresHelper(YarnScheduler scheduler, int node1MaxVCores, int node2MaxVCores, int node3MaxVCores, int ... expectedMaxVCores) throws Exception {
        Assert.assertEquals((long)6L, (long)expectedMaxVCores.length);
        Assert.assertEquals((long)0L, (long)scheduler.getNumClusterNodes());
        int maxVCores = scheduler.getMaximumResourceCapability().getVirtualCores();
        Assert.assertEquals((long)expectedMaxVCores[0], (long)maxVCores);
        RMNode node1 = MockNodes.newNodeInfo(0, Resources.createResource((int)1024, (int)node1MaxVCores), 1, "127.0.0.2");
        scheduler.handle((Event)new NodeAddedSchedulerEvent(node1));
        Assert.assertEquals((long)1L, (long)scheduler.getNumClusterNodes());
        maxVCores = scheduler.getMaximumResourceCapability().getVirtualCores();
        Assert.assertEquals((long)expectedMaxVCores[1], (long)maxVCores);
        scheduler.handle((Event)new NodeRemovedSchedulerEvent(node1));
        Assert.assertEquals((long)0L, (long)scheduler.getNumClusterNodes());
        maxVCores = scheduler.getMaximumResourceCapability().getVirtualCores();
        Assert.assertEquals((long)expectedMaxVCores[2], (long)maxVCores);
        RMNode node2 = MockNodes.newNodeInfo(0, Resources.createResource((int)1024, (int)node2MaxVCores), 2, "127.0.0.3");
        scheduler.handle((Event)new NodeAddedSchedulerEvent(node2));
        Assert.assertEquals((long)1L, (long)scheduler.getNumClusterNodes());
        maxVCores = scheduler.getMaximumResourceCapability().getVirtualCores();
        Assert.assertEquals((long)expectedMaxVCores[3], (long)maxVCores);
        RMNode node3 = MockNodes.newNodeInfo(0, Resources.createResource((int)1024, (int)node3MaxVCores), 3, "127.0.0.4");
        scheduler.handle((Event)new NodeAddedSchedulerEvent(node3));
        Assert.assertEquals((long)2L, (long)scheduler.getNumClusterNodes());
        maxVCores = scheduler.getMaximumResourceCapability().getVirtualCores();
        Assert.assertEquals((long)expectedMaxVCores[4], (long)maxVCores);
        scheduler.handle((Event)new NodeRemovedSchedulerEvent(node3));
        Assert.assertEquals((long)1L, (long)scheduler.getNumClusterNodes());
        maxVCores = scheduler.getMaximumResourceCapability().getVirtualCores();
        Assert.assertEquals((long)expectedMaxVCores[5], (long)maxVCores);
        scheduler.handle((Event)new NodeRemovedSchedulerEvent(node2));
        Assert.assertEquals((long)0L, (long)scheduler.getNumClusterNodes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateMaxAllocationUsesTotal() throws IOException {
        int configuredMaxVCores = 20;
        int configuredMaxMemory = 10240;
        Resource configuredMaximumResource = Resource.newInstance((int)10240, (int)20);
        YarnConfiguration conf = this.getConf();
        conf.setInt("yarn.scheduler.maximum-allocation-vcores", 20);
        conf.setInt("yarn.scheduler.maximum-allocation-mb", 10240);
        conf.setLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 0L);
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm.getResourceScheduler();
            Resource emptyResource = Resource.newInstance((int)0, (int)0);
            Resource fullResource1 = Resource.newInstance((int)1024, (int)5);
            Resource fullResource2 = Resource.newInstance((int)2048, (int)10);
            SchedulerNode mockNode1 = (SchedulerNode)Mockito.mock(SchedulerNode.class);
            Mockito.when((Object)mockNode1.getNodeID()).thenReturn((Object)NodeId.newInstance((String)"foo", (int)8080));
            Mockito.when((Object)mockNode1.getUnallocatedResource()).thenReturn((Object)emptyResource);
            Mockito.when((Object)mockNode1.getTotalResource()).thenReturn((Object)fullResource1);
            SchedulerNode mockNode2 = (SchedulerNode)Mockito.mock(SchedulerNode.class);
            Mockito.when((Object)mockNode1.getNodeID()).thenReturn((Object)NodeId.newInstance((String)"bar", (int)8081));
            Mockito.when((Object)mockNode2.getUnallocatedResource()).thenReturn((Object)emptyResource);
            Mockito.when((Object)mockNode2.getTotalResource()).thenReturn((Object)fullResource2);
            this.verifyMaximumResourceCapability(configuredMaximumResource, (YarnScheduler)scheduler);
            scheduler.nodeTracker.addNode(mockNode1);
            this.verifyMaximumResourceCapability(fullResource1, (YarnScheduler)scheduler);
            scheduler.nodeTracker.addNode(mockNode2);
            this.verifyMaximumResourceCapability(fullResource2, (YarnScheduler)scheduler);
            scheduler.nodeTracker.removeNode(mockNode2.getNodeID());
            this.verifyMaximumResourceCapability(fullResource1, (YarnScheduler)scheduler);
            scheduler.nodeTracker.removeNode(mockNode1.getNodeID());
            this.verifyMaximumResourceCapability(configuredMaximumResource, (YarnScheduler)scheduler);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxAllocationAfterUpdateNodeResource() throws IOException {
        int configuredMaxVCores = 20;
        int configuredMaxMemory = 10240;
        Resource configuredMaximumResource = Resource.newInstance((int)10240, (int)20);
        YarnConfiguration conf = this.getConf();
        conf.setInt("yarn.scheduler.maximum-allocation-vcores", 20);
        conf.setInt("yarn.scheduler.maximum-allocation-mb", 10240);
        conf.setLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 0L);
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm.getResourceScheduler();
            this.verifyMaximumResourceCapability(configuredMaximumResource, (YarnScheduler)scheduler);
            Resource resource1 = Resource.newInstance((int)2048, (int)5);
            Resource resource2 = Resource.newInstance((int)4096, (int)10);
            Resource resource3 = Resource.newInstance((int)512, (int)1);
            Resource resource4 = Resource.newInstance((int)1024, (int)2);
            RMNode node1 = MockNodes.newNodeInfo(0, resource1, 1, "127.0.0.2");
            scheduler.handle((Event)new NodeAddedSchedulerEvent(node1));
            RMNode node2 = MockNodes.newNodeInfo(0, resource3, 2, "127.0.0.3");
            scheduler.handle((Event)new NodeAddedSchedulerEvent(node2));
            this.verifyMaximumResourceCapability(resource1, (YarnScheduler)scheduler);
            scheduler.updateNodeResource(node1, ResourceOption.newInstance((Resource)resource2, (int)0));
            this.verifyMaximumResourceCapability(resource2, (YarnScheduler)scheduler);
            scheduler.updateNodeResource(node1, ResourceOption.newInstance((Resource)resource1, (int)0));
            this.verifyMaximumResourceCapability(resource1, (YarnScheduler)scheduler);
            scheduler.updateNodeResource(node2, ResourceOption.newInstance((Resource)resource4, (int)0));
            this.verifyMaximumResourceCapability(resource1, (YarnScheduler)scheduler);
            scheduler.updateNodeResource(node2, ResourceOption.newInstance((Resource)resource3, (int)0));
            this.verifyMaximumResourceCapability(resource1, (YarnScheduler)scheduler);
        }
        finally {
            rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testReleasedContainerIfAppAttemptisNull() throws Exception {
        YarnConfiguration conf = this.getConf();
        conf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)conf);
        MockRM rm1 = new MockRM((Configuration)conf, (RMStateStore)memStore);
        try {
            rm1.start();
            MockNM nm1 = new MockNM("127.0.0.1:1234", 8192, rm1.getResourceTrackerService());
            nm1.registerNode();
            AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm1.getResourceScheduler();
            MockRMApp mockAPp = new MockRMApp(125, System.currentTimeMillis(), RMAppState.NEW);
            SchedulerApplication application = new SchedulerApplication(null, mockAPp.getUser());
            RMApp app = rm1.submitApp(200);
            MockAM am1 = MockRM.launchAndRegisterAM(app, rm1, nm1);
            ContainerId runningContainer = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
            am1.allocate(null, Arrays.asList(runningContainer));
            Map schedulerApplications = scheduler.getSchedulerApplications();
            SchedulerApplication schedulerApp = (SchedulerApplication)scheduler.getSchedulerApplications().get(app.getApplicationId());
            schedulerApplications.put(mockAPp.getApplicationId(), application);
            scheduler.clearPendingContainerCache();
            Assert.assertEquals((String)"Pending containers are not released when one of the application attempt is null !", (long)schedulerApp.getCurrentAppAttempt().getPendingRelease().size(), (long)0L);
        }
        finally {
            if (rm1 != null) {
                rm1.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testResourceRequestRestoreWhenRMContainerIsAtAllocated() throws Exception {
        this.configureScheduler();
        YarnConfiguration conf = this.getConf();
        MockRM rm1 = new MockRM((Configuration)conf);
        try {
            rm1.start();
            RMApp app1 = rm1.submitApp(200, "name", "user", new HashMap<ApplicationAccessType, String>(), false, "default", -1, null, "Test", false, true);
            MockNM nm1 = new MockNM("127.0.0.1:1234", 10240, rm1.getResourceTrackerService());
            nm1.registerNode();
            MockNM nm2 = new MockNM("127.0.0.1:2351", 10240, rm1.getResourceTrackerService());
            nm2.registerNode();
            MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
            int NUM_CONTAINERS = 1;
            am1.allocate("127.0.0.1", 1024, NUM_CONTAINERS, new ArrayList<ContainerId>());
            nm1.nodeHeartbeat(true);
            List containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
            while (containers.size() != NUM_CONTAINERS) {
                nm1.nodeHeartbeat(true);
                containers.addAll(am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
                Thread.sleep(200L);
            }
            nm1.nodeHeartbeat(am1.getApplicationAttemptId(), 2L, ContainerState.RUNNING);
            ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
            rm1.waitForState(nm1, containerId2, RMContainerState.RUNNING);
            am1.allocate("127.0.0.1", 1024, NUM_CONTAINERS, new ArrayList<ContainerId>());
            nm2.nodeHeartbeat(true);
            ContainerId containerId3 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L);
            rm1.waitForContainerAllocated(nm2, containerId3);
            rm1.waitForState(nm2, containerId3, RMContainerState.ALLOCATED);
            nm2.registerNode();
            rm1.waitForState(nm2, containerId3, RMContainerState.KILLED);
            containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
            while (containers.size() != NUM_CONTAINERS) {
                nm2.nodeHeartbeat(true);
                containers.addAll(am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
                Thread.sleep(200L);
            }
            nm2.nodeHeartbeat(am1.getApplicationAttemptId(), 4L, ContainerState.RUNNING);
            ContainerId containerId4 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)4L);
            rm1.waitForState(nm2, containerId4, RMContainerState.RUNNING);
        }
        finally {
            rm1.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResourceRequestRecoveryToTheRightAppAttempt() throws Exception {
        this.configureScheduler();
        YarnConfiguration conf = this.getConf();
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            RMApp rmApp = rm.submitApp(200, "name", "user", new HashMap<ApplicationAccessType, String>(), false, "default", -1, null, "Test", false, true);
            MockNM node = new MockNM("127.0.0.1:1234", 10240, rm.getResourceTrackerService());
            node.registerNode();
            MockAM am1 = MockRM.launchAndRegisterAM(rmApp, rm, node);
            ApplicationAttemptId applicationAttemptOneID = am1.getApplicationAttemptId();
            ContainerId am1ContainerID = ContainerId.newContainerId((ApplicationAttemptId)applicationAttemptOneID, (long)1L);
            am1.allocate("127.0.0.1", 1024, 1, new ArrayList<ContainerId>());
            node.nodeHeartbeat(true);
            List containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
            while (containers.size() != 1) {
                node.nodeHeartbeat(true);
                containers.addAll(am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
                Thread.sleep(200L);
            }
            node.nodeHeartbeat(applicationAttemptOneID, 2L, ContainerState.RUNNING);
            ContainerId runningContainerID = ContainerId.newContainerId((ApplicationAttemptId)applicationAttemptOneID, (long)2L);
            rm.waitForState(node, runningContainerID, RMContainerState.RUNNING);
            int ALLOCATED_CONTAINER_PRIORITY = 1047;
            am1.allocate("127.0.0.1", 1024, 1, ALLOCATED_CONTAINER_PRIORITY, new ArrayList<ContainerId>(), null);
            node.nodeHeartbeat(true);
            ContainerId allocatedContainerID = ContainerId.newContainerId((ApplicationAttemptId)applicationAttemptOneID, (long)3L);
            rm.waitForContainerAllocated(node, allocatedContainerID);
            rm.waitForState(node, allocatedContainerID, RMContainerState.ALLOCATED);
            RMContainer allocatedContainer = rm.getResourceScheduler().getRMContainer(allocatedContainerID);
            SchedulerApplicationAttempt firstSchedulerAppAttempt = ((AbstractYarnScheduler)rm.getResourceScheduler()).getApplicationAttempt(applicationAttemptOneID);
            node.nodeHeartbeat(applicationAttemptOneID, 1L, ContainerState.COMPLETE);
            rm.waitForContainerState(am1ContainerID, RMContainerState.COMPLETED, 30000);
            RMAppAttempt rmAppAttempt2 = MockRM.waitForAttemptScheduled(rmApp, rm);
            ApplicationAttemptId applicationAttemptTwoID = rmAppAttempt2.getAppAttemptId();
            Assert.assertEquals((long)2L, (long)applicationAttemptTwoID.getAttemptId());
            Assert.assertEquals((Object)RMContainerState.KILLED, (Object)allocatedContainer.getState());
            for (ResourceRequest request : firstSchedulerAppAttempt.getAppSchedulingInfo().getAllResourceRequests()) {
                if (request.getPriority().getPriority() == 0) {
                    Assert.assertEquals((long)0L, (long)request.getNumContainers());
                    continue;
                }
                if (request.getPriority().getPriority() != ALLOCATED_CONTAINER_PRIORITY) continue;
                Assert.assertEquals((long)1L, (long)request.getNumContainers());
            }
            MockRM.launchAM(rmApp, rm, node);
            List transferredContainers = rm.getResourceScheduler().getTransferredContainers(applicationAttemptTwoID);
            Assert.assertEquals((long)1L, (long)transferredContainers.size());
            Assert.assertEquals((Object)runningContainerID, (Object)((Container)transferredContainers.get(0)).getId());
        }
        finally {
            rm.stop();
        }
    }

    private void verifyMaximumResourceCapability(Resource expectedMaximumResource, YarnScheduler scheduler) {
        Resource schedulerMaximumResourceCapability = scheduler.getMaximumResourceCapability();
        Assert.assertEquals((long)expectedMaximumResource.getMemory(), (long)schedulerMaximumResourceCapability.getMemory());
        Assert.assertEquals((long)expectedMaximumResource.getVirtualCores(), (long)schedulerMaximumResourceCapability.getVirtualCores());
    }

    private ResourceTrackerService getPrivateResourceTrackerService(Dispatcher privateDispatcher, ResourceManager rm, SleepHandler sleepHandler) {
        YarnConfiguration conf = this.getConf();
        RMContextImpl privateContext = new RMContextImpl(privateDispatcher, null, null, null, null, null, null, null, null, null);
        privateContext.setNodeLabelManager((RMNodeLabelsManager)Mockito.mock(RMNodeLabelsManager.class));
        privateDispatcher.register(SchedulerEventType.class, (EventHandler)sleepHandler);
        privateDispatcher.register(SchedulerEventType.class, (EventHandler)rm.getResourceScheduler());
        privateDispatcher.register(RMNodeEventType.class, (EventHandler)new ResourceManager.NodeEventDispatcher((RMContext)privateContext));
        ((Service)privateDispatcher).init((Configuration)conf);
        ((Service)privateDispatcher).start();
        NMLivelinessMonitor nmLivelinessMonitor = new NMLivelinessMonitor(privateDispatcher);
        nmLivelinessMonitor.init((Configuration)conf);
        nmLivelinessMonitor.start();
        NodesListManager nodesListManager = new NodesListManager((RMContext)privateContext);
        nodesListManager.init((Configuration)conf);
        RMContainerTokenSecretManager containerTokenSecretManager = new RMContainerTokenSecretManager((Configuration)conf);
        containerTokenSecretManager.start();
        NMTokenSecretManagerInRM nmTokenSecretManager = new NMTokenSecretManagerInRM((Configuration)conf);
        nmTokenSecretManager.start();
        ResourceTrackerService privateResourceTrackerService = new ResourceTrackerService((RMContext)privateContext, nodesListManager, nmLivelinessMonitor, containerTokenSecretManager, nmTokenSecretManager);
        privateResourceTrackerService.init((Configuration)conf);
        privateResourceTrackerService.start();
        rm.getResourceScheduler().setRMContext((RMContext)privateContext);
        return privateResourceTrackerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testNodemanagerReconnect() throws Exception {
        this.configureScheduler();
        YarnConfiguration conf = this.getConf();
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            conf.setBoolean("yarn.dispatcher.exit-on-error", false);
            DrainDispatcher privateDispatcher = new DrainDispatcher();
            SleepHandler sleepHandler = new SleepHandler();
            ResourceTrackerService privateResourceTrackerService = this.getPrivateResourceTrackerService((Dispatcher)privateDispatcher, rm, sleepHandler);
            String hostname1 = "localhost1";
            Resource capability = BuilderUtils.newResource((int)4096, (int)4);
            RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
            RegisterNodeManagerRequest request1 = (RegisterNodeManagerRequest)recordFactory.newRecordInstance(RegisterNodeManagerRequest.class);
            NodeId nodeId1 = NodeId.newInstance((String)hostname1, (int)0);
            request1.setNodeId(nodeId1);
            request1.setHttpPort(0);
            request1.setResource(capability);
            privateResourceTrackerService.registerNodeManager(request1);
            privateDispatcher.await();
            Resource clusterResource = rm.getResourceScheduler().getClusterResource();
            Assert.assertEquals((String)"Initial cluster resources don't match", (Object)capability, (Object)clusterResource);
            Resource newCapability = BuilderUtils.newResource((int)1024, (int)1);
            RegisterNodeManagerRequest request2 = (RegisterNodeManagerRequest)recordFactory.newRecordInstance(RegisterNodeManagerRequest.class);
            request2.setNodeId(nodeId1);
            request2.setHttpPort(0);
            request2.setResource(newCapability);
            sleepHandler.sleepFlag = true;
            privateResourceTrackerService.registerNodeManager(request2);
            privateDispatcher.await();
            Assert.assertEquals((String)"Cluster resources don't match", (Object)newCapability, (Object)rm.getResourceScheduler().getClusterResource());
            privateResourceTrackerService.stop();
        }
        finally {
            rm.stop();
        }
    }

    private class SleepHandler
    implements EventHandler<SchedulerEvent> {
        boolean sleepFlag = false;
        int sleepTime = 20;

        private SleepHandler() {
        }

        public void handle(SchedulerEvent event) {
            try {
                if (this.sleepFlag) {
                    Thread.sleep(this.sleepTime);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

