/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.ArrayList;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAppSchedulingInfo {
    @Test
    public void testBacklistChanged() {
        ApplicationId appIdImpl = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appIdImpl, (int)1);
        FSLeafQueue queue = (FSLeafQueue)Mockito.mock(FSLeafQueue.class);
        ((FSLeafQueue)Mockito.doReturn((Object)"test").when((Object)queue)).getQueueName();
        AppSchedulingInfo appSchedulingInfo = new AppSchedulingInfo(appAttemptId, "test", (Queue)queue, null, 0L, new ResourceUsage());
        appSchedulingInfo.updateBlacklist(new ArrayList(), new ArrayList());
        Assert.assertFalse((boolean)appSchedulingInfo.getAndResetBlacklistChanged());
        ArrayList<String> blacklistAdditions = new ArrayList<String>();
        blacklistAdditions.add("node1");
        blacklistAdditions.add("node2");
        appSchedulingInfo.updateBlacklist(blacklistAdditions, new ArrayList());
        Assert.assertTrue((boolean)appSchedulingInfo.getAndResetBlacklistChanged());
        blacklistAdditions.clear();
        blacklistAdditions.add("node1");
        appSchedulingInfo.updateBlacklist(blacklistAdditions, new ArrayList());
        Assert.assertFalse((boolean)appSchedulingInfo.getAndResetBlacklistChanged());
        ArrayList<String> blacklistRemovals = new ArrayList<String>();
        blacklistRemovals.add("node1");
        appSchedulingInfo.updateBlacklist(new ArrayList(), blacklistRemovals);
        appSchedulingInfo.updateBlacklist(new ArrayList(), blacklistRemovals);
        Assert.assertTrue((boolean)appSchedulingInfo.getAndResetBlacklistChanged());
        appSchedulingInfo.updateBlacklist(new ArrayList(), blacklistRemovals);
        Assert.assertFalse((boolean)appSchedulingInfo.getAndResetBlacklistChanged());
    }
}

