/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestApplicationLimitsByPartition {
    static final int GB = 1024;
    LeafQueue queue;
    RMNodeLabelsManager mgr;
    private YarnConfiguration conf;
    RMContext rmContext = null;

    @Before
    public void setUp() throws IOException {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init((Configuration)this.conf);
    }

    private void simpleNodeLabelMappingToManager() throws IOException {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), TestUtils.toSet("x"), (Object)NodeId.newInstance((String)"h2", (int)0), TestUtils.toSet("y")));
    }

    private void complexNodeLabelMappingToManager() throws IOException {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y", (Object)"z"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), TestUtils.toSet("x"), (Object)NodeId.newInstance((String)"h2", (int)0), TestUtils.toSet("y"), (Object)NodeId.newInstance((String)"h3", (int)0), TestUtils.toSet("y"), (Object)NodeId.newInstance((String)"h4", (int)0), TestUtils.toSet("z"), (Object)NodeId.newInstance((String)"h5", (int)0), (Object)RMNodeLabelsManager.EMPTY_STRING_SET));
    }

    @Test(timeout=120000L)
    public void testAMResourceLimitWithLabels() throws Exception {
        this.simpleNodeLabelMappingToManager();
        CapacitySchedulerConfiguration config = (CapacitySchedulerConfiguration)TestUtils.getConfigurationWithQueueLabels((Configuration)this.conf);
        String A1 = "root.a.a1";
        String C1 = "root.c.c1";
        config.setMaximumAMResourcePercentPerPartition("root.a.a1", "x", 0.2f);
        config.setMaximumApplicationMasterResourcePerQueuePercent("root.c.c1", 0.2f);
        MockRM rm1 = new MockRM((Configuration)config){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestApplicationLimitsByPartition.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 10240);
        rm1.registerNode("h2:1234", 10240);
        MockNM nm3 = rm1.registerNode("h3:1234", 10240);
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "a1", "x");
        RMApp app2 = rm1.submitApp(1024, "app", "user", null, "a1", "x");
        RMApp pendingApp = rm1.submitApp(1024, "app", "user", null, "a1", "x");
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        LeafQueue leafQueue = (LeafQueue)cs.getQueue("a1");
        Assert.assertNotNull((Object)leafQueue);
        Assert.assertEquals((long)2L, (long)leafQueue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)leafQueue.getNumPendingApplications());
        Assert.assertTrue((String)"AM diagnostics not set properly", (boolean)app1.getDiagnostics().toString().contains(SchedulerApplicationAttempt.AMState.ACTIVATED.getDiagnosticMessage()));
        Assert.assertTrue((String)"AM diagnostics not set properly", (boolean)app2.getDiagnostics().toString().contains(SchedulerApplicationAttempt.AMState.ACTIVATED.getDiagnosticMessage()));
        Assert.assertTrue((String)"AM diagnostics not set properly", (boolean)pendingApp.getDiagnostics().toString().contains(SchedulerApplicationAttempt.AMState.INACTIVATED.getDiagnosticMessage()));
        Assert.assertTrue((String)"AM diagnostics not set properly", (boolean)pendingApp.getDiagnostics().toString().contains("Queue's AM resource limit exceeded. "));
        RMApp app3 = rm1.submitApp(1024, "app", "user", null, "c1");
        MockRM.launchAndRegisterAM(app3, rm1, nm3);
        RMApp app4 = rm1.submitApp(1024, "app", "user", null, "c1");
        MockRM.launchAndRegisterAM(app4, rm1, nm3);
        pendingApp = rm1.submitApp(1024, "app", "user", null, "c1");
        leafQueue = (LeafQueue)cs.getQueue("c1");
        Assert.assertNotNull((Object)leafQueue);
        Assert.assertEquals((long)2L, (long)leafQueue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)leafQueue.getNumPendingApplications());
        Assert.assertTrue((String)"AM diagnostics not set properly", (boolean)pendingApp.getDiagnostics().toString().contains(SchedulerApplicationAttempt.AMState.INACTIVATED.getDiagnosticMessage()));
        Assert.assertTrue((String)"AM diagnostics not set properly", (boolean)pendingApp.getDiagnostics().toString().contains("Queue's AM resource limit exceeded. "));
        rm1.killApp(app3.getApplicationId());
        Thread.sleep(1000L);
        Assert.assertEquals((long)2L, (long)leafQueue.getNumActiveApplications());
        Assert.assertEquals((long)0L, (long)leafQueue.getNumPendingApplications());
        rm1.close();
    }

    @Test(timeout=120000L)
    public void testAtleastOneAMRunPerPartition() throws Exception {
        this.simpleNodeLabelMappingToManager();
        CapacitySchedulerConfiguration config = (CapacitySchedulerConfiguration)TestUtils.getConfigurationWithQueueLabels((Configuration)this.conf);
        String A1 = "root.a.a1";
        String C1 = "root.c.c1";
        config.setMaximumAMResourcePercentPerPartition("root.a.a1", "x", 0.15f);
        config.setMaximumApplicationMasterResourcePerQueuePercent("root.c.c1", 0.15f);
        MockRM rm1 = new MockRM((Configuration)config){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestApplicationLimitsByPartition.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 10240);
        rm1.registerNode("h2:1234", 10240);
        MockNM nm3 = rm1.registerNode("h3:1234", 10240);
        RMApp app1 = rm1.submitApp(2048, "app", "user", null, "a1", "x");
        MockRM.launchAndRegisterAM(app1, rm1, nm1);
        rm1.submitApp(1024, "app", "user", null, "a1", "x");
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        LeafQueue leafQueue = (LeafQueue)cs.getQueue("a1");
        Assert.assertNotNull((Object)leafQueue);
        Assert.assertEquals((long)1L, (long)leafQueue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)leafQueue.getNumPendingApplications());
        RMApp app3 = rm1.submitApp(2048, "app", "user", null, "c1");
        MockRM.launchAndRegisterAM(app3, rm1, nm3);
        rm1.submitApp(1024, "app", "user", null, "c1");
        leafQueue = (LeafQueue)cs.getQueue("c1");
        Assert.assertNotNull((Object)leafQueue);
        Assert.assertEquals((long)1L, (long)leafQueue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)leafQueue.getNumPendingApplications());
        rm1.close();
    }

    @Test(timeout=120000L)
    public void testDefaultAMLimitFromQueueForPartition() throws Exception {
        this.simpleNodeLabelMappingToManager();
        CapacitySchedulerConfiguration config = (CapacitySchedulerConfiguration)TestUtils.getConfigurationWithQueueLabels((Configuration)this.conf);
        String A1 = "root.a.a1";
        config.setMaximumApplicationMasterResourcePerQueuePercent("root.a.a1", 0.2f);
        MockRM rm1 = new MockRM((Configuration)config){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestApplicationLimitsByPartition.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 10240);
        rm1.registerNode("h2:1234", 10240);
        rm1.registerNode("h3:1234", 10240);
        RMApp app1 = rm1.submitApp(2048, "app", "user", null, "a1", "x");
        RMApp pendingApp = rm1.submitApp(1024, "app", "user", null, "a1", "x");
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        LeafQueue leafQueue = (LeafQueue)cs.getQueue("a1");
        Assert.assertNotNull((Object)leafQueue);
        Assert.assertEquals((long)1L, (long)leafQueue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)leafQueue.getNumPendingApplications());
        Assert.assertTrue((String)"AM diagnostics not set properly", (boolean)app1.getDiagnostics().toString().contains(SchedulerApplicationAttempt.AMState.ACTIVATED.getDiagnosticMessage()));
        Assert.assertTrue((String)"AM diagnostics not set properly", (boolean)pendingApp.getDiagnostics().toString().contains(SchedulerApplicationAttempt.AMState.INACTIVATED.getDiagnosticMessage()));
        Assert.assertTrue((String)"AM diagnostics not set properly", (boolean)pendingApp.getDiagnostics().toString().contains("Queue's AM resource limit exceeded. "));
        rm1.close();
    }

    @Test(timeout=120000L)
    public void testUserAMResourceLimitWithLabels() throws Exception {
        String user_0 = "user_0";
        String user_1 = "user_1";
        this.simpleNodeLabelMappingToManager();
        CapacitySchedulerConfiguration config = (CapacitySchedulerConfiguration)TestUtils.getConfigurationWithQueueLabels((Configuration)this.conf);
        String A1 = "root.a.a1";
        config.setMaximumAMResourcePercentPerPartition("root.a.a1", "x", 0.4f);
        config.setUserLimit("root.a.a1", 50);
        MockRM rm1 = new MockRM((Configuration)config){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestApplicationLimitsByPartition.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 10240);
        rm1.registerNode("h2:1234", 10240);
        rm1.registerNode("h3:1234", 10240);
        RMApp app1 = rm1.submitApp(1024, "app", "user_0", null, "a1", "x");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        am1.allocate("*", 1024, 15, new ArrayList<ContainerId>(), "");
        RMApp app2 = rm1.submitApp(1024, "app", "user_1", null, "a1", "x");
        MockRM.launchAndRegisterAM(app2, rm1, nm1);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        LeafQueue leafQueue = (LeafQueue)cs.getQueue("a1");
        Assert.assertNotNull((Object)leafQueue);
        Assert.assertEquals((long)2L, (long)leafQueue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)leafQueue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)0L, (long)leafQueue.getNumPendingApplications());
        RMApp app3 = rm1.submitApp(1024, "app", "user_1", null, "a1", "x");
        MockAM am2 = MockRM.launchAndRegisterAM(app3, rm1, nm1);
        am2.allocate("*", 1024, 10, new ArrayList<ContainerId>(), "");
        RMApp pendingApp = rm1.submitApp(1024, "app", "user_1", null, "a1", "x");
        Assert.assertEquals((long)3L, (long)leafQueue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)leafQueue.getNumActiveApplications("user_0"));
        Assert.assertEquals((long)2L, (long)leafQueue.getNumActiveApplications("user_1"));
        Assert.assertEquals((long)1L, (long)leafQueue.getNumPendingApplications("user_1"));
        Assert.assertEquals((long)1L, (long)leafQueue.getNumPendingApplications());
        Assert.assertTrue((String)"AM diagnostics not set properly", (boolean)pendingApp.getDiagnostics().toString().contains(SchedulerApplicationAttempt.AMState.INACTIVATED.getDiagnosticMessage()));
        Assert.assertTrue((String)"AM diagnostics not set properly", (boolean)pendingApp.getDiagnostics().toString().contains("User's AM resource limit exceeded. "));
        rm1.close();
    }

    @Test
    public void testAMResourceLimitForMultipleApplications() throws Exception {
        this.complexNodeLabelMappingToManager();
        CapacitySchedulerConfiguration config = (CapacitySchedulerConfiguration)TestUtils.getComplexConfigurationWithQueueLabels((Configuration)this.conf);
        String A1 = "root.a.a1";
        String B1 = "root.b.b1";
        config.setMaximumAMResourcePercentPerPartition("root.a.a1", "y", 0.25f);
        config.setMaximumApplicationMasterResourcePerQueuePercent("root.b.b1", 0.15f);
        MockRM rm1 = new MockRM((Configuration)config){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestApplicationLimitsByPartition.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        rm1.registerNode("h1:1234", 10240);
        MockNM nm2 = rm1.registerNode("h2:1234", 10240);
        MockNM nm3 = rm1.registerNode("h3:1234", 10240);
        rm1.registerNode("h4:1234", 10240);
        MockNM nm5 = rm1.registerNode("h5:1234", 10240);
        RMApp app1 = rm1.submitApp(2048, "app", "user", null, "a1", "y");
        MockRM.launchAndRegisterAM(app1, rm1, nm2);
        RMApp app2 = rm1.submitApp(1024, "app", "user", null, "a1", "y");
        MockRM.launchAndRegisterAM(app2, rm1, nm3);
        rm1.submitApp(1024, "app", "user", null, "a1", "y");
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        LeafQueue leafQueue = (LeafQueue)cs.getQueue("a1");
        Assert.assertNotNull((Object)leafQueue);
        Assert.assertEquals((long)2L, (long)leafQueue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)leafQueue.getNumPendingApplications());
        RMApp app3 = rm1.submitApp(1024, "app", "user", null, "b1");
        MockRM.launchAndRegisterAM(app3, rm1, nm5);
        rm1.submitApp(1024, "app", "user", null, "b1");
        leafQueue = (LeafQueue)cs.getQueue("b1");
        Assert.assertNotNull((Object)leafQueue);
        Assert.assertEquals((long)1L, (long)leafQueue.getNumActiveApplications());
        Assert.assertEquals((long)1L, (long)leafQueue.getNumPendingApplications());
        rm1.close();
    }
}

