/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtilTestHelper;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.api.ContainerType;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.RMSecretManagerService;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestContainerAllocation {
    private static final Log LOG = LogFactory.getLog(TestContainerAllocation.class);
    private final int GB = 1024;
    private YarnConfiguration conf;
    RMNodeLabelsManager mgr;
    private volatile int numRetries = 0;

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init((Configuration)this.conf);
    }

    @Test(timeout=3000000L)
    public void testExcessReservationThanNodeManagerCapacity() throws Exception {
        MockRM rm = new MockRM((Configuration)this.conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 2048, 4);
        MockNM nm2 = rm.registerNode("127.0.0.1:2234", 3072, 4);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        int waitCount = 20;
        int size = rm.getRMContext().getRMNodes().size();
        while ((size = rm.getRMContext().getRMNodes().size()) != 2 && waitCount-- > 0) {
            LOG.info((Object)("Waiting for node managers to register : " + size));
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)2L, (long)rm.getRMContext().getRMNodes().size());
        RMApp app1 = rm.submitApp(128);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        LOG.info((Object)"sending container requests ");
        am1.addRequests(new String[]{"*"}, 2048, 1, 1);
        AllocateResponse alloc1Response = am1.schedule();
        nm1.nodeHeartbeat(true);
        int waitCounter = 20;
        LOG.info((Object)"heartbeating nm1");
        while (alloc1Response.getAllocatedContainers().size() < 1 && waitCounter-- > 0) {
            LOG.info((Object)"Waiting for containers to be created for app 1...");
            Thread.sleep(500L);
            alloc1Response = am1.schedule();
        }
        LOG.info((Object)("received container : " + alloc1Response.getAllocatedContainers().size()));
        Assert.assertTrue((alloc1Response.getAllocatedContainers().size() == 0 ? 1 : 0) != 0);
        LOG.info((Object)"heartbeating nm2");
        waitCounter = 20;
        nm2.nodeHeartbeat(true);
        while (alloc1Response.getAllocatedContainers().size() < 1 && waitCounter-- > 0) {
            LOG.info((Object)"Waiting for containers to be created for app 1...");
            Thread.sleep(500L);
            alloc1Response = am1.schedule();
        }
        LOG.info((Object)("received container : " + alloc1Response.getAllocatedContainers().size()));
        Assert.assertTrue((alloc1Response.getAllocatedContainers().size() == 1 ? 1 : 0) != 0);
        rm.stop();
    }

    @Test
    public void testContainerTokenGeneratedOnPullRequest() throws Exception {
        MockRM rm1 = new MockRM((Configuration)this.conf);
        rm1.start();
        MockNM nm1 = rm1.registerNode("127.0.0.1:1234", 8000);
        RMApp app1 = rm1.submitApp(200);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        am1.allocate("127.0.0.1", 1024, 1, new ArrayList<ContainerId>());
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        rm1.waitForState(nm1, containerId2, RMContainerState.ALLOCATED);
        RMContainer container = rm1.getResourceScheduler().getRMContainer(containerId2);
        Assert.assertEquals((Object)containerId2, (Object)container.getContainerId());
        Assert.assertNull((Object)container.getContainer().getContainerToken());
        List containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        Assert.assertEquals((Object)containerId2, (Object)((Container)containers.get(0)).getId());
        Assert.assertNotNull((Object)((Container)containers.get(0)).getContainerToken());
        rm1.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNormalContainerAllocationWhenDNSUnavailable() throws Exception {
        List containers;
        MockRM rm1 = new MockRM((Configuration)this.conf);
        rm1.start();
        MockNM nm1 = rm1.registerNode("unknownhost:1234", 8000);
        RMApp app1 = rm1.submitApp(200);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        am1.allocate("127.0.0.1", 1024, 1, new ArrayList<ContainerId>());
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        rm1.waitForState(nm1, containerId2, RMContainerState.ALLOCATED);
        SecurityUtilTestHelper.setTokenServiceUseIp((boolean)true);
        try {
            containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
            Assert.assertEquals((long)0L, (long)containers.size());
        }
        finally {
            SecurityUtilTestHelper.setTokenServiceUseIp((boolean)false);
        }
        containers = am1.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        Assert.assertEquals((long)1L, (long)containers.size());
    }

    @Test
    public void testLogAggregationContextPassedIntoContainerToken() throws Exception {
        MockRM rm1 = new MockRM((Configuration)this.conf);
        rm1.start();
        MockNM nm1 = rm1.registerNode("127.0.0.1:1234", 8000);
        MockNM nm2 = rm1.registerNode("127.0.0.1:2345", 8000);
        Assert.assertNull((Object)this.getLogAggregationContextFromContainerToken(rm1, nm1, null));
        LogAggregationContext logAggregationContext = LogAggregationContext.newInstance((String)"includePattern", (String)"excludePattern", (String)"rolledLogsIncludePattern", (String)"rolledLogsExcludePattern", (String)"policyClass", (String)"policyParameters");
        LogAggregationContext returned = this.getLogAggregationContextFromContainerToken(rm1, nm2, logAggregationContext);
        Assert.assertEquals((Object)"includePattern", (Object)returned.getIncludePattern());
        Assert.assertEquals((Object)"excludePattern", (Object)returned.getExcludePattern());
        Assert.assertEquals((Object)"rolledLogsIncludePattern", (Object)returned.getRolledLogsIncludePattern());
        Assert.assertEquals((Object)"rolledLogsExcludePattern", (Object)returned.getRolledLogsExcludePattern());
        Assert.assertEquals((Object)"policyClass", (Object)returned.getLogAggregationPolicyClassName());
        Assert.assertEquals((Object)"policyParameters", (Object)returned.getLogAggregationPolicyParameters());
        rm1.stop();
    }

    private LogAggregationContext getLogAggregationContextFromContainerToken(MockRM rm1, MockNM nm1, LogAggregationContext logAggregationContext) throws Exception {
        RMApp app2 = rm1.submitApp(200, logAggregationContext);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm1);
        nm1.nodeHeartbeat(true);
        am2.allocate("127.0.0.1", 512, 1, new ArrayList<ContainerId>());
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)2L);
        rm1.waitForState(nm1, containerId, RMContainerState.ALLOCATED);
        List containers = am2.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        Assert.assertEquals((Object)containerId, (Object)((Container)containers.get(0)).getId());
        Assert.assertNotNull((Object)((Container)containers.get(0)).getContainerToken());
        ContainerTokenIdentifier token = BuilderUtils.newContainerTokenIdentifier((Token)((Container)containers.get(0)).getContainerToken());
        return token.getLogAggregationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testAMContainerAllocationWhenDNSUnavailable() throws Exception {
        RMApp app1;
        MockRM rm1 = new MockRM((Configuration)this.conf){

            protected RMSecretManagerService createRMSecretManagerService() {
                return new TestRMSecretManagerService((Configuration)TestContainerAllocation.this.conf, this.rmContext);
            }
        };
        rm1.start();
        MockNM nm1 = rm1.registerNode("unknownhost:1234", 8000);
        try {
            SecurityUtilTestHelper.setTokenServiceUseIp((boolean)true);
            app1 = rm1.submitApp(200);
            RMAppAttempt attempt = app1.getCurrentAppAttempt();
            nm1.nodeHeartbeat(true);
            while (this.numRetries <= 5) {
                nm1.nodeHeartbeat(true);
                Thread.sleep(1000L);
                Assert.assertEquals((Object)RMAppAttemptState.SCHEDULED, (Object)attempt.getAppAttemptState());
                System.out.println("Waiting for am container to be allocated.");
            }
        }
        finally {
            SecurityUtilTestHelper.setTokenServiceUseIp((boolean)false);
        }
        MockRM.launchAndRegisterAM(app1, rm1, nm1);
    }

    @Test(timeout=60000L)
    public void testExcessReservationWillBeUnreserved() throws Exception {
        MockRM rm1 = new MockRM();
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        MockNM nm2 = rm1.registerNode("h2:1234", 8192);
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "default");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        RMApp app2 = rm1.submitApp(1024, "app", "user", null, "default");
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm1);
        am1.allocate("*", 4096, 1, new ArrayList<ContainerId>());
        am2.allocate("*", 4096, 1, new ArrayList<ContainerId>());
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        FiCaSchedulerApp schedulerApp1 = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        FiCaSchedulerApp schedulerApp2 = cs.getApplicationAttempt(am2.getApplicationAttemptId());
        Assert.assertEquals((long)2L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)schedulerApp2.getLiveContainers().size());
        Assert.assertTrue((schedulerApp2.getReservedContainers().size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2048L, (long)cs.getNode(nm1.getNodeId()).getUnallocatedResource().getMemory());
        Assert.assertNotNull((Object)cs.getNode(nm1.getNodeId()).getReservedContainer());
        Assert.assertEquals((long)10240L, (long)cs.getRootQueue().getQueueResourceUsage().getUsed().getMemory());
        am2.allocate("*", 4096, 0, new ArrayList<ContainerId>());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        Assert.assertTrue((schedulerApp2.getReservedContainers().size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2048L, (long)cs.getNode(nm1.getNodeId()).getUnallocatedResource().getMemory());
        Assert.assertNull((Object)cs.getNode(nm1.getNodeId()).getReservedContainer());
        Assert.assertEquals((long)6144L, (long)cs.getRootQueue().getQueueResourceUsage().getUsed().getMemory());
        rm1.close();
    }

    private class TestRMSecretManagerService
    extends RMSecretManagerService {
        public TestRMSecretManagerService(Configuration conf, RMContextImpl rmContext) {
            super(conf, rmContext);
        }

        protected RMContainerTokenSecretManager createContainerTokenSecretManager(Configuration conf) {
            return new RMContainerTokenSecretManager(conf){

                public Token createContainerToken(ContainerId containerId, NodeId nodeId, String appSubmitter, Resource capability, Priority priority2, long createTime, LogAggregationContext logAggregationContext, String nodeLabelExp, ContainerType containerType) {
                    TestContainerAllocation.this.numRetries++;
                    return super.createContainerToken(containerId, nodeId, appSubmitter, capability, priority2, createTime, logAggregationContext, nodeLabelExp, containerType);
                }
            };
        }
    }
}

