/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerResourceChangeRequest;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestContainerResizing {
    private static final Log LOG = LogFactory.getLog(TestContainerResizing.class);
    private final int GB = 1024;
    private YarnConfiguration conf;
    RMNodeLabelsManager mgr;

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init((Configuration)this.conf);
    }

    @Test
    public void testSimpleIncreaseContainer() throws Exception {
        MockRM rm1 = new MockRM(){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestContainerResizing.this.mgr;
            }
        };
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 20480);
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "default");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L);
        this.sentRMContainerLaunched(rm1, containerId1);
        am1.sendContainerResizingRequest(Arrays.asList(ContainerResourceChangeRequest.newInstance((ContainerId)containerId1, (Resource)Resources.createResource((int)3072))), null);
        FiCaSchedulerApp app = TestUtils.getFiCaSchedulerApp(rm1, app1.getApplicationId());
        this.checkPendingResource(rm1, "default", 2048, null);
        Assert.assertEquals((long)2048L, (long)app.getAppAttemptResourceUsage().getPending().getMemory());
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        this.checkPendingResource(rm1, "default", 0, null);
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getPending().getMemory());
        this.verifyContainerIncreased(am1.allocate(null, null), containerId1, 3072);
        this.verifyAvailableResourceOfSchedulerNode(rm1, nm1.getNodeId(), 17408);
        rm1.close();
    }

    @Test
    public void testSimpleDecreaseContainer() throws Exception {
        MockRM rm1 = new MockRM(){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestContainerResizing.this.mgr;
            }
        };
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 20480);
        RMApp app1 = rm1.submitApp(3072, "app", "user", null, "default");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        FiCaSchedulerApp app = TestUtils.getFiCaSchedulerApp(rm1, app1.getApplicationId());
        this.checkUsedResource(rm1, "default", 3072, null);
        Assert.assertEquals((long)3072L, (long)app.getAppAttemptResourceUsage().getUsed().getMemory());
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L);
        this.sentRMContainerLaunched(rm1, containerId1);
        AllocateResponse response = am1.sendContainerResizingRequest(null, Arrays.asList(ContainerResourceChangeRequest.newInstance((ContainerId)containerId1, (Resource)Resources.createResource((int)1024))));
        this.verifyContainerDecreased(response, containerId1, 1024);
        this.checkUsedResource(rm1, "default", 1024, null);
        Assert.assertEquals((long)1024L, (long)app.getAppAttemptResourceUsage().getUsed().getMemory());
        RMNodeImpl rmNode = (RMNodeImpl)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        Collection decreasedContainers = rmNode.getToBeDecreasedContainers();
        boolean rmNodeReceivedDecreaseContainer = false;
        for (Container c : decreasedContainers) {
            if (!c.getId().equals((Object)containerId1) || !c.getResource().equals((Object)Resources.createResource((int)1024))) continue;
            rmNodeReceivedDecreaseContainer = true;
        }
        Assert.assertTrue((boolean)rmNodeReceivedDecreaseContainer);
        rm1.close();
    }

    @Test
    public void testSimpleIncreaseRequestReservation() throws Exception {
        MockRM rm1 = new MockRM(){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestContainerResizing.this.mgr;
            }
        };
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        MockNM nm2 = rm1.registerNode("h2:1234", 8192);
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "default");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        FiCaSchedulerApp app = TestUtils.getFiCaSchedulerApp(rm1, app1.getApplicationId());
        am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)2048), (int)1)), null);
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertTrue((boolean)rm1.waitForState(nm1, containerId2, RMContainerState.ALLOCATED, 10000));
        am1.allocate(null, null);
        this.sentRMContainerLaunched(rm1, containerId2);
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L);
        this.sentRMContainerLaunched(rm1, containerId1);
        am1.sendContainerResizingRequest(Arrays.asList(ContainerResourceChangeRequest.newInstance((ContainerId)containerId1, (Resource)Resources.createResource((int)7168))), null);
        this.checkPendingResource(rm1, "default", 6144, null);
        Assert.assertEquals((long)6144L, (long)app.getAppAttemptResourceUsage().getPending().getMemory());
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        RMContainer rmContainer1 = (RMContainer)app.getLiveContainersMap().get(containerId1);
        Assert.assertTrue((boolean)rmContainer1.hasIncreaseReservation());
        Assert.assertEquals((long)6144L, (long)rmContainer1.getReservedResource().getMemory());
        Assert.assertFalse((boolean)app.getReservedContainers().isEmpty());
        Assert.assertNotNull((Object)cs.getNode(nm1.getNodeId()).getReservedContainer());
        this.checkPendingResource(rm1, "default", 6144, null);
        Assert.assertEquals((long)6144L, (long)app.getAppAttemptResourceUsage().getPending().getMemory());
        this.checkUsedResource(rm1, "default", 9216, null);
        Assert.assertEquals((long)9216L, (long)((LeafQueue)cs.getQueue("default")).getUser("user").getUsed().getMemory());
        Assert.assertEquals((long)3072L, (long)app.getAppAttemptResourceUsage().getUsed().getMemory());
        Assert.assertEquals((long)6144L, (long)app.getAppAttemptResourceUsage().getReserved().getMemory());
        am1.allocate(null, Arrays.asList(containerId2));
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        this.verifyContainerIncreased(am1.allocate(null, null), containerId1, 7168);
        Assert.assertFalse((boolean)rmContainer1.hasIncreaseReservation());
        Assert.assertTrue((boolean)app.getReservedContainers().isEmpty());
        Assert.assertNull((Object)cs.getNode(nm1.getNodeId()).getReservedContainer());
        this.checkPendingResource(rm1, "default", 0, null);
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getPending().getMemory());
        this.checkUsedResource(rm1, "default", 7168, null);
        Assert.assertEquals((long)7168L, (long)((LeafQueue)cs.getQueue("default")).getUser("user").getUsed().getMemory());
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getReserved().getMemory());
        Assert.assertEquals((long)7168L, (long)app.getAppAttemptResourceUsage().getUsed().getMemory());
        this.verifyAvailableResourceOfSchedulerNode(rm1, nm1.getNodeId(), 1024);
        rm1.close();
    }

    @Test
    public void testIncreaseRequestWithNoHeadroomLeft() throws Exception {
        MockRM rm1 = new MockRM(){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestContainerResizing.this.mgr;
            }
        };
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "default");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        FiCaSchedulerApp app = TestUtils.getFiCaSchedulerApp(rm1, app1.getApplicationId());
        am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)2048), (int)1)), null);
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertTrue((boolean)rm1.waitForState(nm1, containerId2, RMContainerState.ALLOCATED, 10000));
        am1.allocate(null, null);
        this.sentRMContainerLaunched(rm1, containerId2);
        am1.sendContainerResizingRequest(Arrays.asList(ContainerResourceChangeRequest.newInstance((ContainerId)containerId2, (Resource)Resources.createResource((int)8192))), null);
        this.checkPendingResource(rm1, "default", 6144, null);
        Assert.assertEquals((long)6144L, (long)app.getAppAttemptResourceUsage().getPending().getMemory());
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        RMContainer rmContainer1 = (RMContainer)app.getLiveContainersMap().get(containerId2);
        Assert.assertFalse((boolean)rmContainer1.hasIncreaseReservation());
        Assert.assertTrue((boolean)app.getReservedContainers().isEmpty());
        Assert.assertNull((Object)cs.getNode(nm1.getNodeId()).getReservedContainer());
        this.checkPendingResource(rm1, "default", 6144, null);
        Assert.assertEquals((long)6144L, (long)app.getAppAttemptResourceUsage().getPending().getMemory());
        this.checkUsedResource(rm1, "default", 3072, null);
        Assert.assertEquals((long)3072L, (long)((LeafQueue)cs.getQueue("default")).getUser("user").getUsed().getMemory());
        Assert.assertEquals((long)3072L, (long)app.getAppAttemptResourceUsage().getUsed().getMemory());
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getReserved().getMemory());
        rm1.close();
    }

    @Test
    public void testExcessiveReservationWhenCancelIncreaseRequest() throws Exception {
        MockRM rm1 = new MockRM(){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestContainerResizing.this.mgr;
            }
        };
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        MockNM nm2 = rm1.registerNode("h2:1234", 8192);
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "default");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        FiCaSchedulerApp app = TestUtils.getFiCaSchedulerApp(rm1, app1.getApplicationId());
        am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)2048), (int)1)), null);
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertTrue((boolean)rm1.waitForState(nm1, containerId2, RMContainerState.ALLOCATED, 10000));
        am1.allocate(null, null);
        this.sentRMContainerLaunched(rm1, containerId2);
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L);
        this.sentRMContainerLaunched(rm1, containerId1);
        am1.sendContainerResizingRequest(Arrays.asList(ContainerResourceChangeRequest.newInstance((ContainerId)containerId1, (Resource)Resources.createResource((int)7168))), null);
        this.checkPendingResource(rm1, "default", 6144, null);
        Assert.assertEquals((long)6144L, (long)app.getAppAttemptResourceUsage().getPending().getMemory());
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        RMContainer rmContainer1 = (RMContainer)app.getLiveContainersMap().get(containerId1);
        Assert.assertTrue((boolean)rmContainer1.hasIncreaseReservation());
        Assert.assertEquals((long)6144L, (long)rmContainer1.getReservedResource().getMemory());
        Assert.assertFalse((boolean)app.getReservedContainers().isEmpty());
        Assert.assertNotNull((Object)cs.getNode(nm1.getNodeId()).getReservedContainer());
        this.checkPendingResource(rm1, "default", 6144, null);
        Assert.assertEquals((long)6144L, (long)app.getAppAttemptResourceUsage().getPending().getMemory());
        this.checkUsedResource(rm1, "default", 9216, null);
        Assert.assertEquals((long)9216L, (long)((LeafQueue)cs.getQueue("default")).getUser("user").getUsed().getMemory());
        Assert.assertEquals((long)3072L, (long)app.getAppAttemptResourceUsage().getUsed().getMemory());
        Assert.assertEquals((long)6144L, (long)app.getAppAttemptResourceUsage().getReserved().getMemory());
        am1.allocate(null, Arrays.asList(containerId2));
        am1.sendContainerResizingRequest(Arrays.asList(ContainerResourceChangeRequest.newInstance((ContainerId)containerId1, (Resource)Resources.createResource((int)1024))), null);
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        Assert.assertTrue((boolean)app.getReservedContainers().isEmpty());
        Assert.assertNull((Object)cs.getNode(nm1.getNodeId()).getReservedContainer());
        Assert.assertFalse((boolean)rmContainer1.hasIncreaseReservation());
        this.checkPendingResource(rm1, "default", 0, null);
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getPending().getMemory());
        this.checkUsedResource(rm1, "default", 1024, null);
        Assert.assertEquals((long)1024L, (long)((LeafQueue)cs.getQueue("default")).getUser("user").getUsed().getMemory());
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getReserved().getMemory());
        Assert.assertEquals((long)1024L, (long)app.getAppAttemptResourceUsage().getUsed().getMemory());
        rm1.close();
    }

    @Test
    public void testExcessiveReservationWhenDecreaseSameContainer() throws Exception {
        MockRM rm1 = new MockRM(){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestContainerResizing.this.mgr;
            }
        };
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        MockNM nm2 = rm1.registerNode("h2:1234", 8192);
        RMApp app1 = rm1.submitApp(2048, "app", "user", null, "default");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        FiCaSchedulerApp app = TestUtils.getFiCaSchedulerApp(rm1, app1.getApplicationId());
        am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)2048), (int)1)), null);
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertTrue((boolean)rm1.waitForState(nm1, containerId2, RMContainerState.ALLOCATED, 10000));
        am1.allocate(null, null);
        this.sentRMContainerLaunched(rm1, containerId2);
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L);
        this.sentRMContainerLaunched(rm1, containerId1);
        am1.sendContainerResizingRequest(Arrays.asList(ContainerResourceChangeRequest.newInstance((ContainerId)containerId1, (Resource)Resources.createResource((int)8192))), null);
        this.checkPendingResource(rm1, "default", 6144, null);
        Assert.assertEquals((long)6144L, (long)app.getAppAttemptResourceUsage().getPending().getMemory());
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        RMContainer rmContainer1 = (RMContainer)app.getLiveContainersMap().get(containerId1);
        Assert.assertTrue((boolean)rmContainer1.hasIncreaseReservation());
        Assert.assertEquals((long)6144L, (long)rmContainer1.getReservedResource().getMemory());
        Assert.assertFalse((boolean)app.getReservedContainers().isEmpty());
        Assert.assertNotNull((Object)cs.getNode(nm1.getNodeId()).getReservedContainer());
        this.checkPendingResource(rm1, "default", 6144, null);
        Assert.assertEquals((long)6144L, (long)app.getAppAttemptResourceUsage().getPending().getMemory());
        this.checkUsedResource(rm1, "default", 10240, null);
        Assert.assertEquals((long)10240L, (long)((LeafQueue)cs.getQueue("default")).getUser("user").getUsed().getMemory());
        Assert.assertEquals((long)4096L, (long)app.getAppAttemptResourceUsage().getUsed().getMemory());
        Assert.assertEquals((long)6144L, (long)app.getAppAttemptResourceUsage().getReserved().getMemory());
        am1.allocate(null, Arrays.asList(containerId2));
        am1.sendContainerResizingRequest(null, Arrays.asList(ContainerResourceChangeRequest.newInstance((ContainerId)containerId1, (Resource)Resources.createResource((int)1024))));
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        Assert.assertTrue((boolean)app.getReservedContainers().isEmpty());
        Assert.assertNull((Object)cs.getNode(nm1.getNodeId()).getReservedContainer());
        Assert.assertFalse((boolean)rmContainer1.hasIncreaseReservation());
        this.checkPendingResource(rm1, "default", 0, null);
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getPending().getMemory());
        this.checkUsedResource(rm1, "default", 1024, null);
        Assert.assertEquals((long)1024L, (long)((LeafQueue)cs.getQueue("default")).getUser("user").getUsed().getMemory());
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getReserved().getMemory());
        Assert.assertEquals((long)1024L, (long)app.getAppAttemptResourceUsage().getUsed().getMemory());
        rm1.close();
    }

    @Test
    public void testIncreaseContainerUnreservedWhenContainerCompleted() throws Exception {
        MockRM rm1 = new MockRM(){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestContainerResizing.this.mgr;
            }
        };
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        MockNM nm2 = rm1.registerNode("h2:1234", 8192);
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "default");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        FiCaSchedulerApp app = TestUtils.getFiCaSchedulerApp(rm1, app1.getApplicationId());
        am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)2048), (int)1)), null);
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertTrue((boolean)rm1.waitForState(nm1, containerId2, RMContainerState.ALLOCATED, 10000));
        am1.allocate(null, null);
        this.sentRMContainerLaunched(rm1, containerId2);
        rm1.waitForContainerState(containerId2, RMContainerState.RUNNING);
        am1.sendContainerResizingRequest(Arrays.asList(ContainerResourceChangeRequest.newInstance((ContainerId)containerId2, (Resource)Resources.createResource((int)8192))), null);
        this.checkPendingResource(rm1, "default", 6144, null);
        Assert.assertEquals((long)6144L, (long)app.getAppAttemptResourceUsage().getPending().getMemory());
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        RMContainer rmContainer2 = (RMContainer)app.getLiveContainersMap().get(containerId2);
        Assert.assertTrue((boolean)rmContainer2.hasIncreaseReservation());
        Assert.assertEquals((long)6144L, (long)rmContainer2.getReservedResource().getMemory());
        Assert.assertFalse((boolean)app.getReservedContainers().isEmpty());
        Assert.assertNotNull((Object)cs.getNode(nm1.getNodeId()).getReservedContainer());
        this.checkPendingResource(rm1, "default", 6144, null);
        Assert.assertEquals((long)6144L, (long)app.getAppAttemptResourceUsage().getPending().getMemory());
        this.checkUsedResource(rm1, "default", 9216, null);
        Assert.assertEquals((long)9216L, (long)((LeafQueue)cs.getQueue("default")).getUser("user").getUsed().getMemory());
        Assert.assertEquals((long)3072L, (long)app.getAppAttemptResourceUsage().getUsed().getMemory());
        Assert.assertEquals((long)6144L, (long)app.getAppAttemptResourceUsage().getReserved().getMemory());
        am1.allocate(null, Arrays.asList(containerId2));
        Assert.assertTrue((boolean)app.getReservedContainers().isEmpty());
        Assert.assertNull((Object)cs.getNode(nm1.getNodeId()).getReservedContainer());
        Assert.assertFalse((boolean)rmContainer2.hasIncreaseReservation());
        this.checkPendingResource(rm1, "default", 0, null);
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getPending().getMemory());
        this.checkUsedResource(rm1, "default", 1024, null);
        Assert.assertEquals((long)1024L, (long)((LeafQueue)cs.getQueue("default")).getUser("user").getUsed().getMemory());
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getReserved().getMemory());
        Assert.assertEquals((long)1024L, (long)app.getAppAttemptResourceUsage().getUsed().getMemory());
        rm1.close();
    }

    @Test
    public void testIncreaseContainerUnreservedWhenApplicationCompleted() throws Exception {
        MockRM rm1 = new MockRM(){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestContainerResizing.this.mgr;
            }
        };
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        MockNM nm2 = rm1.registerNode("h2:1234", 8192);
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "default");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        FiCaSchedulerApp app = TestUtils.getFiCaSchedulerApp(rm1, app1.getApplicationId());
        am1.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)2048), (int)1)), null);
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertTrue((boolean)rm1.waitForState(nm1, containerId2, RMContainerState.ALLOCATED, 10000));
        am1.allocate(null, null);
        this.sentRMContainerLaunched(rm1, containerId2);
        am1.sendContainerResizingRequest(Arrays.asList(ContainerResourceChangeRequest.newInstance((ContainerId)containerId2, (Resource)Resources.createResource((int)8192))), null);
        this.checkPendingResource(rm1, "default", 6144, null);
        Assert.assertEquals((long)6144L, (long)app.getAppAttemptResourceUsage().getPending().getMemory());
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        RMContainer rmContainer2 = (RMContainer)app.getLiveContainersMap().get(containerId2);
        Assert.assertTrue((boolean)rmContainer2.hasIncreaseReservation());
        Assert.assertEquals((long)6144L, (long)rmContainer2.getReservedResource().getMemory());
        Assert.assertFalse((boolean)app.getReservedContainers().isEmpty());
        Assert.assertNotNull((Object)cs.getNode(nm1.getNodeId()).getReservedContainer());
        this.checkPendingResource(rm1, "default", 6144, null);
        Assert.assertEquals((long)6144L, (long)app.getAppAttemptResourceUsage().getPending().getMemory());
        this.checkUsedResource(rm1, "default", 9216, null);
        Assert.assertEquals((long)9216L, (long)((LeafQueue)cs.getQueue("default")).getUser("user").getUsed().getMemory());
        Assert.assertEquals((long)3072L, (long)app.getAppAttemptResourceUsage().getUsed().getMemory());
        Assert.assertEquals((long)6144L, (long)app.getAppAttemptResourceUsage().getReserved().getMemory());
        cs.handle((SchedulerEvent)new AppAttemptRemovedSchedulerEvent(am1.getApplicationAttemptId(), RMAppAttemptState.KILLED, false));
        Assert.assertTrue((boolean)app.getReservedContainers().isEmpty());
        Assert.assertNull((Object)cs.getNode(nm1.getNodeId()).getReservedContainer());
        Assert.assertFalse((boolean)rmContainer2.hasIncreaseReservation());
        this.checkPendingResource(rm1, "default", 0, null);
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getPending().getMemory());
        this.checkUsedResource(rm1, "default", 0, null);
        Assert.assertEquals((long)0L, (long)((LeafQueue)cs.getQueue("default")).getUser("user").getUsed().getMemory());
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getReserved().getMemory());
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getUsed().getMemory());
        rm1.close();
    }

    private void allocateAndLaunchContainers(MockAM am, MockNM nm, MockRM rm, int nContainer, int mem, int priority2, int startContainerId) throws Exception {
        am.allocate(Arrays.asList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)priority2), (String)"*", (Resource)Resources.createResource((int)mem), (int)nContainer)), null);
        ContainerId lastContainerId = ContainerId.newContainerId((ApplicationAttemptId)am.getApplicationAttemptId(), (long)(startContainerId + nContainer - 1));
        Assert.assertTrue((boolean)rm.waitForState(nm, lastContainerId, RMContainerState.ALLOCATED, 10000));
        am.allocate(null, null);
        for (int cId = startContainerId; cId < startContainerId + nContainer; ++cId) {
            this.sentRMContainerLaunched(rm, ContainerId.newContainerId((ApplicationAttemptId)am.getApplicationAttemptId(), (long)cId));
            rm.waitForContainerState(ContainerId.newContainerId((ApplicationAttemptId)am.getApplicationAttemptId(), (long)cId), RMContainerState.RUNNING);
        }
    }

    @Test
    public void testOrderOfIncreaseContainerRequestAllocation() throws Exception {
        MockRM rm1 = new MockRM(){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestContainerResizing.this.mgr;
            }
        };
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 10240);
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "default");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        FiCaSchedulerApp app = TestUtils.getFiCaSchedulerApp(rm1, app1.getApplicationId());
        ApplicationAttemptId attemptId = am1.getApplicationAttemptId();
        this.allocateAndLaunchContainers(am1, nm1, rm1, 2, 1024, 3, 2);
        this.allocateAndLaunchContainers(am1, nm1, rm1, 2, 1024, 2, 4);
        this.allocateAndLaunchContainers(am1, nm1, rm1, 2, 1024, 4, 6);
        ArrayList<ContainerResourceChangeRequest> increaseRequests = new ArrayList<ContainerResourceChangeRequest>();
        for (int cId = 2; cId <= 7; ++cId) {
            ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)cId);
            increaseRequests.add(ContainerResourceChangeRequest.newInstance((ContainerId)containerId, (Resource)Resources.createResource((int)2048)));
        }
        am1.sendContainerResizingRequest(increaseRequests, null);
        this.checkPendingResource(rm1, "default", 6144, null);
        Assert.assertEquals((long)6144L, (long)app.getAppAttemptResourceUsage().getPending().getMemory());
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        AllocateResponse allocateResponse = am1.allocate(null, null);
        Assert.assertEquals((long)3L, (long)allocateResponse.getIncreasedContainers().size());
        this.verifyContainerIncreased(allocateResponse, ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)4L), 2048);
        this.verifyContainerIncreased(allocateResponse, ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)5L), 2048);
        this.verifyContainerIncreased(allocateResponse, ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)2L), 2048);
        this.checkPendingResource(rm1, "default", 3072, null);
        Assert.assertEquals((long)3072L, (long)app.getAppAttemptResourceUsage().getPending().getMemory());
        this.checkUsedResource(rm1, "default", 10240, null);
        Assert.assertEquals((long)10240L, (long)((LeafQueue)cs.getQueue("default")).getUser("user").getUsed().getMemory());
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getReserved().getMemory());
        Assert.assertEquals((long)10240L, (long)app.getAppAttemptResourceUsage().getUsed().getMemory());
        rm1.close();
    }

    @Test
    public void testIncreaseContainerRequestGetPreferrence() throws Exception {
        MockRM rm1 = new MockRM(){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestContainerResizing.this.mgr;
            }
        };
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 10240);
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "default");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        FiCaSchedulerApp app = TestUtils.getFiCaSchedulerApp(rm1, app1.getApplicationId());
        ApplicationAttemptId attemptId = am1.getApplicationAttemptId();
        this.allocateAndLaunchContainers(am1, nm1, rm1, 2, 1024, 3, 2);
        this.allocateAndLaunchContainers(am1, nm1, rm1, 2, 1024, 2, 4);
        this.allocateAndLaunchContainers(am1, nm1, rm1, 2, 1024, 4, 6);
        ArrayList<ContainerResourceChangeRequest> increaseRequests = new ArrayList<ContainerResourceChangeRequest>();
        for (int cId = 2; cId <= 7; ++cId) {
            ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)cId);
            increaseRequests.add(ContainerResourceChangeRequest.newInstance((ContainerId)containerId, (Resource)Resources.createResource((int)2048)));
        }
        am1.sendContainerResizingRequest(increaseRequests, null);
        this.checkPendingResource(rm1, "default", 6144, null);
        Assert.assertEquals((long)6144L, (long)app.getAppAttemptResourceUsage().getPending().getMemory());
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        AllocateResponse allocateResponse = am1.allocate(null, null);
        Assert.assertEquals((long)3L, (long)allocateResponse.getIncreasedContainers().size());
        this.verifyContainerIncreased(allocateResponse, ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)4L), 2048);
        this.verifyContainerIncreased(allocateResponse, ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)5L), 2048);
        this.verifyContainerIncreased(allocateResponse, ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)2L), 2048);
        this.checkPendingResource(rm1, "default", 3072, null);
        Assert.assertEquals((long)3072L, (long)app.getAppAttemptResourceUsage().getPending().getMemory());
        this.checkUsedResource(rm1, "default", 10240, null);
        Assert.assertEquals((long)10240L, (long)((LeafQueue)cs.getQueue("default")).getUser("user").getUsed().getMemory());
        Assert.assertEquals((long)0L, (long)app.getAppAttemptResourceUsage().getReserved().getMemory());
        Assert.assertEquals((long)10240L, (long)app.getAppAttemptResourceUsage().getUsed().getMemory());
        rm1.close();
    }

    @Test(timeout=60000L)
    public void testDecreaseContainerWillNotDeadlockContainerAllocation() throws Exception {
        MockRM rm = new MockRM(){

            public ResourceScheduler createScheduler() {
                MyScheduler cs = new MyScheduler();
                cs.setConf((Configuration)TestContainerResizing.this.conf);
                return cs;
            }
        };
        rm.start();
        MockNM nm = rm.registerNode("h1:1234", 20480);
        RMApp app1 = rm.submitApp(3072, "app", "user", null, "default");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm);
        this.checkUsedResource(rm, "default", 3072, null);
        FiCaSchedulerApp app = TestUtils.getFiCaSchedulerApp(rm, app1.getApplicationId());
        Assert.assertEquals((long)3072L, (long)app.getAppAttemptResourceUsage().getUsed().getMemory());
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L);
        this.sentRMContainerLaunched(rm, containerId1);
        am1.allocate(Collections.singletonList(ResourceRequest.newInstance((Priority)Priority.newInstance((int)1), (String)"*", (Resource)Resources.createResource((int)2048), (int)1)), null);
        nm.nodeHeartbeat(true);
        AllocateResponse response = am1.sendContainerResizingRequest(null, Collections.singletonList(ContainerResourceChangeRequest.newInstance((ContainerId)containerId1, (Resource)Resources.createResource((int)1024))));
        this.verifyContainerDecreased(response, containerId1, 1024);
        rm.close();
    }

    private void checkPendingResource(MockRM rm, String queueName, int memory, String label) {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        CSQueue queue = cs.getQueue(queueName);
        Assert.assertEquals((long)memory, (long)queue.getQueueResourceUsage().getPending(label == null ? "" : label).getMemory());
    }

    private void checkUsedResource(MockRM rm, String queueName, int memory, String label) {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        CSQueue queue = cs.getQueue(queueName);
        Assert.assertEquals((long)memory, (long)queue.getQueueResourceUsage().getUsed(label == null ? "" : label).getMemory());
    }

    private void verifyContainerIncreased(AllocateResponse response, ContainerId containerId, int mem) {
        List increasedContainers = response.getIncreasedContainers();
        boolean found = false;
        for (Container c : increasedContainers) {
            if (!c.getId().equals((Object)containerId)) continue;
            found = true;
            Assert.assertEquals((long)mem, (long)c.getResource().getMemory());
        }
        if (!found) {
            Assert.fail((String)("Container not increased: containerId=" + containerId));
        }
    }

    private void verifyContainerDecreased(AllocateResponse response, ContainerId containerId, int mem) {
        List decreasedContainers = response.getDecreasedContainers();
        boolean found = false;
        for (Container c : decreasedContainers) {
            if (!c.getId().equals((Object)containerId)) continue;
            found = true;
            Assert.assertEquals((long)mem, (long)c.getResource().getMemory());
        }
        if (!found) {
            Assert.fail((String)("Container not decreased: containerId=" + containerId));
        }
    }

    private void sentRMContainerLaunched(MockRM rm, ContainerId containerId) {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        RMContainer rmContainer = cs.getRMContainer(containerId);
        if (rmContainer != null) {
            rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.LAUNCHED));
        } else {
            Assert.fail((String)"Cannot find RMContainer");
        }
    }

    private void verifyAvailableResourceOfSchedulerNode(MockRM rm, NodeId nodeId, int expectedMemory) {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        FiCaSchedulerNode node = cs.getNode(nodeId);
        Assert.assertEquals((long)expectedMemory, (long)node.getUnallocatedResource().getMemory());
    }

    class MyScheduler
    extends CapacityScheduler {
        MyScheduler() {
        }

        protected void decreaseContainers(List<ContainerResourceChangeRequest> decreaseRequests, SchedulerApplicationAttempt attempt) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.debug((Object)"Thread interrupted.");
            }
            super.decreaseContainers(decreaseRequests, attempt);
        }

        public synchronized void allocateContainersToNode(FiCaSchedulerNode node) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.debug((Object)"Thread interrupted.");
            }
            super.allocateContainersToNode(node);
        }
    }
}

