/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNodeLabelContainerAllocation {
    private final int GB = 1024;
    private YarnConfiguration conf;
    RMNodeLabelsManager mgr;

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init((Configuration)this.conf);
    }

    private Configuration getConfigurationWithQueueLabels(Configuration config) {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration(config);
        conf.setQueues("root", new String[]{"a", "b", "c"});
        conf.setCapacityByLabel("root", "x", 100.0f);
        conf.setCapacityByLabel("root", "y", 100.0f);
        conf.setCapacityByLabel("root", "z", 100.0f);
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        conf.setMaximumCapacity("root.a", 15.0f);
        conf.setAccessibleNodeLabels("root.a", this.toSet("x"));
        conf.setCapacityByLabel("root.a", "x", 100.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 20.0f);
        conf.setAccessibleNodeLabels("root.b", this.toSet("y", "z"));
        conf.setCapacityByLabel("root.b", "y", 100.0f);
        conf.setCapacityByLabel("root.b", "z", 100.0f);
        String C = "root.c";
        conf.setCapacity("root.c", 70.0f);
        conf.setMaximumCapacity("root.c", 70.0f);
        conf.setAccessibleNodeLabels("root.c", RMNodeLabelsManager.EMPTY_STRING_SET);
        String A1 = "root.a.a1";
        conf.setQueues("root.a", new String[]{"a1"});
        conf.setCapacity("root.a.a1", 100.0f);
        conf.setMaximumCapacity("root.a.a1", 100.0f);
        conf.setCapacityByLabel("root.a.a1", "x", 100.0f);
        String B1 = "root.b.b1";
        conf.setQueues("root.b", new String[]{"b1"});
        conf.setCapacity("root.b.b1", 100.0f);
        conf.setMaximumCapacity("root.b.b1", 100.0f);
        conf.setCapacityByLabel("root.b.b1", "y", 100.0f);
        conf.setCapacityByLabel("root.b.b1", "z", 100.0f);
        String C1 = "root.c.c1";
        conf.setQueues("root.c", new String[]{"c1"});
        conf.setCapacity("root.c.c1", 100.0f);
        conf.setMaximumCapacity("root.c.c1", 100.0f);
        return conf;
    }

    private void checkTaskContainersHost(ApplicationAttemptId attemptId, ContainerId containerId, ResourceManager rm, String host) {
        ResourceScheduler scheduler = rm.getRMContext().getScheduler();
        SchedulerAppReport appReport = scheduler.getSchedulerAppInfo(attemptId);
        Assert.assertTrue((appReport.getLiveContainers().size() > 0 ? 1 : 0) != 0);
        for (RMContainer c : appReport.getLiveContainers()) {
            if (!c.getContainerId().equals((Object)containerId)) continue;
            Assert.assertEquals((Object)host, (Object)c.getAllocatedNode().getHost());
        }
    }

    private <E> Set<E> toSet(E ... elements) {
        HashSet set = Sets.newHashSet((Object[])elements);
        return set;
    }

    @Test(timeout=300000L)
    public void testContainerAllocationWithSingleUserLimits() throws Exception {
        final NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
        mgr.init((Configuration)this.conf);
        mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x"), (Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("y")));
        MockRM rm1 = new MockRM(TestUtils.getConfigurationWithDefaultQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager((RMNodeLabelsManager)mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8000);
        rm1.registerNode("h2:1234", 8000);
        MockNM nm3 = rm1.registerNode("h3:1234", 8000);
        RMApp app1 = rm1.submitApp(200, "app", "user", null, "a1");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "");
        Assert.assertTrue((boolean)rm1.waitForState(nm3, containerId, RMContainerState.ALLOCATED, 10000));
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "");
        Assert.assertFalse((boolean)rm1.waitForState(nm3, containerId, RMContainerState.ALLOCATED, 10000));
        for (int id = 3; id <= 8; ++id) {
            containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)id);
            am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
            Assert.assertTrue((boolean)rm1.waitForState(nm1, containerId, RMContainerState.ALLOCATED, 10000));
        }
        rm1.close();
    }

    @Test(timeout=300000L)
    public void testContainerAllocateWithComplexLabels() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y", (Object)"z"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x"), (Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("y"), (Object)NodeId.newInstance((String)"h3", (int)0), this.toSet("y"), (Object)NodeId.newInstance((String)"h4", (int)0), this.toSet("z"), (Object)NodeId.newInstance((String)"h5", (int)0), (Object)RMNodeLabelsManager.EMPTY_STRING_SET));
        MockRM rm1 = new MockRM(TestUtils.getComplexConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 2048);
        MockNM nm2 = rm1.registerNode("h2:1234", 2048);
        MockNM nm3 = rm1.registerNode("h3:1234", 2048);
        MockNM nm4 = rm1.registerNode("h4:1234", 2048);
        MockNM nm5 = rm1.registerNode("h5:1234", 2048);
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "a1");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "y");
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertTrue((boolean)rm1.waitForState(nm2, containerId, RMContainerState.ALLOCATED, 10000));
        this.checkTaskContainersHost(am1.getApplicationAttemptId(), containerId, rm1, "h2");
        RMApp app2 = rm1.submitApp(1024, "app", "user", null, "b1");
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm5);
        am2.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm4, containerId, RMContainerState.ALLOCATED, 10000));
        Assert.assertFalse((boolean)rm1.waitForState(nm5, containerId, RMContainerState.ALLOCATED, 10000));
        RMApp app3 = rm1.submitApp(1024, "app", "user", null, "b2");
        MockAM am3 = MockRM.launchAndRegisterAM(app3, rm1, nm5);
        am3.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "y");
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am3.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm1, containerId, RMContainerState.ALLOCATED, 10000));
        Assert.assertTrue((boolean)rm1.waitForState(nm3, containerId, RMContainerState.ALLOCATED, 10000));
        this.checkTaskContainersHost(am3.getApplicationAttemptId(), containerId, rm1, "h3");
        am3.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "z");
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am3.getApplicationAttemptId(), (long)3L);
        Assert.assertTrue((boolean)rm1.waitForState(nm4, containerId, RMContainerState.ALLOCATED, 10000));
        this.checkTaskContainersHost(am3.getApplicationAttemptId(), containerId, rm1, "h4");
        rm1.close();
    }

    @Test(timeout=120000L)
    public void testContainerAllocateWithLabels() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x"), (Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("y")));
        MockRM rm1 = new MockRM(this.getConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8000);
        MockNM nm2 = rm1.registerNode("h2:1234", 8000);
        MockNM nm3 = rm1.registerNode("h3:1234", 8000);
        RMApp app1 = rm1.submitApp(200, "app", "user", null, "a1");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm3);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm2, containerId, RMContainerState.ALLOCATED, 10000));
        Assert.assertTrue((boolean)rm1.waitForState(nm1, containerId, RMContainerState.ALLOCATED, 10000));
        this.checkTaskContainersHost(am1.getApplicationAttemptId(), containerId, rm1, "h1");
        RMApp app2 = rm1.submitApp(200, "app", "user", null, "b1");
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm3);
        am2.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "y");
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm1, containerId, RMContainerState.ALLOCATED, 10000));
        Assert.assertTrue((boolean)rm1.waitForState(nm2, containerId, RMContainerState.ALLOCATED, 10000));
        this.checkTaskContainersHost(am2.getApplicationAttemptId(), containerId, rm1, "h2");
        RMApp app3 = rm1.submitApp(200, "app", "user", null, "c1");
        MockAM am3 = MockRM.launchAndRegisterAM(app3, rm1, nm3);
        am3.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am3.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm2, containerId, RMContainerState.ALLOCATED, 10000));
        Assert.assertTrue((boolean)rm1.waitForState(nm3, containerId, RMContainerState.ALLOCATED, 10000));
        this.checkTaskContainersHost(am3.getApplicationAttemptId(), containerId, rm1, "h3");
        rm1.close();
    }

    @Test(timeout=120000L)
    public void testContainerAllocateWithDefaultQueueLabels() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x"), (Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("y")));
        MockRM rm1 = new MockRM(TestUtils.getConfigurationWithDefaultQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8000);
        MockNM nm2 = rm1.registerNode("h2:1234", 8000);
        MockNM nm3 = rm1.registerNode("h3:1234", 8000);
        RMApp app1 = rm1.submitApp(200, "app", "user", null, "a1");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm3, containerId, RMContainerState.ALLOCATED, 10000));
        Assert.assertTrue((boolean)rm1.waitForState(nm1, containerId, RMContainerState.ALLOCATED, 10000));
        this.checkTaskContainersHost(am1.getApplicationAttemptId(), containerId, rm1, "h1");
        RMApp app2 = rm1.submitApp(200, "app", "user", null, "b1");
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm2);
        am2.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm3, containerId, RMContainerState.ALLOCATED, 10000));
        Assert.assertTrue((boolean)rm1.waitForState(nm2, containerId, RMContainerState.ALLOCATED, 10000));
        this.checkTaskContainersHost(am2.getApplicationAttemptId(), containerId, rm1, "h2");
        RMApp app3 = rm1.submitApp(200, "app", "user", null, "c1");
        MockAM am3 = MockRM.launchAndRegisterAM(app3, rm1, nm3);
        am3.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am3.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm2, containerId, RMContainerState.ALLOCATED, 10000));
        Assert.assertTrue((boolean)rm1.waitForState(nm3, containerId, RMContainerState.ALLOCATED, 10000));
        this.checkTaskContainersHost(am3.getApplicationAttemptId(), containerId, rm1, "h3");
        rm1.close();
    }

    private void checkPendingResource(MockRM rm, int priority2, ApplicationAttemptId attemptId, int memory) {
        CapacityScheduler cs = (CapacityScheduler)rm.getRMContext().getScheduler();
        FiCaSchedulerApp app = cs.getApplicationAttempt(attemptId);
        ResourceRequest rr = app.getAppSchedulingInfo().getResourceRequest(Priority.newInstance((int)priority2), "*");
        Assert.assertEquals((long)memory, (long)(rr.getCapability().getMemory() * rr.getNumContainers()));
    }

    private void checkLaunchedContainerNumOnNode(MockRM rm, NodeId nodeId, int numContainers) {
        CapacityScheduler cs = (CapacityScheduler)rm.getRMContext().getScheduler();
        SchedulerNode node = cs.getSchedulerNode(nodeId);
        Assert.assertEquals((long)numContainers, (long)node.getNumContainers());
    }

    @Test
    public void testResourceRequestUpdateNodePartitions() throws Exception {
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x"), (Object)NodeLabel.newInstance((String)"y", (boolean)false), (Object)NodeLabel.newInstance((String)"z", (boolean)false)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("y")));
        MockRM rm1 = new MockRM(this.getConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm2 = rm1.registerNode("h2:1234", 40960);
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "b1");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm2);
        ArrayList<ResourceRequest> resourceRequest = new ArrayList<ResourceRequest>();
        resourceRequest.add(am1.createResourceReq("/default-rack", 1024, 3, 1, ""));
        resourceRequest.add(am1.createResourceReq("*", 1024, 3, 5, "y"));
        resourceRequest.add(am1.createResourceReq("h1:1234", 1024, 3, 2, ""));
        resourceRequest.add(am1.createResourceReq("*", 1024, 2, 3, "y"));
        resourceRequest.add(am1.createResourceReq("h2:1234", 1024, 2, 4, null));
        resourceRequest.add(am1.createResourceReq("*", 1024, 4, 3, null));
        resourceRequest.add(am1.createResourceReq("h2:1234", 1024, 4, 4, null));
        am1.allocate(resourceRequest, new ArrayList<ContainerId>());
        CapacityScheduler cs = (CapacityScheduler)rm1.getRMContext().getScheduler();
        FiCaSchedulerApp app = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        List allResourceRequests = app.getAppSchedulingInfo().getAllResourceRequests();
        for (ResourceRequest changeReq : allResourceRequests) {
            if (changeReq.getPriority().getPriority() == 2 || changeReq.getPriority().getPriority() == 3) {
                Assert.assertEquals((String)"Expected label y", (Object)"y", (Object)changeReq.getNodeLabelExpression());
                continue;
            }
            if (changeReq.getPriority().getPriority() != 4) continue;
            Assert.assertEquals((String)"Expected label EMPTY", (Object)"", (Object)changeReq.getNodeLabelExpression());
        }
        ArrayList<ResourceRequest> newReq = new ArrayList<ResourceRequest>();
        newReq.add(am1.createResourceReq("h2:1234", 1024, 3, 4, null));
        newReq.add(am1.createResourceReq("*", 1024, 3, 5, "z"));
        newReq.add(am1.createResourceReq("h1:1234", 1024, 3, 4, null));
        newReq.add(am1.createResourceReq("*", 1024, 4, 5, "z"));
        am1.allocate(newReq, new ArrayList<ContainerId>());
        allResourceRequests = app.getAppSchedulingInfo().getAllResourceRequests();
        for (ResourceRequest changeReq : allResourceRequests) {
            if (changeReq.getPriority().getPriority() == 3 || changeReq.getPriority().getPriority() == 4) {
                Assert.assertEquals((String)"Expected label z", (Object)"z", (Object)changeReq.getNodeLabelExpression());
                continue;
            }
            if (changeReq.getPriority().getPriority() != 2) continue;
            Assert.assertEquals((String)"Expected label y", (Object)"y", (Object)changeReq.getNodeLabelExpression());
        }
        ArrayList<ResourceRequest> resourceRequest1 = new ArrayList<ResourceRequest>();
        resourceRequest1.add(am1.createResourceReq("/default-rack", 1024, 3, 1, null));
        resourceRequest1.add(am1.createResourceReq("*", 1024, 3, 5, null));
        resourceRequest1.add(am1.createResourceReq("h1:1234", 1024, 3, 2, ""));
        resourceRequest1.add(am1.createResourceReq("/default-rack", 1024, 2, 1, null));
        resourceRequest1.add(am1.createResourceReq("*", 1024, 2, 3, ""));
        resourceRequest1.add(am1.createResourceReq("h2:1234", 1024, 2, 4, null));
        am1.allocate(resourceRequest1, new ArrayList<ContainerId>());
        allResourceRequests = app.getAppSchedulingInfo().getAllResourceRequests();
        for (ResourceRequest changeReq : allResourceRequests) {
            if (changeReq.getPriority().getPriority() == 3) {
                Assert.assertEquals((String)"Expected label Empty", (Object)"", (Object)changeReq.getNodeLabelExpression());
                continue;
            }
            if (changeReq.getPriority().getPriority() != 2) continue;
            Assert.assertEquals((String)"Expected label y", (Object)"", (Object)changeReq.getNodeLabelExpression());
        }
    }

    @Test
    public void testPreferenceOfNeedyAppsTowardsNodePartitions() throws Exception {
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x"), (Object)NodeLabel.newInstance((String)"y", (boolean)false)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("y")));
        MockRM rm1 = new MockRM(TestUtils.getConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        MockNM nm2 = rm1.registerNode("h2:1234", 102400);
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "b1");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm2);
        RMApp app2 = rm1.submitApp(1024, "app", "user", null, "b1");
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm2);
        am1.allocate("*", 1024, 8, new ArrayList<ContainerId>());
        am2.allocate("*", 1024, 8, new ArrayList<ContainerId>(), "y");
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        RMNode rmNode2 = (RMNode)rm1.getRMContext().getRMNodes().get(nm2.getNodeId());
        for (int i = 0; i < 50; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode2));
        }
        FiCaSchedulerApp schedulerApp1 = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        FiCaSchedulerApp schedulerApp2 = cs.getApplicationAttempt(am2.getApplicationAttemptId());
        this.checkNumOfContainersInAnAppOnGivenNode(0, nm1.getNodeId(), schedulerApp1);
        this.checkNumOfContainersInAnAppOnGivenNode(9, nm2.getNodeId(), schedulerApp1);
        this.checkNumOfContainersInAnAppOnGivenNode(8, nm1.getNodeId(), schedulerApp2);
        this.checkNumOfContainersInAnAppOnGivenNode(1, nm2.getNodeId(), schedulerApp2);
        rm1.close();
    }

    private void checkNumOfContainersInAnAppOnGivenNode(int expectedNum, NodeId nodeId, FiCaSchedulerApp app) {
        int num = 0;
        for (RMContainer container : app.getLiveContainers()) {
            if (!container.getAllocatedNode().equals((Object)nodeId)) continue;
            ++num;
        }
        Assert.assertEquals((long)expectedNum, (long)num);
    }

    @Test
    public void testPreferenceOfNeedyPrioritiesUnderSameAppTowardsNodePartitions() throws Exception {
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x"), (Object)NodeLabel.newInstance((String)"y", (boolean)false)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("y")));
        MockRM rm1 = new MockRM(TestUtils.getConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        MockNM nm2 = rm1.registerNode("h2:1234", 102400);
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "b1");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm2);
        ContainerId nextContainerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        am1.allocate("*", 1024, 1, 1, new ArrayList<ContainerId>(), "");
        am1.allocate("*", 1024, 1, 2, new ArrayList<ContainerId>(), "y");
        Assert.assertTrue((boolean)rm1.waitForState(nm1, nextContainerId, RMContainerState.ALLOCATED, 10000));
        this.checkPendingResource(rm1, 1, am1.getApplicationAttemptId(), 1024);
        this.checkPendingResource(rm1, 2, am1.getApplicationAttemptId(), 0);
        rm1.close();
    }

    @Test
    public void testNonLabeledResourceRequestGetPreferrenceToNonLabeledNode() throws Exception {
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x", (boolean)false), (Object)NodeLabel.newInstance((String)"y")));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockRM rm1 = new MockRM(TestUtils.getConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        MockNM nm2 = rm1.registerNode("h2:1234", 102400);
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "b1");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm2);
        am1.allocate("*", 1024, 6, 1, new ArrayList<ContainerId>(), "");
        for (int i = 2; i < 8; ++i) {
            ContainerId nextContainerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)i);
            Assert.assertTrue((boolean)rm1.waitForState(Arrays.asList(nm1, nm2), nextContainerId, RMContainerState.ALLOCATED, 10000));
        }
        this.checkLaunchedContainerNumOnNode(rm1, nm1.getNodeId(), 0);
        this.checkLaunchedContainerNumOnNode(rm1, nm2.getNodeId(), 7);
        rm1.close();
    }

    @Test
    public void testPreferenceOfQueuesTowardsNodePartitions() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        csConf.setQueues("root", new String[]{"a", "b", "c"});
        csConf.setCapacityByLabel("root", "x", 100.0f);
        String A = "root.a";
        csConf.setCapacity("root.a", 33.0f);
        csConf.setAccessibleNodeLabels("root.a", this.toSet("x"));
        csConf.setCapacityByLabel("root.a", "x", 33.0f);
        csConf.setQueues("root.a", new String[]{"a1", "a2"});
        String B = "root.b";
        csConf.setCapacity("root.b", 33.0f);
        csConf.setAccessibleNodeLabels("root.b", this.toSet("x"));
        csConf.setCapacityByLabel("root.b", "x", 33.0f);
        csConf.setQueues("root.b", new String[]{"b1", "b2"});
        String C = "root.c";
        csConf.setCapacity("root.c", 34.0f);
        csConf.setAccessibleNodeLabels("root.c", this.toSet("x"));
        csConf.setCapacityByLabel("root.c", "x", 34.0f);
        csConf.setQueues("root.c", new String[]{"c1", "c2"});
        String A1 = "root.a.a1";
        csConf.setCapacity("root.a.a1", 50.0f);
        csConf.setCapacityByLabel("root.a.a1", "x", 100.0f);
        csConf.setDefaultNodeLabelExpression("root.a.a1", "x");
        String A2 = "root.a.a2";
        csConf.setCapacity("root.a.a2", 50.0f);
        csConf.setCapacityByLabel("root.a.a2", "x", 0.0f);
        String B1 = "root.b.b1";
        csConf.setCapacity("root.b.b1", 50.0f);
        csConf.setCapacityByLabel("root.b.b1", "x", 100.0f);
        csConf.setDefaultNodeLabelExpression("root.b.b1", "x");
        String B2 = "root.b.b2";
        csConf.setCapacity("root.b.b2", 50.0f);
        csConf.setCapacityByLabel("root.b.b2", "x", 0.0f);
        String C1 = "root.c.c1";
        csConf.setCapacity("root.c.c1", 50.0f);
        csConf.setCapacityByLabel("root.c.c1", "x", 100.0f);
        csConf.setDefaultNodeLabelExpression("root.c.c1", "x");
        String C2 = "root.c.c2";
        csConf.setCapacity("root.c.c2", 50.0f);
        csConf.setCapacityByLabel("root.c.c2", "x", 0.0f);
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x", (boolean)false), (Object)NodeLabel.newInstance((String)"y")));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockRM rm1 = new MockRM((Configuration)csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 20480);
        MockNM nm2 = rm1.registerNode("h2:1234", 102400);
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "a1");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        RMApp app2 = rm1.submitApp(1024, "app", "user", null, "a2");
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm2);
        RMApp app3 = rm1.submitApp(1024, "app", "user", null, "b1");
        MockAM am3 = MockRM.launchAndRegisterAM(app3, rm1, nm1);
        RMApp app4 = rm1.submitApp(1024, "app", "user", null, "b2");
        MockAM am4 = MockRM.launchAndRegisterAM(app4, rm1, nm2);
        RMApp app5 = rm1.submitApp(1024, "app", "user", null, "c1");
        MockAM am5 = MockRM.launchAndRegisterAM(app5, rm1, nm1);
        RMApp app6 = rm1.submitApp(1024, "app", "user", null, "c2");
        MockAM am6 = MockRM.launchAndRegisterAM(app6, rm1, nm2);
        am1.allocate("*", 1024, 5, new ArrayList<ContainerId>());
        am2.allocate("*", 1024, 5, new ArrayList<ContainerId>());
        am3.allocate("*", 1024, 5, new ArrayList<ContainerId>());
        am4.allocate("*", 1024, 5, new ArrayList<ContainerId>());
        am5.allocate("*", 1024, 5, new ArrayList<ContainerId>());
        am6.allocate("*", 1024, 5, new ArrayList<ContainerId>());
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        for (int i = 0; i < 15; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        }
        this.checkLaunchedContainerNumOnNode(rm1, nm1.getNodeId(), 18);
        this.checkPendingResource(rm1, 1, am1.getApplicationAttemptId(), 0);
        this.checkPendingResource(rm1, 1, am2.getApplicationAttemptId(), 5120);
        this.checkPendingResource(rm1, 1, am3.getApplicationAttemptId(), 0);
        this.checkPendingResource(rm1, 1, am4.getApplicationAttemptId(), 5120);
        this.checkPendingResource(rm1, 1, am5.getApplicationAttemptId(), 0);
        this.checkPendingResource(rm1, 1, am6.getApplicationAttemptId(), 5120);
        rm1.close();
    }

    @Test
    public void testQueuesWithoutAccessUsingPartitionedNodes() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        csConf.setQueues("root", new String[]{"a", "b"});
        csConf.setCapacityByLabel("root", "x", 100.0f);
        String A = "root.a";
        csConf.setCapacity("root.a", 50.0f);
        csConf.setAccessibleNodeLabels("root.a", this.toSet("x"));
        csConf.setCapacityByLabel("root.a", "x", 100.0f);
        String B = "root.b";
        csConf.setCapacity("root.b", 50.0f);
        csConf.setAccessibleNodeLabels("root.b", new HashSet());
        csConf.setUserLimitFactor("root.b", 5.0f);
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x", (boolean)false), (Object)NodeLabel.newInstance((String)"y")));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockRM rm1 = new MockRM((Configuration)csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 10240);
        MockNM nm2 = rm1.registerNode("h2:1234", 10240);
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "b");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm2);
        am1.allocate("*", 1024, 50, new ArrayList<ContainerId>());
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        RMNode rmNode2 = (RMNode)rm1.getRMContext().getRMNodes().get(nm2.getNodeId());
        SchedulerNode schedulerNode1 = cs.getSchedulerNode(nm1.getNodeId());
        int cycleWaited = 0;
        for (int i = 0; i < 50; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode2));
            if (schedulerNode1.getNumContainers() != 0) continue;
            ++cycleWaited;
        }
        Assert.assertEquals((long)10L, (long)cycleWaited);
        this.checkLaunchedContainerNumOnNode(rm1, nm1.getNodeId(), 10);
        this.checkLaunchedContainerNumOnNode(rm1, nm2.getNodeId(), 10);
        rm1.close();
    }

    @Test
    public void testAMContainerAllocationWillAlwaysBeExclusive() throws Exception {
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x", (boolean)false), (Object)NodeLabel.newInstance((String)"y")));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockRM rm1 = new MockRM(TestUtils.getConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        String nodeIdStr = "h1:1234";
        MockNM nm1 = rm1.registerNode(nodeIdStr, 8192);
        RMApp app = rm1.submitApp(1024, "app", "user", null, "b1");
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        for (int i = 0; i < 50; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        }
        Assert.assertTrue((String)"Scheduler diagnostics should have reason for not assigning the node", (boolean)app.getDiagnostics().toString().contains("Skipping assigning to Node in Ignore Exclusivity mode. "));
        Assert.assertTrue((String)"Scheduler diagnostics should have last processed node information", (boolean)app.getDiagnostics().toString().contains(" Last Node which was processed for the application : " + nodeIdStr + " ( Partition : [x]"));
        Assert.assertEquals((long)0L, (long)cs.getSchedulerNode(nm1.getNodeId()).getNumContainers());
        rm1.close();
    }

    @Test
    public void testQueueMaxCapacitiesWillNotBeHonoredWhenNotRespectingExclusivity() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        csConf.setQueues("root", new String[]{"a", "b"});
        csConf.setCapacityByLabel("root", "x", 100.0f);
        String A = "root.a";
        csConf.setCapacity("root.a", 50.0f);
        csConf.setAccessibleNodeLabels("root.a", this.toSet("x"));
        csConf.setCapacityByLabel("root.a", "x", 50.0f);
        csConf.setMaximumCapacityByLabel("root.a", "x", 50.0f);
        String B = "root.b";
        csConf.setCapacity("root.b", 50.0f);
        csConf.setAccessibleNodeLabels("root.b", this.toSet("x"));
        csConf.setCapacityByLabel("root.b", "x", 50.0f);
        csConf.setMaximumCapacityByLabel("root.b", "x", 50.0f);
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x", (boolean)false)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockRM rm1 = new MockRM((Configuration)csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 10240);
        MockNM nm2 = rm1.registerNode("h2:1234", 10240);
        RMApp app1 = rm1.submitApp(1024, "app", "user", null, "a");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm2);
        am1.allocate("*", 1024, 10, new ArrayList<ContainerId>());
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        SchedulerNode schedulerNode1 = cs.getSchedulerNode(nm1.getNodeId());
        for (int i = 0; i < 50; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        }
        Assert.assertEquals((long)10L, (long)schedulerNode1.getNumContainers());
        LeafQueue leafQueue = (LeafQueue)cs.getQueue("a");
        Assert.assertFalse((boolean)leafQueue.getIgnoreExclusivityRMContainers().containsKey("y"));
        Assert.assertEquals((long)10L, (long)((TreeSet)leafQueue.getIgnoreExclusivityRMContainers().get("x")).size());
        cs.handle((SchedulerEvent)new AppAttemptRemovedSchedulerEvent(am1.getApplicationAttemptId(), RMAppAttemptState.FINISHED, false));
        Assert.assertFalse((boolean)leafQueue.getIgnoreExclusivityRMContainers().containsKey("x"));
        rm1.close();
    }

    private void checkQueueUsedCapacity(String queueName, CapacityScheduler cs, String nodePartition, float usedCapacity, float absoluteUsedCapacity) {
        float epsilon = 1.0E-6f;
        CSQueue queue = cs.getQueue(queueName);
        Assert.assertNotNull((String)("Failed to get queue=" + queueName), (Object)queue);
        Assert.assertEquals((float)usedCapacity, (float)queue.getQueueCapacities().getUsedCapacity(nodePartition), (float)epsilon);
        Assert.assertEquals((float)absoluteUsedCapacity, (float)queue.getQueueCapacities().getAbsoluteUsedCapacity(nodePartition), (float)epsilon);
    }

    private void doNMHeartbeat(MockRM rm, NodeId nodeId, int nHeartbeat) {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm.getRMContext().getRMNodes().get(nodeId);
        for (int i = 0; i < nHeartbeat; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        }
    }

    private void waitSchedulerNodeJoined(MockRM rm, int expectedNodeNum) throws InterruptedException {
        for (int totalWaitTick = 100; expectedNodeNum > rm.getResourceScheduler().getNumClusterNodes() && totalWaitTick > 0; --totalWaitTick) {
            Thread.sleep(100L);
        }
    }

    @Test
    public void testQueueUsedCapacitiesUpdate() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        csConf.setQueues("root", new String[]{"a", "b"});
        csConf.setCapacityByLabel("root", "x", 100.0f);
        String A = "root.a";
        csConf.setCapacity("root.a", 50.0f);
        csConf.setAccessibleNodeLabels("root.a", this.toSet("x"));
        csConf.setCapacityByLabel("root.a", "x", 50.0f);
        csConf.setQueues("root.a", new String[]{"a1", "a2"});
        String A1 = "root.a.a1";
        csConf.setCapacity("root.a.a1", 50.0f);
        csConf.setAccessibleNodeLabels("root.a.a1", this.toSet("x"));
        csConf.setCapacityByLabel("root.a.a1", "x", 50.0f);
        String A2 = "root.a.a2";
        csConf.setCapacity("root.a.a2", 50.0f);
        csConf.setAccessibleNodeLabels("root.a.a2", this.toSet("x"));
        csConf.setCapacityByLabel("root.a.a2", "x", 50.0f);
        String B = "root.b";
        csConf.setCapacity("root.b", 50.0f);
        csConf.setAccessibleNodeLabels("root.b", this.toSet("x"));
        csConf.setCapacityByLabel("root.b", "x", 50.0f);
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x", (boolean)false)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockRM rm = new MockRM((Configuration)csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm.getRMContext().setNodeLabelManager(this.mgr);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        this.checkQueueUsedCapacity("a", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a1", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a1", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a2", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a2", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("root", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("root", cs, "", 0.0f, 0.0f);
        MockNM nm1 = rm.registerNode("h1:1234", 10240);
        MockNM nm2 = rm.registerNode("h2:1234", 10240);
        this.checkQueueUsedCapacity("a", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a1", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a1", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a2", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a2", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("root", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("root", cs, "", 0.0f, 0.0f);
        RMApp app1 = rm.submitApp(1024, "app", "user", null, "a1");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm2);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        this.doNMHeartbeat(rm, nm2.getNodeId(), 10);
        this.checkQueueUsedCapacity("a", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a", cs, "", 0.4f, 0.2f);
        this.checkQueueUsedCapacity("a1", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a1", cs, "", 0.8f, 0.2f);
        this.checkQueueUsedCapacity("a2", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a2", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("root", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("root", cs, "", 0.2f, 0.2f);
        am1.allocate("*", 1024, 2, new ArrayList<ContainerId>(), "x");
        this.doNMHeartbeat(rm, nm1.getNodeId(), 10);
        this.checkQueueUsedCapacity("a", cs, "x", 0.4f, 0.2f);
        this.checkQueueUsedCapacity("a", cs, "", 0.4f, 0.2f);
        this.checkQueueUsedCapacity("a1", cs, "x", 0.8f, 0.2f);
        this.checkQueueUsedCapacity("a1", cs, "", 0.8f, 0.2f);
        this.checkQueueUsedCapacity("a2", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a2", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("root", cs, "x", 0.2f, 0.2f);
        this.checkQueueUsedCapacity("root", cs, "", 0.2f, 0.2f);
        RMApp app2 = rm.submitApp(1024, "app", "user", null, "a2");
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm2);
        am2.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
        this.doNMHeartbeat(rm, nm1.getNodeId(), 10);
        this.checkQueueUsedCapacity("a", cs, "x", 0.6f, 0.3f);
        this.checkQueueUsedCapacity("a", cs, "", 0.6f, 0.3f);
        this.checkQueueUsedCapacity("a1", cs, "x", 0.8f, 0.2f);
        this.checkQueueUsedCapacity("a1", cs, "", 0.8f, 0.2f);
        this.checkQueueUsedCapacity("a2", cs, "x", 0.4f, 0.1f);
        this.checkQueueUsedCapacity("a2", cs, "", 0.4f, 0.1f);
        this.checkQueueUsedCapacity("b", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("root", cs, "x", 0.3f, 0.3f);
        this.checkQueueUsedCapacity("root", cs, "", 0.3f, 0.3f);
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h3", (int)0), this.toSet("x")));
        rm.registerNode("h3:1234", 10240);
        rm.registerNode("h4:1234", 10240);
        this.waitSchedulerNodeJoined(rm, 4);
        this.checkQueueUsedCapacity("a", cs, "x", 0.3f, 0.15f);
        this.checkQueueUsedCapacity("a", cs, "", 0.3f, 0.15f);
        this.checkQueueUsedCapacity("a1", cs, "x", 0.4f, 0.1f);
        this.checkQueueUsedCapacity("a1", cs, "", 0.4f, 0.1f);
        this.checkQueueUsedCapacity("a2", cs, "x", 0.2f, 0.05f);
        this.checkQueueUsedCapacity("a2", cs, "", 0.2f, 0.05f);
        this.checkQueueUsedCapacity("b", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("root", cs, "x", 0.15f, 0.15f);
        this.checkQueueUsedCapacity("root", cs, "", 0.15f, 0.15f);
        csConf.setCapacity("root.a", 100.0f);
        csConf.setCapacityByLabel("root.a", "x", 100.0f);
        csConf.setCapacity("root.b", 0.0f);
        csConf.setCapacityByLabel("root.b", "x", 0.0f);
        cs.reinitialize((Configuration)csConf, rm.getRMContext());
        this.checkQueueUsedCapacity("a", cs, "x", 0.15f, 0.15f);
        this.checkQueueUsedCapacity("a", cs, "", 0.15f, 0.15f);
        this.checkQueueUsedCapacity("a1", cs, "x", 0.2f, 0.1f);
        this.checkQueueUsedCapacity("a1", cs, "", 0.2f, 0.1f);
        this.checkQueueUsedCapacity("a2", cs, "x", 0.1f, 0.05f);
        this.checkQueueUsedCapacity("a2", cs, "", 0.1f, 0.05f);
        this.checkQueueUsedCapacity("b", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("root", cs, "x", 0.15f, 0.15f);
        this.checkQueueUsedCapacity("root", cs, "", 0.15f, 0.15f);
        am1.allocate(null, Arrays.asList(ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L), ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L), ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)4L)));
        this.checkQueueUsedCapacity("a", cs, "x", 0.05f, 0.05f);
        this.checkQueueUsedCapacity("a", cs, "", 0.1f, 0.1f);
        this.checkQueueUsedCapacity("a1", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a1", cs, "", 0.1f, 0.05f);
        this.checkQueueUsedCapacity("a2", cs, "x", 0.1f, 0.05f);
        this.checkQueueUsedCapacity("a2", cs, "", 0.1f, 0.05f);
        this.checkQueueUsedCapacity("b", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("root", cs, "x", 0.05f, 0.05f);
        this.checkQueueUsedCapacity("root", cs, "", 0.1f, 0.1f);
        rm.close();
    }

    @Test
    public void testOrderOfAllocationOnPartitions() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        csConf.setQueues("root", new String[]{"a", "b", "c", "d"});
        csConf.setCapacityByLabel("root", "x", 100.0f);
        String A = "root.a";
        csConf.setCapacity("root.a", 25.0f);
        csConf.setAccessibleNodeLabels("root.a", this.toSet("x"));
        csConf.setCapacityByLabel("root.a", "x", 30.0f);
        String B = "root.b";
        csConf.setCapacity("root.b", 25.0f);
        csConf.setAccessibleNodeLabels("root.b", this.toSet("x"));
        csConf.setCapacityByLabel("root.b", "x", 70.0f);
        String C = "root.c";
        csConf.setAccessibleNodeLabels("root.c", Collections.emptySet());
        csConf.setCapacity("root.c", 25.0f);
        String D = "root.d";
        csConf.setAccessibleNodeLabels("root.d", Collections.emptySet());
        csConf.setCapacity("root.d", 25.0f);
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x", (boolean)false)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockRM rm = new MockRM((Configuration)csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm.getRMContext().setNodeLabelManager(this.mgr);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        MockNM nm1 = rm.registerNode("h1:1234", 10240);
        MockNM nm2 = rm.registerNode("h2:1234", 10240);
        RMApp app1 = rm.submitApp(1024, "app", "user", null, "a");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm2);
        RMApp app2 = rm.submitApp(1024, "app", "user", null, "b");
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm2);
        RMApp app3 = rm.submitApp(1024, "app", "user", null, "c");
        MockAM am3 = MockRM.launchAndRegisterAM(app3, rm, nm2);
        RMApp app4 = rm.submitApp(1024, "app", "user", null, "d");
        MockAM am4 = MockRM.launchAndRegisterAM(app4, rm, nm2);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
        am2.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
        this.doNMHeartbeat(rm, nm1.getNodeId(), 1);
        this.checkNumOfContainersInAnAppOnGivenNode(1, nm1.getNodeId(), cs.getApplicationAttempt(am2.getApplicationAttemptId()));
        am2.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
        this.doNMHeartbeat(rm, nm1.getNodeId(), 1);
        this.checkNumOfContainersInAnAppOnGivenNode(1, nm1.getNodeId(), cs.getApplicationAttempt(am1.getApplicationAttemptId()));
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "");
        am2.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "");
        this.doNMHeartbeat(rm, nm1.getNodeId(), 2);
        this.checkNumOfContainersInAnAppOnGivenNode(2, nm1.getNodeId(), cs.getApplicationAttempt(am2.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(1, nm1.getNodeId(), cs.getApplicationAttempt(am1.getApplicationAttemptId()));
        this.doNMHeartbeat(rm, nm1.getNodeId(), 2);
        this.checkNumOfContainersInAnAppOnGivenNode(2, nm1.getNodeId(), cs.getApplicationAttempt(am2.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(2, nm1.getNodeId(), cs.getApplicationAttempt(am1.getApplicationAttemptId()));
        am2.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "");
        am3.allocate("*", 1024, 2, new ArrayList<ContainerId>(), "");
        am4.allocate("*", 1024, 2, new ArrayList<ContainerId>(), "");
        this.doNMHeartbeat(rm, nm1.getNodeId(), 2);
        this.checkNumOfContainersInAnAppOnGivenNode(2, nm1.getNodeId(), cs.getApplicationAttempt(am1.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(3, nm1.getNodeId(), cs.getApplicationAttempt(am2.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(0, nm1.getNodeId(), cs.getApplicationAttempt(am3.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(0, nm1.getNodeId(), cs.getApplicationAttempt(am4.getApplicationAttemptId()));
        this.doNMHeartbeat(rm, nm1.getNodeId(), 1);
        this.checkNumOfContainersInAnAppOnGivenNode(2, nm1.getNodeId(), cs.getApplicationAttempt(am1.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(3, nm1.getNodeId(), cs.getApplicationAttempt(am2.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(1, nm1.getNodeId(), cs.getApplicationAttempt(am3.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(0, nm1.getNodeId(), cs.getApplicationAttempt(am4.getApplicationAttemptId()));
        this.doNMHeartbeat(rm, nm1.getNodeId(), 2);
        this.checkNumOfContainersInAnAppOnGivenNode(2, nm1.getNodeId(), cs.getApplicationAttempt(am1.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(3, nm1.getNodeId(), cs.getApplicationAttempt(am2.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(1, nm1.getNodeId(), cs.getApplicationAttempt(am3.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(1, nm1.getNodeId(), cs.getApplicationAttempt(am4.getApplicationAttemptId()));
        this.doNMHeartbeat(rm, nm1.getNodeId(), 1);
        this.checkNumOfContainersInAnAppOnGivenNode(2, nm1.getNodeId(), cs.getApplicationAttempt(am1.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(3, nm1.getNodeId(), cs.getApplicationAttempt(am2.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(2, nm1.getNodeId(), cs.getApplicationAttempt(am3.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(1, nm1.getNodeId(), cs.getApplicationAttempt(am4.getApplicationAttemptId()));
    }

    @Test
    public void testOrderOfAllocationOnPartitionsWhenAccessibilityIsAll() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        csConf.setQueues("root", new String[]{"a", "b"});
        csConf.setCapacityByLabel("root", "x", 100.0f);
        String A = "root.a";
        csConf.setCapacity("root.a", 25.0f);
        csConf.setAccessibleNodeLabels("root.a", this.toSet("*"));
        csConf.setCapacityByLabel("root.a", "x", 60.0f);
        String B = "root.b";
        csConf.setCapacity("root.b", 75.0f);
        csConf.setAccessibleNodeLabels("root.b", this.toSet("x"));
        csConf.setCapacityByLabel("root.b", "x", 40.0f);
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x", (boolean)false)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockRM rm = new MockRM((Configuration)csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm.getRMContext().setNodeLabelManager(this.mgr);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        MockNM nm1 = rm.registerNode("h1:1234", 10240);
        RMApp app1 = rm.submitApp(1024, "app", "user", null, "a", "x");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
        RMApp app2 = rm.submitApp(1024, "app", "user", null, "b", "x");
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm1);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
        am2.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
        this.doNMHeartbeat(rm, nm1.getNodeId(), 1);
        this.checkNumOfContainersInAnAppOnGivenNode(2, nm1.getNodeId(), cs.getApplicationAttempt(am1.getApplicationAttemptId()));
    }

    @Test
    public void testParentQueueMaxCapsAreRespected() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        csConf.setQueues("root", new String[]{"a", "b"});
        csConf.setCapacityByLabel("root", "x", 100.0f);
        String A = "root.a";
        csConf.setCapacity("root.a", 10.0f);
        csConf.setAccessibleNodeLabels("root.a", this.toSet("x"));
        csConf.setCapacityByLabel("root.a", "x", 50.0f);
        csConf.setMaximumCapacityByLabel("root.a", "x", 50.0f);
        String B = "root.b";
        csConf.setCapacity("root.b", 90.0f);
        csConf.setAccessibleNodeLabels("root.b", this.toSet("x"));
        csConf.setCapacityByLabel("root.b", "x", 50.0f);
        csConf.setMaximumCapacityByLabel("root.b", "x", 50.0f);
        csConf.setQueues("root.a", new String[]{"a1", "a2"});
        String A1 = "root.a.a1";
        csConf.setCapacity("root.a.a1", 50.0f);
        csConf.setAccessibleNodeLabels("root.a.a1", this.toSet("x"));
        csConf.setCapacityByLabel("root.a.a1", "x", 50.0f);
        csConf.setMaximumCapacityByLabel("root.a.a1", "x", 100.0f);
        csConf.setUserLimitFactor("root.a.a1", 100.0f);
        String A2 = "root.a.a2";
        csConf.setCapacity("root.a.a2", 50.0f);
        csConf.setAccessibleNodeLabels("root.a.a2", this.toSet("x"));
        csConf.setCapacityByLabel("root.a.a2", "x", 50.0f);
        csConf.setMaximumCapacityByLabel("root.a.a2", "x", 100.0f);
        csConf.setUserLimitFactor("root.a.a2", 100.0f);
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x", (boolean)false)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockRM rm = new MockRM((Configuration)csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm.getRMContext().setNodeLabelManager(this.mgr);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        MockNM nm1 = new MockNM("h1:1234", 24576, rm.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = rm.submitApp(1024, "app", "user", null, "a1", "x");
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
        am1.allocate("*", 4096, 2, new ArrayList<ContainerId>(), "x");
        this.doNMHeartbeat(rm, nm1.getNodeId(), 10);
        this.checkNumOfContainersInAnAppOnGivenNode(3, nm1.getNodeId(), cs.getApplicationAttempt(am1.getApplicationAttemptId()));
        RMApp app2 = rm.submitApp(2048, "app", "user", null, "a2", "x");
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm1);
        am2.allocate("*", 2048, 2, new ArrayList<ContainerId>(), "x");
        this.doNMHeartbeat(rm, nm1.getNodeId(), 10);
        this.checkNumOfContainersInAnAppOnGivenNode(1, nm1.getNodeId(), cs.getApplicationAttempt(am2.getApplicationAttemptId()));
    }
}

